/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.excuter.ProcessConcurrentExcuter;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.factory.ISubProcessorFactory;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Set;

public class StopVmRecoveryProcessor
extends GalaxBaseRecoveryProcessor {
    private static final long serialVersionUID = 6344459213710607527L;
    private static final Log logger = LogFactory.getInstance(StopVmRecoveryProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"Recovery STOPVM Setp:Ready to stop vms.");
        this.setContextRef(context);
        this.updateSubProcessors(context);
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            logger.info((Object)"No vm need stop.");
            return this.endRecoveryProcessWithoutProcessor("ism.drm.recovery.process.no.need", true);
        }
        ProcessConcurrentExcuter excuter = new ProcessConcurrentExcuter(context, (RecoveryProcessor)this);
        excuter.excuteProcessByOrder("vrm_batchExecuteStopVM", false);
        logger.info((Object)"Recovery STOPVM Setp:complete the process of stop vms.");
        return this.calcExcuteResult();
    }

    @Override
    protected boolean calcExcuteResult() {
        boolean executeResult = super.calcExcuteResult();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus() && DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue() == this.getProcType()) {
            executeResult = false;
        }
        return executeResult;
    }

    private void updateSubProcessors(RecoveryProcessorContext context) {
        ISubProcessorFactory subProcessorFactory = this.getSubProcessorFactory();
        if (subProcessorFactory == null) {
            throw new LegoCheckedException(102L);
        }
        Set<RecoveryProcessor> stopVmProcessors = subProcessorFactory.createStopVmSubProcessors(context, (RecoveryProcessor)this);
        this.saveProcessors(stopVmProcessors);
    }

    public void updateProcessName() {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()) {
            this.setProcName("com.huawei.ism.drm.galax.recovery.process.StopProductVmRecoveryProcessor");
        }
    }

    public void updateDescription() {
        if (this.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()) {
            this.setDescription("com.huawei.ism.drm.galax.recovery.process.StopProductVmRecoveryProcessor.des");
        }
    }
}

