/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.base;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseSubRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.factory.ISubProcessorFactory;
import com.huawei.ism.drm.galax.recovery.process.factory.RpProcessorFactoryManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class GalaxBaseRecoveryProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -1039801762963760601L;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public boolean saveProcessors(Set<RecoveryProcessor> subProcessors) {
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        if (subProcessors == null) {
            subProcessors = new HashSet<RecoveryProcessor>();
            if (this.getChildProc() != null) {
                for (RecoveryProcessor preProcessor : this.getChildProc()) {
                    recoveryProcessService.deleteRecoveryProcessor(preProcessor.getProcId());
                }
            }
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setChildProc(subProcessors);
        } else {
            this.updateSubProcessors(subProcessors);
        }
        return recoveryProcessService.updateRecoveryProcessor((RecoveryProcessor)this);
    }

    protected boolean endRecoveryProcessWithoutProcessor(String tip, boolean result) {
        this.updateProcessDetail(tip, new String[0]);
        int procStatus = result ? DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue() : DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue();
        this.setProcStatus(procStatus);
        return result;
    }

    protected boolean calcExcuteResult() {
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RecoveryPlanExecuteResultE.PART_SUCCESS.getValue() == this.getProcStatus() && (DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING.getValue() == this.getProcType() || DrmEnumDefine.RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue() == this.getProcType())) {
            executeResult = false;
        }
        return executeResult;
    }

    protected void updateSubProcessors(Set<RecoveryProcessor> newSubProcessors) {
        if (newSubProcessors == null || newSubProcessors.isEmpty() || this.getChildProc() == null || this.getChildProc().isEmpty()) {
            return;
        }
        Set processes = this.getChildProc();
        Iterator preIterator = processes.iterator();
        while (preIterator.hasNext()) {
            RecoveryProcessor preProcessor = (RecoveryProcessor)preIterator.next();
            boolean isExist = false;
            Iterator<RecoveryProcessor> newIterator = newSubProcessors.iterator();
            while (newIterator.hasNext()) {
                RecoveryProcessor newProcessor = newIterator.next();
                if (!this.isSameProcessor(preProcessor, newProcessor)) continue;
                this.updateProcessorData(preProcessor, newProcessor);
                newIterator.remove();
                isExist = true;
                break;
            }
            if (isExist) continue;
            this.replaceOldProcessor(newSubProcessors, preProcessor);
            preIterator.remove();
        }
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor recoveryProcess : processes) {
            subProcessors.add(recoveryProcess);
        }
        for (RecoveryProcessor recoveryProcess : newSubProcessors) {
            subProcessors.add(recoveryProcess);
        }
        this.setChildProc(subProcessors);
    }

    private void replaceOldProcessor(Set<RecoveryProcessor> newSubProcessors, RecoveryProcessor oldProcessor) {
        RecoveryProcessor preProcessor;
        RecoveryProcessor newSubProcessor = null;
        for (RecoveryProcessor processor : newSubProcessors) {
            if (processor.getClass() != oldProcessor.getClass()) continue;
            newSubProcessor = processor;
            break;
        }
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        if (newSubProcessor != null) {
            newSubProcessor.setPreviousProcessor(null);
            preProcessor = oldProcessor.getPreviousProcessor();
            RecoveryProcessor nextProcessor = oldProcessor.getNextProcessor();
            if (preProcessor != null) {
                preProcessor.setNextProcessor(newSubProcessor);
                newSubProcessor.setPreviousProcessor(preProcessor);
                newSubProcessor.setNextProcessor(null);
            }
            if (nextProcessor != null) {
                nextProcessor.setPreviousProcessor(newSubProcessor);
                newSubProcessor.setNextProcessor(nextProcessor);
            }
            recoveryProcessService.deleteRecoveryProcessor(oldProcessor.getProcId());
        } else {
            preProcessor = oldProcessor.getPreviousProcessor();
            RecoveryProcessor nextProcessor = oldProcessor.getNextProcessor();
            if (preProcessor != null) {
                preProcessor.setNextProcessor(nextProcessor);
            }
            if (nextProcessor != null) {
                nextProcessor.setPreviousProcessor(preProcessor);
            }
            recoveryProcessService.deleteRecoveryProcessor(oldProcessor.getProcId());
        }
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (oldProcess == null || newProcess == null) {
            return false;
        }
        GalaxBaseSubRecoveryProcessor preProcessor = (GalaxBaseSubRecoveryProcessor)oldProcess;
        GalaxBaseSubRecoveryProcessor newProcessor = (GalaxBaseSubRecoveryProcessor)newProcess;
        if (preProcessor.getGalaxId() == null || !preProcessor.getGalaxId().equals(newProcessor.getGalaxId())) {
            return false;
        }
        int successStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
        return successStatus == preProcessor.getProcStatus();
    }

    protected ISubProcessorFactory getSubProcessorFactory() {
        ProtectGroup pg = this.getContextRef().getProtectGroup();
        if (pg.getTemplate().getType() == 11) {
            return RpProcessorFactoryManager.getInstance().getProcessorFactory("H" + this.getProcType());
        }
        return RpProcessorFactoryManager.getInstance().getProcessorFactory("S" + this.getProcType());
    }
}

