/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.base;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.util.common.task.IExecuteTask;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class GalaxBaseSubRecoveryProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 2433567424507061803L;
    private ProtectObject po;
    private String galaxId;
    private Map<String, String> extendParams;
    private transient IExecuteTask excuteTask;

    public GalaxBaseSubRecoveryProcessor() {
    }

    public GalaxBaseSubRecoveryProcessor(RecoveryProcessor parentProcess, String galaxId) {
        if (null == parentProcess) {
            return;
        }
        this.galaxId = galaxId;
        this.setProcName(this.getName());
        this.setProcType(parentProcess.getProcType());
        this.setPlanId(parentProcess.getPlanId());
        this.setParentProc(parentProcess);
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
        this.extendParams = new HashMap<String, String>();
    }

    public GalaxBaseSubRecoveryProcessor(RecoveryProcessor parrentProcess, ProtectObject po) {
        this(parrentProcess, po.getUuid());
        this.po = po;
        Map<String, String> params = this.getExtendParams();
        if (null != params) {
            this.getExtendParams().put(RpExParamsEnum.SHOWPARAM.getValue(), po.getName());
            this.getExtendParams().put(RpExParamsEnum.VM_UUID.getValue(), po.getMoUuid());
            JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
            if (!VerifyUtil.isEmpty((Map)jo)) {
                this.getExtendParams().put(RpExParamsEnum.VM_TYPE.getValue(), jo.getString(RpExParamsEnum.VM_TYPE.getValue()));
            }
        }
    }

    protected String getShowParam() {
        return this.getExtendParams().get(RpExParamsEnum.SHOWPARAM.getValue());
    }

    public String getGalaxId() {
        return this.galaxId;
    }

    public void setGalaxId(String galaxId) {
        this.galaxId = galaxId;
    }

    public Map<String, String> getExtendParams() {
        return this.extendParams;
    }

    public void setExtendParams(Map<String, String> extendParams) {
        this.extendParams = extendParams;
    }

    public IExecuteTask getExcuteTask() {
        return this.excuteTask;
    }

    public void setExcuteTask(IExecuteTask excuteTask) {
        this.excuteTask = excuteTask;
    }

    public void updateExtendParams(Map<String, String> newExtendParams) {
        Set<Map.Entry<String, String>> entryMap = newExtendParams.entrySet();
        for (Map.Entry<String, String> entry : entryMap) {
            if (null == entry.getValue()) continue;
            this.extendParams.put(entry.getKey(), entry.getValue());
        }
    }

    public ProtectObject getPo() {
        return this.po;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected String generateResultKey() {
        return this.getName() + "_" + this.galaxId;
    }

    public void endRecoveryProcessor() {
        super.endRecoveryProcessor();
    }

    protected RecoveryPlan getRecoveryPlan(RecoveryProcessorContext context) {
        RecoveryPlan recoveryPlan = (RecoveryPlan)context.getAttribute("RecoveryPlan");
        return recoveryPlan;
    }
}

