/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.command.impl;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlatformInfo;
import com.huawei.ism.drm.galax.recovery.process.command.exception.FindNoResourceMappingCheckedException;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractCommand;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.Hypervisor;
import com.huawei.ism.drm.galax.sdk.model.VPC;
import com.huawei.ism.drm.galax.sdk.proxy.VmMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.vrm.model.CipherChannel;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmNicSpecification;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.IpAddress6;
import com.huawei.ism.drm.galax.sdk.vrm.model.NicSpecification;
import com.huawei.ism.drm.galax.sdk.vrm.model.OsOptionsType;
import com.huawei.ism.drm.galax.sdk.vrm.model.RegisterVMRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.RegisterVMResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigNicType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmCustomization;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.c10.RegisterVMReqTypeExt;
import com.huawei.ism.drm.galax.sdk.vrm.service.IFMInfosRetriever;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractRegisterVmCmd
extends AbstractCommand {
    private static final Log LOGGER = LogFactory.getInstance(AbstractRegisterVmCmd.class);
    private static final String ALREADY_REGISTERVM = "10300451";
    private static final int NIC_MAX_NUM = 8;
    private VmMgrInfoBase vmMgrInfo;
    private String location;
    private String vrmSn;
    private String vpcId;
    private String proCloudSn;
    private Set<RecoverySetting> recoverySetting;

    public AbstractRegisterVmCmd(RecoveryPlatformInfo platformInfo, VmMgrInfoBase vmMgrInfo, Set<RecoverySetting> recoverySetting) {
        super(platformInfo.getRecSiteId(), platformInfo.getRecCloudSn());
        if (null == vmMgrInfo) {
            return;
        }
        this.vmMgrInfo = vmMgrInfo;
        this.proCloudSn = platformInfo.getCloudSn();
        this.recoverySetting = recoverySetting;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getVrmSn() {
        return this.vrmSn;
    }

    public void setVrmSn(String vrmSn) {
        this.vrmSn = vrmSn;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getProCloudSn() {
        return this.proCloudSn;
    }

    public void setProCloudSn(String proCloudSn) {
        this.proCloudSn = proCloudSn;
    }

    public VmMgrInfoBase getVmMgrInfo() {
        return this.vmMgrInfo;
    }

    public Set<RecoverySetting> getRecoverySetting() {
        return this.recoverySetting;
    }

    @Override
    public CloudPlatformResponse excute(Object ... params) {
        CloudPlatformResponse response = null;
        this.checkParams();
        if (GalaxVM.VMProviderType.FC.getValue().equals(this.vmMgrInfo.getVmType())) {
            this.queryFcPlaceHoldVmInfo(this.getCloudSn());
            response = this.excuteFcVm();
        }
        if (GalaxVM.VMProviderType.FM.getValue().equals(this.vmMgrInfo.getVmType())) {
            this.queryFmPlaceHoldVmInfo();
            response = this.excuteFmVm();
        }
        if (null != response) {
            response.getExtendParam().put(RpExParamsEnum.LOCATION.getValue(), this.location);
            if (null != this.vpcId) {
                String vpcIdKey = FmUtils.getFmResourceUrn((String)this.getCloudSn(), (String)VPC.class.getSimpleName(), (String)this.vpcId);
                response.getExtendParam().put(RpExParamsEnum.FM_VPC.getValue(), vpcIdKey);
            }
        }
        return response;
    }

    protected void checkParams() {
        if (null == this.location || null == this.vrmSn) {
            LOGGER.error((Object)("Failed to get rm by loc:" + this.vmMgrInfo.getLocation()), 90160758787071L);
            throw new FindNoResourceMappingCheckedException();
        }
    }

    protected void queryFmPlaceHoldVmInfo() {
    }

    protected String queryFcPlaceHoldVmInfo(String fcSn) {
        return null;
    }

    protected CloudPlatformResponse excuteFcVm() {
        VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject(this.getCloudSn());
        RegisterVMRequestType registerRequest = this.buildRegisterRequest(vrmInfo);
        this.fillRegisterVMRequest(registerRequest, vrmInfo);
        LOGGER.info((Object)("start to register vm(" + this.vmMgrInfo.getName() + "), request=" + registerRequest), 90160758786816L);
        RegisterVMResponseType response = FusionSphereServiceManager.getInstance().getVirResourceService().registerVM(vrmInfo, registerRequest);
        CloudPlatformResponse cloudResponse = this.generateCloudResponse(response);
        LOGGER.info((Object)("register vm(" + this.vmMgrInfo.getName() + ") end, response=" + cloudResponse), 90160758786816L);
        return cloudResponse;
    }

    private CloudPlatformResponse generateCloudResponse(RegisterVMResponseType response) {
        if (null == response) {
            return null;
        }
        CloudPlatformResponse cloudResponse = new CloudPlatformResponse(null, response.getErrorCode());
        if (ALREADY_REGISTERVM.equals(response.getErrorCode())) {
            LOGGER.info((Object)"Failed to getVmUri,the vm has been registered.", 90160758786816L);
            GalaxVM vm = this.getVmByUuid(this.vmMgrInfo.getUuid());
            if (null != vm) {
                cloudResponse.getExtendParam().put(RpExParamsEnum.VM_URN.getValue(), vm.getUrn());
                cloudResponse.getExtendParam().put(RpExParamsEnum.VM_URIORID.getValue(), vm.getUri());
                LOGGER.info((Object)("Calculate new vmUri&vmUrn is:" + vm.getUri() + vm.getUrn()), 90160758786816L);
            }
        } else if (null != response.getUri()) {
            cloudResponse.getExtendParam().put(RpExParamsEnum.VM_URN.getValue(), response.getUrn());
            cloudResponse.getExtendParam().put(RpExParamsEnum.VM_URIORID.getValue(), response.getUri());
        }
        cloudResponse.setFinished(true);
        cloudResponse.setSuccess(null != cloudResponse.getExtendParam().get(RpExParamsEnum.VM_URIORID.getValue()));
        return cloudResponse;
    }

    private GalaxVM getVmByUuid(String uuid) {
        GalaxVM vm;
        try {
            vm = (GalaxVM)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(GalaxVM.class, "uuid", (Object)uuid);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to get VmConfigType!" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            vm = null;
        }
        return vm;
    }

    private RegisterVMRequestType buildRegisterRequest(VrmObject vrmInfo) {
        if (!"v5.0".equals(vrmInfo.getVersion().getVersion())) {
            RegisterVMReqTypeExt reqTypeExt = new RegisterVMReqTypeExt();
            reqTypeExt.setIsMultiDiskSpeedup(this.vmMgrInfo.getIsMultiDiskSpeedup());
            return reqTypeExt;
        }
        RegisterVMRequestType request = new RegisterVMRequestType();
        return request;
    }

    protected void fillRegisterVMRequest(RegisterVMRequestType registerRequest, VrmObject vrmInfo) {
        VmConfigType vmConfigType = (VmConfigType)this.vmMgrInfo.generateVmConfig();
        if (!"v5.0".equals(vrmInfo.getVersion().getVersion())) {
            FsRecoveryUtil.setConfigPropertiesExt(this.vmMgrInfo.getVmConfig(), vmConfigType);
        }
        this.updateVmConfig(vmConfigType);
        OsOptionsType osOptionsType = (OsOptionsType)this.vmMgrInfo.generateVmOsOption();
        registerRequest.setName(this.vmMgrInfo.getName());
        registerRequest.setDescription(this.vmMgrInfo.getDescription());
        registerRequest.setGroup("");
        registerRequest.setIsBindingHost(Boolean.valueOf(this.vmMgrInfo.isHostLoc()));
        registerRequest.setLocation(this.location);
        registerRequest.setOsOptions(osOptionsType);
        registerRequest.setUuid(this.vmMgrInfo.getUuid());
        registerRequest.setVmConfig(vmConfigType);
        registerRequest.setIsTemplate(Boolean.valueOf(this.vmMgrInfo.isTemplate()));
        registerRequest.setConfidentialityLevel(this.vmMgrInfo.getConfidentialityLevel());
        registerRequest.setKek(this.vmMgrInfo.getKek());
        this.updateVmInfoByRecoverySetting(registerRequest);
        if (LegoBaseConfig.getInstance().getBoolean("require.check.vmcustom", Boolean.valueOf(true)).booleanValue() && registerRequest.getVmCustomization() != null && this.checkVmCustomization(registerRequest.getVmCustomization())) {
            registerRequest.setVmCustomization(null);
        }
    }

    private boolean checkVmCustomization(VmCustomization vmCustomization) {
        List nicSpecifications = vmCustomization.getNicSpecification();
        long validNicCount = nicSpecifications.stream().filter(nic -> nic.getIp() != null || nic.getIpAddress6() != null || nic.getGateway() != null || nic.getGatewayIpAddr6() != null).count();
        return validNicCount == 0L;
    }

    protected void updateVmInfoByRecoverySetting(RegisterVMRequestType request) {
        if (VerifyUtil.isEmpty(this.recoverySetting)) {
            return;
        }
        for (RecoverySetting setting : this.recoverySetting) {
            if (!"NicInfo".equals(setting.getName())) continue;
            request.setVmCustomization(this.getNicCustomSetting(request.getName(), request.getVmConfig().getNics(), setting));
        }
    }

    protected VmCustomization getNicCustomSetting(String name, List<VmConfigNicType> productNics, RecoverySetting setting) {
        VmCustomization customization = new VmCustomization();
        customization.setName(name);
        List nicSpecInfos = (List)com.huawei.ism.drm.galax.util.rest.CommonUtil.json2Bean((String)setting.getValue(), NicSpecification[].class);
        Collections.sort(nicSpecInfos, new Comparator<NicSpecification>(){

            @Override
            public int compare(NicSpecification arg0, NicSpecification arg1) {
                if (arg0.getSequenceNum() == null || arg1.getSequenceNum() == null) {
                    return -1;
                }
                return arg0.getSequenceNum().compareTo(arg1.getSequenceNum());
            }
        });
        ArrayList<NicSpecification> newSpecInfos = new ArrayList<NicSpecification>();
        for (VmConfigNicType pNic : productNics) {
            NicSpecification specNic = this.getSpecNicByProductNic(pNic, nicSpecInfos);
            if (specNic != null) {
                newSpecInfos.add(specNic);
                continue;
            }
            specNic = new NicSpecification();
            newSpecInfos.add(specNic);
        }
        int i = 1;
        for (NicSpecification nicSpec : newSpecInfos) {
            nicSpec.setSequenceNum(Integer.valueOf(i++));
        }
        customization.setNicSpecification(newSpecInfos);
        return customization;
    }

    private NicSpecification getSpecNicByProductNic(VmConfigNicType pNic, List<NicSpecification> specNics) {
        for (NicSpecification specNic : specNics) {
            if (!specNic.getSequenceNum().equals(pNic.getSequenceNum())) continue;
            return specNic;
        }
        return null;
    }

    protected void updateVmConfig(VmConfigType vmConfigType) {
        CipherChannel cipherChannel = vmConfigType.getCipherChannel();
        if (!VerifyUtil.isEmpty((Object)cipherChannel)) {
            vmConfigType.setCipherChannelId(cipherChannel.getId());
        } else {
            vmConfigType.setCipherChannelId(Long.valueOf(0L));
        }
        vmConfigType.setCipherChannel(null);
    }

    protected CloudPlatformResponse excuteFmVm() {
        String errorCode;
        String taskId;
        String vmId;
        block5: {
            vmId = null;
            taskId = null;
            errorCode = null;
            FmObject fo = FmUtils.generateFmObj((String)this.getCloudSn());
            ResourcepoolVMServiceV2Stub.VMInfo vmInfo = this.generateFmVmInfo();
            try {
                LOGGER.info((Object)("excute restore vm(" + this.vmMgrInfo.getName() + "), vpcId=" + this.vpcId + ", fo=" + fo + ", vmUUid=" + vmInfo.getVmUUId()), 90160758786816L);
                ResourcepoolVMServiceV2Stub.RestoreVMResponse response = FusionSphereServiceManager.getInstance().getFmRetriever().restoreVM(fo, this.vpcId, vmInfo);
                if (null != response) {
                    taskId = response.getTaskID();
                    vmId = response.getVmID();
                }
            }
            catch (FmBusinessException e) {
                LOGGER.error((Object)"Failed to act FmVm", (Throwable)e, 90160758787071L);
                errorCode = e.getErrorCode();
                vmId = this.findVmId();
                if (null == vmId) break block5;
                errorCode = ALREADY_REGISTERVM;
            }
        }
        CloudPlatformResponse cloudResponse = new CloudPlatformResponse(taskId, errorCode);
        if (null != vmId) {
            cloudResponse.getExtendParam().put(RpExParamsEnum.VM_URIORID.getValue(), vmId);
            if (ALREADY_REGISTERVM.equals(errorCode)) {
                cloudResponse.setFinished(true);
                cloudResponse.setSuccess(true);
            }
        }
        LOGGER.info((Object)("result of restore vm(" + this.vmMgrInfo.getName() + ")end, response=" + cloudResponse), 90160758786816L);
        return cloudResponse;
    }

    private String findVmId() {
        GalaxVM vm = this.getVmByUuid(this.vmMgrInfo.getUuid());
        if (null == vm) {
            return null;
        }
        IFmService fmService = FusionSphereServiceManager.getInstance().getFmService();
        Hypervisor hyperV = fmService.getHypervisorByVrm(this.vrmSn);
        if (null == hyperV) {
            return null;
        }
        String hypervisorId = FmUtils.getCommonObjectId((String)hyperV.getUuid(), (String)Hypervisor.class.getSimpleName());
        FmObject fmInfo = FmUtils.generateFmObj((String)this.getCloudSn());
        ArrayList<String> listVmUrns = new ArrayList<String>();
        listVmUrns.add(vm.getUrn());
        List<ResourcepoolVMServiceV2Stub.VMInfo0> vmInfos = this.getVmInfoEList(fmInfo, hypervisorId, listVmUrns);
        if (VerifyUtil.isEmpty(vmInfos)) {
            return null;
        }
        return vmInfos.get(0).getVmID();
    }

    protected List<ResourcepoolVMServiceV2Stub.VMInfo0> getVmInfoEList(FmObject fmInfo, String hypervisorId, List<String> listVmUrns) {
        IFMInfosRetriever fmRetriever = FusionSphereServiceManager.getInstance().getFmRetriever();
        ArrayList<ResourcepoolVMServiceV2Stub.VMInfo0> vmInfos = new ArrayList();
        try {
            vmInfos = fmRetriever.queryVMs(fmInfo, hypervisorId, listVmUrns);
        }
        catch (FmBusinessException e) {
            LOGGER.error((Object)"Failed to query vms.", (Throwable)e, 90160758787071L);
        }
        return vmInfos;
    }

    private ResourcepoolVMServiceV2Stub.VMInfo generateFmVmInfo() {
        ResourcepoolVMServiceV2Stub.VMInfo vmInfo = new ResourcepoolVMServiceV2Stub.VMInfo();
        vmInfo.setVmUUId(this.vmMgrInfo.getUuid());
        String description = this.vmMgrInfo.getDescription();
        vmInfo.setVLocation(this.location);
        vmInfo.setDescription(description);
        vmInfo.setName(this.vmMgrInfo.getName());
        this.updateVmInfo(vmInfo);
        return vmInfo;
    }

    protected void updateVmInfo(ResourcepoolVMServiceV2Stub.VMInfo vmInfo) {
        ResourcepoolVMServiceV2Stub.VmConfigSetE vmConfig = (ResourcepoolVMServiceV2Stub.VmConfigSetE)this.vmMgrInfo.generateVmConfig();
        ResourcepoolVMServiceV2Stub.OsOptions osOptions = (ResourcepoolVMServiceV2Stub.OsOptions)this.vmMgrInfo.generateVmOsOption();
        vmInfo.setCpu(vmConfig.getCpu());
        vmInfo.setOsOptions(osOptions);
        vmInfo.setMemory(vmConfig.getMemory());
        vmInfo.setProperties(vmConfig.getProperties());
        for (ResourcepoolVMServiceV2Stub.Disk disk : vmConfig.getDisks()) {
            this.updateDisk(disk);
        }
        vmInfo.setDisks(vmConfig.getDisks());
        this.findVpcId();
        List<ResourcepoolVMServiceV2Stub.VMNic> listVmNic = this.updateVmNics(vmConfig);
        if (!VerifyUtil.isEmpty(listVmNic)) {
            vmInfo.setVmNics(listVmNic.toArray(new ResourcepoolVMServiceV2Stub.VMNic[listVmNic.size()]));
        }
        this.updateVmInfoByRecoverySetting(vmInfo);
    }

    private void updateVmInfoByRecoverySetting(ResourcepoolVMServiceV2Stub.VMInfo request) {
        if (VerifyUtil.isEmpty(this.recoverySetting)) {
            return;
        }
        for (RecoverySetting setting : this.recoverySetting) {
            if (!"NicInfo".equals(setting.getName())) continue;
            List<ResourcepoolVMServiceV2Stub.NicCustom> fmNicList = this.getNicFmCustomSetting(setting);
            request.setNicCustomList(fmNicList.toArray(new ResourcepoolVMServiceV2Stub.NicCustom[fmNicList.size()]));
        }
    }

    protected void findVpcId() {
    }

    private List<ResourcepoolVMServiceV2Stub.VMNic> updateVmNics(ResourcepoolVMServiceV2Stub.VmConfigSetE vmConfig) {
        ArrayList<ResourcepoolVMServiceV2Stub.VMNic> listVmNic = new ArrayList<ResourcepoolVMServiceV2Stub.VMNic>();
        if (VerifyUtil.isEmpty((Object[])vmConfig.getNics())) {
            return listVmNic;
        }
        for (ResourcepoolVMServiceV2Stub.Nic nic : vmConfig.getNics()) {
            if (null == nic) continue;
            ResourcepoolVMServiceV2Stub.VMNic vmNic = new ResourcepoolVMServiceV2Stub.VMNic();
            this.updateFmNicForNetwork(vmNic, nic);
            vmNic.setGatewayPost(nic.getGateWay());
            vmNic.setIpAddrPost(nic.getIp());
            vmNic.setMaskPost(nic.getSubnetMask());
            vmNic.setNicNetworkId(nic.getNetworkid());
            vmNic.setSequenceNum(nic.getSequenceNum());
            vmNic.setMac(nic.getMac());
            vmNic.setName(nic.getName());
            this.updateFmNicForSgPort(vmNic, nic);
            FmNicSpecification fmNicSpec = this.getSpecification(nic);
            if (!VerifyUtil.isEmpty((Object)fmNicSpec)) {
                String recoverySiteId = ((RecoverySetting)CommonUtil.getFirstElement(this.recoverySetting)).getDisasterSiteId();
                String flexIp = VerifyUtil.isEmpty((Map)fmNicSpec.getFlexIpMap()) ? fmNicSpec.getFlexIp() : (String)fmNicSpec.getFlexIpMap().get(recoverySiteId);
                if (!VerifyUtil.isEmpty((String)flexIp)) {
                    ArrayList<String> publicIps = new ArrayList<String>();
                    publicIps.add(flexIp);
                    vmNic.setPublicIps(publicIps.toArray(new String[publicIps.size()]));
                }
                if (!(VerifyUtil.isEmpty((String)fmNicSpec.getPrivatePort()) || VerifyUtil.isEmpty((String)fmNicSpec.getPublicPort()) || VerifyUtil.isEmpty((String)fmNicSpec.getProtocal()))) {
                    ArrayList<ResourcepoolVMServiceV2Stub.Dnat> nats = new ArrayList<ResourcepoolVMServiceV2Stub.Dnat>();
                    ResourcepoolVMServiceV2Stub.Dnat nat = new ResourcepoolVMServiceV2Stub.Dnat();
                    nat.setPrivatePort(NumberUtil.convertToInteger((Object)fmNicSpec.getPrivatePort()).intValue());
                    nat.setPublicPort(NumberUtil.convertToInteger((Object)fmNicSpec.getPublicPort()).intValue());
                    nat.setProtocol(fmNicSpec.getProtocal());
                    if (!VerifyUtil.isEmpty((String)fmNicSpec.getPublicIp())) {
                        nat.setPublicIP(fmNicSpec.getPublicIp());
                    }
                    nats.add(nat);
                    vmNic.setDnats(nats.toArray(new ResourcepoolVMServiceV2Stub.Dnat[nats.size()]));
                }
            }
            listVmNic.add(vmNic);
        }
        return listVmNic;
    }

    protected void updateFmNicForNetwork(ResourcepoolVMServiceV2Stub.VMNic vmNic, ResourcepoolVMServiceV2Stub.Nic nic) {
    }

    protected void updateFmNicForSgPort(ResourcepoolVMServiceV2Stub.VMNic vmNic, ResourcepoolVMServiceV2Stub.Nic nic) {
    }

    protected List<ResourcepoolVMServiceV2Stub.NicCustom> getNicFmCustomSetting(RecoverySetting setting) {
        ArrayList<ResourcepoolVMServiceV2Stub.NicCustom> fmNicList = new ArrayList<ResourcepoolVMServiceV2Stub.NicCustom>();
        ResourcepoolVMServiceV2Stub.VmConfigSetE vmConfig = (ResourcepoolVMServiceV2Stub.VmConfigSetE)this.vmMgrInfo.generateVmConfig();
        ResourcepoolVMServiceV2Stub.Nic[] productNics = vmConfig.getNics();
        int i = 1;
        for (ResourcepoolVMServiceV2Stub.Nic pNic : productNics) {
            ResourcepoolVMServiceV2Stub.NicCustom nicCust;
            FmNicSpecification specNic = this.getSpecification(pNic, setting);
            if (specNic != null) {
                nicCust = new ResourcepoolVMServiceV2Stub.NicCustom();
                nicCust.setAdddns6(specNic.getAdddns6());
                nicCust.setAutoConfEnabled6(specNic.getAutoConfEnabled6() == null ? false : specNic.getAutoConfEnabled6());
                nicCust.setDhcpEnabled6(specNic.getDhcpEnabled6() == null ? false : specNic.getDhcpEnabled6());
                nicCust.setGateWay(specNic.getGateway());
                nicCust.setGatewayIpAddr6(specNic.getGatewayIpAddr6());
                nicCust.setIp(specNic.getIp());
                ArrayList<ResourcepoolVMServiceV2Stub.Ipv6> fmV6 = new ArrayList<ResourcepoolVMServiceV2Stub.Ipv6>();
                List ipv6List = specNic.getIpAddress6();
                if (!VerifyUtil.isEmpty((Collection)ipv6List)) {
                    for (IpAddress6 ipAddress6 : ipv6List) {
                        ResourcepoolVMServiceV2Stub.Ipv6 temp = new ResourcepoolVMServiceV2Stub.Ipv6();
                        temp.setIpv6Addr(ipAddress6.getIpv6Addr());
                        temp.setIpv6Prefix(ipAddress6.getIpv6Prefix());
                        fmV6.add(temp);
                    }
                }
                nicCust.setIpv6S(fmV6.toArray(new ResourcepoolVMServiceV2Stub.Ipv6[fmV6.size()]));
                if (specNic.getIpVersion() != null) {
                    nicCust.setIpVersion(NumberUtil.convertToInteger((Object)specNic.getIpVersion()).intValue());
                }
                nicCust.setPrimaryDNS(specNic.getSetdns());
                nicCust.setSecondaryDNS(specNic.getAdddns());
                nicCust.setSequenceNum(i++);
                nicCust.setSetdns6(specNic.getSetdns6());
                nicCust.setSubnetMask(specNic.getNetmask() == null ? 0 : com.huawei.ism.drm.galax.util.rest.CommonUtil.getSubNetMaskCount((String)specNic.getNetmask()));
                nicCust.setVUrn(this.vrmSn);
                fmNicList.add(nicCust);
                continue;
            }
            nicCust = new ResourcepoolVMServiceV2Stub.NicCustom();
            nicCust.setVUrn(this.vrmSn);
            nicCust.setSequenceNum(i++);
            fmNicList.add(nicCust);
        }
        return fmNicList;
    }

    private FmNicSpecification getSpecification(ResourcepoolVMServiceV2Stub.Nic nic) {
        if (VerifyUtil.isEmpty(this.recoverySetting)) {
            return null;
        }
        for (RecoverySetting setting : this.recoverySetting) {
            if (!"NicInfo".equals(setting.getName())) continue;
            return this.getSpecification(nic, setting);
        }
        return null;
    }

    private FmNicSpecification getSpecification(ResourcepoolVMServiceV2Stub.Nic nic, RecoverySetting setting) {
        List nics = (List)com.huawei.ism.drm.galax.util.rest.CommonUtil.json2Bean((String)setting.getValue(), FmNicSpecification[].class);
        for (FmNicSpecification fmNicSpec : nics) {
            if (fmNicSpec.getSequenceNum().intValue() != nic.getSequenceNum()) continue;
            return fmNicSpec;
        }
        return null;
    }

    protected void updateDisk(ResourcepoolVMServiceV2Stub.Disk disk) {
    }

    protected int querySequenceNum(List<VmConfigNicType> nics) {
        for (int i = 0; i < 8; ++i) {
            boolean flag = false;
            for (VmConfigNicType nic : nics) {
                int num;
                if (null == nic.getSequenceNum() || (num = nic.getSequenceNum().intValue()) != i) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            return i;
        }
        return 0;
    }
}

