/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.command.impl;

import com.huawei.ism.drm.constant.DrsEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlatformInfo;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractCommand;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.ism.drm.galax.sdk.model.DrsGroup;
import com.huawei.ism.drm.galax.sdk.model.DrsMapping;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.pg.host.service.ICloudController;
import com.huawei.ism.drm.galax.sdk.proxy.VmMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.service.IDrsMappingService;
import com.huawei.ism.drm.galax.sdk.vrm.model.DrsVmGroup;
import com.huawei.ism.drm.galax.sdk.vrm.model.VMOperateResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.DrsBalanceVmRequest;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.DrsGroupMember;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.DrsRule;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.DrsRuleGroupRequest;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.DrsSetting;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.DrsVm;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.ModifyDrsGroupRequest;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ConfigVmCmd
extends AbstractCommand {
    private static final Log logger = LogFactory.getInstance(ConfigVmCmd.class);
    private final ICloudController cloudController;
    private VmMgrInfoBase vmMgr;
    private List<DrsMapping> drsMappingList = new ArrayList<DrsMapping>();
    private IDrsMappingService drsMappingService;
    private RecoveryPlatformInfo platformInfo;
    private Map<String, List> prdDrsUrnAndVmIdMap = new HashMap<String, List>();

    public ConfigVmCmd(RecoveryProcessorContext context, RecoveryPlatformInfo platformInfo, VmMgrInfoBase vmMgr, ProtectObject po) {
        super(platformInfo.getSiteId(), platformInfo.getCloudSn());
        this.platformInfo = platformInfo;
        this.cloudController = (ICloudController)ServiceLocator.getInstance().getService(ICloudController.class);
        Set recoverySettings = context.getRecoveryPlan().getRecoverySettings();
        this.drsMappingService = (IDrsMappingService)ServiceLocator.getInstance().getService(IDrsMappingService.class);
        Optional<RecoverySetting> settingOptional = recoverySettings.stream().filter(set -> set.getOwnerId().equals(po.getUuid()) && set.getName().equals("prd_drs_vm_id_list")).findFirst();
        if (settingOptional.isPresent()) {
            RecoverySetting recoverySetting = settingOptional.get();
            this.prdDrsUrnAndVmIdMap = JSONObject.toMap((JSONObject)JSONObject.fromObject((Object)recoverySetting.getValue()), List.class);
        }
        if (vmMgr != null) {
            String productSiteId = String.valueOf(context.getAttribute("PRODUCT_SITE_ID"));
            String recoverySiteId = String.valueOf(context.getAttribute("SELECT_DISASTER_SITE_KEY"));
            JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
            ResourceMapping res = FsRecoveryUtil.getResourceMapping(jo.getString("location"), jo.getBoolean("hostLoc"), "productResourceId", productSiteId, recoverySiteId);
            List allMappingList = this.drsMappingService.getTotalDrsMapping(res.getMappingId());
            this.drsMappingList = allMappingList.stream().filter(DrsMapping::getIsValid).collect(Collectors.toList());
            this.vmMgr = vmMgr;
        }
    }

    @Override
    public CloudPlatformResponse excute(Object ... params) {
        CloudPlatformResponse cloudResponse = new CloudPlatformResponse(null, null);
        cloudResponse.setFinished(true);
        cloudResponse.setSuccess(true);
        if (this.prdDrsUrnAndVmIdMap.isEmpty()) {
            return cloudResponse;
        }
        GalaxVM drVm = this.cloudController.queryVmInfoByVmUuid(this.platformInfo.getRecCloudSn(), this.vmMgr.getUuid());
        VrmObject vrmObj = VrmUtil.getRecoveryVrmObject((String)this.platformInfo.getRecCloudSn());
        ArrayList<String> errNameList = new ArrayList<String>();
        Map<String, List<ModifyDrsGroupRequest>> msgMap = this.initRequest(this.prdDrsUrnAndVmIdMap, this.vmMgr.getUrn(), drVm.getUrn());
        logger.info((Object)"Valid DRS Mapping Quantity:%s,Number of to-be-synchronized:%s", new Object[]{this.drsMappingList.size(), msgMap.size()});
        for (Map.Entry<String, List<ModifyDrsGroupRequest>> map : msgMap.entrySet()) {
            this.configDrs(vrmObj, errNameList, map);
        }
        if (!errNameList.isEmpty()) {
            logger.error((Object)"Config vm(%s) DRS(%s) error.", new Object[]{this.vmMgr.getName(), String.join((CharSequence)",", errNameList)});
            throw new LegoCheckedException(1073949728L, new String[]{String.join((CharSequence)",", errNameList)});
        }
        return cloudResponse;
    }

    private void configDrs(VrmObject vrmObj, List<String> errNameList, Map.Entry<String, List<ModifyDrsGroupRequest>> map) {
        for (ModifyDrsGroupRequest request : map.getValue()) {
            try {
                VMOperateResponseType vmOperateResponseType = VrmManager.getInstance().getVrmVirtualResService().modifyDrsGroup(map.getKey(), vrmObj, request.getMsg());
                if (VerifyUtil.isEmpty((Object)vmOperateResponseType) || VerifyUtil.isEmpty((String)vmOperateResponseType.getErrorCode())) continue;
                logger.error((Object)"Config errorCode:%s,errMsg:%s", new Object[]{vmOperateResponseType.getErrorCode(), vmOperateResponseType.getErrorDes()});
                throw new LegoCheckedException(vmOperateResponseType.getErrorCode());
            }
            catch (Exception e) {
                logger.error((Object)"Config vm(%s) DRS(%s) error:%s", new Object[]{this.vmMgr.getUuid(), request.getGroupName(), ExceptionUtil.getErrorMessage((Throwable)e)});
                errNameList.add(request.getGroupName());
            }
        }
    }

    private Optional<DrsGroup> getRecoveryDrsGroupUrn(String prdUrn) {
        for (DrsMapping drsMapping : this.drsMappingList) {
            if (drsMapping.getProductGroupUrn().equals(prdUrn)) {
                DrsGroup drsGroup = new DrsGroup();
                drsGroup.setUrn(drsMapping.getRecoveryGroupUrn());
                drsGroup.setName(drsMapping.getRecoveryGroupName());
                drsGroup.setRuleType(drsMapping.getRuleType());
                drsGroup.setGroupType(drsMapping.getGroupType());
                return Optional.of(drsGroup);
            }
            if (!drsMapping.getRecoveryGroupUrn().equals(prdUrn)) continue;
            DrsGroup drsGroup = new DrsGroup();
            drsGroup.setUrn(drsMapping.getProductGroupUrn());
            drsGroup.setName(drsMapping.getProductGroupName());
            drsGroup.setRuleType(drsMapping.getRuleType());
            drsGroup.setGroupType(drsMapping.getGroupType());
            return Optional.of(drsGroup);
        }
        return Optional.empty();
    }

    private Map<String, List<ModifyDrsGroupRequest>> initRequest(Map<String, List> drsVmList, String pdVmUrn, String drVmUrn) {
        HashMap<String, List<ModifyDrsGroupRequest>> result = new HashMap<String, List<ModifyDrsGroupRequest>>();
        for (Map.Entry<String, List> entry : drsVmList.entrySet()) {
            Optional<DrsGroup> drsGroupOptional;
            if (!entry.getValue().contains(pdVmUrn) || !(drsGroupOptional = this.getRecoveryDrsGroupUrn(entry.getKey())).isPresent()) continue;
            List<String> pdVmList = this.getVmList(entry, drsGroupOptional.get());
            this.initRequestMsg(drsGroupOptional.get(), drVmUrn, result, pdVmList);
        }
        return result;
    }

    private List<String> getVmList(Map.Entry<String, List> entry, DrsGroup drsGroup) {
        DrsMapping drsMapping;
        if (drsGroup.getGroupType().intValue() == DrsEnumDefine.GroupTypeEnum.RULE_GROUP.getValue() && (drsMapping = (DrsMapping)this.drsMappingList.stream().filter(mp -> mp.getProductGroupUrn().equals(drsGroup.getUrn()) || mp.getRecoveryGroupUrn().equals(drsGroup.getUrn())).findFirst().orElse(null)) != null) {
            Site drSite = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(this.platformInfo.getRecSiteId());
            Map drVmMap = this.drsMappingService.getVmsOfGroup(Collections.singletonList(drsMapping), drSite);
            String drDrsGroupUrn = drsMapping.getProductGroupUrn().equals(entry.getKey()) ? drsMapping.getRecoveryGroupUrn() : drsMapping.getProductGroupUrn();
            return drVmMap.getOrDefault(drDrsGroupUrn, Collections.emptyList());
        }
        return Collections.emptyList();
    }

    private void initRequestMsg(DrsGroup drsGroup, String recoveryUrn, Map<String, List<ModifyDrsGroupRequest>> result, List<String> vmUrnList) {
        if (VerifyUtil.isEmpty((Object)drsGroup) || VerifyUtil.isEmpty((String)drsGroup.getUrn())) {
            return;
        }
        String clusterId = drsGroup.getUrn().split(":")[4];
        String groupId = drsGroup.getUrn().split(":")[6];
        ModifyDrsGroupRequest modifyDrsGroupRequest = new ModifyDrsGroupRequest();
        modifyDrsGroupRequest.setGroupName(drsGroup.getName());
        if (drsGroup.getGroupType().intValue() == DrsEnumDefine.GroupTypeEnum.VM_GROUP.getValue()) {
            DrsGroupMember drsGroupMember = new DrsGroupMember(recoveryUrn, DrsEnumDefine.OperateType.ADD.getValue());
            DrsVmGroup drsVmGroup = new DrsVmGroup(0, Collections.singletonList(drsGroupMember));
            modifyDrsGroupRequest.setMsg((Object)drsVmGroup);
            String key = String.format(Locale.ROOT, "/clusters/%s/resourcegroups/%s", clusterId, groupId);
            List requests = result.getOrDefault(key, new ArrayList());
            requests.add(modifyDrsGroupRequest);
            result.put(key, requests);
        } else if (drsGroup.getGroupType().intValue() == DrsEnumDefine.GroupTypeEnum.RULE_GROUP.getValue()) {
            ArrayList<DrsVm> drsVmList = new ArrayList<DrsVm>();
            DrsVm drsVm = new DrsVm(recoveryUrn);
            drsVmList.add(drsVm);
            for (String vmUrn : vmUrnList) {
                DrsVm defaultUrn = new DrsVm(vmUrn);
                drsVmList.add(defaultUrn);
            }
            DrsRule drsRule = this.getDrsRule(drsGroup, groupId, drsVmList);
            DrsSetting drsSetting = new DrsSetting(Collections.singletonList(drsRule));
            DrsRuleGroupRequest drsRuleGroupRequest = new DrsRuleGroupRequest(drsSetting);
            modifyDrsGroupRequest.setMsg((Object)drsRuleGroupRequest);
            String key = String.format(Locale.ROOT, "/clusters/%s", clusterId);
            List requests = result.getOrDefault(key, new ArrayList());
            requests.add(modifyDrsGroupRequest);
            result.put(key, requests);
        } else if (drsGroup.getGroupType().intValue() == DrsEnumDefine.GroupTypeEnum.BALANCED_GROUP.getValue()) {
            ArrayList<DrsGroupMember> drsGroupMembers = new ArrayList<DrsGroupMember>();
            DrsGroupMember drsGroupMember = new DrsGroupMember(recoveryUrn, DrsEnumDefine.OperateType.ADD.getValue());
            drsGroupMembers.add(drsGroupMember);
            DrsBalanceVmRequest drsBalanceVmRequest = new DrsBalanceVmRequest();
            drsBalanceVmRequest.setMembers(drsGroupMembers);
            modifyDrsGroupRequest.setMsg((Object)drsBalanceVmRequest);
            String key = String.format(Locale.ROOT, "/clusters/%s/lbgroups/%s", clusterId, groupId);
            List requests = result.getOrDefault(key, new ArrayList());
            requests.add(modifyDrsGroupRequest);
            result.put(key, requests);
        } else {
            return;
        }
    }

    private DrsRule getDrsRule(DrsGroup drsGroup, String groupId, List<DrsVm> drsVmList) {
        DrsRule drsRule = new DrsRule();
        drsRule.setRuleType(drsGroup.getRuleType().intValue());
        drsRule.setOperationType(DrsEnumDefine.OperateType.ADD.getValue());
        drsRule.setRuleType(drsGroup.getRuleType().intValue());
        drsRule.setRuleIndex(Integer.parseInt(groupId));
        drsRule.setVms(drsVmList);
        return drsRule;
    }
}

