/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.command.impl;

import com.huawei.ism.drm.galax.constant.cloudenum.VmRecoveryCmdEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractCommand;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.proxy.VmMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.VMOperateResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;

public class DeleteVmCmd
extends AbstractCommand {
    private static final Log logger = LogFactory.getInstance(DeleteVmCmd.class);
    private String vmKey;
    private String vmType;
    private String urlExt;

    public DeleteVmCmd(String siteId, String cloudSn, VmMgrInfoBase param) {
        super(siteId, cloudSn);
        if (null != param) {
            this.vmKey = param.getVmUriOrId();
            this.vmType = param.getVmType();
        }
    }

    public DeleteVmCmd(String siteId, String cloudSn, VmMgrInfoBase param, String urlExt) {
        super(siteId, cloudSn);
        if (null != param) {
            this.vmKey = param.getVmUriOrId();
            this.vmType = param.getVmType();
        }
        this.urlExt = urlExt;
    }

    @Override
    public CloudPlatformResponse excute(Object ... params) {
        if (GalaxVM.VMProviderType.FC.getValue().equals(this.vmType)) {
            return this.excuteFcVm();
        }
        if (GalaxVM.VMProviderType.FM.getValue().equals(this.vmType)) {
            return this.excuteFmVm();
        }
        return null;
    }

    private CloudPlatformResponse excuteFcVm() {
        CloudPlatformResponse cloudResponse;
        VMOperateResponseType response;
        logger.info((Object)("start to delete FC vm, vmKey=" + this.vmKey + ", cloudSn=" + this.getCloudSn()), 90160758786816L);
        Site site = FusionSphereServiceManager.getInstance().getSiteService().getSiteById(this.getSiteId());
        if (1 == site.getSiteType()) {
            String params = this.vmKey;
            if (null != this.urlExt) {
                params = this.vmKey + "@";
            }
            response = (VMOperateResponseType)FsRecoveryUtil.excuteCmdToCloud(this.getSiteId(), this.getCloudSn(), params, VmRecoveryCmdEnum.DELETE_VM.toString());
        } else {
            VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject(this.getCloudSn());
            response = FusionSphereServiceManager.getInstance().getVirResourceService().terminateVm(vrmInfo, this.vmKey, this.urlExt);
        }
        if (null == response) {
            logger.error((Object)"faild to excute delete vm cmd, response is null.", 90160758787071L);
            cloudResponse = new CloudPlatformResponse(null, null);
            cloudResponse.setFinished(true);
            cloudResponse.setSuccess(false);
            return cloudResponse;
        }
        cloudResponse = new CloudPlatformResponse(response.getTaskUri(), response.getErrorCode());
        logger.info((Object)("delete FC vm end, response=" + cloudResponse), 90160758786816L);
        return cloudResponse;
    }

    private CloudPlatformResponse excuteFmVm() {
        logger.info((Object)("start to delete FM vm, vmKey=" + this.vmKey + ", cloudSn=" + this.getCloudSn()), 90160758786816L);
        String taskId = null;
        String errorCode = null;
        Site site = FusionSphereServiceManager.getInstance().getSiteService().getSiteById(this.getSiteId());
        if (1 == site.getSiteType()) {
            return this.excuteRemoteCmd();
        }
        try {
            FmObject fo = FmUtils.generateFmObj((String)this.getCloudSn());
            taskId = FusionSphereServiceManager.getInstance().getFmRetriever().deleteVM(fo, this.vmKey);
        }
        catch (FmBusinessException e) {
            logger.error((Object)"Failed to act FmVm.", (Throwable)e, 90160758787071L);
            errorCode = e.getErrorCode();
        }
        CloudPlatformResponse cloudResponse = new CloudPlatformResponse(taskId, errorCode);
        logger.info((Object)("delete FM vm end, response=" + cloudResponse), 90160758786816L);
        return cloudResponse;
    }

    private CloudPlatformResponse excuteRemoteCmd() {
        String taskId = null;
        String errorCode = null;
        try {
            String jsonStr = (String)FsRecoveryUtil.excuteCmdToCloud(this.getSiteId(), this.getCloudSn(), this.vmKey, VmRecoveryCmdEnum.DELETE_VM.toString());
            JSONObject jsonObj = JSONObject.fromObject((Object)jsonStr);
            if (jsonObj.containsKey((Object)"errorCode")) {
                errorCode = (String)jsonObj.get("errorCode");
            } else {
                taskId = (String)jsonObj.get("taskId");
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Failed to transfer jsonStr:" + this.getSiteId() + ":" + this.getCloudSn() + ":" + VmRecoveryCmdEnum.DELETE_VM.toString()), (Throwable)e, 90160758787071L);
        }
        return new CloudPlatformResponse(taskId, errorCode);
    }
}

