/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.command.impl;

import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractCommand;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.proxy.VmMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.VMOperateResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class HangUpVmCmd
extends AbstractCommand {
    private static final Log logger = LogFactory.getInstance(HangUpVmCmd.class);
    private String vmKey;
    private String vmType;

    public HangUpVmCmd(String siteId, String cloudSn, VmMgrInfoBase vmMgr) {
        super(siteId, cloudSn);
        if (null != vmMgr) {
            this.vmKey = vmMgr.getVmUriOrId();
            this.vmType = vmMgr.getVmType();
        }
    }

    @Override
    public CloudPlatformResponse excute(Object ... params) {
        if (GalaxVM.VMProviderType.FC.getValue().equals(this.vmType)) {
            return this.excuteFcVm();
        }
        if (GalaxVM.VMProviderType.FM.getValue().equals(this.vmType)) {
            return this.excuteFmVm();
        }
        return null;
    }

    private CloudPlatformResponse excuteFcVm() {
        logger.info((Object)("Hangup FC vm begin. vm=" + this.vmKey + ", cloudSn=" + this.getCloudSn()), 90160758786816L);
        VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject(this.getCloudSn());
        VMOperateResponseType response = FusionSphereServiceManager.getInstance().getVirResourceService().hangUpVM(vrmInfo, this.vmKey);
        if (response == null) {
            logger.info((Object)"Hangup FC vm end. response is null.", 90160758786816L);
            CloudPlatformResponse cloudResponse = new CloudPlatformResponse(null, null);
            cloudResponse.setFinished(true);
            cloudResponse.setSuccess(false);
            return cloudResponse;
        }
        logger.info((Object)("Hangup FC VM's VMOperateResponse is:" + CommonUtil.beanToJson((Object)response)), 90160758786816L);
        CloudPlatformResponse cloudResponse = new CloudPlatformResponse(response.getTaskUri(), response.getErrorCode());
        cloudResponse.getExtendParam().put(RpExParamsEnum.VM_URIORID.getValue(), this.vmKey);
        cloudResponse.getExtendParam().put(RpExParamsEnum.VM_TYPE.getValue(), this.vmType);
        logger.info((Object)("Hangup FC vm end. response=" + cloudResponse), 90160758786816L);
        return cloudResponse;
    }

    private CloudPlatformResponse excuteFmVm() {
        String taskId = null;
        String errorCode = null;
        logger.info((Object)("Hangup FM vm begin, vmKey=" + this.vmKey + ", cloudSn=" + this.getCloudSn()), 90160758786816L);
        try {
            FmObject fo = FmUtils.generateFmObj((String)this.getCloudSn());
            taskId = FusionSphereServiceManager.getInstance().getFmRetriever().pauseVM(fo, this.vmKey);
        }
        catch (FmBusinessException e) {
            logger.error((Object)"Failed to Hangup FM vm.", (Throwable)e, 90160758787071L);
            errorCode = e.getErrorCode();
        }
        CloudPlatformResponse cloudResponse = new CloudPlatformResponse(taskId, errorCode);
        cloudResponse.getExtendParam().put(RpExParamsEnum.VM_URIORID.getValue(), this.vmKey);
        cloudResponse.getExtendParam().put(RpExParamsEnum.VM_TYPE.getValue(), this.vmType);
        logger.info((Object)("Hangup FM vm end, response=" + cloudResponse), 90160758786816L);
        return cloudResponse;
    }
}

