/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.command.impl;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolCommonServiceV2Stub;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractCommand;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmTaskType;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.common.task.constants.TaskExecuteStatus;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;

public class QueryResultCmd
extends AbstractCommand {
    private static final Log logger = LogFactory.getInstance(QueryResultCmd.class);
    private static final int TASK_STATUS_SUCCESS = 0;
    private static final int TASK_STATUS_FAILED = 1;
    private String vmType;
    private boolean isCheckDetail = false;

    public QueryResultCmd(String siteId, String cloudSn, String vmType) {
        super(siteId, cloudSn);
        this.vmType = vmType;
        this.isCheckDetail = false;
    }

    public QueryResultCmd(String siteId, String cloudSn, String vmType, boolean isCheckDetail) {
        super(siteId, cloudSn);
        this.vmType = vmType;
        this.isCheckDetail = isCheckDetail;
    }

    @Override
    public CloudPlatformResponse excute(Object ... params) {
        if (null == params) {
            return null;
        }
        String taskId = (String)params[0];
        if (GalaxVM.VMProviderType.FC.getValue().equals(this.vmType)) {
            return this.excuteFc(taskId);
        }
        if (GalaxVM.VMProviderType.FM.getValue().equals(this.vmType)) {
            return this.excuteFm(taskId);
        }
        return null;
    }

    private CloudPlatformResponse excuteFc(String taskId) {
        VrmTaskType taskResult;
        Site site = FusionSphereServiceManager.getInstance().getSiteService().getSiteById(this.getSiteId());
        if (1 == site.getSiteType()) {
            taskResult = (VrmTaskType)FsRecoveryUtil.queryVmResult(this.getSiteId(), this.getCloudSn(), taskId);
        } else {
            VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject(this.getCloudSn());
            taskResult = FusionSphereServiceManager.getInstance().getVirResourceService().describeTasks(vrmInfo, taskId);
        }
        if (null == taskResult) {
            logger.error((Object)("result of query task is null, cloudSn=" + this.getCloudSn() + ", taskId=" + taskId), 90160758786816L);
            return new CloudPlatformResponse(null, null);
        }
        CloudPlatformResponse response = new CloudPlatformResponse(taskResult.getUri(), taskResult.getReason());
        if (taskResult.getStatus().equals(TaskExecuteStatus.success.name()) || taskResult.getStatus().equals(TaskExecuteStatus.failed.name())) {
            logger.info((Object)("result of end query task is " + taskResult), 90160758786816L);
            response.setFinished(true);
            if (this.isCheckDetail) {
                response.setSuccess(taskResult.getStatus().equals(TaskExecuteStatus.success.name()) && VerifyUtil.isEmpty((String)taskResult.getReason()));
            } else {
                response.setSuccess(taskResult.getStatus().equals(TaskExecuteStatus.success.name()));
            }
            return response;
        }
        return response;
    }

    private CloudPlatformResponse excuteFm(String taskId) {
        String errorCode = null;
        ResourcepoolCommonServiceV2Stub.QueryTaskResp response = null;
        Site site = FusionSphereServiceManager.getInstance().getSiteService().getSiteById(this.getSiteId());
        try {
            if (1 == site.getSiteType()) {
                response = (ResourcepoolCommonServiceV2Stub.QueryTaskResp)FsRecoveryUtil.queryVmResult(this.getSiteId(), this.getCloudSn(), taskId);
            } else {
                FmObject fmObject = FmUtils.generateFmObj((String)this.getCloudSn());
                response = FusionSphereServiceManager.getInstance().getFmRetriever().queryTask(fmObject, taskId);
            }
        }
        catch (FmBusinessException e) {
            logger.error((Object)("Failed to queryTask:" + taskId), (Throwable)e, 90160758787071L);
            errorCode = e.getErrorCode();
        }
        CloudPlatformResponse cloudResponse = new CloudPlatformResponse(taskId, errorCode);
        if (null != response) {
            int taskResult = response.getStatus();
            if (0 == taskResult || 1 == taskResult) {
                logger.info((Object)("result of end query task is " + taskResult + ", taskId=" + taskId), 90160758786816L);
                cloudResponse.setFinished(true);
                cloudResponse.setSuccess(0 == taskResult);
            }
        } else {
            logger.error((Object)("result of query task is null, cloudSn=" + this.getCloudSn() + ", taskId=" + taskId), 90160758786816L);
            cloudResponse.setFinished(true);
            cloudResponse.setSuccess(false);
        }
        return cloudResponse;
    }
}

