/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.command.impl;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.discover.commons.DeviceOperationLock;
import com.huawei.ism.cbb.discover.commons.OperationLock;
import com.huawei.ism.cbb.discover.commons.RefreshContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractCommand;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.HashSet;
import java.util.Set;

public class RefreshCloudCmd
extends AbstractCommand {
    private static final Log logger = LogFactory.getInstance(RefreshCloudCmd.class);
    private static final long MAX_WAIT_INTERVAL = 15000L;
    private static final long SYS_IS_BUSY = 102401L;
    private String cloudType;
    private String recoveryType;
    private Set<String> pgUuidSet = new HashSet<String>();

    public RefreshCloudCmd(String siteId, String cloudSn, String cloudType, String recoveryType) {
        super(siteId, cloudSn);
        this.cloudType = cloudType;
        this.recoveryType = recoveryType;
    }

    public RefreshCloudCmd(String siteId, String cloudSn, String cloudType, String recoveryType, Set<String> pgUuidSet) {
        super(siteId, cloudSn);
        this.cloudType = cloudType;
        this.recoveryType = recoveryType;
        this.pgUuidSet = pgUuidSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CloudPlatformResponse excute(Object ... params) {
        OperationLock operationLock = DeviceOperationLock.getLock((String)this.getCloudSn());
        synchronized (operationLock) {
            CloudPlatformResponse response = this.refreshCloudWaitBack();
            return response;
        }
    }

    private CloudPlatformResponse refreshCloudWaitBack() {
        CloudPlatformResponse response;
        logger.info((Object)("start to refresh CloudPlatform, cloudSn=" + this.getCloudSn()), 90160758786816L);
        while (true) {
            try {
                response = this.refreshCloud();
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() == 102401L) {
                    logger.info((Object)"Sys is busy.", 90160758786816L);
                    CommonUtil.sleep((long)15000L);
                    continue;
                }
                throw e;
            }
            break;
        }
        logger.info((Object)("refresh CloudPlatform end, response=" + response), 90160758786816L);
        return response;
    }

    private CloudPlatformResponse refreshCloud() {
        NetworkEntity mo = (NetworkEntity)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(NetworkEntity.class, "sn", (Object)this.getCloudSn());
        RefreshContext context = new RefreshContext((ManagedObject)mo);
        context.setAttribute("refreshTask", (Object)this);
        context.setAttribute("DiscoveryType", (Object)"refresh");
        context.setAttribute("GALAX_RECOVERY_TYPE", (Object)this.recoveryType);
        context.setAttribute("PG_FORCE_REFRESH_SET", this.pgUuidSet);
        CommonTemplate refreshTemplate = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType(this.cloudType);
        if (null == refreshTemplate) {
            throw new LegoCheckedException(127402L);
        }
        refreshTemplate.process((AbstractContext)context);
        Long errorCode = (Long)context.getAttribute("icommand:errorcode");
        if (errorCode != null) {
            throw new LegoCheckedException(errorCode.longValue());
        }
        CloudPlatformResponse response = new CloudPlatformResponse(null, null);
        response.setFinished(true);
        response.setSuccess(true);
        return response;
    }
}

