/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.command.impl;

import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractCommand;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.proxy.VmMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.VMOperateResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class StartVmCmd
extends AbstractCommand {
    private static final Log logger = LogFactory.getInstance(StartVmCmd.class);
    private String vmKey;
    private String vmType;

    public StartVmCmd(String siteId, String cloudSn, VmMgrInfoBase vmMgr) {
        super(siteId, cloudSn);
        if (null != vmMgr) {
            this.vmKey = vmMgr.getVmUriOrId();
            this.vmType = vmMgr.getVmType();
        }
    }

    @Override
    public CloudPlatformResponse excute(Object ... params) {
        if (GalaxVM.VMProviderType.FC.getValue().equals(this.vmType)) {
            return this.excuteFcVm();
        }
        if (GalaxVM.VMProviderType.FM.getValue().equals(this.vmType)) {
            return this.excuteFmVm();
        }
        return null;
    }

    private CloudPlatformResponse excuteFcVm() {
        logger.info((Object)("start to start FC vm, vmKey=" + this.vmKey + ", cloudSn=" + this.getCloudSn()), 90160758786816L);
        VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject(this.getCloudSn());
        VMOperateResponseType response = FusionSphereServiceManager.getInstance().getVirResourceService().startVM(vrmInfo, this.vmKey);
        if (null == response) {
            logger.error((Object)"faild to start FC vm, response is null.", 90160758787071L);
            CloudPlatformResponse cloudResponse = new CloudPlatformResponse(null, null);
            cloudResponse.setFinished(true);
            cloudResponse.setSuccess(false);
            return cloudResponse;
        }
        CloudPlatformResponse cloudResponse = new CloudPlatformResponse(response.getTaskUri(), response.getErrorCode());
        logger.info((Object)("start FC vm end, response=" + cloudResponse), 90160758786816L);
        return cloudResponse;
    }

    private CloudPlatformResponse excuteFmVm() {
        logger.info((Object)("start to start FM vm, vmKey=" + this.vmKey + ", cloudSn=" + this.getCloudSn()), 90160758786816L);
        FmObject fo = FmUtils.generateFmObj((String)this.getCloudSn());
        String taskId = null;
        String errorCode = null;
        try {
            taskId = FusionSphereServiceManager.getInstance().getFmRetriever().startVM(fo, this.vmKey);
        }
        catch (FmBusinessException e) {
            logger.error((Object)"Failed to act FmVm.", (Throwable)e, 90160758787071L);
            errorCode = e.getErrorCode();
        }
        CloudPlatformResponse cloudResponse = new CloudPlatformResponse(taskId, errorCode);
        logger.info((Object)("start FM vm end, response=" + cloudResponse), 90160758786816L);
        return cloudResponse;
    }
}

