/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.command.impl;

import com.huawei.ism.drm.galax.constant.cloudenum.StopVmMode;
import com.huawei.ism.drm.galax.constant.cloudenum.VmRecoveryCmdEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.recovery.process.command.impl.AbstractCommand;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.proxy.VmMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.VMOperateResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;

public class StopVmCmd
extends AbstractCommand {
    private static final Log logger = LogFactory.getInstance(StopVmCmd.class);
    private String vmKey;
    private String vmType;
    private StopVmMode stopVmMode = StopVmMode.safe;

    public StopVmCmd(String siteId, String cloudSn, VmMgrInfoBase vmMgr, StopVmMode stopMode) {
        super(siteId, cloudSn);
        if (null != vmMgr) {
            this.vmKey = vmMgr.getVmUriOrId();
            this.vmType = vmMgr.getVmType();
        }
        if (null != stopMode) {
            this.stopVmMode = stopMode;
        }
    }

    @Override
    public CloudPlatformResponse excute(Object ... params) {
        if (GalaxVM.VMProviderType.FC.getValue().equals(this.vmType)) {
            return this.excuteFcVm();
        }
        if (GalaxVM.VMProviderType.FM.getValue().equals(this.vmType)) {
            return this.excuteFmVm();
        }
        return null;
    }

    private CloudPlatformResponse excuteFcVm() {
        CloudPlatformResponse cloudResponse;
        VMOperateResponseType response;
        Site site = FusionSphereServiceManager.getInstance().getSiteService().getSiteById(this.getSiteId());
        if (1 == site.getSiteType()) {
            logger.info((Object)("excute stop vm to remote cloud, cloudSn=" + this.getCloudSn() + ", vmKey=" + this.vmKey + ", mode=" + this.stopVmMode), 90160758786816L);
            response = (VMOperateResponseType)FsRecoveryUtil.excuteCmdToCloud(this.getSiteId(), this.getCloudSn(), this.vmKey, StopVmMode.force.equals((Object)this.stopVmMode) ? VmRecoveryCmdEnum.STOP_VM_FORCE.toString() : VmRecoveryCmdEnum.STOP_VM_SAFE.toString());
        } else {
            VrmObject vrmInfo = FsRecoveryUtil.getRecoveryVrmObject(this.getCloudSn());
            logger.info((Object)("excute stop vm, vrmInfo=" + vrmInfo + ", vmKey=" + this.vmKey + ", mode=" + this.stopVmMode), 90160758786816L);
            response = FusionSphereServiceManager.getInstance().getVirResourceService().stopVM(vrmInfo, this.vmKey, this.stopVmMode);
        }
        if (null == response) {
            logger.error((Object)"faild to excute cmd, response is null.", 90160758787071L);
            cloudResponse = new CloudPlatformResponse(null, null);
            cloudResponse.setFinished(true);
            cloudResponse.setSuccess(false);
            return cloudResponse;
        }
        cloudResponse = new CloudPlatformResponse(response.getTaskUri(), response.getErrorCode());
        logger.info((Object)("result of excute stop vm, response=" + cloudResponse), 90160758786816L);
        return cloudResponse;
    }

    private CloudPlatformResponse excuteFmVm() {
        String taskId = null;
        String errorCode = null;
        Site site = FusionSphereServiceManager.getInstance().getSiteService().getSiteById(this.getSiteId());
        if (1 == site.getSiteType()) {
            return this.excuteRemoteCmd();
        }
        try {
            FmObject fo = FmUtils.generateFmObj((String)this.getCloudSn());
            logger.info((Object)("excute stop vm, fo=" + fo + ", vmKey=" + this.vmKey + ", mode=" + this.stopVmMode), 90160758786816L);
            taskId = StopVmMode.force.equals((Object)this.stopVmMode) ? FusionSphereServiceManager.getInstance().getFmRetriever().stopVMForce(fo, this.vmKey) : FusionSphereServiceManager.getInstance().getFmRetriever().stopVMSafe(fo, this.vmKey);
        }
        catch (FmBusinessException e) {
            logger.error((Object)"Failed to stop FmVm.", (Throwable)e, 90160758787071L);
            errorCode = e.getErrorCode();
        }
        CloudPlatformResponse cloudResponse = new CloudPlatformResponse(taskId, errorCode);
        logger.info((Object)("result of excute stop vm, response=" + cloudResponse), 90160758786816L);
        return cloudResponse;
    }

    private CloudPlatformResponse excuteRemoteCmd() {
        String taskId = null;
        String errorCode = null;
        try {
            logger.info((Object)("excute stop vm to remote cloud, cloudSn=" + this.getCloudSn() + ", vmKey=" + this.vmKey + ", mode=" + this.stopVmMode), 90160758786816L);
            String jsonStr = (String)FsRecoveryUtil.excuteCmdToCloud(this.getSiteId(), this.getCloudSn(), this.vmKey, StopVmMode.force.equals((Object)this.stopVmMode) ? VmRecoveryCmdEnum.STOP_VM_FORCE.toString() : VmRecoveryCmdEnum.STOP_VM_SAFE.toString());
            JSONObject jsonObj = JSONObject.fromObject((Object)jsonStr);
            if (jsonObj.containsKey((Object)"errorCode")) {
                errorCode = (String)jsonObj.get("errorCode");
            } else {
                taskId = (String)jsonObj.get("taskId");
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Failed to transfer jsonStr:" + this.getSiteId() + this.getCloudSn() + this.vmKey), (Throwable)e, 90160758787071L);
        }
        logger.info((Object)("result of excute stop vm to remote cloud, taskId=" + taskId + ", errorCode=" + errorCode), 90160758786816L);
        return new CloudPlatformResponse(taskId, errorCode);
    }
}

