/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.command.parse;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseSubRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.command.ICmdResponseParser;
import com.huawei.ism.drm.galax.recovery.process.command.exception.FindNoResourceMappingCheckedException;
import com.huawei.ism.drm.galax.sdk.model.CloudPlatformResponse;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class BaseRecoveryCmdResParser
implements ICmdResponseParser {
    private static final Log logger = LogFactory.getInstance(BaseRecoveryCmdResParser.class);
    private static final String ALREADY_REGISTERVM = "10300451";
    private static final String ALREADY_STARTEDVM = "10300094";
    private static final String ALREADY_STOPEDVM = "10300092";
    private static final String CLOUDPLATFORM_OBJ_NOT_EXIT = "10000008";
    private static final String FM_VM_NOT_EXIST = "00030106";
    private static final String FM_OBJ_NOT_EXIST = "00000007";
    private static final String SCANNING_STORAGE_UNIT_WAITING_OR_RUNNING = "10490448";
    private List<String> listIgnoreErrorCode = new ArrayList<String>();
    private GalaxBaseSubRecoveryProcessor processor;

    public BaseRecoveryCmdResParser(GalaxBaseSubRecoveryProcessor processor) {
        this.processor = processor;
        this.listIgnoreErrorCode.add(ALREADY_REGISTERVM);
        this.listIgnoreErrorCode.add(ALREADY_STARTEDVM);
        this.listIgnoreErrorCode.add(ALREADY_STOPEDVM);
        this.listIgnoreErrorCode.add(CLOUDPLATFORM_OBJ_NOT_EXIT);
        this.listIgnoreErrorCode.add(FM_VM_NOT_EXIST);
        this.listIgnoreErrorCode.add(FM_OBJ_NOT_EXIST);
    }

    public BaseRecoveryCmdResParser(GalaxBaseSubRecoveryProcessor processor, List<String> ignoreErrorCodeList) {
        this.processor = processor;
        this.listIgnoreErrorCode = ignoreErrorCodeList;
    }

    protected GalaxBaseSubRecoveryProcessor getProcessor() {
        return this.processor;
    }

    public void addIgnoreErrorCode(String errorCode) {
        this.listIgnoreErrorCode.add(errorCode);
    }

    public List<String> getListIgnoreErrorCode() {
        return this.listIgnoreErrorCode;
    }

    @Override
    public boolean parser(CloudPlatformResponse response) {
        if (null == response) {
            this.processor.updateProcessDetail("ism.drm.recovery.executevm.vrm.noresponse", new String[0]);
            this.processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.processor.endRecoveryProcessor();
            return true;
        }
        if (response.isFinished() && !response.isSuccess() && null == response.getErrorCode()) {
            this.processor.updateProcessDetail("fusionsphere.error.unknown", new String[0]);
            this.processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            this.processor.endRecoveryProcessor();
            return true;
        }
        this.processor.updateExtendParams(response.getExtendParam());
        if (response.isFinished() && response.isSuccess()) {
            this.processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            this.processor.endRecoveryProcessor();
            return true;
        }
        if (response.getErrorCode() != null) {
            logger.warn((Object)"The error code is:%s.", new Object[]{response.getErrorCode()});
            if (this.listIgnoreErrorCode.contains(response.getErrorCode())) {
                this.processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
            } else {
                if (SCANNING_STORAGE_UNIT_WAITING_OR_RUNNING.equals(response.getErrorCode())) {
                    return false;
                }
                this.processor.updateProcessDetail("fusionsphere.error." + response.getErrorCode(), new String[0]);
                this.processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
            }
            this.processor.endRecoveryProcessor();
            return true;
        }
        return false;
    }

    @Override
    public boolean paserException(Exception e) {
        if (e instanceof LegoCheckedException) {
            this.handleLegoException((LegoCheckedException)((Object)e));
        } else if (e instanceof DataAccessException) {
            logger.error((Object)("Failed to access dataBase." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.processor.updateProcessDetail("ism.drm.recovery.database.access.error", new String[0]);
        } else if (e instanceof FindNoResourceMappingCheckedException) {
            this.processor.updateProcessDetail("ism.drm.recovery.process.cloudplatform.noresourcemapping", new String[0]);
        } else {
            this.processor.updateProcessDetail("ism.drm.recovery.executevm.vrm.noresponse", new String[0]);
        }
        this.processor.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        this.processor.endRecoveryProcessor();
        return true;
    }

    private void handleLegoException(LegoCheckedException legoException) {
        long errorCode = legoException.getErrorCode();
        if (256L == errorCode) {
            this.processor.updateProcessDetail("ism.drm.recovery.login.vrm.failed", new String[0]);
            logger.error((Object)("call virtualResourceManagerProxy describeTasks failed,ErrorCode=" + legoException.getErrorCode()), 90160758787071L);
        } else if (1073947663L == errorCode) {
            this.processor.updateProcessDetail("ism.drm.recovery.vrm.account.locked", new String[0]);
            logger.error((Object)("call virtualResourceManagerProxy describeTasks failed,ErrorCode=" + legoException.getErrorCode()), 90160758787071L);
        } else if (1073947400L == errorCode) {
            this.processor.updateProcessDetail("ism.drm.recovery.vrm.not.enough.right", new String[0]);
            logger.error((Object)("call virtualResourceManagerProxy describeTasks failed,ErrorCode=" + legoException.getErrorCode()), 90160758787071L);
        } else if (1073947399L == errorCode) {
            this.processor.updateProcessDetail("ism.drm.recovery.connect.vrm.failed", new String[0]);
        } else if (1073947398L == errorCode || 1073947395L == errorCode) {
            this.processor.updateProcessDetail("ism.drm.reprotect.prepare.connect.remotesite.abnomal", new String[0]);
        }
        int errCodeLen = String.valueOf(errorCode).length();
        if (8 == errCodeLen || 9 == errCodeLen) {
            this.processor.updateProcessDetail("fusionsphere.error." + errorCode, legoException.getParameters());
        } else {
            this.processor.updateProcessDetail(legoException.getErrorMessageKey(), legoException.getParameters());
        }
        logger.error((Object)"Failed to excute cmd.", (Throwable)legoException, 90160758787071L);
    }
}

