/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.factory.impl.operate;

import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlatformInfo;
import com.huawei.ism.drm.galax.recovery.process.factory.ICmdSubProcessorFactory;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.virtualization.recovery.tools.RecoveryToolsUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractCmdSubProcessorFactory
implements ICmdSubProcessorFactory {
    protected static final String CLOUDPLATFORMINFO = "CloudPlatFormInfo";
    private static final Log LOGGER = LogFactory.getInstance(AbstractCmdSubProcessorFactory.class);

    @Override
    public Set<RecoveryProcessor> createSubProcessors(RecoveryProcessorContext context, RecoveryProcessor parentRp) {
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        context.setAttribute(CLOUDPLATFORMINFO, (Object)this.generatePlatformInfo(context, parentRp));
        for (ProtectGroup pg : this.getPgs(context)) {
            for (ProtectObject po : pg.getPolist()) {
                RecoveryProcessor processor = this.generateSubProcessor(context, parentRp, po);
                if (processor == null) {
                    LOGGER.info((Object)"generateSubProcessor return null, po name:%s.", new Object[]{po.getName()});
                    continue;
                }
                subProcessors.add(processor);
            }
        }
        return subProcessors;
    }

    private RecoveryPlatformInfo generatePlatformInfo(RecoveryProcessorContext context, RecoveryProcessor processor) {
        String recoverySiteId;
        ProtectGroup pg = context.getProtectGroup();
        RecoveryPlan plan = context.getRecoveryPlan();
        String proCloudSn = pg.getPoProviderSN();
        if (plan.getPlanType() == DrmEnumDefine.RecoveryPlanTypeE.LOCAL.getValue()) {
            RecoveryPlatformInfo platformInfo = new RecoveryPlatformInfo();
            platformInfo.setCloudSn(proCloudSn);
            platformInfo.setSiteId(pg.getProductSiteId());
            if (this.isRollBack(processor)) {
                platformInfo.setRecCloudSn(proCloudSn);
                platformInfo.setRecSiteId(pg.getProductSiteId());
                return platformInfo;
            }
            String clusterMap = FsRecoveryUtil.getGlobalSettingFromPlan(plan, "testHostCluster");
            if (VerifyUtil.isEmpty((String)clusterMap)) {
                LOGGER.error((Object)"can not get the cluster resourcemap.", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            JSONArray array = JSONArray.fromObject((Object)clusterMap);
            if (array == null || array.isEmpty()) {
                LOGGER.error((Object)"change cluster to json failed. clusterMap=%s.", new Object[]{clusterMap});
                throw new LegoCheckedException(1073947393L);
            }
            JSONObject jsonObject = array.getJSONObject(0);
            platformInfo.setRecCloudSn(jsonObject.getString("remoteCloudId"));
            platformInfo.setRecSiteId(jsonObject.getString("remoteSiteId"));
            return platformInfo;
        }
        ArrayList<QueryCondition> props = new ArrayList<QueryCondition>();
        QueryCondition condition = new QueryCondition("productResourceProviderId", (Object)proCloudSn);
        props.add(condition);
        String productSiteId = context.getAttribute("PRODUCT_SITE_ID") == null ? null : String.valueOf(context.getAttribute("PRODUCT_SITE_ID"));
        String string = recoverySiteId = context.getAttribute("SELECT_DISASTER_SITE_KEY") == null ? null : String.valueOf(context.getAttribute("SELECT_DISASTER_SITE_KEY"));
        if (!VerifyUtil.isEmpty((String)productSiteId) && !VerifyUtil.isEmpty((String)recoverySiteId)) {
            QueryCondition conditionRecoverySiteId = new QueryCondition("recoverySiteId", (Object)recoverySiteId);
            props.add(conditionRecoverySiteId);
        }
        ResourceMapping rm = FsRecoveryUtil.getResourceMapping(props, "productResourceProviderId", proCloudSn);
        RecoveryPlatformInfo platformInfo = new RecoveryPlatformInfo(rm);
        return platformInfo;
    }

    protected Set<ProtectGroup> getPgs(RecoveryProcessorContext context) {
        Set pgs = context.getRecoveryPlan().getProtectGroups();
        if (VerifyUtil.isEmpty((Collection)pgs)) {
            LOGGER.error((Object)"pgs is empty.");
            throw new LegoCheckedException(1073947394L);
        }
        return pgs;
    }

    protected RecoveryPlatformInfo getPlatformInfo(RecoveryProcessorContext context) {
        return (RecoveryPlatformInfo)context.getAttribute(CLOUDPLATFORMINFO);
    }

    protected boolean isRollBack(RecoveryProcessor processor) {
        return processor.getProcType() == DrmEnumDefine.RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue();
    }

    protected RecoveryProcessor generateSubProcessor(RecoveryProcessorContext context, RecoveryProcessor parrentRp, ProtectObject po) {
        return null;
    }

    protected final Set<RecoveryProcessor> getSubProcessorsFromReplica(RecoveryProcessorContext context, RecoveryProcessor parrentRp) {
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        ProtectGroup pg = RecoveryToolsUtil.getInstance().getHistoryProtectGroupFromContext(context);
        for (ProtectObject po : pg.getPolist()) {
            RecoveryProcessor processor = this.generateSubProcessor(context, parrentRp, po);
            if (processor == null) {
                LOGGER.info((Object)"GenerateSubProcessor return null, po name:%s.", new Object[]{po.getName()});
                continue;
            }
            subProcessors.add(processor);
        }
        return subProcessors;
    }
}

