/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.factory.impl.operate;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VmTypeEnum;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlatformInfo;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseSubRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.command.ICmdResponseParser;
import com.huawei.ism.drm.galax.recovery.process.command.impl.HangUpVmCmd;
import com.huawei.ism.drm.galax.recovery.process.command.impl.QueryResultCmd;
import com.huawei.ism.drm.galax.recovery.process.factory.impl.operate.AbstractCmdSubProcessorFactory;
import com.huawei.ism.drm.galax.recovery.process.processtask.RecoveryProcessTask;
import com.huawei.ism.drm.galax.recovery.process.subprocess.HangUpNoncriticalVmSubProcessor;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.Hypervisor;
import com.huawei.ism.drm.galax.sdk.model.NoneCriticalVm;
import com.huawei.ism.drm.galax.sdk.proxy.VmMgrInfoBase;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractHangUpVmCmdFactory
extends AbstractCmdSubProcessorFactory {
    private static final Log logger = LogFactory.getInstance(AbstractHangUpVmCmdFactory.class);

    @Override
    public Set<RecoveryProcessor> createSubProcessors(RecoveryProcessorContext context, RecoveryProcessor parrentRp) {
        super.createSubProcessors(context, parrentRp);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        String noncriticalVmSetting = (String)recoveryPlan.getGlobalSettings().get("NoncritialVM");
        if (VerifyUtil.isEmpty((String)noncriticalVmSetting)) {
            logger.info((Object)"there is no noncritical Vm configed.", 90160758786816L);
            return subProcessors;
        }
        List vmList = (List)CommonUtil.json2Bean((String)noncriticalVmSetting, NoneCriticalVm[].class);
        for (NoneCriticalVm vm : vmList) {
            RecoveryProcessor rp = this.generateSubProcessor(context, parrentRp, vm);
            if (null == rp) {
                logger.warn((Object)("the processor for vm is null. uuid=" + vm.getUuid()), 90160758787071L);
                continue;
            }
            subProcessors.add(rp);
        }
        return subProcessors;
    }

    private RecoveryProcessor generateSubProcessor(RecoveryProcessorContext context, RecoveryProcessor parrentRp, NoneCriticalVm vm) {
        String vmUriOrId;
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("uri", vm.getUri());
        List galaxVmList = CommonDAOLocator.getMoDao().findMoBy(GalaxVM.class, props);
        if (VerifyUtil.isEmpty((Collection)galaxVmList)) {
            logger.warn((Object)("can not find the vm. uri=" + vm.getUri()), 90160758787071L);
            return null;
        }
        VmMgrInfoBase vmMgrInfo = this.getVmMgrInfo((GalaxVM)galaxVmList.get(0));
        if (vmMgrInfo.isTemplate() || ((GalaxVM)galaxVmList.get(0)).getVmType().intValue() == VmTypeEnum.PLACE_HOLDER_VM.getStatus()) {
            logger.info((Object)("the vm is template. uri=" + vm.getUri()), 90160758786816L);
            return null;
        }
        RecoveryPlatformInfo platformInfo = this.getPlatformInfo(context);
        if (GalaxVM.VMProviderType.FM.getValue().equals(vmMgrInfo.getVmType())) {
            List vmInfos;
            IFmService fmService = FusionSphereServiceManager.getInstance().getFmService();
            logger.debug((Object)("[HangUpVmFactory] Fc Sn is " + ((GalaxVM)galaxVmList.get(0)).getTopMoUuid()), 90160758787071L);
            Hypervisor hyperV = fmService.getHypervisorByVrm(((GalaxVM)galaxVmList.get(0)).getTopMoUuid());
            if (null == hyperV) {
                logger.error((Object)("Failed to get Fm VM Info. vmInfo is null." + vmMgrInfo.getUrn()), 90160758787071L);
                return null;
            }
            String hypervisorId = FmUtils.getCommonObjectId((String)hyperV.getUuid(), (String)Hypervisor.class.getSimpleName());
            FmObject fmInfo = FmUtils.generateFmObj((String)platformInfo.getRecCloudSn());
            ArrayList<String> listVmUrns = new ArrayList<String>();
            listVmUrns.add(vmMgrInfo.getUrn());
            try {
                vmInfos = FusionSphereServiceManager.getInstance().getFmRetriever().queryVMs(fmInfo, hypervisorId, listVmUrns);
            }
            catch (FmBusinessException e) {
                logger.error((Object)("[HangUpVmFactory]Failed to get Fm VM Info:" + fmInfo + vmMgrInfo.getUrn()), (Throwable)e, 90160758787071L);
                return null;
            }
            if (VerifyUtil.isEmpty((Collection)vmInfos)) {
                logger.error((Object)("[HangUpVmFactory]Failed to get Fm VM Info. vmInfo is null." + fmInfo + vmMgrInfo.getUrn()), 90160758787071L);
                return null;
            }
            vmUriOrId = ((ResourcepoolVMServiceV2Stub.VMInfo0)vmInfos.get(0)).getVmID();
        } else {
            vmUriOrId = vm.getUri();
        }
        HangUpNoncriticalVmSubProcessor processor = new HangUpNoncriticalVmSubProcessor(parrentRp, vmUriOrId);
        vmMgrInfo.setVmUriOrId(vmUriOrId);
        if (null != processor.getExtendParams()) {
            processor.getExtendParams().put(RpExParamsEnum.STARTUPNUM.getValue(), String.valueOf(vm.getOrder()));
            processor.getExtendParams().put(RpExParamsEnum.VM_URIORID.getValue(), vmUriOrId);
            processor.getExtendParams().put(RpExParamsEnum.SHOWPARAM.getValue(), vmMgrInfo.getName());
        }
        HangUpVmCmd cmd = new HangUpVmCmd(platformInfo.getRecSiteId(), platformInfo.getRecCloudSn(), vmMgrInfo);
        QueryResultCmd queryCmd = new QueryResultCmd(platformInfo.getRecSiteId(), platformInfo.getRecCloudSn(), vmMgrInfo.getVmType());
        ICmdResponseParser parser = this.getCmdResponseParser(processor, new ArrayList<String>());
        RecoveryProcessTask task = new RecoveryProcessTask(parrentRp.getProcId(), cmd, queryCmd, parser);
        processor.setExcuteTask(task);
        return processor;
    }

    protected abstract VmMgrInfoBase getVmMgrInfo(GalaxVM var1);

    protected abstract ICmdResponseParser getCmdResponseParser(GalaxBaseSubRecoveryProcessor var1, List<String> var2);
}

