/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.process.factory.impl.operate;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlatformInfo;
import com.huawei.ism.drm.galax.recovery.process.HangUpNoncriticalVmRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.base.GalaxBaseSubRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.command.ICmdResponseParser;
import com.huawei.ism.drm.galax.recovery.process.command.impl.QueryResultCmd;
import com.huawei.ism.drm.galax.recovery.process.command.impl.StartVmCmd;
import com.huawei.ism.drm.galax.recovery.process.factory.impl.operate.AbstractCmdSubProcessorFactory;
import com.huawei.ism.drm.galax.recovery.process.processtask.RecoveryProcessTask;
import com.huawei.ism.drm.galax.recovery.process.subprocess.StartVmRecoverySubProcessor;
import com.huawei.ism.drm.galax.recovery.proxy.RecoveryPlanProxy;
import com.huawei.ism.drm.galax.sdk.proxy.VmMgrInfoBase;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractStartVmCmdFactory
extends AbstractCmdSubProcessorFactory {
    private static final Log logger = LogFactory.getInstance(AbstractStartVmCmdFactory.class);

    @Override
    public Set<RecoveryProcessor> createSubProcessors(RecoveryProcessorContext context, RecoveryProcessor parrentRp) {
        super.createSubProcessors(context, parrentRp);
        RecoveryPlanProxy rpProxy = new RecoveryPlanProxy(context.getRecoveryPlan());
        RecoveryProcessor hangupVmProcessor = rpProxy.getRecoveryProcessByType(DrmEnumDefine.RecoveryPlanExecuteTypeE.DRILLING, HangUpNoncriticalVmRecoveryProcessor.class);
        HashSet<RecoveryProcessor> subProcessors = new HashSet<RecoveryProcessor>();
        if (null == hangupVmProcessor) {
            return subProcessors;
        }
        for (RecoveryProcessor subRp : hangupVmProcessor.getChildProc()) {
            RecoveryProcessor rp = this.generateSubProcessor(context, parrentRp, (GalaxBaseSubRecoveryProcessor)subRp);
            if (null == rp) continue;
            subProcessors.add(rp);
        }
        return subProcessors;
    }

    private RecoveryProcessor generateSubProcessor(RecoveryProcessorContext context, RecoveryProcessor parrentRp, GalaxBaseSubRecoveryProcessor subRp) {
        int successStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue();
        String vmKey = subRp.getExtendParams().get(RpExParamsEnum.VM_URIORID.getValue());
        if (subRp.getProcStatus() != successStatus && VerifyUtil.isEmpty((String)vmKey)) {
            logger.info((Object)"vmKey is empty and the procStatus of sub processor is not success", 90160758786816L);
            return null;
        }
        VmMgrInfoBase vmMgr = this.getVmMgrInfo();
        vmMgr.setVmType(subRp.getExtendParams().get(RpExParamsEnum.VM_TYPE.getValue()));
        vmMgr.setVmUriOrId(vmKey);
        StartVmRecoverySubProcessor processor = new StartVmRecoverySubProcessor(parrentRp, vmKey);
        if (null == processor.getExtendParams()) {
            return null;
        }
        String startUpNum = subRp.getExtendParams().get(RpExParamsEnum.STARTUPNUM.getValue());
        if (!VerifyUtil.isEmpty((String)startUpNum)) {
            processor.getExtendParams().put(RpExParamsEnum.STARTUPNUM.getValue(), startUpNum);
        }
        processor.getExtendParams().put(RpExParamsEnum.VM_URIORID.getValue(), vmKey);
        processor.getExtendParams().put(RpExParamsEnum.SHOWPARAM.getValue(), subRp.getExtendParams().get(RpExParamsEnum.SHOWPARAM.getValue()));
        RecoveryPlatformInfo platformInfo = this.getPlatformInfo(context);
        StartVmCmd cmd = new StartVmCmd(platformInfo.getRecSiteId(), platformInfo.getRecCloudSn(), vmMgr);
        QueryResultCmd queryCmd = new QueryResultCmd(platformInfo.getRecSiteId(), platformInfo.getRecCloudSn(), vmMgr.getVmType());
        ICmdResponseParser parser = this.getCmdResponseParser(processor);
        RecoveryProcessTask task = new RecoveryProcessTask(parrentRp.getProcId(), cmd, queryCmd, parser);
        processor.setExcuteTask(task);
        return processor;
    }

    protected abstract VmMgrInfoBase getVmMgrInfo();

    protected abstract ICmdResponseParser getCmdResponseParser(GalaxBaseSubRecoveryProcessor var1);
}

