/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.provider;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.galax.constant.cloudenum.PgExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.PoExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.process.RegisterVmRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.subprocess.RegisterVmRecoverySubProcessor;
import com.huawei.ism.drm.galax.recovery.proxy.RecoveryPlanProxy;
import com.huawei.ism.drm.galax.resource.checker.ProtectObjectCountChecker;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.service.IDsgService;
import com.huawei.ism.drm.galax.util.RecoveryUtil;
import com.huawei.ism.drm.galax.util.cloud.DsgUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupBaseService;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectBaseProvider;
import com.huawei.ism.drm.protection.provider.sdk.service.IProtectObjectProviderBaseDelegate;
import com.huawei.ism.drm.recovery.framework.provider.BaseRefactorConfigurationProvider;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.replication.builder.ReplicationPairConfiguration;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelationBo;
import com.huawei.ism.drm.virtualization.sdk.model.VirtualDataStoreGroup;
import com.huawei.ism.drm.virtualization.sdk.util.ProtectionTypeEnum;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ServiceBoundInfo(methodName="noMethed", targetBeanName="refactorConfigurationProviderMgr")
public class DefaultGalaxReProtectProcessorProvider
extends BaseRefactorConfigurationProvider {
    private Log log = LogFactory.getInstance(DefaultGalaxReProtectProcessorProvider.class);
    private String trace = "trace";
    private List<IDsgService> dsgServiceList = new ArrayList<IDsgService>();

    public List<String> getAppType() {
        this.log.trace((Object)(this.trace + " trace message"));
        ArrayList<String> appTypes = new ArrayList<String>();
        appTypes.add(DrmEnumDefine.AppType.GALAX_VM.name());
        return appTypes;
    }

    public void onBind(IDsgService dsgService, Map<?, ?> properties) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.dsgServiceList.add(dsgService);
    }

    public void onUnbind(IDsgService dsgService, Map<?, ?> properties) {
        this.log.trace((Object)(this.trace + " trace message"));
        this.dsgServiceList.remove(dsgService);
    }

    protected void reverseProtectObjectAttributes(ProtectObject protectObject, Map<String, Object> params) {
        this.log.trace((Object)(this.trace + " trace message"));
    }

    public void refactorProtectObjectStorageInfos(ProtectObject protectObject, Map<String, Object> params) {
        this.log.trace((Object)(this.trace + " trace message"));
    }

    protected void reverseProtectGroupAttributes(ProtectGroup protectGroup, Map<String, Object> params) {
        this.log.trace((Object)(this.trace + " trace message"));
        String oldProviderSn = protectGroup.getPoProviderSN();
        ResourceMapping rm = this.getResourceMapping(params, oldProviderSn);
        String newProviderSn = this.getNewProviderSn(oldProviderSn, rm);
        if (VerifyUtil.isEmpty((String)newProviderSn)) {
            this.log.error((Object)("can not find the resource mapping, providerSn=" + oldProviderSn), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        protectGroup.setPoProviderSN(newProviderSn);
        if (protectGroup.getTemplate().getType() == 33 || protectGroup.getTemplate().getType() == 39) {
            this.buildProtectObjectsByVm(protectGroup, params);
        } else {
            VirtualDataStoreGroup newDsg = this.getDisasterSiteDsg(protectGroup, newProviderSn);
            if (newDsg == null) {
                this.log.error((Object)"can not find new Dsg id", 90160758787071L);
                throw new LegoCheckedException(1073947394L);
            }
            protectGroup.getProps().remove(PgExParamsEnum.PG_DATASTOREGROUP_ID.getValue());
            protectGroup.getProps().put(PgExParamsEnum.PG_DATASTOREGROUP_ID.getValue(), newDsg.getGroupId());
            this.buildProtectObjects(protectGroup, newDsg);
        }
        protectGroup.setPgHistoryLogs(new HashSet());
        IProtectGroupBaseService protectGroupService = (IProtectGroupBaseService)ServiceLocator.getInstance().getService(IProtectGroupBaseService.class);
        protectGroupService.deleteProtectGroupHistory(protectGroup.getUuid());
        this.deletePopKeyWithMgr(protectGroup);
        ProtectObjectCountChecker.checkPoCountInSystem(protectGroup.getPoCount(), protectGroup.getUuid());
        IProtectObjectBaseProvider galaxVmProvider = ((IProtectObjectProviderBaseDelegate)ServiceLocator.getInstance().getService(IProtectObjectProviderBaseDelegate.class)).getProviderByAppType(12);
        galaxVmProvider.buildProtectObjects(protectGroup);
        this.refactorStoragePoolMap(protectGroup);
    }

    private ResourceMapping getResourceMapping(Map<String, Object> params, String oldProviderSn) {
        List<QueryCondition> props;
        ResourceMapping queryRm;
        String recoverySiteId;
        ResourceMapping rm = this.getResourceMapping(oldProviderSn);
        String productSiteId = null == params.get("PRODUCT_SITE_ID") ? null : String.valueOf(params.get("PRODUCT_SITE_ID"));
        String string = recoverySiteId = null == params.get("SELECT_DISASTER_SITE_KEY") ? null : String.valueOf(params.get("SELECT_DISASTER_SITE_KEY"));
        if (!(VerifyUtil.isEmpty((String)productSiteId) || VerifyUtil.isEmpty((String)recoverySiteId) || VerifyUtil.isEmpty((Object)(queryRm = FsRecoveryUtil.getResourceMapping(props = this.getQueryConditions(oldProviderSn, recoverySiteId), "productResourceProviderId", oldProviderSn))))) {
            rm = queryRm;
        }
        return rm;
    }

    private void deletePopKeyWithMgr(ProtectGroup protectGroup) {
        Map pgPops = protectGroup.getProps();
        HashSet<String> delKeySet = new HashSet<String>();
        for (String popKey : pgPops.keySet()) {
            if (!popKey.startsWith("pgMgrInfo")) continue;
            delKeySet.add(popKey);
        }
        for (String delKey : delKeySet) {
            pgPops.remove(delKey);
        }
    }

    private String getNewProviderSn(String oldProviderSn, ResourceMapping rm) {
        String newProviderSn = null;
        if (!VerifyUtil.isEmpty((Object)rm)) {
            newProviderSn = oldProviderSn.equals(rm.getProductResourceProviderId()) ? rm.getRecoveryResourceProviderId() : rm.getProductResourceProviderId();
        }
        return newProviderSn;
    }

    private List<QueryCondition> getQueryConditions(String oldProviderSn, String recoverySiteId) {
        ArrayList<QueryCondition> props = new ArrayList<QueryCondition>();
        QueryCondition conditionProductResourceId = new QueryCondition("productResourceProviderId", (Object)oldProviderSn);
        props.add(conditionProductResourceId);
        QueryCondition conditionRecoverySiteId = new QueryCondition("recoverySiteId", (Object)recoverySiteId);
        props.add(conditionRecoverySiteId);
        return props;
    }

    private ResourceMapping getResourceMapping(String oldProviderSn) {
        List rms = VrmManager.getInstance().getDaoAdapter().getResourceMappingList("productResourceProviderId", oldProviderSn);
        ResourceMapping rm = !VerifyUtil.isEmpty((Collection)rms) ? (ResourceMapping)rms.get(0) : null;
        return rm;
    }

    private void refactorStoragePoolMap(ProtectGroup protectGroup) {
        if (protectGroup.getTemplate().getType() != 33 && protectGroup.getTemplate().getType() != 39) {
            return;
        }
        if (null == protectGroup.getAnyoneReplicationReplica()) {
            this.log.error((Object)"protectGroup.getAnyoneReplicationReplica() is null");
            throw new LegoCheckedException(-1L);
        }
        String srcDevSN = protectGroup.getAnyoneReplicationReplica().getProductArray();
        String replicationCfg = (String)protectGroup.getProps().get("storagePoolMapping");
        ReplicationPairConfiguration config = new ReplicationPairConfiguration(replicationCfg);
        List storagePairs = config.findStoragePair(srcDevSN);
        for (StoragePair storagePair : storagePairs) {
            String oldSrcDevSN = storagePair.getSrcDevSN();
            storagePair.setSrcDevSN(storagePair.getTgtDevSN());
            storagePair.setTgtDevSN(oldSrcDevSN);
            Map oldStoragePools = storagePair.getStoragePools();
            HashMap newStoragePools = new HashMap();
            for (Map.Entry entry : oldStoragePools.entrySet()) {
                newStoragePools.put(entry.getValue(), entry.getKey());
            }
            storagePair.setStoragePools(newStoragePools);
        }
        protectGroup.getProps().put("storagePoolMapping", JSONArray.fromObject((Object)storagePairs).toString());
    }

    private void buildProtectObjectsByVm(ProtectGroup protectGroup, Map<String, Object> params) {
        RecoveryPlan recoveryPlan = (RecoveryPlan)params.get("RecoveryPlan");
        RecoveryPlanProxy rpProxy = new RecoveryPlanProxy(recoveryPlan);
        RecoveryProcessor registerRp = rpProxy.getRecoveryProcessByType(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION, RegisterVmRecoveryProcessor.class);
        HashSet<ProtectObject> polist = new HashSet<ProtectObject>();
        if (null == registerRp || VerifyUtil.isEmpty((Collection)registerRp.getChildProc())) {
            registerRp = rpProxy.getRecoveryProcessByType(DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY, RegisterVmRecoveryProcessor.class);
        }
        if (null == registerRp) {
            this.log.error((Object)"registerRp is null");
            throw new LegoCheckedException(-1L);
        }
        HashSet<String> vmUriSet = new HashSet<String>();
        for (RecoveryProcessor recoveryProcessor : registerRp.getChildProc()) {
            RegisterVmRecoverySubProcessor registerVmSubProc = (RegisterVmRecoverySubProcessor)recoveryProcessor;
            String vmUri = registerVmSubProc.getExtendParams().get(RpExParamsEnum.VM_URIORID.getValue());
            vmUriSet.add(vmUri);
        }
        QueryCondition qc = new QueryCondition("uri", (Object)vmUriSet.toArray(), 8);
        ArrayList<QueryCondition> qcList = new ArrayList<QueryCondition>();
        qcList.add(qc);
        List vmList = CommonDAOLocator.getMoDao().findMoBy(GalaxVM.class, qcList);
        for (GalaxVM vm : vmList) {
            ProtectObject po = new ProtectObject();
            po.setMoUuid(vm.getUuid());
            po.setName(vm.getName());
            po.setPoType(12);
            HashMap<String, String> props = new HashMap<String, String>();
            String vmId = vm.getUri().split("vms")[1].replace("/", "");
            props.put(PoExParamsEnum.VM_ID.getValue(), vmId);
            po.setProps(props);
            polist.add(po);
        }
        protectGroup.setPolist(polist);
    }

    public void updateProtectObject(ProtectObject oldProtectObject, ProtectObject newProtectObject) {
        this.log.trace((Object)(this.trace + " trace message"));
        oldProtectObject.setProps(newProtectObject.getProps());
        super.updateProtectObject(oldProtectObject, newProtectObject);
    }

    public void updateProtectGroup(ProtectGroup oldProtectGroup, ProtectGroup newProtectGroup) {
        this.log.trace((Object)(this.trace + " trace message"));
        super.updateProtectGroup(oldProtectGroup, newProtectGroup);
        Set oldProtectObjects = oldProtectGroup.getPolist();
        ArrayList newProtectObjects = new ArrayList(newProtectGroup.getPolist());
        HashSet<ProtectObject> needDeleteOldProtectObjects = new HashSet<ProtectObject>();
        int index = 0;
        for (ProtectObject oldProtectObject : oldProtectObjects) {
            if (index > newProtectObjects.size() - 1) {
                this.log.error((Object)("The produce site's po bigger than the disaster site's po number. produce numbers:" + oldProtectObjects.size() + ",disaster vm numbers:" + newProtectObjects.size()), 90160758784001L);
                needDeleteOldProtectObjects.add(oldProtectObject);
                continue;
            }
            DRMObject drmObject = (DRMObject)newProtectObjects.get(index);
            ++index;
            if (null == drmObject) continue;
            ProtectObject newProtectObject = (ProtectObject)drmObject;
            this.updateProtectObject(oldProtectObject, newProtectObject);
        }
        oldProtectObjects.removeAll(needDeleteOldProtectObjects);
        oldProtectGroup.setProps(newProtectGroup.getProps());
    }

    public void refactorRecoveryPlan(RecoveryPlan recoveryPlan, Map<String, Object> params) {
        this.log.trace((Object)(this.trace + " trace message"));
        super.refactorRecoveryPlan(recoveryPlan, params);
        HashSet<RecoverySetting> needRemovedSettings = new HashSet<RecoverySetting>();
        Set recoverySettings = recoveryPlan.getRecoverySettings();
        String productSiteId = (String)recoveryPlan.getGlobalSettings().get("SELECT_DISASTER_SITE_KEY");
        String recoverySiteId = (String)recoveryPlan.getGlobalSettings().get("PRODUCT_SITE_ID");
        for (RecoverySetting recoverySetting : recoverySettings) {
            ProtectObject po = this.getSetPo(recoveryPlan, recoverySetting.getOwnerId());
            if (null == po) {
                needRemovedSettings.add(recoverySetting);
                continue;
            }
            if ("startOrder".equals(recoverySetting.getName())) {
                String startPri = this.getRecoverSettingValue(po, String.valueOf(0), recoverySetting.getValue(), String.valueOf(10));
                recoverySetting.setValue(startPri);
                continue;
            }
            if ("isStart".equals(recoverySetting.getName())) {
                String needStart = this.getRecoverSettingValue(po, String.valueOf(Boolean.FALSE), recoverySetting.getValue(), String.valueOf(Boolean.TRUE));
                recoverySetting.setValue(needStart);
                continue;
            }
            if ("APP_IS_ENABLE_SETTING_KEY".equals(recoverySetting.getName())) {
                String enableSetting = this.getRecoverSettingValue(po, String.valueOf(Boolean.TRUE), recoverySetting.getValue(), String.valueOf(Boolean.FALSE));
                recoverySetting.setValue(enableSetting);
                continue;
            }
            if ("prd_drs_vm_id_list".equals(recoverySetting.getName())) {
                String prdVmIdListString = FsRecoveryUtil.getDrsVmIdList(po, productSiteId, recoverySiteId);
                if (VerifyUtil.isEmpty((String)prdVmIdListString)) {
                    needRemovedSettings.add(recoverySetting);
                    continue;
                }
                recoverySetting.setValue(prdVmIdListString);
                continue;
            }
            needRemovedSettings.add(recoverySetting);
        }
        for (RecoverySetting setting : needRemovedSettings) {
            recoverySettings.remove(setting);
        }
    }

    private String getRecoverSettingValue(ProtectObject po, String tamplateValue, String nowValue, String defaultValue) {
        if (RecoveryUtil.isTemplate((ProtectObject)po)) {
            return tamplateValue;
        }
        if (this.getIsReversed().booleanValue()) {
            return nowValue;
        }
        return defaultValue;
    }

    private ProtectObject getSetPo(RecoveryPlan recoveryPlan, String moUuid) {
        this.log.trace((Object)(this.trace + " trace message"));
        Set poList = ((ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)recoveryPlan.getProtectGroups())).getPolist();
        if (VerifyUtil.isEmpty((Collection)poList)) {
            return null;
        }
        for (ProtectObject po : poList) {
            if (!moUuid.equals(po.getUuid())) continue;
            return po;
        }
        return null;
    }

    private VirtualDataStoreGroup getDisasterSiteDsg(ProtectGroup protectGroup, String disasterCloudSN) {
        this.log.trace((Object)(this.trace + " trace message"));
        String productSiteId = protectGroup.getProductSiteId();
        List replications = protectGroup.getReplicationRelationByRecoverySiteId(productSiteId);
        if (replications == null || replications.isEmpty()) {
            this.log.error((Object)("get ReplicationRelation failed, site=" + productSiteId), 90160758787071L);
            return null;
        }
        ReplicationRelationBo replication = (ReplicationRelationBo)replications.get(0);
        Map allPairStorageIds = replication.getTgtLuns();
        if (this.dsgServiceList.isEmpty()) {
            this.log.error((Object)"the DSG service bind failed.", 90160758787071L);
            return null;
        }
        List allDataStore = this.dsgServiceList.get(0).getUnusedDataStoreGroupListByCloudSn(disasterCloudSN, true, Integer.valueOf(ProtectionTypeEnum.STORAGE_REPLICATION.getValue()));
        VirtualDataStoreGroup result = this.getDataStoreGroupByStorageInfo(replication.getTgtDeviceSn(), allPairStorageIds, allDataStore);
        return result;
    }

    private VirtualDataStoreGroup getDataStoreGroupByStorageInfo(String providerSN, Map<String, String> allPairStorageIds, List<VirtualDataStoreGroup> allDataStore) {
        this.log.trace((Object)(this.trace + " trace message"));
        ArrayList<String> items = new ArrayList<String>();
        for (String item : allPairStorageIds.values()) {
            items.add(providerSN + ":" + item);
        }
        for (VirtualDataStoreGroup dsg : allDataStore) {
            List dataStores = VrmManager.getInstance().getDaoAdapter().getDataStoresByVmUuids(dsg.getVmUuidSet());
            if (VerifyUtil.isEmpty((Collection)dataStores)) {
                this.log.error((Object)("dataStores is empty! vmUuidSet:" + dsg.getVmUuidSet()));
                return null;
            }
            HashSet<String> allStorageIds = new HashSet<String>();
            for (DataStore ds : dataStores) {
                List luns = DsgUtil.getLunsByDs((DataStore)ds, (boolean)false);
                if (VerifyUtil.isEmpty((Collection)luns)) {
                    this.log.warn((Object)("luns is empty! dsName:" + ds.getName()));
                    continue;
                }
                for (Lun storageResource : luns) {
                    this.log.info((Object)("ds lun name:" + storageResource.getName() + ", lunId:" + storageResource.getLunId() + ", devsn:" + storageResource.getDevSn()));
                    allStorageIds.add(storageResource.getDevSn() + ":" + storageResource.getResourceId());
                }
            }
            if (!allStorageIds.containsAll(items)) continue;
            return dsg;
        }
        return null;
    }

    private void buildProtectObjects(ProtectGroup protectGroup, VirtualDataStoreGroup newDsg) {
        this.log.trace((Object)(this.trace + " trace message"));
        HashSet<ProtectObject> polist = new HashSet<ProtectObject>();
        Set allVMmoids = newDsg.getVmUuidSet();
        for (String vMmoid : allVMmoids) {
            ProtectObject vm = new ProtectObject();
            ProtectObject tempPo = this.findPoByMOuuid(vMmoid, protectGroup.getPolist());
            if (tempPo != null) {
                vm.setUuid(tempPo.getUuid());
            }
            vm.setMoUuid(vMmoid);
            vm.setProtectGroup(protectGroup);
            polist.add(vm);
        }
        protectGroup.setPolist(polist);
    }

    private ProtectObject findPoByMOuuid(String moUUid, Set<ProtectObject> polist) {
        this.log.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty(polist)) {
            return null;
        }
        for (ProtectObject po : polist) {
            if (!moUUid.equals(po.getMoUuid())) continue;
            return po;
        }
        return null;
    }
}

