/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.provider;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.galax.sdk.service.IGalaxRecoveryProviderManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.IRecoveryProcessBaseProvider;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationBaseProvider;
import com.huawei.ism.drm.recovery.process.IRefactorConfigurationFusionShpereProvider;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GalaxReProtectProcessorProvider
implements IRefactorConfigurationFusionShpereProvider {
    private static final Log logger = LogFactory.getInstance(GalaxReProtectProcessorProvider.class);
    private static GalaxReProtectProcessorProvider instance = new GalaxReProtectProcessorProvider();
    private Map<String, IGalaxRecoveryProviderManager> managers = new HashMap<String, IGalaxRecoveryProviderManager>();

    private GalaxReProtectProcessorProvider() {
    }

    public static GalaxReProtectProcessorProvider getInstance() {
        return instance;
    }

    public void onBind(IGalaxRecoveryProviderManager provider, Map properties) {
        this.managers.put(provider.getCloudType(), provider);
    }

    public void onUnbind(IGalaxRecoveryProviderManager provider, Map properties) {
        this.managers.remove(provider.getCloudType());
    }

    public List<String> getAppType() {
        ArrayList<String> appTypes = new ArrayList<String>();
        appTypes.add(DrmEnumDefine.AppType.GALAX_VM.name());
        return appTypes;
    }

    public void refactorConfiguration(RecoveryPlan recoveryPlan) {
        this.getGalaxRecoveryProviderManager(recoveryPlan).getRefactorConfigurationProvider().refactorConfiguration(recoveryPlan);
    }

    public void saveConfiguration(RecoveryPlan recoveryPlan) {
        this.getGalaxRecoveryProviderManager(recoveryPlan).getRefactorConfigurationProvider().saveConfiguration(recoveryPlan);
    }

    public void deleteCustomRecoveryProcessors(RecoveryProcessDefinition definition, Class<? extends RecoveryProcessor> customProcessorCls, IRecoveryProcessBaseProvider provider) {
        IGalaxRecoveryProviderManager manager = this.managers.get("default");
        if (null == manager) {
            logger.error((Object)"can not get default manager.");
            throw new LegoCheckedException(0x300001L);
        }
        IRefactorConfigurationBaseProvider iRefactorConfigurationBaseProvider = manager.getRefactorConfigurationProvider();
        iRefactorConfigurationBaseProvider.deleteCustomRecoveryProcessors(definition, customProcessorCls, provider);
    }

    private IGalaxRecoveryProviderManager getGalaxRecoveryProviderManager(RecoveryPlan recoveryPlan) {
        IGalaxRecoveryProviderManager result = this.managers.get("default");
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)recoveryPlan.getProtectGroups());
        if (null == pg) {
            logger.error((Object)("pg is null. plan is " + recoveryPlan.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        List<Integer> openStackPolicyTemplate = Arrays.asList(22, 21, 25, 34, 37);
        if (openStackPolicyTemplate.contains(pg.getTemplate().getType())) {
            result = this.managers.get("openstack");
        }
        if (null == result) {
            logger.error((Object)("can not get manager.plan is " + recoveryPlan.getName()));
            throw new LegoCheckedException(0x300001L);
        }
        return result;
    }
}

