/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.provider;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessBaseService;
import com.huawei.ism.drm.galax.protection.adapter.GalaxProtectObjectCloudProviderAdapter;
import com.huawei.ism.drm.galax.recovery.process.GalaxExecuteScriptProcessor;
import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectCloudProvider;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.provider.BaseRecoveryProcessVRProvider;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.cbb.user.sdk.model.User;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VmRecoveryProcessProvider
extends BaseRecoveryProcessVRProvider {
    private static final Log LOGGER = LogFactory.getInstance(VmRecoveryProcessProvider.class);
    private static final Set<Integer> SUPPORT_POLICY_TEMPLATE_TYPE_SET = ImmutableSet.builder().add((Object)0).add((Object)1).add((Object)33).add((Object)39).add((Object)51).add((Object)52).add((Object)11).add((Object)18).add((Object)20).add((Object)23).add((Object)24).add((Object)26).add((Object)27).add((Object)3).add((Object)4).add((Object)5).add((Object)6).build();
    private static final List<String> SUPPORT_APP_TYPE = ImmutableList.of((Object)DrmEnumDefine.AppType.GALAX_VM.name());

    public List<String> getAppType() {
        return SUPPORT_APP_TYPE;
    }

    public boolean isSuitableProtectGroup(DrmEnumDefine.RecoveryPlanTypeE planType, ProtectGroup protectGroup) {
        boolean isSuitable = super.isSuitableProtectGroup(planType, protectGroup);
        if (isSuitable) {
            return true;
        }
        int policyTemplateType = protectGroup.getTemplate().getType();
        return planType == DrmEnumDefine.RecoveryPlanTypeE.REMOTE && policyTemplateType == 11;
    }

    public Map<String, Object> getCustomRecoveryProcessorInfos(RecoveryProcessDefinition rpDef, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, String procId) {
        VerifyUtil.checkObjs((Object[])new Object[]{rpDef, procType, procId});
        if (!this.isSupportByTemplateType(rpDef.getPlanId())) {
            LOGGER.debug((Object)"Dont support by templateType.");
            return null;
        }
        RecoveryProcessor customProcessor = null;
        for (RecoveryProcessor processor : rpDef.getRecoveryProcessors()) {
            if (!processor.getProcId().equals(procId)) continue;
            customProcessor = processor;
            break;
        }
        if (!(customProcessor instanceof GalaxExecuteScriptProcessor)) {
            LOGGER.error((Object)"The customProcessor is null or customProcessor is not instanceof GalaxExecuteScriptProcessor.");
            throw new LegoCheckedException(1073947394L);
        }
        GalaxExecuteScriptProcessor executeScriptProcessor = (GalaxExecuteScriptProcessor)customProcessor;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("CUSTOM_PROCESSOR_NAME", executeScriptProcessor.getProcName());
        params.put("EXECUTE_SCRIPT_NAME", executeScriptProcessor.getScriptName());
        params.put("EXECUTE_POLICY", executeScriptProcessor.getProps().get("EXECUTE_POLICY"));
        return params;
    }

    public String addCustomRecoveryProcessor(RecoveryProcessDefinition rpDefinition, RecoveryProcessor afterProcessor, Map<String, Object> params, boolean isEnable, boolean isNeedUpdateDb) {
        VerifyUtil.checkObjs((Object[])new Object[]{rpDefinition});
        if (!this.isSupportByTemplateType(rpDefinition.getPlanId())) {
            LOGGER.debug((Object)"Dont support by templateType.");
            return null;
        }
        RecoveryProcessor customProcessor = this.getCustomRecoveryProcessor(params);
        customProcessor.setProcessId(rpDefinition.getProcessId());
        customProcessor.setPlanId(rpDefinition.getPlanId());
        this.insertRecoveryProcessors(rpDefinition, afterProcessor, customProcessor, isEnable, isNeedUpdateDb);
        return customProcessor.getProcId();
    }

    public RecoveryProcessor getCustomRecoveryProcessor(Map<String, Object> params) {
        GalaxExecuteScriptProcessor executeScriptProcessor = new GalaxExecuteScriptProcessor();
        executeScriptProcessor.setProcName(String.valueOf(params.get("CUSTOM_PROCESSOR_NAME")));
        executeScriptProcessor.setScriptName(String.valueOf(params.get("EXECUTE_SCRIPT_NAME")));
        executeScriptProcessor.setProcId(String.valueOf(params.get("CustomProcId")));
        executeScriptProcessor.getProps().put("EXECUTE_POLICY", String.valueOf(params.get("EXECUTE_POLICY")));
        return executeScriptProcessor;
    }

    public void modifyCustomRecoveryProcessor(RecoveryProcessDefinition recoveryProcessDefinition, String procId, Map<String, Object> params) {
        VerifyUtil.checkObjs((Object[])new Object[]{recoveryProcessDefinition, procId});
        if (VerifyUtil.isEmpty(params)) {
            LOGGER.error((Object)"Params error, params is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (!this.isSupportByTemplateType(recoveryProcessDefinition.getPlanId())) {
            LOGGER.debug((Object)"Dont support by templateType.");
            return;
        }
        RecoveryProcessor customProcessor = null;
        for (RecoveryProcessor processor : recoveryProcessDefinition.getRecoveryProcessors()) {
            if (!processor.getProcId().equals(procId)) continue;
            customProcessor = processor;
            break;
        }
        if (!(customProcessor instanceof GalaxExecuteScriptProcessor)) {
            LOGGER.error((Object)"Params customProcessor is null or customProcessor is not instanceof GalaxExecuteScriptProcessor.");
            throw new LegoCheckedException(1073947394L);
        }
        if (!customProcessor.getIsEditable().booleanValue()) {
            throw new LegoCheckedException(1073948732L);
        }
        GalaxExecuteScriptProcessor executeScriptProcessor = (GalaxExecuteScriptProcessor)customProcessor;
        executeScriptProcessor.setProcName(String.valueOf(params.get("CUSTOM_PROCESSOR_NAME")));
        executeScriptProcessor.setScriptName(String.valueOf(params.get("EXECUTE_SCRIPT_NAME")));
        executeScriptProcessor.getProps().put("EXECUTE_POLICY", String.valueOf(params.get("EXECUTE_POLICY")));
        IRecoveryProcessBaseService recoveryProcessService = (IRecoveryProcessBaseService)ServiceLocator.getInstance().getService(IRecoveryProcessBaseService.class);
        boolean isSuccess = recoveryProcessService.updateRecoveryProcessor((RecoveryProcessor)executeScriptProcessor);
        if (isSuccess) {
            return;
        }
        LOGGER.error((Object)"Modify customRecoveryProcessor error.");
        throw new LegoCheckedException(-1L);
    }

    public Class<? extends RecoveryProcessor> getCustomRecoveryProcessorClass() {
        return GalaxExecuteScriptProcessor.class;
    }

    public Map<String, Object> checkRecoveryContext(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext, User operator) {
        IGalaxProtectObjectCloudProvider provider;
        if (recoveryContext == null || procType == null || planId == null) {
            LOGGER.error((Object)"Param is null.");
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = ((IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class)).getRecoveryPlan(planId);
        if (recoveryPlan == null) {
            LOGGER.error((Object)"Failed to get recoveryPlan.");
            throw new LegoCheckedException(201L);
        }
        ProtectGroup pg = (ProtectGroup)recoveryPlan.getProtectGroups().iterator().next();
        Set pgrSet = pg.getReplicaList();
        String reySite = null;
        if (!VerifyUtil.isEmpty((Collection)pgrSet)) {
            ProtectGroupReplica pgr = (ProtectGroupReplica)pgrSet.iterator().next();
            reySite = pgr.getRecoverySite();
        }
        if (!VerifyUtil.isEmpty((String)recoveryContext.get("DISASTER_SITE_ID"))) {
            reySite = recoveryContext.get("DISASTER_SITE_ID");
        }
        if ((provider = GalaxProtectObjectCloudProviderAdapter.getInstance().getGalaxPoProviderByProtectGroup(pg)) == null) {
            LOGGER.error((Object)"Not found provider for pg, pgId: %s.", new Object[]{pg.getUuid()});
            throw new LegoCheckedException(1073947393L);
        }
        return provider.checkRecoveryContext(procType, recoveryContext, recoveryPlan, reySite);
    }

    public String getRecoverySiteId(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext) {
        RecoveryPlan plan = ((IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class)).getRecoveryPlan(planId);
        return this.getRecoverySiteId(plan, procType, recoveryContext);
    }

    public String getRecoverySiteId(RecoveryPlan plan, DrmEnumDefine.RecoveryPlanExecuteTypeE procType, Map<String, String> recoveryContext) {
        ProtectGroup pg = (ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)plan.getProtectGroups());
        int templateType = pg.getTemplate().getType();
        if (SUPPORT_POLICY_TEMPLATE_TYPE_SET.contains(templateType)) {
            String reySite = ((ProtectGroupReplica)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)pg.getReplicaList())).getRecoverySite();
            if (!VerifyUtil.isEmpty((String)recoveryContext.get("DISASTER_SITE_ID"))) {
                reySite = recoveryContext.get("DISASTER_SITE_ID");
            } else {
                recoveryContext.put("DISASTER_SITE_ID", reySite);
            }
            return reySite;
        }
        return "";
    }

    private boolean isSupportByTemplateType(String planId) {
        ProtectGroup pg = this.getProtectGroupByPlanId(planId);
        int templateType = pg.getTemplate().getType();
        return SUPPORT_POLICY_TEMPLATE_TYPE_SET.contains(templateType);
    }

    private ProtectGroup getProtectGroupByPlanId(String planId) {
        RecoveryPlan plan = ((IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class)).getRecoveryPlan(planId);
        if (plan == null) {
            LOGGER.error((Object)"The plan is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)plan.getProtectGroups());
        if (pg == null) {
            LOGGER.error((Object)"The pg is null.");
            throw new LegoCheckedException(1073947393L);
        }
        return pg;
    }

    public void checkRecoverySettings(List<RecoverySetting> recoverySettingList) {
        RecoverySetting tempSetting = (RecoverySetting)CommonUtil.getFirstElement(recoverySettingList);
        if (tempSetting == null) {
            LOGGER.debug((Object)"The tempSetting is null.");
            return;
        }
        String planId = tempSetting.getRecoveryPlan().getUuid();
        ProtectGroup pg = this.getProtectGroupByPlanId(planId);
        IGalaxProtectObjectCloudProvider provider = GalaxProtectObjectCloudProviderAdapter.getInstance().getGalaxPoProviderByProtectGroup(pg);
        if (provider == null) {
            LOGGER.error((Object)"Not found provider for pg,pgId: %s.", new Object[]{pg.getUuid()});
            throw new LegoCheckedException(1073947393L);
        }
        provider.checkRecoverySettings(recoverySettingList);
    }
}

