/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.proxy;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class RecoveryPlanProxy {
    private static final Log logger = LogFactory.getInstance(RecoveryPlanProxy.class);
    private RecoveryPlan recoveryPlan;
    private Set<RecoverySetting> vMRecoverySettings;

    public RecoveryPlanProxy(RecoveryPlan recoveryPlan) {
        this.recoveryPlan = recoveryPlan;
        if (null != recoveryPlan) {
            this.vMRecoverySettings = recoveryPlan.getRecoverySettings();
        }
    }

    public RecoverySetting getPoRecoverySetting(String poId) {
        if (null == poId) {
            return null;
        }
        RecoverySetting poStartOrderSetting = null;
        for (RecoverySetting setting : this.vMRecoverySettings) {
            if (!poId.equals(setting.getOwnerId())) continue;
            if ("isStart".equals(setting.getName()) && Boolean.FALSE.toString().equals(setting.getValue())) {
                return null;
            }
            if (!poId.equals(setting.getOwnerId()) || !"startOrder".equals(setting.getName())) continue;
            poStartOrderSetting = setting;
        }
        return poStartOrderSetting;
    }

    public int getVmStartupOrder(String poId) {
        RecoverySetting setting = this.getPoRecoverySetting(poId);
        if (null == setting) {
            return Integer.MAX_VALUE;
        }
        int startUp = Integer.MAX_VALUE;
        try {
            startUp = Integer.parseInt(setting.getValue());
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Failed to transfer setting value to Integer:" + setting.getValue()), (Throwable)e, 90160758787071L);
        }
        if ("startOrder".equals(setting.getName()) && startUp >= 0) {
            return startUp;
        }
        return Integer.MAX_VALUE;
    }

    public boolean isPoStartUp(String poId) {
        RecoverySetting setting = this.getRecoverySetting(poId, "isStart");
        if (null == setting) {
            return true;
        }
        return !"false".equals(setting.getValue());
    }

    public RecoveryProcessor getRecoveryProcessByType(DrmEnumDefine.RecoveryPlanExecuteTypeE type, Class<?> cl) {
        RecoveryProcessDefinition rpd = this.recoveryPlan.getRecoveryProcess(type);
        if (rpd == null) {
            return null;
        }
        for (RecoveryProcessor rp : rpd.getRecoveryProcessors()) {
            if (rp.getClass() != cl) continue;
            return rp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistRecoveryPlan(Site remoteSite) {
        if (null == remoteSite) {
            logger.error((Object)"parameter remoteSite is null.", 90160758787071L);
            return;
        }
        Set rps = this.recoveryPlan.getRecoveryProcesses();
        this.recoveryPlan.setRecoveryProcesses(null);
        logger.info((Object)("persistRecoveryPlan begin. remoteSite=" + remoteSite), 90160758786816L);
        try {
            if (DrmEnumDefine.RecoveryPlanTypeE.REMOTE.getValue() == this.recoveryPlan.getPlanType() && !VerifyUtil.isEmpty((Object)remoteSite) && 0 != remoteSite.getSiteType()) {
                RestClient client = SiteUtil.initClient((Site)remoteSite);
                client.postSerializableObj((Object)this.recoveryPlan, "/ws/drp/syncSaveReprotectUpdate");
                logger.info((Object)"syncSaveReprotectUpdate finish.", 90160758786816L);
            }
        }
        finally {
            this.recoveryPlan.setRecoveryProcesses(rps);
        }
        CommonDAOLocator.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)this.recoveryPlan);
        logger.info((Object)"persistRecoveryPlan finish.", 90160758786816L);
    }

    public String getProductSite() {
        Set pgs = this.recoveryPlan.getProtectGroups();
        Iterator iterator = pgs.iterator();
        if (iterator.hasNext()) {
            ProtectGroup pg = (ProtectGroup)iterator.next();
            return pg.getProductSiteId();
        }
        return null;
    }

    public String getRecoverySite() {
        Set pgs = this.recoveryPlan.getProtectGroups();
        for (ProtectGroup pg : pgs) {
            Set pgrSet = pg.getReplicaList();
            Iterator iterator = pgrSet.iterator();
            if (!iterator.hasNext()) continue;
            ProtectGroupReplica pgr = (ProtectGroupReplica)iterator.next();
            return pgr.getRecoverySite();
        }
        return null;
    }

    public RecoverySetting getRecoverySetting(String poId, String settingName) {
        if (!VerifyUtil.isEmpty(this.vMRecoverySettings)) {
            for (RecoverySetting recoverySetting : this.vMRecoverySettings) {
                if (!recoverySetting.getOwnerId().equals(poId) || !recoverySetting.getName().equals(settingName)) continue;
                return recoverySetting;
            }
        }
        return null;
    }

    public GalaxVM.VMProviderType getCloudType() {
        ProtectGroup pg = (ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)this.recoveryPlan.getProtectGroups());
        String cloudSn = pg.getPoProviderSN();
        if (cloudSn.startsWith("Dr_Vrm")) {
            return GalaxVM.VMProviderType.FC;
        }
        return GalaxVM.VMProviderType.FM;
    }
}

