/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.service;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolNetServiceV2Stub;
import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.CloudParamType;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.recovery.common.ProtectObjectUtils;
import com.huawei.ism.drm.galax.recovery.common.RecoveryPlanUtil;
import com.huawei.ism.drm.galax.recovery.proxy.RecoveryPlanProxy;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.FmNetwork;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.NicInfoEntity;
import com.huawei.ism.drm.galax.sdk.model.PortGroup;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.model.TestNetwork;
import com.huawei.ism.drm.galax.sdk.model.TestNetworkSetting;
import com.huawei.ism.drm.galax.sdk.model.VPC;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.service.IStorageRecoveryPlanService;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmNicSpecification;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.IpAddress6;
import com.huawei.ism.drm.galax.sdk.vrm.model.NicSpecification;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigNicType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractFusionSphereRecoveryPlanService
extends BaseService
implements IStorageRecoveryPlanService {
    private static final String IP_NOT_EXIST_ERROR = "00360004";
    private static final Integer IP_NOT_EXIST = 2;
    private static final Integer IP_UNUSED = 1;
    private static final Integer IP_OK = 0;
    private static final Integer IP_NOT_BINDED = 2;
    private static final Integer IP_NOT_FREEZED = 255;
    private static final Integer IP_OPERATE_STATUS_BIND_FAILED = 3;
    private static final Integer IP_OPERATE_STATUS_UNBIND_SUCC = 6;
    private static final Integer IP_OPERATE_STATUS_FREEZE_FAILED = 11;
    private static final Integer IP_OPERATE_STATUS_UNFREEZE_SUCC = 13;
    private static final Integer IP_OPERATE_STATUS_UNOPER = 15;
    private Log logger = LogFactory.getInstance(AbstractFusionSphereRecoveryPlanService.class);
    private String trace = "trace";
    private IBaseDao<Object, Serializable> baseDao;
    private IRecoveryPlanBaseService rpService;
    private ISiteBaseService siteService;
    private IFmService fmService;

    public ISiteBaseService getSiteService() {
        this.logger.trace((Object)(this.trace + " trace message"));
        return this.siteService;
    }

    public void setSiteService(ISiteBaseService siteService) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.siteService = siteService;
    }

    public IBaseDao<Object, Serializable> getBaseDao() {
        this.logger.trace((Object)(this.trace + " trace message"));
        return this.baseDao;
    }

    public void setBaseDao(IBaseDao<Object, Serializable> baseDao) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.baseDao = baseDao;
    }

    public IRecoveryPlanBaseService getRpService() {
        this.logger.trace((Object)(this.trace + " trace message"));
        return this.rpService;
    }

    public void setRpService(IRecoveryPlanBaseService rpService) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.rpService = rpService;
    }

    public RecoveryPlan getRecoveryPlanByPlanId(String planId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty((String)planId)) {
            this.logger.error((Object)"@@planId is null ", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.getRpService().getRecoveryPlan(planId);
        if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
            this.logger.error((Object)"@@recovery plan is null", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        return recoveryPlan;
    }

    protected abstract String getRecoveryCloudSn(RecoveryPlan var1, String var2);

    public List<NicInfoEntity> getNicList(String planId, String poId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        RecoveryPlan recoveryPlan = this.getRecoveryPlanByPlanId(planId);
        List<NicInfoEntity> nicList = new ArrayList<NicInfoEntity>();
        if (null == recoveryPlan) {
            this.logger.info((Object)"RecoveryPlan is null.", 90160758786816L);
            return nicList;
        }
        ProtectObject po = ProtectObjectUtils.getProtectObjectInRecoveryPlan((RecoveryPlan)recoveryPlan, (String)poId);
        if (null == po) {
            this.logger.info((Object)"ProjectObject is null.", 90160758786816L);
            return nicList;
        }
        nicList = RecoveryPlanUtil.getNecsequenceNumListByPo(po);
        Collections.sort(nicList, new Comparator<NicInfoEntity>(){

            @Override
            public int compare(NicInfoEntity arg0, NicInfoEntity arg1) {
                if (arg0.getSequenceNum() == null || arg1.getSequenceNum() == null) {
                    return -1;
                }
                return arg0.getSequenceNum().compareTo(arg1.getSequenceNum());
            }
        });
        return nicList;
    }

    private List<Integer> getSequenceNumList(List<NicInfoEntity> nicInfos) {
        this.logger.trace((Object)(this.trace + " trace message"));
        ArrayList<Integer> nicList = new ArrayList<Integer>();
        if (VerifyUtil.isEmpty(nicInfos)) {
            return nicList;
        }
        for (NicInfoEntity nicInfoEntity : nicInfos) {
            nicList.add(nicInfoEntity.getSequenceNum());
        }
        return nicList;
    }

    public NicSpecification getRecoveryPlanNicInfoById(String planId, String poId, Integer sequenceNum) {
        this.logger.trace((Object)(this.trace + " trace message"));
        RecoveryPlan recoveryPlan = this.getRecoveryPlanByPlanId(planId);
        if (null == recoveryPlan) {
            this.logger.info((Object)"RecoveryPlan is null.", 90160758786816L);
            return null;
        }
        RecoveryPlanProxy rpProxy = new RecoveryPlanProxy(recoveryPlan);
        GalaxVM.VMProviderType cloudType = rpProxy.getCloudType();
        if (GalaxVM.VMProviderType.FC.equals((Object)cloudType)) {
            return this.getFcNicInfo(recoveryPlan, poId, sequenceNum);
        }
        if (GalaxVM.VMProviderType.FM.equals((Object)cloudType)) {
            return this.getFmNicInfo(recoveryPlan, poId, sequenceNum);
        }
        return null;
    }

    private NicSpecification getFcNicInfo(RecoveryPlan recoveryPlan, String poId, Integer sequenceNum) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List<NicSpecification> fcNicInfoList = RecoveryPlanUtil.getFcNicInfoList(recoveryPlan, poId);
        String gateway = null;
        String gatewayIpAddr6 = null;
        for (NicSpecification fcNicInfo : fcNicInfoList) {
            if (!VerifyUtil.isEmpty((String)fcNicInfo.getGateway())) {
                gateway = fcNicInfo.getGateway();
            }
            if (VerifyUtil.isEmpty((String)fcNicInfo.getGatewayIpAddr6())) continue;
            gatewayIpAddr6 = fcNicInfo.getGatewayIpAddr6();
        }
        for (NicSpecification fcNicInfo : fcNicInfoList) {
            if (!sequenceNum.equals(fcNicInfo.getSequenceNum())) continue;
            if (VerifyUtil.isEmpty((String)fcNicInfo.getGateway())) {
                fcNicInfo.setGateway(gateway);
            }
            if (VerifyUtil.isEmpty((String)fcNicInfo.getGatewayIpAddr6())) {
                fcNicInfo.setGatewayIpAddr6(gatewayIpAddr6);
            }
            return fcNicInfo;
        }
        return null;
    }

    private NicSpecification getFmNicInfo(RecoveryPlan recoveryPlan, String poId, Integer sequenceNum) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List<FmNicSpecification> fmNicInfoList = RecoveryPlanUtil.getFmNicInfoList(recoveryPlan, poId);
        for (FmNicSpecification fmNic : fmNicInfoList) {
            if (!sequenceNum.equals(fmNic.getSequenceNum())) continue;
            if (!VerifyUtil.isEmpty((String)fmNic.getFlexIp())) {
                RecoveryPlanProxy rpProxy = new RecoveryPlanProxy(recoveryPlan);
                String recoverySiteId = rpProxy.getRecoverySite();
                HashMap<String, String> flexIpMap = new HashMap<String, String>();
                flexIpMap.put(recoverySiteId, fmNic.getFlexIp());
                fmNic.setFlexIpMap(flexIpMap);
            }
            return fmNic;
        }
        return null;
    }

    public void modifyRecoveryPlanNicInfo(String planId, String poId, NicSpecification nicSpecification) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty((Object)nicSpecification)) {
            this.logger.error((Object)"NicSpecification is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.getRecoveryPlanByPlanId(planId);
        if (null == recoveryPlan) {
            this.logger.error((Object)"RecoveryPlan is null.", 90160758784001L);
            return;
        }
        RecoveryPlanProxy rpProxy = new RecoveryPlanProxy(recoveryPlan);
        GalaxVM.VMProviderType cloudeType = rpProxy.getCloudType();
        String jsonRePlanNicInfo = "";
        List<Integer> productNicList = this.getSequenceNumList(this.getNicList(planId, poId));
        ArrayList<Integer> reNicList = new ArrayList<Integer>();
        ArrayList<Integer> deleteFcNicList = new ArrayList<Integer>();
        ArrayList<Integer> addFcNicList = new ArrayList<Integer>();
        if (GalaxVM.VMProviderType.FC.equals((Object)cloudeType)) {
            List<NicSpecification> fcNicList = RecoveryPlanUtil.getFcNicInfoList(recoveryPlan, poId);
            for (NicSpecification fcNic : fcNicList) {
                reNicList.add(fcNic.getSequenceNum());
            }
            RecoveryPlanUtil.setUpdateFcNicList(productNicList, reNicList, addFcNicList, deleteFcNicList);
            RecoveryPlanUtil.deleteNic(fcNicList, deleteFcNicList, NicSpecification.class);
            RecoveryPlanUtil.addEmptyNicToList(fcNicList, addFcNicList, NicSpecification.class);
            String gateway = nicSpecification.getGateway();
            String gatewayIpAddr6 = nicSpecification.getGatewayIpAddr6();
            for (NicSpecification fcNic : fcNicList) {
                if (!VerifyUtil.isEmpty((String)nicSpecification.getIp()) && !VerifyUtil.isEmpty((String)fcNic.getIp())) {
                    fcNic.setGateway(gateway);
                }
                if (VerifyUtil.isEmpty((Collection)nicSpecification.getIpAddress6()) || VerifyUtil.isEmpty((String)((IpAddress6)nicSpecification.getIpAddress6().get(0)).getIpv6Addr()) || VerifyUtil.isEmpty((Collection)fcNic.getIpAddress6()) || VerifyUtil.isEmpty((String)((IpAddress6)fcNic.getIpAddress6().get(0)).getIpv6Addr())) continue;
                fcNic.setGatewayIpAddr6(gatewayIpAddr6);
            }
            RecoveryPlanUtil.updateNicList(fcNicList, nicSpecification, NicSpecification.class);
            jsonRePlanNicInfo = CommonUtil.beanToJson(fcNicList);
        } else if (GalaxVM.VMProviderType.FM.equals((Object)cloudeType)) {
            List<FmNicSpecification> fmNicList = RecoveryPlanUtil.getFmNicInfoList(recoveryPlan, poId);
            if (!(nicSpecification instanceof FmNicSpecification)) {
                this.logger.error((Object)("save FM ip failed, because input param: " + nicSpecification + "is not FmNicSpecification!"), 90160758784001L);
                return;
            }
            FmNicSpecification fmNic = (FmNicSpecification)nicSpecification;
            for (FmNicSpecification fmNicTemp : fmNicList) {
                reNicList.add(fmNicTemp.getSequenceNum());
            }
            RecoveryPlanUtil.setUpdateFcNicList(productNicList, reNicList, addFcNicList, deleteFcNicList);
            RecoveryPlanUtil.deleteNic(fmNicList, deleteFcNicList, FmNicSpecification.class);
            RecoveryPlanUtil.addEmptyNicToList(fmNicList, addFcNicList, FmNicSpecification.class);
            RecoveryPlanUtil.updateNicList(fmNicList, fmNic, FmNicSpecification.class);
            jsonRePlanNicInfo = CommonUtil.beanToJson(fmNicList);
        }
        RecoveryPlanUtil.saveRePlanNicInfo(recoveryPlan, poId, jsonRePlanNicInfo);
    }

    public Integer queryEIpInfoFromFm(String planId, String poId, String recoverySiteId, String ip) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.checkParametersNotEmpty(planId, poId, recoverySiteId, ip);
        RecoveryPlan rp = this.getRecoveryPlanByPlanId(planId);
        this.checkParam(rp, 1073947394L);
        ProtectObject po = ProtectObjectUtils.getProtectObjectInRecoveryPlan((RecoveryPlan)rp, (String)poId);
        this.checkParam(po, 1073947394L);
        String oldVpcId = null;
        JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
        JSONObject extendParams = jo.getJSONObject("extendParams");
        if (null != extendParams) {
            oldVpcId = extendParams.getString(CloudParamType.VPC_ID.getValue());
        }
        this.checkParam(oldVpcId, 1073947394L);
        String productSn = po.getProviderSN();
        String productVpcId = FmUtils.getFmResourceUrn((String)productSn, (String)VPC.class.getSimpleName(), (String)oldVpcId);
        this.logger.info((Object)("productVpcId is: " + productVpcId), 90160758786816L);
        String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)rp);
        ResourceMapping rm = FsRecoveryUtil.getResourceMapping(productVpcId, ResTypeEnum.NETWORK.getResType(), "productVpcId", productSiteId, recoverySiteId);
        String vpcId = "";
        String fmSn = "";
        if (!VerifyUtil.isEmpty((Object)rm)) {
            vpcId = FmUtils.getCommonObjectId((String)rm.getRecoveryVpcId(), (String)VPC.class.getSimpleName());
            fmSn = rm.getRecoveryResourceProviderId();
        }
        this.logger.info((Object)("vpcId is:" + vpcId + "fmSn is :" + fmSn), 90160758787071L);
        this.checkParam(vpcId, 1073947394L);
        this.checkParam(fmSn, 1073947394L);
        try {
            return this.queryEIpsFromVPC(fmSn, vpcId, ip);
        }
        catch (FmBusinessException e) {
            this.logger.error((Object)("query elastic ip is failed:" + e.getErrorCode() + e.getFaultString()), (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(1073948864L, (Throwable)e);
        }
    }

    private Integer queryEIpsFromVPC(String fmSn, String vpcId, String ip) throws FmBusinessException {
        ResourcepoolNetServiceV2Stub.ElasticIP elasticIp;
        this.logger.trace((Object)(this.trace + " trace message"));
        FmObject fmInfo = FmUtils.generateFmObj((String)fmSn);
        try {
            elasticIp = FusionSphereServiceManager.getInstance().getFmRetriever().queryElasticIpInfo(fmInfo, vpcId, ip);
        }
        catch (FmBusinessException e) {
            if (IP_NOT_EXIST_ERROR.equals(e.getErrorCode())) {
                return IP_NOT_EXIST;
            }
            throw e;
        }
        if (null == elasticIp) {
            return IP_NOT_EXIST;
        }
        if (this.isIpUseable(elasticIp)) {
            return IP_OK;
        }
        return IP_UNUSED;
    }

    private boolean isIpUseable(ResourcepoolNetServiceV2Stub.ElasticIP eIp) {
        this.logger.trace((Object)(this.trace + " trace message"));
        boolean bool1 = eIp.getResourceStatus() == IP_NOT_BINDED.intValue();
        boolean bool2 = eIp.getBusinessStatus() == IP_NOT_FREEZED.intValue();
        boolean bool3 = eIp.getOperateStatus() == IP_OPERATE_STATUS_BIND_FAILED.intValue() || eIp.getOperateStatus() == IP_OPERATE_STATUS_FREEZE_FAILED.intValue() || eIp.getOperateStatus() == IP_OPERATE_STATUS_UNBIND_SUCC.intValue() || eIp.getOperateStatus() == IP_OPERATE_STATUS_UNFREEZE_SUCC.intValue() || eIp.getOperateStatus() == IP_OPERATE_STATUS_UNOPER.intValue();
        return bool1 && bool2 && bool3;
    }

    public List<TestNetwork> queryTestNetwork(String planId, String recoverySiteId, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.logger.info((Object)"query local portgroup or network is begin!", 90160758786816L);
        RecoveryPlan recoveryPlan = this.getRecoveryPlanByPlanId(planId);
        this.checkParam(recoveryPlan, 1073947394L);
        ProtectGroup pg = (ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)recoveryPlan.getProtectGroups());
        this.checkParam(pg, 1073947394L);
        String siteId = ((ProtectGroupReplica)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)pg.getReplicaList())).getRecoverySite();
        if (!VerifyUtil.isEmpty((String)recoverySiteId)) {
            siteId = recoverySiteId;
        } else {
            recoverySiteId = siteId;
        }
        Site site = FusionSphereServiceManager.getInstance().getSiteService().getSiteById(siteId);
        if (site.getSiteType() == 1) {
            return RecoveryPlanUtil.getRemoteTestNetworks(site, planId);
        }
        String recoveryCloudSn = this.getRecoveryCloudSn(recoveryPlan, recoverySiteId);
        List sns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(Arrays.asList(recoveryCloudSn), Long.valueOf(userId));
        if (VerifyUtil.isEmpty((Collection)sns)) {
            this.logger.error((Object)"sns is null or empty.", 90160758787071L);
            return Collections.emptyList();
        }
        ArrayList<TestNetwork> testNetworks = new ArrayList<TestNetwork>();
        HashMap<String, TestNetwork> testNetworkMap = new HashMap<String, TestNetwork>();
        Set poSet = pg.getPolist();
        for (ProtectObject po : poSet) {
            this.addTestNetworkToMap(po, testNetworkMap, recoveryPlan, recoverySiteId, userId);
        }
        Collection testColl = testNetworkMap.values();
        for (TestNetwork test : testColl) {
            testNetworks.add(test);
        }
        this.logger.info((Object)"query local portgroup or network is success!", 90160758786816L);
        return testNetworks;
    }

    protected abstract ResourceMapping getResourceMappingByProductRes(String var1, String var2);

    private ResourceMapping getResMapping(String productResourceId, boolean isPortGroup) {
        ResourceMapping rm;
        this.logger.trace((Object)(this.trace + " trace message"));
        try {
            rm = this.getResourceMappingByProductRes("productResourceId", productResourceId);
        }
        catch (LegoCheckedException e) {
            if (1073947394L == e.getErrorCode()) {
                this.logger.error((Object)("can not find resourceMapping,resource id  is: " + productResourceId), 90160758787071L);
                if (isPortGroup) {
                    throw new LegoCheckedException(1073948359L, (Throwable)e);
                }
                throw new LegoCheckedException(1073948354L, (Throwable)e);
            }
            this.logger.error((Object)"can not find resourceMapping", 90160758787071L);
            throw e;
        }
        return rm;
    }

    private void addTestNetworkToMap(ProtectObject po, Map<String, TestNetwork> testNetworkMap, RecoveryPlan recoveryPlan, String recoverySiteId, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
        String vmProviderType = jo.getString(RpExParamsEnum.VM_TYPE.getValue());
        String vmConfig = jo.getString(RpExParamsEnum.VM_CONFIG.getValue());
        if (GalaxVM.VMProviderType.FC.getValue().equals(vmProviderType)) {
            VmConfigType vmConfigType = (VmConfigType)CommonUtil.jsonToBean((String)vmConfig, VmConfigType.class);
            this.addFcTestNetwork(testNetworkMap, vmConfigType.getNics(), recoveryPlan, recoverySiteId, userId);
        } else if (GalaxVM.VMProviderType.FM.getValue().equals(vmProviderType)) {
            ResourcepoolVMServiceV2Stub.VmConfigSetE vmConfigType = (ResourcepoolVMServiceV2Stub.VmConfigSetE)CommonUtil.jsonToBean((String)vmConfig, ResourcepoolVMServiceV2Stub.VmConfigSetE.class);
            String providerSn = po.getProviderSN();
            this.addFmTestNetwork(testNetworkMap, vmConfigType.getNics(), recoveryPlan, recoverySiteId, providerSn, userId);
        }
    }

    private void addFcTestNetwork(Map<String, TestNetwork> testNetworkMap, List<VmConfigNicType> fcNics, RecoveryPlan recoveryPlan, String recoverySiteId, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        for (VmConfigNicType fcNic : fcNics) {
            ResourceMapping rm;
            TestNetwork fcTest = testNetworkMap.get(fcNic.getPortGroupUrn());
            if (null != fcTest) continue;
            TestNetwork test = new TestNetwork();
            test.setProUrn(fcNic.getPortGroupUrn());
            test.setProName(fcNic.getPortGroupName());
            if (!VerifyUtil.isEmpty((String)recoverySiteId)) {
                ResourceMapping queryRm;
                String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan);
                rm = queryRm = FsRecoveryUtil.getResourceMapping(fcNic.getPortGroupUrn(), ResTypeEnum.PORT_GROUP.getResType(), "productResourceId", productSiteId, recoverySiteId);
            } else {
                rm = this.getResMapping(fcNic.getPortGroupUrn(), true);
            }
            if (VerifyUtil.isEmpty((Object)rm)) {
                test.setDrName("");
                test.setDrUrn("");
            } else {
                test.setDrName(rm.getRecoveryResourceName());
                test.setDrUrn(rm.getRecoveryResourceId());
            }
            List<TestNetwork> availableTestNetworks = this.queryAvaiablePortGroup(test.getDrUrn(), recoveryPlan.getPlanId(), recoverySiteId, true, userId);
            this.updateTestNetworkByExistSetting(recoveryPlan, test, availableTestNetworks);
            testNetworkMap.put(test.getProUrn(), test);
        }
    }

    private void addFmTestNetwork(Map<String, TestNetwork> testNetworkMap, ResourcepoolVMServiceV2Stub.Nic[] fmNicArray, RecoveryPlan recoveryPlan, String recoverySiteId, String providerSn, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        for (ResourcepoolVMServiceV2Stub.Nic nic : fmNicArray) {
            ResourceMapping rm;
            TestNetwork fmTest = testNetworkMap.get(nic.getNetworkid());
            if (null != fmTest) continue;
            TestNetwork test = new TestNetwork();
            test.setProUrn(nic.getNetworkid());
            String productResourceId = FmUtils.getFmResourceUrn((String)providerSn, (String)FmNetwork.class.getSimpleName(), (String)nic.getNetworkid());
            if (!VerifyUtil.isEmpty((String)recoverySiteId)) {
                ResourceMapping queryRm;
                String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan);
                rm = queryRm = FsRecoveryUtil.getResourceMapping(productResourceId, ResTypeEnum.NETWORK.getResType(), "productResourceId", productSiteId, recoverySiteId);
            } else {
                rm = this.getResMapping(productResourceId, false);
            }
            if (VerifyUtil.isEmpty((Object)rm)) {
                test.setDrName("");
                test.setDrUrn("");
                test.setProName("");
            } else {
                test.setDrName(rm.getRecoveryResourceName());
                test.setDrUrn(rm.getRecoveryResourceId());
                test.setProName(rm.getProductResourceName());
            }
            List<TestNetwork> availableTestNetworks = this.queryAvaiablePortGroup(test.getDrUrn(), recoveryPlan.getPlanId(), recoverySiteId, false, userId);
            this.updateTestNetworkByExistSetting(recoveryPlan, test, availableTestNetworks);
            testNetworkMap.put(test.getProUrn(), test);
        }
    }

    private boolean testNetorkUrnInAvailbeTestNetworks(TestNetworkSetting testNetworkSetting, List<TestNetwork> availableTestNetworks) {
        this.logger.trace((Object)(this.trace + " trace message"));
        String testNetworkUrn = testNetworkSetting.getTestNetworkUrn();
        if (VerifyUtil.isEmpty((String)testNetworkUrn) || VerifyUtil.isEmpty(availableTestNetworks)) {
            return false;
        }
        for (TestNetwork e : availableTestNetworks) {
            if (!testNetworkUrn.equalsIgnoreCase(e.getTestUrn())) continue;
            testNetworkSetting.setTestNetworkName(e.getTestName());
            return true;
        }
        return false;
    }

    private void updateTestNetworkByExistSetting(RecoveryPlan recoveryPlan, TestNetwork test, List<TestNetwork> availableTestNetworks) {
        this.logger.trace((Object)(this.trace + " trace message"));
        String testNetworkJson = (String)recoveryPlan.getGlobalSettings().get("TestNetwork");
        if (!VerifyUtil.isEmpty((String)testNetworkJson) && this.updateTestNetwork(test, testNetworkJson, availableTestNetworks)) {
            return;
        }
        this.logger.info((Object)"testNetworkSetting from globalSettings is null, set DrUrn as test networkUrn", 90160758786816L);
        test.setTestName(test.getDrName());
        test.setTestUrn(test.getDrUrn());
    }

    private boolean updateTestNetwork(TestNetwork test, String testNetworkJson, List<TestNetwork> availableTestNetworks) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List testNetworks = (List)CommonUtil.json2Bean((String)testNetworkJson, TestNetworkSetting[].class);
        if (VerifyUtil.isEmpty((Collection)testNetworks)) {
            return false;
        }
        for (TestNetworkSetting testSetting : testNetworks) {
            if (!test.getProUrn().equals(testSetting.getProNetworkUrn()) || !this.testNetorkUrnInAvailbeTestNetworks(testSetting, availableTestNetworks)) continue;
            test.setTestName(testSetting.getTestNetworkName());
            test.setTestUrn(testSetting.getTestNetworkUrn());
            return true;
        }
        return false;
    }

    public List<TestNetwork> queryAvaiablePortGroup(String drUrn, String planId, String recoverySiteId, boolean isPortGroup, long userId) {
        String vpcId;
        String drSn;
        ResourceMapping rm;
        this.logger.trace((Object)(this.trace + " trace message"));
        this.logger.info((Object)"begin remote query useable portGroup or network!", 90160758786816L);
        RecoveryPlan recoveryPlan = this.getRecoveryPlanByPlanId(planId);
        this.checkParam(recoveryPlan, 1073947394L);
        Set proGroups = recoveryPlan.getProtectGroups();
        this.checkParam(proGroups, 1073947394L);
        ProtectGroup pg = (ProtectGroup)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)recoveryPlan.getProtectGroups());
        String siteId = ((ProtectGroupReplica)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)pg.getReplicaList())).getRecoverySite();
        if (!VerifyUtil.isEmpty((String)recoverySiteId)) {
            siteId = recoverySiteId;
        } else {
            recoverySiteId = siteId;
        }
        Site site = FusionSphereServiceManager.getInstance().getSiteService().getSiteById(siteId);
        if (site.getSiteType() == 1) {
            return RecoveryPlanUtil.getRemoteAllNetworks(site, planId, drUrn);
        }
        if (!this.isValidOfDrUrn(recoveryPlan, recoverySiteId, drUrn, userId)) {
            this.logger.error((Object)"Invalid drUrn.", 90160758787071L);
            return Collections.emptyList();
        }
        ArrayList<TestNetwork> testNetworks = new ArrayList<TestNetwork>();
        try {
            String productSiteId;
            int type;
            ResourceMapping queryRm;
            rm = this.getResourceMappingByProductRes("productResourceId", drUrn);
            if (!VerifyUtil.isEmpty((String)recoverySiteId) && !VerifyUtil.isEmpty((Object)(queryRm = FsRecoveryUtil.getResourceMapping(drUrn, type = isPortGroup ? ResTypeEnum.PORT_GROUP.getResType() : ResTypeEnum.NETWORK.getResType(), "productResourceId", productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)recoveryPlan), recoverySiteId)))) {
                rm = queryRm;
            }
        }
        catch (LegoCheckedException e) {
            if (1073947394L == e.getErrorCode()) {
                this.logger.error((Object)("can not find resourceMapping, resource id is:" + drUrn), 90160758787071L);
                throw new LegoCheckedException(1073948359L, (Throwable)e);
            }
            this.logger.error((Object)"can not find resourceMapping", 90160758787071L);
            throw e;
        }
        if (VerifyUtil.isEmpty((Object)rm)) {
            this.logger.info((Object)("can not get ResourceMapping, resourceId is" + drUrn), 90160758786816L);
            return testNetworks;
        }
        if (rm.getRecoveryResourceId().equals(drUrn)) {
            drSn = rm.getRecoveryResourceProviderId();
            vpcId = rm.getRecoveryVpcId();
        } else {
            drSn = rm.getProductResourceProviderId();
            vpcId = rm.getProductVpcId();
        }
        this.logger.info((Object)("get CloudeSn is " + drSn + ",vpcId" + vpcId), 90160758786816L);
        this.queryNetworks(drSn, vpcId, testNetworks);
        this.logger.info((Object)"Query remote useable portgroup or network is success!", 90160758786816L);
        return testNetworks;
    }

    private boolean isValidOfDrUrn(RecoveryPlan plan, String recoverySiteId, String drUrn, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        String recoveryCloudSn = this.getRecoveryCloudSn(plan, recoverySiteId);
        List sns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(Arrays.asList(recoveryCloudSn), Long.valueOf(userId));
        if (VerifyUtil.isEmpty((Collection)sns)) {
            this.logger.error((Object)"sns is null or empty.", 90160758787071L);
            return false;
        }
        IMoDao moDao = FusionSphereServiceManager.getInstance().getMoDao();
        ManagedObject obj = moDao.getMo(ManagedObject.class, "uuid", (Object)drUrn);
        if (null == recoveryCloudSn || null == obj || !recoveryCloudSn.equals(obj.getTopMoUuid())) {
            this.logger.error((Object)("DrUrn does not belong to recoveryCloud, DrUrn=" + drUrn + ",RecoveryCloudSn=" + recoveryCloudSn), 90160758787071L);
            return false;
        }
        return true;
    }

    private void queryNetworks(String drSn, String vpcId, List<TestNetwork> testNetworks) {
        IMoDao moDao = FusionSphereServiceManager.getInstance().getMoDao();
        if (FusionSphereServiceManager.getInstance().getVrmService().isVrmSn(drSn)) {
            VRM vrm = (VRM)moDao.getMo(VRM.class, "sn", (Object)drSn);
            this.checkParam(vrm, 1073947394L);
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("topMoUuid", drSn);
            List portGroups = moDao.findMoBy(PortGroup.class, "name", true, props);
            for (PortGroup portGroup : portGroups) {
                TestNetwork tn = new TestNetwork();
                tn.setTestName(portGroup.getName());
                tn.setTestUrn(portGroup.getUrn());
                testNetworks.add(tn);
            }
        } else {
            VPC vpc = (VPC)moDao.getMo(VPC.class, "uuid", (Object)vpcId);
            this.checkParam(vpc, 1073947394L);
            HashMap<String, VPC> props = new HashMap<String, VPC>();
            props.put("parentMo", vpc);
            List networks = moDao.findMoBy(FmNetwork.class, "name", true, props);
            for (FmNetwork fn : networks) {
                TestNetwork tn = new TestNetwork();
                tn.setTestName(fn.getName());
                tn.setTestUrn(fn.getUuid());
                testNetworks.add(tn);
            }
        }
    }

    public List<TestNetworkSetting> updateTestNetworkSetting(String planId, String recoverySiteId, List<TestNetworkSetting> testNetworkSettings, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        RecoveryPlan plan = this.getRecoveryPlanByPlanId(planId);
        String recoveryCloudSn = this.getRecoveryCloudSn(plan, recoverySiteId);
        List sns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(Arrays.asList(recoveryCloudSn), Long.valueOf(userId));
        if (VerifyUtil.isEmpty((Collection)sns)) {
            this.logger.error((Object)"sns is null or empty.", 90160758787071L);
            throw new LegoCheckedException(1073947400L);
        }
        Set<String> proNetworkUrnSet = this.getProNetworkUrnSetFrom(plan);
        for (TestNetworkSetting e : testNetworkSettings) {
            String proNetworkUrn = e.getProNetworkUrn();
            if (!proNetworkUrnSet.contains(proNetworkUrn)) {
                this.logger.error((Object)("Test network does not belong to cloudPlatform, proNetworkUrn=" + proNetworkUrn), 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            String testNetworkUrn = e.getTestNetworkUrn();
            IMoDao moDao = FusionSphereServiceManager.getInstance().getMoDao();
            ManagedObject obj = moDao.getMo(ManagedObject.class, "uuid", (Object)testNetworkUrn);
            if (null == obj) {
                this.logger.error((Object)("obj is null, testNetworkUrn=" + testNetworkUrn), 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            String topMoUuid = obj.getTopMoUuid();
            if (null == topMoUuid || !topMoUuid.equals(recoveryCloudSn)) {
                this.logger.error((Object)("Test network does not belong to cloudPlatform, testNetworkUrn=" + testNetworkUrn + ", recoveryCloudSn=" + recoveryCloudSn), 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            e.setTestNetworkName(obj.getName());
        }
        return testNetworkSettings;
    }

    private Set<String> getProNetworkUrnSetFrom(RecoveryPlan plan) {
        this.logger.trace((Object)(this.trace + " trace message"));
        HashSet<String> proNetworkUrnSet = new HashSet<String>();
        Set pgSet = plan.getProtectGroups();
        for (ProtectGroup pg : pgSet) {
            Set poSet = pg.getPolist();
            for (ProtectObject po : poSet) {
                this.addProNetworkUrnToSet(po, proNetworkUrnSet);
            }
        }
        return proNetworkUrnSet;
    }

    private void addProNetworkUrnToSet(ProtectObject po, Set<String> proNetworkUrnSet) {
        block3: {
            String vmConfig;
            String vmProviderType;
            block2: {
                this.logger.trace((Object)(this.trace + " trace message"));
                JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
                vmProviderType = jo.getString(RpExParamsEnum.VM_TYPE.getValue());
                vmConfig = jo.getString(RpExParamsEnum.VM_CONFIG.getValue());
                if (!GalaxVM.VMProviderType.FC.getValue().equals(vmProviderType)) break block2;
                VmConfigType vmConfigType = (VmConfigType)CommonUtil.jsonToBean((String)vmConfig, VmConfigType.class);
                List fcNics = vmConfigType.getNics();
                for (VmConfigNicType fcNic : fcNics) {
                    proNetworkUrnSet.add(fcNic.getPortGroupUrn());
                }
                break block3;
            }
            if (!GalaxVM.VMProviderType.FM.getValue().equals(vmProviderType)) break block3;
            ResourcepoolVMServiceV2Stub.VmConfigSetE vmConfigType = (ResourcepoolVMServiceV2Stub.VmConfigSetE)CommonUtil.jsonToBean((String)vmConfig, ResourcepoolVMServiceV2Stub.VmConfigSetE.class);
            for (ResourcepoolVMServiceV2Stub.Nic nic : vmConfigType.getNics()) {
                proNetworkUrnSet.add(nic.getNetworkid());
            }
        }
    }

    private void checkParam(Object param, long errorType) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (null == param) {
            this.logger.error((Object)"param is null.", 90160758787071L);
            throw new LegoCheckedException(errorType);
        }
    }

    private void checkParametersNotEmpty(Object ... args) {
        this.logger.trace((Object)(this.trace + " trace message"));
        for (Object arg : args) {
            if (!VerifyUtil.isEmpty((Object)arg)) continue;
            this.logger.error((Object)"param is null.", 90160758787071L);
            throw new LegoCheckedException(65540L);
        }
    }

    public void setFmService(IFmService fmService) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.fmService = fmService;
    }

    public IFmService getFmService() {
        this.logger.trace((Object)(this.trace + " trace message"));
        return this.fmService;
    }
}

