/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.service;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessDefinition;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.common.FusionSphereServiceManager;
import com.huawei.ism.drm.galax.recovery.process.RegisterVmRecoveryProcessor;
import com.huawei.ism.drm.galax.recovery.process.command.exception.FindNoResourceMappingCheckedException;
import com.huawei.ism.drm.galax.recovery.process.subprocess.RegisterVmRecoverySubProcessor;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.service.IGalaxVMInfoService;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractGalaxVmInfoService
extends BaseService
implements IGalaxVMInfoService {
    private static final String HYPERV_VMURN = "HYPERV_VMURN";
    private Log logger = LogFactory.getInstance(AbstractGalaxVmInfoService.class);
    private IRecoveryPlanBaseService drpService;
    private String debug = "debug";

    public IRecoveryPlanBaseService getDrpService() {
        return this.drpService;
    }

    public void setDrpService(IRecoveryPlanBaseService drpService) {
        this.drpService = drpService;
    }

    public Map<String, String> getVmOsTypeMap(List<ProtectObject> pos) {
        this.logger.debug((Object)(this.debug + "getVmOsTypeMap enter."), 90160758786816L);
        HashMap<String, String> map = new HashMap<String, String>();
        for (ProtectObject po : pos) {
            map.put(po.getUuid(), this.getVmOsType(po));
        }
        return map;
    }

    protected abstract String getVmOsType(ProtectObject var1);

    public Map<String, Boolean> getVmIfTemplateMap(List<ProtectObject> pos) {
        this.logger.debug((Object)(this.debug + "getVmIfTemplateMap enter."), 90160758786816L);
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (ProtectObject po : pos) {
            JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
            map.put(po.getUuid(), jo.getBoolean("template"));
        }
        return map;
    }

    public Map<String, String> getVmProductionUrnMap(List<ProtectObject> pos) {
        this.logger.debug((Object)(this.debug + "getVmProductionUrnMap enter."), 90160758786816L);
        HashMap<String, String> map = new HashMap<String, String>();
        for (ProtectObject po : pos) {
            JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
            map.put(po.getUuid(), jo.getString("urn"));
        }
        return map;
    }

    public Map<String, String> getVmProductionIdMap(List<ProtectObject> pos) {
        this.logger.debug((Object)(this.debug + "getVmProductionIdMap enter."), 90160758786816L);
        HashMap<String, String> map = new HashMap<String, String>();
        for (ProtectObject po : pos) {
            JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
            map.put(po.getUuid(), jo.getString("vmUriOrId"));
        }
        return map;
    }

    public Map<String, String> getVmProductionLocationMap(List<ProtectObject> pos) {
        this.logger.debug((Object)(this.debug + "getVmProductionLocationMap enter."), 90160758786816L);
        HashMap<String, String> map = new HashMap<String, String>();
        for (ProtectObject po : pos) {
            JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
            map.put(po.getUuid(), jo.getString("location"));
        }
        return map;
    }

    public Map<String, String> getVmProductVPCMap(List<ProtectObject> pos) {
        this.logger.debug((Object)(this.debug + "getVmProductVPCMap enter."), 90160758786816L);
        HashMap<String, String> map = new HashMap<String, String>();
        for (ProtectObject po : pos) {
            JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
            JSONObject extendParams = jo.getJSONObject("extendParams");
            if (null == extendParams || !extendParams.containsKey((Object)"vpcId")) continue;
            map.put(po.getUuid(), extendParams.getString("vpcId"));
        }
        return map;
    }

    public Map<String, String> getVmRecoveryUrnMap(List<ProtectObject> pos) {
        this.logger.debug((Object)(this.debug + "getVmRecoveryUrnMap enter."), 90160758786816L);
        return this.getVmRecoveryInfoMap(pos, RpExParamsEnum.VM_URN.getValue());
    }

    public Map<String, String> getVmRecoveryIdMap(List<ProtectObject> pos) {
        this.logger.debug((Object)(this.debug + "getVmRecoveryIdMap enter."), 90160758786816L);
        return this.getVmRecoveryInfoMap(pos, RpExParamsEnum.VM_URIORID.getValue());
    }

    public Map<String, String> getVmRecoveryVPCMap(List<ProtectObject> pos) {
        this.logger.debug((Object)(this.debug + "getVmRecoveryVPCMap enter."), 90160758786816L);
        return this.getVmRecoveryInfoMap(pos, RpExParamsEnum.FM_VPC.getValue());
    }

    private Map<String, String> getVmRecoveryInfoMap(List<ProtectObject> pos, String value) {
        this.logger.debug((Object)(this.debug + "getVmRecoveryInfoMap enter."), 90160758786816L);
        HashMap<String, String> recoveryVmMap = new HashMap<String, String>();
        List allRecoveryPlans = this.drpService.getAllRecoveryPlan();
        ArrayList<String> vmIdList = new ArrayList<String>();
        List vmInfos = null;
        block2: for (ProtectObject po : pos) {
            String poId = po.getUuid();
            RecoveryPlan plan = this.getRecoveryPlan(allRecoveryPlans, po.getUuid());
            if (null == plan) {
                throw new LegoCheckedException(1073947394L, "RecoveryPlan is null, plan uuid " + po.getUuid());
            }
            List<RecoveryProcessor> registerVmRecoverySubProcessors = this.getRecoveryProcesses(plan);
            if (value.equals(HYPERV_VMURN) && null == vmInfos && !po.getProviderSN().startsWith("Dr_Vrm")) {
                FmObject fmInfo = null;
                for (RecoveryProcessor process : registerVmRecoverySubProcessors) {
                    RegisterVmRecoverySubProcessor processor = (RegisterVmRecoverySubProcessor)process;
                    String vmId = processor.getExtendParams().get(RpExParamsEnum.VM_URIORID.getValue());
                    vmIdList.add(vmId);
                    if (null != fmInfo) continue;
                    String fmVpc = processor.getExtendParams().get(RpExParamsEnum.FM_VPC.getValue());
                    String[] vpcArray = null == fmVpc ? new String[]{} : fmVpc.split(":");
                    String fmSn = this.getSplitStringByIndex(vpcArray, 2);
                    fmInfo = FmUtils.generateFmObj((String)fmSn);
                }
                try {
                    vmInfos = FusionSphereServiceManager.getInstance().getFmRetriever().queryVMs(fmInfo, null, vmIdList);
                }
                catch (FmBusinessException e) {
                    this.logger.error((Object)"Failed to get vmInfo by vmid", (Throwable)e, 90160758787071L);
                }
            }
            for (RecoveryProcessor process : registerVmRecoverySubProcessors) {
                RegisterVmRecoverySubProcessor processor = (RegisterVmRecoverySubProcessor)process;
                if (value.equals(HYPERV_VMURN) && processor.getGalaxId().equals(poId)) {
                    String vmId = processor.getExtendParams().get(RpExParamsEnum.VM_URIORID.getValue());
                    if (null == vmInfos) continue block2;
                    recoveryVmMap.put(poId, this.getHyperVVMurnId(vmId, vmInfos));
                    continue block2;
                }
                if (!processor.getGalaxId().equals(poId)) continue;
                recoveryVmMap.put(poId, processor.getExtendParams().get(value));
                continue block2;
            }
        }
        return recoveryVmMap;
    }

    private String getSplitStringByIndex(String[] strArray, int index) {
        if (strArray.length > index) {
            return strArray[index];
        }
        return null;
    }

    public Map<String, String> getVmRecoveryLocationMap(List<ProtectObject> pos, String productSiteId, String recoverySiteId) {
        this.logger.debug((Object)(this.debug + "getVmRecoveryLocationMap enter."), 90160758786816L);
        HashMap<String, String> map = new HashMap<String, String>();
        for (ProtectObject po : pos) {
            boolean isBindingHost;
            JSONObject jo = FsRecoveryUtil.getVmMgrInfo(po);
            String location = jo.getString("location");
            ResourceMapping rm = FsRecoveryUtil.getResourceMapping(location, isBindingHost = jo.getBoolean("hostLoc"), "productResourceId", productSiteId, recoverySiteId);
            if (null == rm) {
                this.logger.error((Object)("get rm failed, location:" + location), 90160758787071L);
                throw new FindNoResourceMappingCheckedException();
            }
            map.put(po.getUuid(), rm.getRecoveryResourceId());
        }
        return map;
    }

    private RecoveryPlan getRecoveryPlan(List<RecoveryPlan> planList, String poId) {
        this.logger.debug((Object)(this.debug + "getRecoveryPlan enter."), 90160758786816L);
        for (RecoveryPlan plan : planList) {
            ProtectObject po = this.getProtectObjectInRecoveryPlan(plan, poId);
            if (po == null) continue;
            return this.drpService.getRecoveryPlanWithProcess(plan.getPlanId());
        }
        return null;
    }

    private ProtectObject getProtectObjectInRecoveryPlan(RecoveryPlan plan, String poId) {
        this.logger.debug((Object)(this.debug + "getProtectObjectInRecoveryPlan enter."), 90160758786816L);
        Set pgSet = plan.getProtectGroups();
        for (ProtectGroup pg : pgSet) {
            Set pos = pg.getPolist();
            for (ProtectObject po : pos) {
                if (!po.getUuid().equals(poId)) continue;
                return po;
            }
        }
        return null;
    }

    private List<RecoveryProcessor> getRecoveryProcesses(RecoveryPlan plan) {
        this.logger.debug((Object)(this.debug + "getRecoveryProcesses enter."), 90160758786816L);
        ArrayList<RecoveryProcessor> processes = new ArrayList<RecoveryProcessor>();
        RecoveryProcessDefinition processDef = plan.getRecoveryProcess(DrmEnumDefine.RecoveryPlanExecuteTypeE.PLANED_MOTION);
        Set<RecoveryProcessor> registerVmSubProc = this.getRegisterVmSubProcessors(processDef);
        if (!VerifyUtil.isEmpty(registerVmSubProc)) {
            processes.addAll(registerVmSubProc);
        }
        processDef = plan.getRecoveryProcess(DrmEnumDefine.RecoveryPlanExecuteTypeE.DISASTER_RECOVERY);
        registerVmSubProc = this.getRegisterVmSubProcessors(processDef);
        if (VerifyUtil.isEmpty(processes) && !VerifyUtil.isEmpty(registerVmSubProc)) {
            this.logger.info((Object)"Failed to get PLANED_MOTION RegisterVmRecoverySubProcessor,It is empty.", 90160758787071L);
            processes.addAll(registerVmSubProc);
        }
        if (VerifyUtil.isEmpty(processes)) {
            this.logger.info((Object)"Failed to get DISASTER_RECOVERY RegisterVmRecoverySubProcessor,It is empty.", 90160758787071L);
        }
        return processes;
    }

    private Set<RecoveryProcessor> getRegisterVmSubProcessors(RecoveryProcessDefinition planedMotionProcessDef) {
        this.logger.debug((Object)(this.debug + "getRegisterVmSubProcessors enter."), 90160758786816L);
        Set registerVmSubProc = null;
        for (RecoveryProcessor rp : planedMotionProcessDef.getRecoveryProcessors()) {
            if (rp.getClass() != RegisterVmRecoveryProcessor.class) continue;
            registerVmSubProc = rp.getChildProc();
        }
        return registerVmSubProc;
    }

    public Map<String, String> getVmProductGlobalIdMap(List<ProtectObject> pos) {
        this.logger.debug((Object)(this.debug + "getVmProductGlobalIdMap enter."), 90160758786816L);
        HashMap<String, String> map = new HashMap<String, String>();
        for (ProtectObject po : pos) {
            map.put(po.getUuid(), (String)po.getProps().get(HYPERV_VMURN));
        }
        return map;
    }

    public Map<String, String> getVmRecoveryGlobalIdMap(List<ProtectObject> pos) {
        this.logger.debug((Object)(this.debug + "getVmRecoveryGlobalIdMap enter."), 90160758786816L);
        return this.getVmRecoveryInfoMap(pos, HYPERV_VMURN);
    }

    private String getHyperVVMurnId(String vmId, List<ResourcepoolVMServiceV2Stub.VMInfo0> vmInfos) {
        this.logger.debug((Object)"getHyperVVMurnId enter.", 90160758786816L);
        if (VerifyUtil.isEmpty(vmInfos)) {
            return "";
        }
        for (ResourcepoolVMServiceV2Stub.VMInfo0 vmInfo : vmInfos) {
            if (!vmInfo.getVmID().equals(vmId)) continue;
            return vmInfo.getHyperVId() + "$" + vmInfo.getVVMURN();
        }
        return "";
    }
}

