/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.service;

import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.recovery.service.GalaxRecoveryPlanService;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.service.DrsRecoveryService;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;

@Service(name="DrsRecoveryServiceImpl", desc="", interfaceClass=DrsRecoveryService.class)
public class DrsRecoveryServiceImpl
extends BaseService
implements DrsRecoveryService {
    private static final Log LOGGER = LogFactory.getInstance(GalaxRecoveryPlanService.class);

    public void refreshDrsRecoverySetting(ProtectGroup protectGroup) {
        try {
            IRecoveryPlanBaseService rpService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
            String rpId = rpService.getAssociatedRecoveryPlanWithProtectGroup(protectGroup.getUuid());
            RecoveryPlan rp = rpService.getRecoveryPlan(rpId);
            boolean needRefreshRecoverySet = this.needInitDrs(rp);
            if (needRefreshRecoverySet) {
                rpService.saveOrUpdateRecoverySettings(rp.getUuid(), new ArrayList(rp.getRecoverySettings()));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to refresh the drs primary VM.");
        }
    }

    public boolean needInitDrs(RecoveryPlan recoveryPlan) {
        try {
            ProtectGroup pg = recoveryPlan.getProtectGroup();
            if (pg.getTemplate().getType() == 15) {
                LOGGER.info((Object)"In the active-active scenario, no update is required.");
                return false;
            }
            String productSiteId = pg.getProductSiteId();
            String recoverySiteId = ((ProtectGroupReplica)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)pg.getReplicaList())).getRecoverySite();
            boolean isRefreshRecoverySet = false;
            for (ProtectObject po : pg.getPolist()) {
                String drsString = FsRecoveryUtil.getDrsVmIdList(po, productSiteId, recoverySiteId);
                if (VerifyUtil.isEmpty((String)drsString)) continue;
                isRefreshRecoverySet = true;
                LOGGER.debug((Object)"Protected object (%s) refreshes the DRS group in the recovery plan.", new Object[]{po.getName()});
                this.updatePoRecoverySetting(recoveryPlan, po, "prd_drs_vm_id_list", drsString);
            }
            return isRefreshRecoverySet;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to initialize the DRS information in the recovery plan.");
            return false;
        }
    }

    private void updatePoRecoverySetting(RecoveryPlan plan, ProtectObject po, String settingKey, String settingValue) {
        Set vmRecoverySettings = plan.getRecoverySettings();
        Optional<RecoverySetting> drsOptional = vmRecoverySettings.stream().filter(set -> set.getOwnerId().equals(po.getUuid()) && settingKey.equals(set.getName())).findFirst();
        if (drsOptional.isPresent()) {
            RecoverySetting recoverySetting = drsOptional.get();
            recoverySetting.setValue(settingValue);
        } else {
            RecoverySetting recoverySetting = new RecoverySetting();
            recoverySetting.setRecoveryPlan(plan);
            recoverySetting.setName(settingKey);
            recoverySetting.setOwnerId(po.getUuid());
            recoverySetting.setValue(settingValue);
            vmRecoverySettings.add(recoverySetting);
        }
    }
}

