/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.recovery.service;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.galax.constant.cloudenum.PoExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.RpExParamsEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VmStatusEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.NoneCriticalVm;
import com.huawei.ism.drm.galax.sdk.model.NoneCriticalVmWebBean;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.pg.model.FixLengthProps;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.service.IGalaxRecoveryPlanService;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigCPUType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.galax.util.rest.JSONUtils;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaBaseService;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.IManagementServerBaseService;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.virtualization.util.VirtualizationCommonUtil;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.dao.DataAccessException;

@Service(name="com.huawei.ism.drm.galax.sdk.service.IGalaxRecoveryPlanService", desc="", interfaceClass=IGalaxRecoveryPlanService.class)
public class GalaxRecoveryPlanService
extends BaseService
implements IGalaxRecoveryPlanService {
    private static final int MAX_POPROPS_LEN = 8192;
    private Log logger = LogFactory.getInstance(GalaxRecoveryPlanService.class);
    private String trace = "trace";
    private IBaseDao<Object, Serializable> baseDao;
    private IRecoveryPlanBaseService rpService;
    private IFmService fmService;
    private IDaoAdapter daoAdapter;
    private IManagementServerBaseService managementServerService;
    private ISiteBaseService siteService;

    public IManagementServerBaseService getManagementServerService() {
        return this.managementServerService;
    }

    public void setManagementServerService(IManagementServerBaseService managementServerService) {
        this.managementServerService = managementServerService;
    }

    public ISiteBaseService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(ISiteBaseService siteService) {
        this.siteService = siteService;
    }

    public IDaoAdapter getDaoAdapter() {
        this.logger.trace((Object)(this.trace + " trace message"));
        return this.daoAdapter;
    }

    public void setDaoAdapter(IDaoAdapter daoAdapter) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.daoAdapter = daoAdapter;
    }

    public IBaseDao<Object, Serializable> getBaseDao() {
        this.logger.trace((Object)(this.trace + " trace message"));
        return this.baseDao;
    }

    public void setBaseDao(IBaseDao<Object, Serializable> baseDao) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.baseDao = baseDao;
    }

    public IRecoveryPlanBaseService getRpService() {
        this.logger.trace((Object)(this.trace + " trace message"));
        return this.rpService;
    }

    public void setRpService(IRecoveryPlanBaseService rpService) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.rpService = rpService;
    }

    public IFmService getFmService() {
        this.logger.trace((Object)(this.trace + " trace message"));
        return this.fmService;
    }

    public void setFmService(IFmService fmService) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.fmService = fmService;
    }

    public List<NoneCriticalVmWebBean> queryUnSetVm(String planId, String recoverySiteId, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.checkParams(planId);
        Site site = this.getSiteService().getSiteById(recoverySiteId, Long.valueOf(userId));
        if (site == null) {
            this.logger.error((Object)"not found recovery plan disaster site by uuid(%s)", new Object[]{recoverySiteId});
            throw new LegoCheckedException(1073948719L);
        }
        if (site.getSiteType() == 1) {
            String data = this.managementServerService.get(site.getServerUuid(), "/ws/fusionsphere/vms/action/getAvailableNonCirticalVm?planId={planId}&&recoverySiteId={siteId}", new JSONObject().set((Object)"planId", (Object)planId).set((Object)"siteId", (Object)recoverySiteId));
            if (VerifyUtil.isEmpty((String)data)) {
                return Collections.emptyList();
            }
            return JSONArray.fromObject((Object)data).filter(JSONObject.class).stream().map(item -> item.set((Object)"vmUuid", item.get("uuid")).set((Object)"vmName", item.get("name")).set((Object)"vmUri", item.get("uri"))).map(item -> (NoneCriticalVmWebBean)JSONObject.toBean((JSONObject)item, NoneCriticalVmWebBean.class)).collect(Collectors.toList());
        }
        RecoveryPlan plan = this.getRecoveryPlanByPlanId(planId);
        String remoteCloudSn = this.getRecoveryCloudSn(plan, recoverySiteId);
        List sns = this.daoAdapter.filterDrResourceSN(Arrays.asList(remoteCloudSn), Long.valueOf(userId));
        if (VerifyUtil.isEmpty((Collection)sns)) {
            this.logger.error((Object)"sns is null or empty.", 90160758787071L);
            return Collections.emptyList();
        }
        List<GalaxVM> listGalaxVmInCloud = this.getRecoveryVmByCloudSn(remoteCloudSn);
        if (!remoteCloudSn.startsWith("Dr_Vrm")) {
            listGalaxVmInCloud = this.filterCloudPlatmVmInPlan(plan, recoverySiteId, listGalaxVmInCloud);
        }
        List<GalaxVM> listGalaxVm = this.filterNoneCriticalVmInPlan(planId, recoverySiteId, listGalaxVmInCloud, userId);
        listGalaxVm = this.filterStoppedVm(listGalaxVm);
        List<NoneCriticalVmWebBean> vmList = this.constructNoneCriticalVm(listGalaxVm);
        return vmList;
    }

    private List<GalaxVM> filterStoppedVm(List<GalaxVM> vmList) {
        return vmList.stream().filter(vm -> VmStatusEnum.RUNNING.getKey() == vm.getStatus().intValue()).collect(Collectors.toList());
    }

    private List<GalaxVM> filterCloudPlatmVmInPlan(RecoveryPlan plan, String recoverySiteId, List<GalaxVM> listGalaxVmInCloud) {
        this.logger.trace((Object)(this.trace + " trace message"));
        Set pgList = plan.getProtectGroups();
        ArrayList poList = new ArrayList();
        for (ProtectGroup pg : pgList) {
            if (VerifyUtil.isEmpty((Collection)pg.getPolist())) continue;
            poList.addAll(pg.getPolist());
        }
        String productSiteId = RecoveryServiceUtil.getProductSiteId((RecoveryPlan)plan);
        ArrayList<String> cloudSnList = new ArrayList<String>();
        for (ProtectObject po : poList) {
            String vrmSn = this.getVrmSnFromPo(productSiteId, recoverySiteId, po);
            if (cloudSnList.contains(vrmSn)) continue;
            cloudSnList.add(vrmSn);
        }
        ArrayList<GalaxVM> vmList = new ArrayList<GalaxVM>();
        for (GalaxVM vm : listGalaxVmInCloud) {
            String cloudUuid = vm.getTopMoUuid();
            if (!cloudSnList.contains(cloudUuid)) continue;
            vmList.add(vm);
        }
        return vmList;
    }

    private List<GalaxVM> filterNoneCriticalVmInPlan(String planId, String recoverySiteId, List<GalaxVM> listGalaxVmInCloud, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List<NoneCriticalVmWebBean> noneCriticalVmInRp = this.queryNoneCriticalVm(planId, recoverySiteId, userId);
        if (VerifyUtil.isEmpty(noneCriticalVmInRp)) {
            this.logger.info((Object)"@@there is no noneCriticalVm in recoveryPlan ", 90160758786816L);
            return listGalaxVmInCloud;
        }
        ArrayList<String> uuids = new ArrayList<String>();
        for (NoneCriticalVmWebBean vm : noneCriticalVmInRp) {
            uuids.add(vm.getVmUuid());
        }
        ArrayList<GalaxVM> vmList = new ArrayList<GalaxVM>();
        for (GalaxVM vm : listGalaxVmInCloud) {
            if (uuids.contains(vm.getUuid())) continue;
            vmList.add(vm);
        }
        return vmList;
    }

    private List<NoneCriticalVmWebBean> constructNoneCriticalVm(List<GalaxVM> listGalaxVm) {
        this.logger.trace((Object)(this.trace + " trace message"));
        ArrayList<NoneCriticalVmWebBean> vmList = new ArrayList<NoneCriticalVmWebBean>();
        if (!VerifyUtil.isEmpty(listGalaxVm)) {
            for (GalaxVM galaxVM : listGalaxVm) {
                NoneCriticalVmWebBean vm = new NoneCriticalVmWebBean();
                vm.setVmUri(galaxVM.getUri());
                vm.setVmUuid(galaxVM.getUuid());
                vm.setVmName(galaxVM.getName());
                vmList.add(vm);
            }
        }
        return vmList;
    }

    public List<GalaxVM> getRecoveryVmByCloudSn(String remoteCloudSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.logger.info((Object)"begin to query vm by cloudSn ", 90160758786816L);
        HashMap<String, Object> extendCondition = new HashMap<String, Object>();
        extendCondition.put("isPoAllow", true);
        return FsRecoveryUtil.getFilterVms(remoteCloudSn, extendCondition);
    }

    public String getRecoveryCloudSn(RecoveryPlan plan, String recoverySiteId) {
        String remoteCloudSn;
        block8: {
            this.logger.trace((Object)(this.trace + " trace message"));
            String localCloudSn = null;
            Set pgs = plan.getProtectGroups();
            Iterator it = pgs.iterator();
            if (it.hasNext()) {
                ProtectGroup pg = (ProtectGroup)it.next();
                if (VerifyUtil.isEmpty((Collection)pg.getPolist())) {
                    this.logger.error((Object)"poList is empty.", 90160758787071L);
                    throw new LegoCheckedException(1073947394L);
                }
                localCloudSn = ((ProtectObject)VirtualizationCommonUtil.getInstance().getElementFromCollection((Collection)pg.getPolist())).getProviderSN();
            }
            if (null == localCloudSn) {
                this.logger.error((Object)"localCloudSn is null.", 90160758787071L);
                throw new LegoCheckedException(1073947394L);
            }
            try {
                Site recoverySite;
                ResourceMapping rm = !VerifyUtil.isEmpty((String)recoverySiteId) ? (0 != (recoverySite = RecoveryServiceUtil.getRecoverySite((String)recoverySiteId)).getSiteType() ? GalaxRecoveryPlanService.queryRemoteResourceMapping(localCloudSn, recoverySite) : this.queryLocalResourceMapping(recoverySiteId, localCloudSn, pgs)) : this.daoAdapter.getResourceMappingByProductRes("productResourceProviderId", localCloudSn);
                if (null != rm) {
                    remoteCloudSn = rm.getRecoveryResourceProviderId();
                    if (rm.getRecoveryResourceProviderId().equals(localCloudSn)) {
                        remoteCloudSn = rm.getProductResourceProviderId();
                    }
                    break block8;
                }
                this.logger.error((Object)"get ResourceMapping by productResourceProviderId failed", 90160758784002L);
                throw new LegoCheckedException(1073948259L);
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)"ResourceMapping does not exist", 90160758784002L);
                throw e;
            }
            catch (DataAccessException e) {
                this.logger.error((Object)"get ResourceMapping by productResourceProviderId failed", 90160758784002L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
        return remoteCloudSn;
    }

    private static ResourceMapping queryRemoteResourceMapping(String localCloudSn, Site recoverySite) {
        ResourceMapping rm = null;
        QueryCondition cond = new QueryCondition("recoverySiteId", (Object)recoverySite.getSiteId());
        List<ResourceMapping> list = FsRecoveryUtil.getRemoteResourceMappings(recoverySite, cond);
        if (!VerifyUtil.isEmpty(list)) {
            for (ResourceMapping resourceMapping : list) {
                if (recoverySite.getSiteId().equals(resourceMapping.getRecoverySiteId()) && localCloudSn.equals(resourceMapping.getProductResourceProviderId())) {
                    rm = resourceMapping;
                    break;
                }
                if (!recoverySite.getSiteId().equals(resourceMapping.getProductSiteId()) || !localCloudSn.equals(resourceMapping.getRecoveryResourceProviderId())) continue;
                rm = resourceMapping;
                break;
            }
        }
        return rm;
    }

    private ResourceMapping queryLocalResourceMapping(String recoverySiteId, String localCloudSn, Set<ProtectGroup> pgs) {
        ResourceMapping rm = null;
        Iterator<ProtectGroup> iterator = pgs.iterator();
        if (iterator.hasNext()) {
            ResourceMapping queryRm;
            ArrayList<QueryCondition> props = new ArrayList<QueryCondition>();
            QueryCondition conditionProductResourceId = new QueryCondition("productResourceProviderId", (Object)localCloudSn);
            props.add(conditionProductResourceId);
            QueryCondition conditionRecoverySiteId = new QueryCondition("recoverySiteId", (Object)recoverySiteId);
            props.add(conditionRecoverySiteId);
            rm = queryRm = FsRecoveryUtil.getResourceMapping(props, "productResourceProviderId", localCloudSn);
        }
        return rm;
    }

    public List<NoneCriticalVmWebBean> queryNoneCriticalVm(String planId, String recoverySiteId, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.checkParams(planId);
        RecoveryPlan plan = this.getRecoveryPlanByPlanId(planId);
        String remoteCloudSn = this.getRecoveryCloudSn(plan, recoverySiteId);
        List sns = this.daoAdapter.filterDrResourceSN(Arrays.asList(remoteCloudSn), Long.valueOf(userId));
        if (VerifyUtil.isEmpty((Collection)sns)) {
            this.logger.error((Object)"sns is null or empty.", 90160758787071L);
            return Collections.emptyList();
        }
        return this.getNoneCriticalVm(plan);
    }

    public List<NoneCriticalVmWebBean> getNoneCriticalVm(RecoveryPlan plan) {
        this.logger.trace((Object)(this.trace + " trace message"));
        Map globalSetting = plan.getGlobalSettings();
        if (VerifyUtil.isEmpty((Map)globalSetting) || VerifyUtil.isEmpty((String)((String)globalSetting.get("NoncritialVM")))) {
            this.logger.info((Object)"@@globalSetting or the noncriticalvm is null ", 90160758786816L);
            return null;
        }
        String json = (String)globalSetting.get("NoncritialVM");
        List vmList = (List)CommonUtil.json2Bean((String)json, NoneCriticalVm[].class);
        return this.updateNoneCriticalVm(vmList);
    }

    private List<NoneCriticalVmWebBean> updateNoneCriticalVm(List<NoneCriticalVm> vmList) {
        this.logger.trace((Object)(this.trace + " trace message"));
        ArrayList<NoneCriticalVmWebBean> vmForFEList = new ArrayList<NoneCriticalVmWebBean>();
        for (NoneCriticalVm ncVm : vmList) {
            GalaxVM galaxVm = (GalaxVM)CommonDAOLocator.getMoDao().getMo(GalaxVM.class, "uuid", (Object)ncVm.getUuid());
            if (VerifyUtil.isEmpty((Object)galaxVm)) {
                this.logger.info((Object)("vm is not exist, vmUri is " + ncVm.getUuid()), 90160758786816L);
                continue;
            }
            NoneCriticalVmWebBean vm = new NoneCriticalVmWebBean();
            vm.setVmName(galaxVm.getName());
            vm.setVmUuid(ncVm.getUuid());
            vm.setVmUri(ncVm.getUri());
            vmForFEList.add(vm);
        }
        Collections.sort(vmForFEList, new Comparator<NoneCriticalVmWebBean>(){

            @Override
            public int compare(NoneCriticalVmWebBean arg0, NoneCriticalVmWebBean arg1) {
                if (arg0.getVmName() == null || arg1.getVmName() == null) {
                    return -1;
                }
                return arg0.getVmName().compareTo(arg1.getVmName());
            }
        });
        return vmForFEList;
    }

    public void setNoneCriticalVm(String planId, String recoverySiteId, List<String> uuids, long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.checkParams(planId);
        if (null == uuids) {
            this.logger.error((Object)"@@The uuids is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan plan = this.getRecoveryPlanByPlanId(planId);
        String remoteCloudSn = this.getRecoveryCloudSn(plan, recoverySiteId);
        List sns = this.daoAdapter.filterDrResourceSN(Arrays.asList(remoteCloudSn), Long.valueOf(userId));
        if (VerifyUtil.isEmpty((Collection)sns)) {
            this.logger.error((Object)"sns is null or empty.", 90160758787071L);
            return;
        }
        ArrayList<GalaxVM> galaxVms = new ArrayList<GalaxVM>();
        String topMoUuidOfVm = null;
        for (String string : uuids) {
            GalaxVM vm = (GalaxVM)this.daoAdapter.getMo(GalaxVM.class, "uuid", (Object)string);
            if (null == vm) {
                this.logger.error((Object)("This vm was not found, uuid:" + string), 90160758784001L);
                continue;
            }
            topMoUuidOfVm = this.getTopMoUuid(vm.getTopMoUuid(), remoteCloudSn);
            if (null == topMoUuidOfVm || !topMoUuidOfVm.equals(remoteCloudSn)) {
                this.logger.error((Object)("This vm does not belong to recCloudPlatform, uuid:" + string + " and recoveryCloudSn:" + remoteCloudSn), 90160758784001L);
                continue;
            }
            galaxVms.add(vm);
        }
        Collections.sort(galaxVms, new Comparator<GalaxVM>(){

            @Override
            public int compare(GalaxVM arg0, GalaxVM arg1) {
                if (arg0.getName() == null || arg1.getName() == null) {
                    return -1;
                }
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        ArrayList<NoneCriticalVm> ncVmList = new ArrayList<NoneCriticalVm>();
        for (GalaxVM vm : galaxVms) {
            NoneCriticalVm ncVm = new NoneCriticalVm();
            ncVm.setUuid(vm.getUuid());
            ncVm.setUri(vm.getUri());
            ncVmList.add(ncVm);
        }
        String string = CommonUtil.beanToJson(ncVmList);
        plan.getGlobalSettings().put("NoncritialVM", string);
        this.getBaseDao().getHibernateTemplate().saveOrUpdate((Object)plan);
    }

    private String getTopMoUuid(String topMoUuidOfVm, String recoveryCloudSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (!recoveryCloudSn.startsWith("Dr_Vrm")) {
            FusionManager recCloudPlatform = this.fmService.getDependenceFmByVrm(topMoUuidOfVm);
            if (null == recCloudPlatform) {
                this.logger.error((Object)"recCloudPlatform is null", 90160758784001L);
                return null;
            }
            return recCloudPlatform.getSn();
        }
        return topMoUuidOfVm;
    }

    public RecoveryPlan getRecoveryPlanByPlanId(String planId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty((String)planId)) {
            this.logger.error((Object)"@@planId is null ", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        RecoveryPlan recoveryPlan = this.getRpService().getRecoveryPlan(planId);
        if (VerifyUtil.isEmpty((Object)recoveryPlan)) {
            this.logger.error((Object)"@@recovery plan is null", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        return recoveryPlan;
    }

    private void checkParams(String param) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty((String)param)) {
            this.logger.error((Object)"@@The param is null", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public Integer queryCpuCoresPerSocket(String vmUuid) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.checkParams(vmUuid);
        GalaxVM vm = (GalaxVM)CommonDAOLocator.getMoDao().getMo(GalaxVM.class, "sn", (Object)vmUuid);
        if (VerifyUtil.isEmpty((Object)vm)) {
            this.logger.error((Object)"@@The vm is not exist ", 90160758784001L);
            throw new LegoCheckedException(1073947394L);
        }
        VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)vm.getVmConfig(), VmConfigType.class);
        VmConfigCPUType cpuConfig = vmConfig.getCpu();
        int coresPerSocket = cpuConfig.getCoresPerSocket();
        return coresPerSocket;
    }

    private String getVrmSnFromPo(String productSiteId, String recoverySiteId, ProtectObject po) {
        this.logger.trace((Object)(this.trace + " trace message"));
        FixLengthProps recoveryVmProps = new FixLengthProps(po.getProps(), 8192);
        String vmMgrJson = recoveryVmProps.getValue(PoExParamsEnum.VM_MGR_INFO.getValue());
        if (null == vmMgrJson) {
            return null;
        }
        try {
            JSONObject jsonObj = JSONObject.fromObject((Object)vmMgrJson);
            Boolean hostLoc = (Boolean)jsonObj.get("hostLoc");
            String location = jsonObj.getString("location");
            ResourceMapping res = FsRecoveryUtil.getResourceMapping(location, hostLoc, "productResourceId", productSiteId, recoverySiteId);
            if (null != res) {
                return res.getRecoveryResourceProviderId();
            }
        }
        catch (LegoCheckedException e) {
            this.logger.error((Object)"get template from po failed. Json format error.", (Throwable)e, 90160758787071L);
        }
        return null;
    }

    public List<String> queryVmConfigsByReplicaId(String replicaId) {
        IReplicaBaseService replicaService = (IReplicaBaseService)ServiceLocator.getInstance().getService(IReplicaBaseService.class);
        List poList = replicaService.getProtectObjectListByReplicaId(replicaId);
        ArrayList<String> vmConfigs = new ArrayList<String>();
        if (VerifyUtil.isEmpty((Collection)poList)) {
            return vmConfigs;
        }
        for (ProtectObject po : poList) {
            JSONObject jo;
            String vmConfig;
            FixLengthProps poRecoveryProps = new FixLengthProps(po.getProps(), 8192);
            String vmMgrJson = poRecoveryProps.getValue(PoExParamsEnum.VM_MGR_INFO.getValue());
            if (VerifyUtil.isEmpty((String)vmMgrJson) || VerifyUtil.isEmpty((String)(vmConfig = (jo = JSONUtils.fromString((String)vmMgrJson)).getString(RpExParamsEnum.VM_CONFIG.getValue())))) continue;
            vmConfigs.add(vmConfig);
        }
        return vmConfigs;
    }
}

