/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.ism.cbb.mediation.status.DefaultOnlineToOfflineStatus;
import com.huawei.ism.cbb.mediation.status.GlobalDeviceStatus;
import com.huawei.ism.cbb.mediation.status.Istatus;
import com.huawei.ism.drm.galax.resource.discovery.manager.FmServiceManager;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.GalaxObject;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class FmBaseProcessor
implements IProcessor {
    private static final Log LOGGER = LogFactory.getInstance(FmBaseProcessor.class);

    public void clean(AbstractContext arg0) {
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void postProcess(AbstractContext arg0) {
    }

    public boolean process(AbstractContext context) {
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        LOGGER.info((Object)("enter process FusionManager discovery, ip=" + extend.getNetworkIpAddress()), 90160758786816L);
        String port = (String)extend.getExtendParams().get("port");
        extend.getExtendParams().clear();
        extend.getExtendParams().put("port", port);
        FusionManager fm = this.getFmInfo(context, extend);
        if (null == fm) {
            LOGGER.error((Object)("FusionManager is not exist, ip=" + extend.getNetworkIpAddress()), 90160758787071L);
            this.processFmOfflineAlarm(context);
            throw new LegoCheckedException(1073947394L);
        }
        this.checkFmSn(context, (NetworkEntity)fm);
        fm.setProductModel("Dr_Fm");
        fm.setIsTopMo(Boolean.valueOf(true));
        fm = this.queryFmResource(fm, extend);
        fm.setStatus(Integer.valueOf(0));
        context.setAttribute("DRMFM", (Object)fm);
        context.setAttribute("StorageDevice", (Object)fm);
        Istatus devStatus = GlobalDeviceStatus.getStatus((String)fm.getUuid(), DefaultOnlineToOfflineStatus.class);
        devStatus.doAction((ManagedObject)fm, 0);
        LOGGER.info((Object)("leave process FusionManager discovery, ip=" + fm.getIpAddress()), 90160758786816L);
        return true;
    }

    private void processFmOfflineAlarm(AbstractContext context) {
        String opType = (String)context.getAttribute("DiscoveryType");
        if (!"register".equalsIgnoreCase(opType)) {
            FusionManager fm = (FusionManager)context.getAttribute("StorageDevice");
            fm.setStatus(Integer.valueOf(-1));
            Istatus devStatus = GlobalDeviceStatus.getStatus((String)fm.getSn(), DefaultOnlineToOfflineStatus.class);
            devStatus.doAction((ManagedObject)fm, -1);
            DiscoverUtil.setMosOffline((NetworkEntity)fm);
            VrmManager.getInstance().getCloudService().updateDrCloudStatus((NetworkEntity)fm, -1);
            LOGGER.info((Object)("set FusionManager offline, ip=" + fm.getIpAddress()), 90160758786816L);
        }
    }

    private FusionManager getFmInfo(AbstractContext context, NeMgrProtocolExtend extend) {
        FusionManager fm;
        try {
            fm = FmServiceManager.getInstance().getFmResService().loginFm(extend);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("get fm(" + extend.getNetworkIpAddress() + ")'basic info failed."), (Throwable)e, 90160758787071L);
            this.processFmOfflineAlarm(context);
            throw e;
        }
        catch (Exception e) {
            fm = null;
            this.processFmOfflineAlarm(context);
            ExceptionUtil.rethrowException((Throwable)e, (String)("get fm(" + extend.getNetworkIpAddress() + ")'basic info failed."), (long)1073947399L, null, (Log)LOGGER);
        }
        return fm;
    }

    private FusionManager queryFmResource(FusionManager fm, NeMgrProtocolExtend extend) {
        this.queryAllMoResource((ManagedObject)fm, extend);
        VrmUtil.cleanExtend((NeMgrProtocolExtend)extend);
        return fm;
    }

    private void queryAllMoResource(ManagedObject mo, NeMgrProtocolExtend extend) {
        this.queryMoResource(mo, extend);
        Set childMoSet = mo.getChildMos();
        if (VerifyUtil.isEmpty((Collection)childMoSet)) {
            return;
        }
        for (ManagedObject childmo : childMoSet) {
            this.queryAllMoResource(childmo, extend);
        }
    }

    private void queryMoResource(ManagedObject mo, NeMgrProtocolExtend extend) {
        extend.getExtendParams().put("resourceType", mo.getClass().getName());
        extend.getExtendParams().put("parrentUri", FmUtils.getCommonObjectId((String)mo.getUuid(), (String)mo.getClass().getSimpleName()));
        List listMo = FmServiceManager.getInstance().getFmResService().queryChildResource(extend);
        this.buildMoRelation(mo, listMo);
    }

    private void buildMoRelation(ManagedObject parrentMo, List<GalaxObject> childrenMo) {
        if (null == childrenMo || childrenMo.isEmpty() || null == parrentMo) {
            return;
        }
        for (ManagedObject managedObject : childrenMo) {
            managedObject.setParentMo(parrentMo);
            parrentMo.addChildMo(managedObject);
        }
    }

    private void checkFmSn(AbstractContext context, NetworkEntity entity) {
        FusionManager fm;
        String opType = (String)context.getAttribute("DiscoveryType");
        if (!"register".equalsIgnoreCase(opType) && !(fm = (FusionManager)context.getAttribute("StorageDevice")).getSn().equals(entity.getSn())) {
            LOGGER.error((Object)("the sn of FM changed, ip=" + entity.getLinkIp()), 90160758787071L);
            throw new LegoCheckedException(1073947432L);
        }
    }
}

