/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.ism.cbb.mediation.status.DefaultOnlineToOfflineStatus;
import com.huawei.ism.cbb.mediation.status.GlobalDeviceStatus;
import com.huawei.ism.cbb.mediation.status.Istatus;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IFMInfosRetriever;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;

public class PingCloudPlatformProcessor
implements IProcessor {
    private Log logger = LogFactory.getInstance((Object)this);

    public void clean(AbstractContext context) {
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void postProcess(AbstractContext context) {
    }

    public boolean process(AbstractContext context) {
        NetworkEntity networkEntity = (NetworkEntity)context.getAttribute("StorageDevice");
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        VRM cloudPlatform = null;
        try {
            if (networkEntity instanceof VRM) {
                cloudPlatform = VrmManager.getInstance().getVrmResService().loginVrm(extend);
            } else if (networkEntity instanceof FusionManager) {
                cloudPlatform = this.loginFusionManager(extend);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("cloud platform Ping failed " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160777658372L);
        }
        int nowStatus = null == cloudPlatform ? -1 : 0;
        int oldStatus = null == networkEntity.getStatus() ? -1 : networkEntity.getStatus();
        this.logger.debug((Object)("process status, ne=" + networkEntity.getName() + ", oldStaus=" + networkEntity.getStatus() + ", newStatus=" + nowStatus));
        if (oldStatus == nowStatus) {
            return true;
        }
        if (nowStatus == 0) {
            ArrayList<String> availableIps = new ArrayList<String>();
            availableIps.add(networkEntity.getLinkIp());
            context.setAttribute("AvailableIps", availableIps);
        } else {
            VrmManager.getInstance().getCloudService().updateDrCloudStatus(networkEntity, nowStatus);
        }
        Istatus devStatus = GlobalDeviceStatus.getStatus((String)networkEntity.getUuid(), DefaultOnlineToOfflineStatus.class);
        devStatus.doAction((ManagedObject)networkEntity, nowStatus);
        DiscoverUtil.updateNetworkEntityStatus((NetworkEntity)networkEntity, (int)nowStatus);
        return true;
    }

    private FusionManager loginFusionManager(NeMgrProtocolExtend extend) throws FmBusinessException {
        FmObject fmobj = ((IFMInfosRetriever)ServiceLocator.getInstance().getService(IFMInfosRetriever.class)).login(extend);
        if (null == fmobj || null == fmobj.getUrn()) {
            this.logger.error((Object)("login fm is null, ip=" + extend.getNetworkIpAddress()), 90160758787071L);
            return null;
        }
        FusionManager result = new FusionManager();
        result.setUuid(fmobj.getUrn());
        result.setLinkIp(extend.getNetworkIpAddress());
        result.setIpAddress(extend.getNetworkIpAddress());
        result.setSn(fmobj.getUrn());
        result.setName(fmobj.getName());
        return result;
    }
}

