/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.ism.cbb.mediation.status.DefaultOnlineToOfflineStatus;
import com.huawei.ism.cbb.mediation.status.GlobalDeviceStatus;
import com.huawei.ism.cbb.mediation.status.Istatus;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.sdk.model.GalaxObject;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class VrmBaseProcessor
implements IProcessor {
    private static final Log LOGGER = LogFactory.getInstance(VrmBaseProcessor.class);
    private static List<String> vrmResList = new ArrayList<String>();

    public VrmBaseProcessor() {
        vrmResList.add("clustor");
        vrmResList.add("host");
        vrmResList.add("dvswitch");
        vrmResList.add("portGroup");
        vrmResList.add("datastore");
        vrmResList.add("vm");
    }

    public void clean(AbstractContext arg0) {
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void postProcess(AbstractContext arg0) {
    }

    public boolean process(AbstractContext context) {
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        String port = (String)extend.getExtendParams().get("port");
        extend.getExtendParams().clear();
        extend.getExtendParams().put("port", port);
        VRM vrm = this.getVrmInfo(context, extend);
        if (null == vrm) {
            LOGGER.error((Object)("the vrm(" + extend.getNetworkIpAddress() + ")'info is not valid."), 90160758786816L);
            this.processVrmOfflineAlarm(context);
            throw new LegoCheckedException(1073947394L);
        }
        this.checkVrmSn(context, (NetworkEntity)vrm);
        LOGGER.info((Object)("enter process FusionCompute discovery, ip=" + vrm.getIpAddress()), 90160758786816L);
        vrm.setProductModel("Dr_Vrm");
        vrm.setIsTopMo(Boolean.valueOf(true));
        try {
            vrm = this.queryVrmResource(vrm, extend);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("get FusionSphere information failed,FusionSphere name:" + vrm.getName() + ",Ip:" + vrm.getIpAddress() + ",errorMessage:" + e.getMessage()), 90160758786989L);
            throw e;
        }
        vrm.setStatus(Integer.valueOf(0));
        context.setAttribute("DRMVRM", (Object)vrm);
        context.setAttribute("StorageDevice", (Object)vrm);
        Istatus devStatus = GlobalDeviceStatus.getStatus((String)vrm.getUuid(), DefaultOnlineToOfflineStatus.class);
        devStatus.doAction((ManagedObject)vrm, 0);
        return true;
    }

    private void processVrmOfflineAlarm(AbstractContext context) {
        String opType = (String)context.getAttribute("DiscoveryType");
        if (!"register".equalsIgnoreCase(opType)) {
            VRM vrm = (VRM)context.getAttribute("StorageDevice");
            vrm.setStatus(Integer.valueOf(-1));
            Istatus devStatus = GlobalDeviceStatus.getStatus((String)vrm.getSn(), DefaultOnlineToOfflineStatus.class);
            devStatus.doAction((ManagedObject)vrm, -1);
            DiscoverUtil.setMosOffline((NetworkEntity)vrm);
            VrmManager.getInstance().getCloudService().updateDrCloudStatus((NetworkEntity)vrm, -1);
        }
    }

    private VRM getVrmInfo(AbstractContext context, NeMgrProtocolExtend extend) {
        try {
            return VrmManager.getInstance().getVrmResService().loginVrm(extend);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)("get vrm(" + extend.getNetworkIpAddress() + ")'basic info failed."), (Throwable)e, 90160758787071L);
            this.processVrmOfflineAlarm(context);
            throw e;
        }
        catch (Exception e) {
            this.processVrmOfflineAlarm(context);
            ExceptionUtil.rethrowException((Throwable)e, (String)("get vrm(" + extend.getNetworkIpAddress() + ")'basic info failed."), (long)1073947399L, null, (Log)LOGGER);
            return null;
        }
    }

    private VRM queryVrmResource(VRM vrm, NeMgrProtocolExtend extend) {
        List<GalaxObject> listMo = null;
        for (String resType : vrmResList) {
            listMo = this.queryResource(vrm, resType, listMo, extend);
        }
        VrmUtil.cleanExtend((NeMgrProtocolExtend)extend);
        return vrm;
    }

    private List<GalaxObject> queryResource(VRM vrm, String resType, List<GalaxObject> referenceMoList, NeMgrProtocolExtend extend) {
        extend.getExtendParams().put("resourceType", resType);
        List galaxMoList = null;
        if (resType.equals("portGroup")) {
            if (VerifyUtil.isEmpty(referenceMoList)) {
                return null;
            }
            for (GalaxObject mo : referenceMoList) {
                extend.getExtendParams().put("parrentUri", mo.getUri());
                galaxMoList = VrmManager.getInstance().getVrmResService().queryResource(extend);
                this.buildMoRelation((ManagedObject)mo, galaxMoList);
            }
        } else {
            galaxMoList = VrmManager.getInstance().getVrmResService().queryResource(extend);
            if (resType.equals("vm")) {
                this.filterVm(vrm, galaxMoList);
            }
            this.buildMoRelation((ManagedObject)vrm, galaxMoList);
        }
        return galaxMoList;
    }

    private void filterVm(VRM vrm, List<GalaxObject> galaxMoList) {
        Set protectedVmUuids = VrmManager.getInstance().getVrmService().getProtectedVmInOtherVRM(vrm);
        if (VerifyUtil.isEmpty((Collection)protectedVmUuids)) {
            return;
        }
        Iterator<GalaxObject> itr = galaxMoList.iterator();
        block0: while (itr.hasNext()) {
            GalaxObject obj = itr.next();
            for (String vmUuid : protectedVmUuids) {
                if (!vmUuid.equals(obj.getUuid())) continue;
                LOGGER.info((Object)("vm(" + obj.getUuid() + ") in vrm(" + vrm.getIpAddress() + ") is protected by anothor vrm."));
                itr.remove();
                continue block0;
            }
        }
    }

    private void buildMoRelation(ManagedObject parrentMo, List<GalaxObject> childrenMo) {
        if (null == childrenMo || childrenMo.isEmpty() || null == parrentMo) {
            return;
        }
        for (ManagedObject managedObject : childrenMo) {
            managedObject.setParentMo(parrentMo);
            parrentMo.addChildMo(managedObject);
        }
    }

    private void checkVrmSn(AbstractContext context, NetworkEntity entity) {
        VRM vrm;
        String opType = (String)context.getAttribute("DiscoveryType");
        if (!"register".equalsIgnoreCase(opType) && !(vrm = (VRM)context.getAttribute("StorageDevice")).getSn().equals(entity.getSn())) {
            LOGGER.error((Object)("the sn of VRM changed, ip=" + entity.getLinkIp()), 90160758787071L);
            throw new LegoCheckedException(1073947432L);
        }
    }
}

