/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.process;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.cbb.discover.util.DiscoverUtil;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class VrmSaveProcessor
implements IProcessor {
    private static final Log logger = LogFactory.getInstance(VrmSaveProcessor.class);
    private static final Object LOCK = new Object();

    public void clean(AbstractContext arg0) {
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void postProcess(AbstractContext arg0) {
    }

    public boolean process(AbstractContext context) {
        VRM vrm = (VRM)context.getAttribute("DRMVRM");
        NeMgrProtocolExtend extend = (NeMgrProtocolExtend)context.getAttribute("NeMgrProtocolExtend");
        if (null == vrm || null == extend) {
            return false;
        }
        vrm.setMainType("ism.drm.deviceType.fusionsphere.mainType");
        vrm.setSubType("ism.drm.deviceType.vrm.subType");
        String action = (String)context.getAttribute("DiscoveryType");
        try {
            List vrms;
            CommonDAOLocator.getMoDao().getTransactionTemplate().execute((TransactionCallback)new SaveVrmTransactionCallback(vrm, extend));
            extend.setMoId(vrm.getMoId());
            ((INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class)).save(extend);
            if ("register".equals(action)) {
                Long userId = (Long)context.getAttribute("OperatorId");
                DiscoverUtil.grantUserNeAuthority((NetworkEntity)vrm, (Long)userId);
            }
            if (!VerifyUtil.isEmpty((Collection)(vrms = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrVrm where deviceSn = ? and siteId in (select siteId from Site where siteType = 0)", new Object[]{vrm.getSn()})))) {
                DrVrm drVrm = VrmUtil.translateVrm((VRM)vrm, (String)((DrVrm)vrms.get(0)).getSiteId());
                drVrm.setDbId(((DrVrm)vrms.get(0)).getDbId());
                ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).saveOrUpdate((Object)drVrm);
                this.handleCNAResource(drVrm.getChildResources(), ((DrVrm)vrms.get(0)).getChildResources());
            }
            logger.info((Object)("save vrm ok:" + vrm.getIpAddress()), 90160758786816L);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"save vrm error.", (long)-1L, null, (Log)logger);
        }
        if (!"register".equals(action) && 0 != vrm.getStatus()) {
            throw new LegoCheckedException(1073947399L);
        }
        context.setAttribute("DRMVRM", (Object)vrm);
        context.setAttribute("GALAX_KEY_FLAG", (Object)"DRMVRM");
        return true;
    }

    private void deleteVmNoParent() {
        ArrayList<QueryCondition> props = new ArrayList<QueryCondition>();
        props.add(new QueryCondition("type", (Object)"com.huawei.ism.drm.galax.sdk.model.GalaxVM"));
        IMoDao moDao = CommonDAOLocator.getMoDao();
        List vms = moDao.findMoBy(ManagedObject.class, props);
        moDao.deleteMoList(vms.stream().filter(vm -> VerifyUtil.isEmpty((Object)vm.getParentId())).map(ManagedObject::getMoId).collect(Collectors.toList()));
    }

    private void deleteSubMos(VRM existVrm, Class<? extends ManagedObject> cl) {
        List childMos = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getSubListMo(cl, existVrm.getMoId(), new ArrayList());
        if (null != childMos) {
            for (ManagedObject mo : childMos) {
                CommonDAOLocator.getMoDao().deleteMo(mo.getMoId());
            }
        }
    }

    private void handleCNAResource(Set<DrResource> newHosts, Set<DrResource> oldHosts) {
        if (VerifyUtil.isEmpty(newHosts)) {
            return;
        }
        ArrayList<String> existResId = new ArrayList<String>();
        for (DrResource newHost : newHosts) {
            if (VerifyUtil.isEmpty(oldHosts)) {
                ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).saveOrUpdate((Object)newHost);
                continue;
            }
            for (DrResource oldHost : oldHosts) {
                if (!newHost.getDeviceSn().equals(oldHost.getDeviceSn())) continue;
                newHost.setDbId(oldHost.getDbId());
                existResId.add(oldHost.getDbId());
                break;
            }
            ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).saveOrUpdate((Object)newHost);
        }
        if (!VerifyUtil.isEmpty(oldHosts)) {
            ArrayList<DrResource> delResources = new ArrayList<DrResource>();
            for (DrResource oldHost : oldHosts) {
                if (existResId.contains(oldHost.getDbId())) continue;
                delResources.add(oldHost);
            }
            for (DrResource delRes : delResources) {
                ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).deleteResouce((Object)delRes);
            }
        }
    }

    private class SaveVrmTransactionCallback
    implements TransactionCallback {
        private VRM vrm;
        private NeMgrProtocolExtend extend;

        public SaveVrmTransactionCallback(VRM vrm, NeMgrProtocolExtend extend) {
            this.vrm = vrm;
            this.extend = extend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object doInTransaction(TransactionStatus transactionStatus) {
            VRM existVrm = (VRM)CommonDAOLocator.getMoDao().getMo(VRM.class, "sn", (Object)VrmUtil.generateVrmSn((String)((String)this.extend.getExtendParams().get("vrmUri"))));
            if (existVrm != null) {
                VrmSaveProcessor.this.deleteSubMos(existVrm, DataStore.class);
                this.vrm.setMoId(existVrm.getMoId());
                this.vrm.setName(existVrm.getName());
            }
            HashMap result = new HashMap();
            Object object = LOCK;
            synchronized (object) {
                VrmSaveProcessor.this.deleteVmNoParent();
                CommonDAOLocator.getMoDao().addMoAndSubMoWithoutMsg((ManagedObject)this.vrm, result);
            }
            return null;
        }
    }
}

