/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.service;

import com.huawei.ism.cbb.util.DiscParamValidator;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscParamVilidateResult;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.service.IDisParamValidator;
import java.util.Map;

public class CloudDisParamValidatorImpl
implements IDisParamValidator {
    private static final Log LOGGER = LogFactory.getInstance(CloudDisParamValidatorImpl.class);

    public String getValidatorKey() {
        return "ism.drm.deviceType.fusionsphere.mainTypeism.drm.deviceType.cloud.subType";
    }

    public DiscParamVilidateResult validate(DiscoveryPolicy policy) {
        DiscParamVilidateResult dpvrSuccess = new DiscParamVilidateResult();
        dpvrSuccess.setResult(true);
        DiscParamVilidateResult dpvrError = new DiscParamVilidateResult();
        dpvrError.setResult(false);
        dpvrError.setErrorCode(2099466L);
        if (null == policy || VerifyUtil.isEmpty((Map)policy.getParamMap())) {
            LOGGER.error((Object)"the extern paramtere is null or empty.", 90160758787071L);
            return dpvrError;
        }
        String ipAddr = policy.getStartIP();
        if (VerifyUtil.isEmpty((String)ipAddr) || !CommonUtil.isIpValid((String)ipAddr)) {
            LOGGER.error((Object)"the parameter of ip is invalid.", 90160758787071L);
            return dpvrError;
        }
        Map paramMap = policy.getParamMap();
        if (!this.validateParamNull(paramMap)) {
            LOGGER.error((Object)"the discovery parameter contains null.", 90160758787071L);
            return dpvrError;
        }
        if (!this.checkPortAndType(paramMap)) {
            LOGGER.error((Object)"the parameter of port is invalid.", 90160758787071L);
            return dpvrError;
        }
        String name = (String)paramMap.get("username");
        if (!this.checkUseName(name)) {
            LOGGER.error((Object)"the parameter of username check failed.", 90160758787071L);
            return dpvrError;
        }
        String password = (String)paramMap.get("password");
        if (!this.checkPassword(password)) {
            LOGGER.error((Object)"the authentication parameter check failed.", 90160758787071L);
            return dpvrError;
        }
        return dpvrSuccess;
    }

    private boolean validateParamNull(Map<String, String> paramMap) {
        if (DiscParamValidator.stringisNull((String)paramMap.get("username")) || DiscParamValidator.stringisNull((String)paramMap.get("password")) || DiscParamValidator.stringisNull((String)paramMap.get("devicetype")) || DiscParamValidator.stringisNull((String)paramMap.get("port"))) {
            LOGGER.error((Object)"the extern paramterer contans null.", 90160758787071L);
            return false;
        }
        return true;
    }

    private boolean checkPortAndType(Map<String, String> paramMap) {
        String devicetype = paramMap.get("devicetype");
        String port = paramMap.get("port");
        if (!"FusionManager".equals(devicetype) && !"FusionCompute".equals(devicetype)) {
            LOGGER.error((Object)("the devicetype failed, devicetype=" + devicetype), 90160758787071L);
            return false;
        }
        try {
            int portInt = Integer.parseInt(port);
            if (!DiscParamValidator.isPort((int)portInt)) {
                LOGGER.error((Object)("the port out of range,  port=" + port), 90160758787071L);
                return false;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("the port parameter is not a number,  port=" + port), (Throwable)e, 90160758787071L);
            return false;
        }
        return true;
    }

    private boolean checkUseName(String userName) {
        if (!DiscParamValidator.checkStringLength((String)userName, (int)32)) {
            LOGGER.error((Object)"the length of username check failed.", 90160758787071L);
            return false;
        }
        return true;
    }

    private boolean checkPassword(String password) {
        if (!DiscParamValidator.checkStringLength((String)password, (int)32)) {
            LOGGER.error((Object)"the length of authentication parameter check failed.", 90160758787071L);
            return false;
        }
        return true;
    }
}

