/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.service;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.galax.protection.adapter.GalaxProtectObjectCloudProviderAdapter;
import com.huawei.ism.drm.galax.resource.discovery.manager.FmServiceManager;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.resource.discovery.service.CloudServiceUtil;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.CNARegistInfo;
import com.huawei.ism.drm.galax.sdk.model.CloudInfo;
import com.huawei.ism.drm.galax.sdk.model.DrFm;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.ICloudResource;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.pg.service.IGalaxProtectObjectCloudProvider;
import com.huawei.ism.drm.galax.sdk.service.ICloudService;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.galax.util.rest.JSONUtils;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.orm.hibernate5.HibernateTemplate;

@Service(name="com.huawei.ism.drm.galax.sdk.service.ICloudService", desc="", interfaceClass=ICloudService.class)
public class CloudServiceImpl
extends BaseService
implements ICloudService {
    private Log logger = LogFactory.getInstance(CloudServiceImpl.class);
    private INeMgrProtocolExtendService neMgr;
    private String debug = "debug";

    public INeMgrProtocolExtendService getNeMgr() {
        return this.neMgr;
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }

    public void refreshCloud(String cloudSn, String userName) {
        this.refreshCloud(cloudSn, null, userName, true);
    }

    private String getCloudType(String cloudSn) {
        try {
            String hql = "from DrResource as dh where dh.deviceSn = ? ";
            Object[] condition = new String[]{cloudSn};
            List resources = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(hql, condition);
            if (resources == null || resources.isEmpty()) {
                this.logger.error((Object)"resources is null or empty.");
                throw new LegoCheckedException(1073947393L);
            }
            DrResource resource = (DrResource)resources.get(0);
            if (resource instanceof ICloudResource) {
                return resource.getClass().getSimpleName();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Failed to refreshCloud because param is invalid");
        }
        return null;
    }

    private void refreshCloud(String cloudSn, String type, String userName, boolean cascade) {
        type = type != null ? type : this.getCloudType(cloudSn);
        this.logger.info((Object)new StringBuilder().append("refreshCloud enter. cloudSn=").append(cloudSn).append(",type=").append(type).append(",userName=").append(userName), 90160758786816L);
        IGalaxProtectObjectCloudProvider provider = GalaxProtectObjectCloudProviderAdapter.getInstance().getGalaxPoProviderByCloud(type);
        if (provider == null) {
            this.logger.error((Object)"Failed to refreshCloud because type is invalid", 90160758786816L);
            throw new LegoCheckedException(1073947393L);
        }
        provider.refreshCloud(cloudSn, userName, cascade);
    }

    public List<DrResource> getAllRemoteRegistedClouds(Site site) {
        ArrayList clouds;
        this.logger.debug((Object)(this.debug + "getAllRemoteRegistedClouds enter"), 90160758786816L);
        if (null == site) {
            this.logger.error((Object)"parameter site is null.", 90160758787071L);
            return new ArrayList<DrResource>();
        }
        RestClient client = SiteUtil.initClient((Site)site);
        StringBuilder request = new StringBuilder();
        request.append("/ws/vrm/queryRegistedCloudsBySiteId?siteId=").append(site.getSiteId());
        try {
            clouds = (ArrayList)client.getSerializableObject(request.toString(), List.class);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"unable to get remote clouds.", (long)1073947669L, null, (Log)this.logger);
            clouds = new ArrayList();
        }
        ArrayList<DrResource> remoteSns = new ArrayList<DrResource>();
        if (VerifyUtil.isEmpty(clouds)) {
            return remoteSns;
        }
        for (String json : clouds) {
            JSONObject jsonObj = JSONObject.fromObject((Object)json);
            CloudInfo ci = (CloudInfo)JSONUtils.toBean((JSONObject)jsonObj, CloudInfo.class);
            this.handCNAofCloud(ci, jsonObj);
            remoteSns.add(FmUtils.translateDrResource((Site)site, (CloudInfo)ci));
        }
        return remoteSns;
    }

    private void handCNAofCloud(CloudInfo cInfo, JSONObject jsonObj) {
        this.logger.debug((Object)(this.debug + "handCNAofCloud enter"), 90160758786816L);
        JSONArray jsonArray = jsonObj.getJSONArray("drCNANodes");
        if (null == jsonArray) {
            return;
        }
        if (!VerifyUtil.isEmpty((Collection)cInfo.getDrCNANodes())) {
            return;
        }
        ArrayList<Object> cnaInfos = new ArrayList<Object>();
        for (int idx = 0; idx < jsonArray.size(); ++idx) {
            cnaInfos.add(JSONUtils.toBean((JSONObject)jsonArray.getJSONObject(idx), CNARegistInfo.class));
        }
        cInfo.setDrCNANodes(cnaInfos);
    }

    public <T extends ManagedObject> T getCloud(String attribute, Object value, Class<T> cloudClass) {
        this.logger.debug((Object)(this.debug + "getCloud enter"), 90160758786816L);
        if (VerifyUtil.isEmpty((Object)value) || VerifyUtil.isEmpty((String)attribute)) {
            this.logger.error((Object)(value + " dosen't exist.Failed to get."), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObject fm = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(cloudClass, attribute, value);
        if (null == fm) {
            this.logger.error((Object)("Cloud id(" + value + ") dosen't exist.Failed to get."), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        return (T)fm;
    }

    public void refreshVrm(String vrmSn, String username) {
        this.refreshCloud(vrmSn, DrVrm.class.getSimpleName(), username, false);
    }

    private void updateDrVrm(NetworkEntity vrm, int status) {
        this.logger.debug((Object)(this.debug + "updateDrVrm enter"), 90160758786816L);
        ArrayList<String> sns = new ArrayList<String>();
        sns.add(vrm.getSn());
        List listDrVrm = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getResourceList(sns, DrVrm.class, "deviceSn");
        if (null != listDrVrm && !listDrVrm.isEmpty()) {
            for (DrVrm drVrm : listDrVrm) {
                drVrm.setStatus(String.valueOf(status));
                ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).saveOrUpdate((Object)drVrm);
            }
        }
    }

    public void refreshFm(String fmSn, String username) {
        this.refreshCloud(fmSn, DrFm.class.getSimpleName(), username, false);
    }

    private void updateDrFm(NetworkEntity fm, int status) {
        this.logger.debug((Object)(this.debug + "updateDrFm enter"), 90160758786816L);
        ArrayList<String> sns = new ArrayList<String>();
        sns.add(fm.getSn());
        List listDrFm = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getResourceList(sns, DrFm.class, "deviceSn");
        if (null != listDrFm && !listDrFm.isEmpty()) {
            for (DrFm drFm : listDrFm) {
                drFm.setStatus(String.valueOf(status));
                ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).saveOrUpdate((Object)drFm);
            }
        }
    }

    public void updateDrCloudStatus(NetworkEntity dr, int status) {
        this.logger.debug((Object)(this.debug + "updateDrCloud enter"), 90160758786816L);
        if (dr instanceof FusionManager) {
            this.updateDrFm(dr, status);
        }
        if (dr instanceof VRM) {
            this.updateDrVrm(dr, status);
        }
    }

    public List<String> registerClouds(String siteId, String[] resSns) {
        this.logger.debug((Object)(this.debug + "registerClouds enter"), 90160758786816L);
        if (VerifyUtil.isEmpty((Object[])resSns)) {
            this.logger.error((Object)"sn is empty, and registerClouds failed", 90160758787071L);
            return new ArrayList<String>();
        }
        ArrayList<String> fcSns = new ArrayList<String>();
        ArrayList<String> fmSns = new ArrayList<String>();
        ArrayList<String> retSns = new ArrayList<String>();
        for (String sn : resSns) {
            ManagedObject mo = FmServiceManager.getInstance().getFmService().getCloudObjectBySn(sn);
            if (mo == null) continue;
            if (mo instanceof VRM) {
                fcSns.add(sn);
                continue;
            }
            if (!(mo instanceof FusionManager)) continue;
            fmSns.add(sn);
        }
        if (!fmSns.isEmpty()) {
            for (String fmSn : fmSns) {
                FmServiceManager.getInstance().getFmService().registFm(siteId, fmSn);
            }
        }
        if (!fcSns.isEmpty()) {
            VrmManager.getInstance().getVrmService().registFcs(siteId, fcSns);
        }
        retSns.addAll(fmSns);
        retSns.addAll(fcSns);
        return retSns;
    }

    public Page pageQueryLocalCloudBySiteId(String siteId, Long userId, String orderBy, int pageSize, int currentPage, boolean isAsc) {
        this.logger.debug((Object)(this.debug + "pageQueryLocalCloudBySiteId enter"), 90160758786816L);
        if (VerifyUtil.isEmpty((Object)userId)) {
            this.logger.error((Object)"userId is empty!", 90160758787071L);
            return new Page();
        }
        Site site = VrmUtil.getSiteByIdObjectNotExist((String)siteId);
        List<DrResource> drVrms = CloudServiceUtil.findDrResources(DrResource.class, site.getSiteId(), null, orderBy, isAsc);
        if (drVrms != null) {
            List<CloudInfo> registedCloud = this.filterRegistedCloudsByUser(userId, site, drVrms);
            return Page.createPage((int)currentPage, (int)pageSize, registedCloud);
        }
        this.logger.error((Object)"drVrms or registedCloud is null ", 90160758787071L);
        return new Page();
    }

    public Page pageQueryRegistedCloudsBySiteId(String siteId, String orderBy, int pageNo, int pageSize, boolean isAsc, Long userId) {
        this.logger.debug((Object)(this.debug + "pageQueryRegistedCloudsBySiteId enter"), 90160758786816L);
        if (VerifyUtil.isEmpty((Object)userId)) {
            this.logger.error((Object)"userId is empty!", 90160758787071L);
            return new Page();
        }
        List<CloudInfo> registedCloud = this.getCloudInfosBySite(siteId, orderBy, isAsc, userId);
        return Page.createPage((int)pageNo, (int)pageSize, registedCloud);
    }

    private List<CloudInfo> getCloudInfosBySite(String siteId, String orderBy, boolean isAsc, Long userId) {
        Site site = VrmUtil.getSiteByIdObjectNotExist((String)siteId);
        List<CloudInfo> registedCloud = null;
        List<DrResource> drVrms = CloudServiceUtil.findDrResources(DrResource.class, site.getSiteId(), null, orderBy, isAsc);
        if (drVrms != null) {
            registedCloud = this.fillRegistedCloudInfos(userId, site, drVrms);
        }
        if (null == registedCloud) {
            registedCloud = Collections.emptyList();
        }
        return registedCloud;
    }

    public Page pageQueryAllRegistedClouds(String orderBy, int pageNo, int pageSize, boolean isAsc, Long userId) {
        List sites = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getAllSites(userId);
        ArrayList<CloudInfo> cloudInfoList = new ArrayList<CloudInfo>();
        for (Site site : sites) {
            List<CloudInfo> registedCloud = this.getCloudInfosBySite(site.getSiteId(), orderBy, isAsc, userId);
            cloudInfoList.addAll(registedCloud);
        }
        return Page.createPage((int)pageNo, (int)pageSize, cloudInfoList);
    }

    private List<CloudInfo> fillRegistedCloudInfos(Long userId, Site site, List<? extends DrResource> registedClouds) {
        this.logger.debug((Object)(this.debug + "fillRegistedCloudInfos enter"), 90160758786816L);
        List<CloudInfo> registedCloud = this.filterRegistedCloudsByUser(userId, site, registedClouds);
        for (CloudInfo res : registedCloud) {
            List<VRM> vrmList;
            if (!res.getResType().equals(DrFm.class.getSimpleName())) continue;
            if (site.getSiteType() == 0) {
                vrmList = FmServiceManager.getInstance().getFmService().getRegistedFcOfSpecfiedFm(res.getDeviceSn());
            } else {
                this.refreshRemoteSiteRegistedCloud(site);
                vrmList = this.getRemoteRegistedFcOfSpecfiedFm(site, res.getDeviceSn());
            }
            if (VerifyUtil.isEmpty((Collection)vrmList)) continue;
            for (VRM vrm : vrmList) {
                for (CloudInfo subRes : registedCloud) {
                    if (!vrm.getUuid().equals(subRes.getDeviceSn())) continue;
                    subRes.setParentResource(res.getDeviceSn());
                }
            }
        }
        return registedCloud;
    }

    private List<CloudInfo> filterRegistedCloudsByUser(Long userId, Site site, List<? extends DrResource> registedClouds) {
        this.logger.debug((Object)(this.debug + "fillRegistedCloudInfos enter"), 90160758786816L);
        ArrayList<CloudInfo> registedCloud = new ArrayList<CloudInfo>();
        List sns = new ArrayList<String>();
        for (DrResource drResource : registedClouds) {
            sns.add(drResource.getDeviceSn());
        }
        if (0 == site.getSiteType()) {
            sns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(sns, userId);
        }
        for (DrResource drResource : registedClouds) {
            if (!sns.contains(drResource.getDeviceSn()) || !(drResource instanceof ICloudResource)) continue;
            CloudInfo cinfo = FmUtils.translateCloudInfo((DrResource)drResource, null);
            registedCloud.add(cinfo);
        }
        return registedCloud;
    }

    private void refreshRemoteSiteRegistedCloud(Site site) {
        this.logger.debug((Object)(this.debug + "refreshRemoteSiteRegistedCloud enter"), 90160758786816L);
        List<DrResource> clouds = this.getAllRemoteRegistedClouds(site);
        HibernateTemplate ht = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        for (DrResource drRes : clouds) {
            if (SiteResourceManagerUtil.isResourceExists((String)drRes.getDeviceSn())) continue;
            Set subResources = drRes.getChildResources();
            drRes.setChildResources(null);
            ht.merge((Object)drRes);
            if (VerifyUtil.isEmpty((Collection)subResources)) continue;
            for (DrResource subRes : subResources) {
                ht.merge((Object)subRes);
            }
        }
    }

    public List<VRM> getRemoteRegistedFcOfSpecfiedFm(Site site, String sn) {
        ArrayList<VRM> vrmList;
        block4: {
            this.logger.debug((Object)(this.debug + "getRemoteRegistedFcOfSpecfiedFm enter"), 90160758786816L);
            vrmList = new ArrayList<VRM>();
            RestClient client = SiteUtil.initClient((Site)site);
            StringBuilder request = new StringBuilder();
            request.append("/ws/vrm/getRegistedFcOfSpecfiedFm?sn=").append(sn);
            try {
                String jsonStr = client.getReourceCollect(request.toString());
                JSONArray array = JSONArray.fromObject((Object)jsonStr);
                for (int i = 0; i < array.size(); ++i) {
                    String json = array.getString(i);
                    JSONObject object = JSONObject.fromObject((Object)json);
                    VRM vrm = new VRM();
                    String uuid = object.getString("uuid");
                    String name = object.getString("name");
                    vrm.setUuid(uuid);
                    vrm.setName(name);
                    if (object.containsKey((Object)"licenseVersion")) {
                        int licenseVersion = object.getInt("licenseVersion");
                        vrm.setLicenseVersion(Integer.valueOf(licenseVersion));
                    }
                    vrmList.add(vrm);
                }
            }
            catch (LegoCheckedException e) {
                this.logger.error((Object)"query fc under fm failed.", (Throwable)e, 90160758787071L);
                if (1073947394L != e.getErrorCode()) break block4;
                this.logger.error((Object)("maybe fm has been deleted, siteId=" + site.getSiteId() + ", sn=" + sn), 90160758787071L);
            }
        }
        return vrmList;
    }

    public Page pageQueryVmsByCloudSn(String cloudSn, String orderBy, int pageSize, int startPage, boolean isAsc, String filterName, String filterValue) {
        Page pageVms;
        this.logger.debug((Object)(this.debug + "pageQueryVmsByCloudSn enter"), 90160758786816L);
        if (VerifyUtil.isEmpty((String)cloudSn) || VerifyUtil.isEmpty((String)orderBy)) {
            this.logger.error((Object)"parameter cloudSn or orderBy is empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        NetworkEntity nEntity = (NetworkEntity)VrmManager.getInstance().getDaoAdapter().getMo(NetworkEntity.class, "sn", (Object)cloudSn);
        if (null == nEntity) {
            this.logger.error((Object)("can not find the object, sn=" + cloudSn), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        if (nEntity instanceof VRM) {
            pageVms = VrmManager.getInstance().getVrmService().pageQueryVmsByCloudSn(cloudSn, orderBy, pageSize, startPage, isAsc, filterName, filterValue);
        } else if (nEntity instanceof FusionManager) {
            pageVms = FmServiceManager.getInstance().getFmService().pageQueryVmsByCloudSn(cloudSn, orderBy, pageSize, startPage, isAsc, filterName, filterValue);
        } else {
            this.logger.error((Object)("this object is not cloud, sn=" + cloudSn), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        return pageVms;
    }

    public DrVrm getVrmByVrgSn(String vrgSn) {
        this.logger.debug((Object)(this.debug + "getVrmByVrgSn enter"), 90160758786816L);
        if (VerifyUtil.isEmpty((String)vrgSn)) {
            this.logger.error((Object)"parameter vrgSn.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        HibernateTemplate ht = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        List drVrgs = ht.find("from DrResource where deviceSn=?", new Object[]{vrgSn});
        if (VerifyUtil.isEmpty((Collection)drVrgs)) {
            this.logger.error((Object)("vrg is not regist in site, vrgSn=" + vrgSn), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        List drVrms = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrVrm where siteId=?", new Object[]{((DrResource)drVrgs.get(0)).getSiteId()});
        if (VerifyUtil.isEmpty((Collection)drVrms)) {
            this.logger.error((Object)("there is no FusionCompute under site, vrgSn=" + vrgSn), 90160758787071L);
            throw new LegoCheckedException(1073947852L);
        }
        for (DrVrm drVrm : drVrms) {
            if (VerifyUtil.isEmpty((Collection)VrmManager.getInstance().getVrmVirtualResService().queryVMByIp(VrmUtil.getRecoveryVrmObject((String)drVrm.getDeviceSn()), ((DrResource)drVrgs.get(0)).getIpAddress()))) continue;
            return drVrm;
        }
        this.logger.error((Object)("can not find the FusionCompute by VRG, vrgSn=" + vrgSn), 90160758787071L);
        throw new LegoCheckedException(1073947852L);
    }

    public VRM getRemoteVrmByVrgSn(Site site, String sn) {
        this.logger.debug((Object)(this.debug + "getRemoteVrmByVrgSn enter"));
        if (null == site || VerifyUtil.isEmpty((String)sn)) {
            this.logger.error((Object)"parameter is null.");
            return null;
        }
        VRM vrm = new VRM();
        RestClient client = SiteUtil.initClient((Site)site);
        StringBuilder request = new StringBuilder();
        request.append("/ws/vrm/getVrmBySn?vrmSn=").append(sn);
        try {
            String jsonStr = client.get(request.toString(), null);
            JSONObject object = JSONObject.fromObject((Object)jsonStr);
            String uuid = object.getString("uuid");
            String name = object.getString("name");
            vrm.setUuid(uuid);
            vrm.setName(name);
            if (object.containsKey((Object)"licenseVersion")) {
                int licenseVersion = object.getInt("licenseVersion");
                vrm.setLicenseVersion(Integer.valueOf(licenseVersion));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("get vrm from remote site error, site =" + site.getName() + ", vrgSn=" + sn + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        return vrm;
    }
}

