/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.service;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.galax.resource.discovery.service.CloudServiceUtil;
import com.huawei.ism.drm.galax.sdk.model.DrFm;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.service.ICloudService;
import com.huawei.ism.drm.galax.sdk.service.IGalaxSiteResService;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class CloudSiteResServiceImpl
implements IGalaxSiteResService {
    private static final Log LOGGER = LogFactory.getInstance(CloudSiteResServiceImpl.class);
    private ICloudService cloudService;

    public ICloudService getCloudService() {
        return this.cloudService;
    }

    public void setCloudService(ICloudService cloudService) {
        this.cloudService = cloudService;
    }

    public void registerResource(Site site, String[] resSns) {
        switch (site.getSiteType()) {
            case 0: {
                this.registerCloudOfLocalSite(site, resSns);
                break;
            }
            case 1: {
                this.registerCloudOfRemoteSite(site);
                break;
            }
            default: {
                LOGGER.error((Object)("the type is error:" + site.getSiteType()), 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
        }
    }

    private void registerCloudOfRemoteSite(Site site) {
        List clouds = this.cloudService.getAllRemoteRegistedClouds(site);
        if (VerifyUtil.isEmpty((Collection)clouds)) {
            return;
        }
        HashSet setCloud = new HashSet(clouds);
        if (SiteResourceManagerUtil.isResourceExists(setCloud)) {
            throw new LegoCheckedException(1073947660L);
        }
        CommonDAOLocator.getBaseDao().saveOrUpdateAll(setCloud);
    }

    private void registerCloudOfLocalSite(Site site, String[] resSns) {
        if (resSns == null || resSns.length == 0) {
            return;
        }
        this.cloudService.registerClouds(site.getSiteId(), resSns);
    }

    public void refreshResouce(Site site) {
        Site remoteSite = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(site.getSiteId());
        if (null == remoteSite) {
            return;
        }
        List clouds = this.cloudService.getAllRemoteRegistedClouds(site);
        HibernateTemplate ht = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        List oldFms = ht.find("from DrFm where siteId=?", new Object[]{site.getSiteId()});
        ht.deleteAll((Collection)oldFms);
        List oldCNAs = ht.find("from DrComputeNode where siteId=?", new Object[]{site.getSiteId()});
        ht.deleteAll((Collection)oldCNAs);
        List oldFcs = ht.find("from DrVrm where siteId=?", new Object[]{site.getSiteId()});
        ht.deleteAll((Collection)oldFcs);
        for (DrResource drRes : clouds) {
            if (SiteResourceManagerUtil.isResourceExists((String)drRes.getDeviceSn())) continue;
            Set subResources = drRes.getChildResources();
            drRes.setChildResources(null);
            ht.merge((Object)drRes);
            if (VerifyUtil.isEmpty((Collection)subResources)) continue;
            for (DrResource subRes : subResources) {
                ht.merge((Object)subRes);
            }
        }
    }

    public String getResourceSubType() {
        return "ism.drm.deviceType.cloud.subType";
    }

    public void checkDrResouceUsed(String siteId, String devSn) {
        CloudServiceUtil.checkCloudPlatformIsUsed(siteId, devSn);
    }

    public DrResource getDrResourceByMo(NetworkEntity mo) {
        if (null == mo) {
            return null;
        }
        NeMgrProtocolExtend extend = VrmUtil.getExtend((String)String.valueOf(mo.getMoId()));
        if (mo instanceof VRM) {
            VRM vrmMo = (VRM)mo;
            DrVrm drResource = new DrVrm();
            drResource.setDeviceSn(vrmMo.getSn());
            drResource.setName(vrmMo.getName());
            drResource.setIpAddress(vrmMo.getIpAddress());
            drResource.setStatus(String.valueOf(vrmMo.getStatus()));
            drResource.setPort((String)extend.getExtendParams().get("port"));
            drResource.setDbId(UUIDGenerator.getUUID());
            drResource.setVersion(vrmMo.getVersion());
            return drResource;
        }
        FusionManager fmMo = (FusionManager)mo;
        DrFm drResource = new DrFm();
        drResource.setDeviceSn(fmMo.getSn());
        drResource.setName(fmMo.getName());
        drResource.setIpAddress(fmMo.getIpAddress());
        drResource.setStatus(String.valueOf(fmMo.getStatus()));
        drResource.setPort((String)extend.getExtendParams().get("port"));
        drResource.setDbId(UUIDGenerator.getUUID());
        return drResource;
    }

    public DrResource getDrResourceBySn(String cloudSn) {
        List drVrms = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrVrm where deviceSn=?", new Object[]{cloudSn});
        if (null != drVrms && !drVrms.isEmpty()) {
            return (DrResource)drVrms.get(0);
        }
        List drFms = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrFm where deviceSn=?", new Object[]{cloudSn});
        if (null != drFms && !drFms.isEmpty()) {
            return (DrResource)drFms.get(0);
        }
        return null;
    }

    public List<DrResource> getDrResourceBySite(Integer siteType) {
        List drVrms = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrVrm where siteId in (select siteId from Site where siteType = ?)", new Object[]{siteType});
        List drFms = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrFm where siteId in (select siteId from Site where siteType = ?)", new Object[]{siteType});
        ArrayList<DrResource> result = new ArrayList<DrResource>();
        result.addAll(drVrms);
        result.addAll(drFms);
        return result;
    }

    public List<DrResource> getDrResourceBySite(String siteId) {
        List drVrms = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrVrm where siteId=?", new Object[]{siteId});
        List drFms = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("from DrFm where siteId=?", new Object[]{siteId});
        ArrayList<DrResource> result = new ArrayList<DrResource>();
        result.addAll(drVrms);
        result.addAll(drFms);
        return result;
    }
}

