/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.service;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.drm.galax.resource.manager.impl.FMInfosRetrieverInvocationHandler;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.GalaxObject;
import com.huawei.ism.drm.galax.sdk.model.VPC;
import com.huawei.ism.drm.galax.sdk.service.IFmResourceService;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IFMInfosRetriever;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

@Service(name="com.huawei.ism.drm.galax.sdk.service.IFmResourceService", desc="", interfaceClass=IFmResourceService.class)
public class FmResourceServiceImpl
extends BaseService
implements IFmResourceService {
    private static final Log logger = LogFactory.getInstance(FmResourceServiceImpl.class);
    private IFMInfosRetriever fmResManager = null;

    public IFMInfosRetriever getFmResManager() {
        return this.fmResManager;
    }

    public void setFmResManager(IFMInfosRetriever fmResManager) {
        FMInfosRetrieverInvocationHandler handler = new FMInfosRetrieverInvocationHandler(fmResManager);
        this.fmResManager = (IFMInfosRetriever)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{IFMInfosRetriever.class}, (InvocationHandler)handler);
    }

    public FusionManager loginFm(NeMgrProtocolExtend extend) {
        FmObject fmInfo;
        try {
            fmInfo = this.fmResManager.login(extend);
        }
        catch (FmBusinessException e) {
            logger.error((Object)("LoginFm failed. resultCode=" + e.getErrorCode()), 90160758787071L);
            throw new LegoCheckedException(1073947399L, (Throwable)e);
        }
        if (null == fmInfo || null == fmInfo.getUrn()) {
            logger.error((Object)("result of login FusionManager is null, ip=" + extend.getNetworkIpAddress()), 90160758787071L);
            return null;
        }
        extend.getExtendParams().put("vrmUri", fmInfo.getUri());
        extend.getExtendParams().put("vrmUrn", fmInfo.getUrn());
        extend.getExtendParams().put("vrmVersion", fmInfo.getVersion().getVersion());
        extend.getExtendParams().put("loginUri", fmInfo.getVersion().getLoginUri());
        extend.getExtendParams().put("param_name", fmInfo.getName());
        FusionManager fm = new FusionManager();
        fm.setUuid(fmInfo.getUrn());
        fm.setLinkIp(extend.getNetworkIpAddress());
        fm.setIpAddress(fm.getLinkIp());
        fm.setSn(fm.getUuid());
        fm.setName(fmInfo.getName());
        fm.setDescription(fmInfo.getDescription());
        fm.setLocation(extend.getOtherParam());
        fm.setVersion(fmInfo.getVersion().getVersion());
        return fm;
    }

    public List<GalaxObject> queryChildResource(NeMgrProtocolExtend extend) {
        String resType = (String)extend.getExtendParams().get("resourceType");
        if (null == resType) {
            logger.error((Object)"parameter resType is null.", 90160758787071L);
            return new ArrayList<GalaxObject>();
        }
        try {
            return this.getFMResourceByParent(extend);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Failed to get FM(" + extend.getNetworkIpAddress() + ") resource(" + resType + "!"), (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to get FM(" + extend.getNetworkIpAddress() + ") resource(" + resType + "!"), (long)1073947399L, null, (Log)logger);
            return new ArrayList<GalaxObject>();
        }
    }

    private List<GalaxObject> getFMResourceByParent(NeMgrProtocolExtend extend) throws FmBusinessException {
        String parentResType = (String)extend.getExtendParams().get("resourceType");
        if (null == parentResType) {
            logger.error((Object)"parameter parentResType is null.", 90160758787071L);
            throw new LegoCheckedException(65540L);
        }
        ArrayList<GalaxObject> list = new ArrayList<GalaxObject>();
        FmObject fmInfo = FmUtils.generateFmObj((NeMgrProtocolExtend)extend);
        if (parentResType.equals(FusionManager.class.getName())) {
            List hypers = this.fmResManager.queryHyperviors(fmInfo);
            this.insertList(list, hypers);
            List vpcs = this.fmResManager.queryAllVPC(fmInfo);
            this.insertList(list, vpcs);
        } else if (parentResType.equals(VPC.class.getName())) {
            String vpcId = (String)extend.getExtendParams().get("parrentUri");
            List nets = this.fmResManager.queryNetworksByVPC(fmInfo, vpcId);
            this.insertList(list, nets);
            List sgs = this.fmResManager.querySecurityGroupsByVPC(fmInfo, vpcId);
            this.insertList(list, sgs);
        } else {
            logger.error((Object)("can not identify this resType=" + parentResType), 90160758787071L);
            return null;
        }
        return list;
    }

    private void insertList(List<GalaxObject> parentList, List<? extends GalaxObject> childList) {
        if (childList != null && parentList != null) {
            for (GalaxObject galaxObject : childList) {
                if (null == galaxObject.getName() || "null".equals(galaxObject.getName())) {
                    galaxObject.setName("null ");
                }
                parentList.add(galaxObject);
            }
        }
    }
}

