/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.service;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.galax.constant.LockFactory;
import com.huawei.ism.drm.galax.resource.discovery.service.CloudServiceUtil;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.CNARegistInfo;
import com.huawei.ism.drm.galax.sdk.model.CloudInfo;
import com.huawei.ism.drm.galax.sdk.model.DrComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DrFm;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.Hypervisor;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.model.VrmCommInfo;
import com.huawei.ism.drm.galax.sdk.service.ICloudService;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.service.IVrmService;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateTemplate;

@Service(name="com.huawei.ism.drm.galax.sdk.service.IFmService", desc="", interfaceClass=IFmService.class)
public class FmServiceImpl
extends BaseService
implements IFmService {
    private Log logger = LogFactory.getInstance(FmServiceImpl.class);
    private String trace = "trace";
    private INeMgrProtocolExtendService neMgr;
    private IVrmService vrmService;
    private ICloudService cloudService;

    public INeMgrProtocolExtendService getNeMgr() {
        this.logger.trace((Object)"enter getNeMgr");
        return this.neMgr;
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.logger.trace((Object)"enter setNeMgr");
        this.neMgr = neMgr;
    }

    public IVrmService getVrmService() {
        this.logger.trace((Object)"enter getVrmService");
        return this.vrmService;
    }

    public void setVrmService(IVrmService vrmService) {
        this.logger.trace((Object)"enter setVrmService");
        this.vrmService = vrmService;
    }

    public ICloudService getCloudService() {
        this.logger.trace((Object)"enter getCloudService");
        return this.cloudService;
    }

    public void setCloudService(ICloudService cloudService) {
        this.logger.trace((Object)"enter setCloudService");
        this.cloudService = cloudService;
    }

    public FusionManager getFm(String fmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        return (FusionManager)this.cloudService.getCloud("sn", (Object)fmSn, FusionManager.class);
    }

    public FusionManager getFmByMoId(String moId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        return (FusionManager)this.cloudService.getCloud("moId", (Object)Long.valueOf(moId), FusionManager.class);
    }

    public VrmCommInfo getFmCommInfoByMoId(String moId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        return this.vrmService.getVrmCommInfoByMoId(moId);
    }

    public FusionManager getDependenceFmByVrm(String vrmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        Hypervisor hyper = this.getHypervisorByVrm(vrmSn);
        return hyper == null ? null : (FusionManager)hyper.getParentMo();
    }

    public Hypervisor getHypervisorByVrm(String vrmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        VRM vrm = this.getVrm(vrmSn);
        return this.getHypervisorByVrm(vrm);
    }

    public Hypervisor getHypervisorByVrm(VRM vrm) {
        this.logger.trace((Object)(this.trace + " trace message"));
        ArrayList<QueryCondition> conditionList = new ArrayList<QueryCondition>();
        conditionList.add(new QueryCondition("ipAddress", (Object)vrm.getIpAddress(), true, true));
        conditionList.add(new QueryCondition("hvType", (Object)"fusioncompute"));
        List hypers = CommonDAOLocator.getMoDao().findMoBy(Hypervisor.class, conditionList);
        if (!VerifyUtil.isEmpty((Collection)hypers)) {
            if (hypers.size() > 1) {
                this.logger.error((Object)("More than 1 hypervisor ipAddress is the same with vrm " + vrm.getUuid()), 90160758787071L);
            }
            return (Hypervisor)hypers.get(0);
        }
        return null;
    }

    public List<VRM> getRegistedFcOfSpecfiedFm(String fmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List<DrFm> regFmList = CloudServiceUtil.findDrFms(null, fmSn);
        if (VerifyUtil.isEmpty(regFmList)) {
            return null;
        }
        ArrayList<VRM> vrmList = new ArrayList<VRM>();
        List<String> fcIps = this.getFcIpsOfFmByFmId(fmSn);
        List<DrVrm> drVrmList = CloudServiceUtil.findDrVrms(regFmList.get(0).getSiteId(), null);
        if (!VerifyUtil.isEmpty(drVrmList)) {
            for (DrVrm drVrm : drVrmList) {
                VRM v = this.getVrm(drVrm.getDeviceSn());
                if (!fcIps.contains(v.getIpAddress())) continue;
                vrmList.add(v);
            }
        }
        return vrmList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registFm(String siteId, String fmSn, List<String> fcSns) {
        this.logger.info((Object)("registFm enter. siteid = " + siteId + ", fmSn = " + fmSn + ", fcSns = " + fcSns), 90160758786816L);
        VrmUtil.checkParameter((String)fmSn);
        VrmUtil.checkParameter((String)siteId);
        if (!VerifyUtil.isEmpty(fcSns) && fcSns.size() > 16) {
            this.logger.error((Object)"Size of fcSns is over max count.Failed to regist cloud.", 90160758787071L);
            throw new LegoCheckedException(1073947670L);
        }
        VrmUtil.checkDataBaseBySiteId((String)siteId);
        VrmUtil.getSiteById((String)siteId);
        this.checkRelationshipBetweenFmAndFcs(fmSn, fcSns);
        Object object = LockFactory.CLOUD_PLATFORM_LOCK;
        synchronized (object) {
            List<DrFm> fms = CloudServiceUtil.findDrFms(null, fmSn);
            if (!VerifyUtil.isEmpty(fms)) {
                if (!siteId.equals(fms.get(0).getSiteId())) {
                    this.logger.error((Object)("THE vrm(" + fmSn + ") has already registed."), 90160758787071L);
                    throw new LegoCheckedException(1073947660L);
                }
                if (VerifyUtil.isEmpty(fcSns)) {
                    this.logger.error((Object)"param of registFm is empty. ", 90160758787071L);
                    throw new LegoCheckedException(1073947660L);
                }
                this.saveRegistInfos(siteId, null, fcSns);
            } else {
                this.saveRegistInfos(siteId, fmSn, fcSns);
            }
        }
        this.logger.info((Object)"registFm exit.", 90160758786816L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRegistInfos(String siteId, String fmSn, List<String> fcSns) {
        this.logger.trace((Object)(this.trace + " trace message"));
        HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        Session session = template.getSessionFactory().openSession();
        Transaction t = null;
        try {
            t = session.beginTransaction();
            if (!VerifyUtil.isEmpty((String)fmSn)) {
                session.saveOrUpdate((Object)this.getRegistableFm(siteId, fmSn, fcSns));
            }
            if (!VerifyUtil.isEmpty(fcSns)) {
                List<DrVrm> tobeRegistedFcs = this.getRegistableFcsUnderFm(siteId, fcSns);
                for (DrVrm v : tobeRegistedFcs) {
                    session.saveOrUpdate((Object)v);
                }
            }
            VrmUtil.getSiteById((String)siteId);
            t.commit();
        }
        catch (LegoCheckedException e) {
            this.rollbackSession(t);
            throw e;
        }
        catch (Exception e) {
            this.rollbackSession(t);
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to regist cloud platform", (long)-1L, null, (Log)this.logger);
        }
        finally {
            this.closeSession(session);
        }
    }

    private void checkRelationshipBetweenFmAndFcs(String fmSn, List<String> fcSns) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty(fcSns)) {
            return;
        }
        List<String> fcIps = this.getFcIpsOfFmByFmId(fmSn);
        for (String fcSn : fcSns) {
            VRM fc = this.getVrm(fcSn);
            if (fcIps.contains(fc.getIpAddress())) continue;
            this.logger.error((Object)(fcSn + " is not a child of " + fmSn), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private List<String> getFcIpsOfFmByFmId(String fmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        FusionManager fm = (FusionManager)CommonDAOLocator.getMoDao().getMo(FusionManager.class, "sn", (Object)fmSn);
        if (null == fm) {
            this.logger.error((Object)"fm is null.");
            throw new LegoCheckedException(1073947394L);
        }
        ArrayList conditions = new ArrayList();
        List hypers = CommonDAOLocator.getMoDao().findSubMoBy(fm.getMoId().longValue(), Hypervisor.class, conditions);
        ArrayList<String> fcIps = new ArrayList<String>();
        if (hypers != null) {
            for (Hypervisor h : hypers) {
                if (!"fusioncompute".equals(h.getHvType())) continue;
                fcIps.add(h.getIpAddress());
            }
        }
        return fcIps;
    }

    private DrFm getRegistableFm(String siteId, String fmSn, List<String> fcSns) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.checkFmRegistRules(siteId, fmSn, fcSns);
        FusionManager vrm = this.getFm(fmSn);
        return FmUtils.translateFm((FusionManager)vrm, (String)siteId);
    }

    private List<DrVrm> getRegistableFcsUnderFm(String siteId, List<String> fcSns) {
        this.logger.trace((Object)(this.trace + " trace message"));
        CloudServiceUtil.checkFcRegistRule(siteId, fcSns);
        ArrayList<DrVrm> tobeRegist = new ArrayList<DrVrm>();
        for (String fc : fcSns) {
            tobeRegist.add(VrmUtil.translateVrm((VRM)this.getVrm(fc), (String)siteId));
        }
        return tobeRegist;
    }

    private void checkFmRegistRules(String siteId, String fmSn, List<String> fcSns) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List<DrFm> registedFms = CloudServiceUtil.findDrFms(siteId, null);
        if (!VerifyUtil.isEmpty(registedFms)) {
            this.logger.error((Object)("The site(" + siteId + ") has already registed maxcount drm."), 90160758787071L);
            throw new LegoCheckedException(1073947678L);
        }
        List<DrVrm> registedFcs = CloudServiceUtil.findDrVrms(siteId, null);
        List<String> fcIps = this.getFcIpsOfFmByFmId(fmSn);
        if (!VerifyUtil.isEmpty(registedFcs)) {
            for (DrVrm v : registedFcs) {
                VRM fc = this.getVrm(v.getDeviceSn());
                if (fcIps.contains(fc.getIpAddress())) continue;
                this.logger.error((Object)(v.getDeviceSn() + " is not a child of " + fmSn), 90160758787071L);
                throw new LegoCheckedException(1073947675L);
            }
        } else if (VerifyUtil.isEmpty(fcSns)) {
            this.logger.error((Object)("To be registed FC List is Empty. fmsn=" + fmSn), 90160758787071L);
            throw new LegoCheckedException(1073947679L);
        }
        this.checkFmAndFcInSameSite(siteId, fmSn, fcIps);
    }

    private void checkFmAndFcInSameSite(String siteId, String fmSn, List<String> fcIps) {
        this.logger.trace((Object)(this.trace + " trace message"));
        HashSet<String> sites = new HashSet<String>();
        for (String fcIp : fcIps) {
            List<DrVrm> drVrms;
            VRM vrm = (VRM)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(VRM.class, "ipAddress", (Object)fcIp);
            if (vrm == null || VerifyUtil.isEmpty(drVrms = CloudServiceUtil.findDrVrms(null, vrm.getSn()))) continue;
            sites.add(drVrms.get(0).getSiteId());
        }
        if (sites.size() > 1 || !sites.isEmpty() && !siteId.equals(sites.iterator().next())) {
            this.logger.error((Object)("The children of fm(" + fmSn + ") are registed into diffent sites."), 90160758787071L);
            throw new LegoCheckedException(1073947676L);
        }
    }

    private VRM getVrm(String vrmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        return this.vrmService.getVrm(vrmSn);
    }

    public VrmCommInfo getFmCommInfo(String fmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        FusionManager fm = this.getFm(fmSn);
        return this.getFmCommInfoByMoId(fm.getMoId().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregistFm(String siteId, String sn, String type) {
        this.logger.info((Object)("unregistFm enter. siteid = " + siteId + ", sn = " + sn + ", type = " + type), 90160758786816L);
        VrmUtil.checkParameter((String)sn);
        VrmUtil.checkParameter((String)siteId);
        Object object = LockFactory.CLOUD_PLATFORM_LOCK;
        synchronized (object) {
            if (DrFm.class.getSimpleName().equals(type)) {
                List<DrFm> fms = CloudServiceUtil.findDrFms(siteId, sn);
                this.checkUnregistFmRules(siteId, sn, fms);
                this.unregistFmAndFcs(fms);
            } else if (DrVrm.class.getSimpleName().equals(type)) {
                List<DrVrm> vrms = CloudServiceUtil.findDrVrms(siteId, sn);
                this.checkUnregistFcRules(siteId, sn, vrms);
                ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).deleteResouce((Object)vrms.get(0));
            } else {
                this.logger.error((Object)"The 'type' param of unregistFm is invalid. ", 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
        }
        this.logger.info((Object)("cloud(" + sn + ") has been unRegistered."), 90160758786816L);
    }

    private void checkUnregistFmRules(String siteId, String sn, List<DrFm> fms) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty(fms)) {
            this.logger.error((Object)("the DrFm has been deleted or unregisterd:" + sn), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        CloudServiceUtil.checkCloudPlatformIsUsed(siteId, sn);
    }

    private void checkUnregistFcRules(String siteId, String sn, List<DrVrm> vrms) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty(vrms)) {
            this.logger.error((Object)("the DrVrm has been deleted or unregisterd:" + sn), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        List<DrVrm> drVrmsInSite = CloudServiceUtil.findDrVrms(siteId, null);
        if (drVrmsInSite.size() <= 1) {
            this.logger.error((Object)"Under the site must have at least one FC.", 90160758787071L);
            throw new LegoCheckedException(1073947679L);
        }
        CloudServiceUtil.checkCloudPlatformIsUsed(siteId, sn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregistFmAndFcs(List<DrFm> fms) {
        this.logger.trace((Object)(this.trace + " trace message"));
        HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        Session session = template.getSessionFactory().openSession();
        Transaction t = null;
        try {
            t = session.beginTransaction();
            session.delete((Object)fms.get(0));
            t.commit();
        }
        catch (Exception e) {
            this.rollbackSession(t);
            ExceptionUtil.rethrowException((Throwable)e, (String)("failed to delete vrm from drFm and drVrm table:" + fms.get(0).getDeviceSn()), (long)-1L, null, (Log)this.logger);
        }
        finally {
            this.closeSession(session);
        }
    }

    private void rollbackSession(Transaction t) {
        if (null != t) {
            t.rollback();
        }
    }

    public void updateFm(String vrmId, VrmCommInfo commInfo, boolean changedPw, String optName) {
        this.logger.info((Object)("updateFm enter. vrmId = " + vrmId + ", changedPw = " + changedPw), 90160758786816L);
        VrmUtil.checkParameter((String)vrmId);
        CloudServiceUtil.checkCommInfoParam(commInfo);
        String fmUri = CloudServiceUtil.updateExtend(vrmId, commInfo, changedPw, DrFm.class, this.neMgr);
        FusionManager fm = this.getFmByMoId(vrmId);
        CloudServiceUtil.updateNetworkEntity(commInfo, fmUri, (NetworkEntity)fm);
        CloudServiceUtil.updateRegistedCloud(commInfo, (NetworkEntity)fm, DrFm.class);
        try {
            this.cloudService.refreshFm(fm.getSn(), optName);
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to refresh fm." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786816L);
        }
    }

    public Page pageQueryRegistedCloudsBySiteId(String siteId, String orderBy, int pageNo, int pageSize, boolean isAsc, Long userId) {
        List<DrVrm> drVrms;
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty((Object)userId)) {
            this.logger.error((Object)"userId is empty!", 90160758787071L);
            return new Page();
        }
        Site site = VrmUtil.getSiteByIdObjectNotExist((String)siteId);
        ArrayList<CloudInfo> registedCloud = new ArrayList<CloudInfo>();
        List<DrFm> drFms = CloudServiceUtil.findDrFms(site.getSiteId(), null);
        if (drFms != null) {
            this.fillRegistedCloudInfos(userId, site, null, registedCloud, drFms);
        }
        if ((drVrms = CloudServiceUtil.findDrResources(DrVrm.class, site.getSiteId(), null, orderBy, isAsc)) != null) {
            CloudInfo parentRes = registedCloud.isEmpty() ? null : (CloudInfo)registedCloud.get(0);
            this.fillRegistedCloudInfos(userId, site, parentRes, registedCloud, drVrms);
        }
        return Page.createPage((int)pageNo, (int)pageSize, registedCloud);
    }

    private void fillRegistedCloudInfos(Long userId, Site site, CloudInfo parentRes, List<CloudInfo> registedCloud, List<? extends DrResource> registedClouds) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List sns = new ArrayList<String>();
        for (DrResource drResource : registedClouds) {
            sns.add(drResource.getDeviceSn());
        }
        if (0 == site.getSiteType()) {
            sns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(sns, userId);
        }
        for (DrResource drResource : registedClouds) {
            if (!sns.contains(drResource.getDeviceSn())) continue;
            CloudInfo cloudInfo = FmUtils.translateCloudInfo((DrResource)drResource, (CloudInfo)parentRes);
            registedCloud.add(cloudInfo);
            Set resources = drResource.getChildResources();
            if (VerifyUtil.isEmpty((Collection)resources)) continue;
            ArrayList<CNARegistInfo> tempNodes = new ArrayList<CNARegistInfo>();
            for (DrResource drResource2 : resources) {
                if (!(drResource2 instanceof DrComputeNode)) continue;
                tempNodes.add(new CNARegistInfo((DrComputeNode)drResource2));
            }
            cloudInfo.setDrCNANodes(tempNodes);
        }
    }

    public <T extends DrResource> List<CloudInfo> getRegistedCloudListBySiteId(String siteId, Long userId, Class<T> classType) {
        Page page;
        List tmp;
        this.logger.trace((Object)(this.trace + " trace message"));
        ArrayList<CloudInfo> list = new ArrayList<CloudInfo>();
        int pageNo = 0;
        while ((tmp = (page = this.pageQueryRegistedCloudsBySiteId(siteId, null, pageNo, 10, false, userId)).getResult()) != null) {
            for (CloudInfo cloudInfo : tmp) {
                if (classType != null && !classType.getSimpleName().equals(cloudInfo.getResType())) continue;
                list.add(cloudInfo);
            }
            if (page.getTotalCount() < 10L) break;
            ++pageNo;
        }
        return list;
    }

    public List<DrFm> getRegistableFmListBySite(Long userId, String siteId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty((String)siteId)) {
            return this.getUnregisteredFmList(userId);
        }
        List<DrFm> fms = CloudServiceUtil.findDrFms(siteId, null);
        if (VerifyUtil.isEmpty(fms)) {
            return this.getUnregisteredFmList(userId);
        }
        return this.filterDrFmByUserId(userId, fms);
    }

    private List<DrFm> filterDrFmByUserId(Long userId, List<DrFm> fms) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List sns = new ArrayList<String>();
        for (DrFm fm : fms) {
            sns.add(fm.getDeviceSn());
        }
        sns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(sns, userId);
        if (null == sns || sns.isEmpty()) {
            return new ArrayList<DrFm>();
        }
        ArrayList<DrFm> fmList = new ArrayList<DrFm>();
        for (DrFm fm : fms) {
            if (!sns.contains(fm.getDeviceSn())) continue;
            fmList.add(fm);
        }
        return fmList;
    }

    public List<DrVrm> getUnregistedVrmListByFm(Long userId, String fmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List<String> sns = new ArrayList();
        List<String> vrmIps = this.getFcIpsOfFmByFmId(fmSn);
        List<VRM> vrms = CloudServiceUtil.getAllLocalMos(VRM.class);
        for (VRM vrmMo : vrms) {
            if (!vrmIps.contains(vrmMo.getIpAddress())) continue;
            sns.add(vrmMo.getSn());
        }
        sns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(sns, userId);
        if (null == sns || sns.isEmpty()) {
            return new ArrayList<DrVrm>();
        }
        List<DrVrm> listRegisted = CloudServiceUtil.findDrVrms(null, null);
        return CloudServiceUtil.getUnregisteredDrResource(vrms, listRegisted, sns);
    }

    public List<DrFm> getUnregisteredFmList(Long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List<String> sns = new ArrayList<String>();
        List<FusionManager> fms = CloudServiceUtil.getAllLocalMos(FusionManager.class);
        for (FusionManager fmMo : fms) {
            sns.add(fmMo.getSn());
        }
        List<DrFm> listRegisted = CloudServiceUtil.findDrFms(null, null);
        sns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(sns, userId);
        if (null == sns || sns.isEmpty()) {
            return new ArrayList<DrFm>();
        }
        return CloudServiceUtil.getUnregisteredDrResource(fms, listRegisted, sns);
    }

    public String getRegistedCloudType(String siteId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty((String)siteId)) {
            return null;
        }
        List<DrFm> fms = CloudServiceUtil.findDrFms(siteId, null);
        if (!VerifyUtil.isEmpty(fms)) {
            return DrFm.class.getSimpleName();
        }
        List<DrVrm> vrms = CloudServiceUtil.findDrVrms(siteId, null);
        if (!VerifyUtil.isEmpty(vrms)) {
            return DrVrm.class.getSimpleName();
        }
        return null;
    }

    public ManagedObject getCloudObjectBySn(String sn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        VRM vrm = (VRM)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(VRM.class, "sn", (Object)sn);
        if (vrm != null) {
            return vrm;
        }
        FusionManager fm = (FusionManager)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(FusionManager.class, "sn", (Object)sn);
        if (fm != null) {
            return fm;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registFm(String siteId, String fmSn) {
        this.logger.info((Object)("registFm enter. siteid = " + siteId + ", fmSn = " + fmSn), 90160758786816L);
        VrmUtil.checkParameter((String)fmSn);
        VrmUtil.checkParameter((String)siteId);
        VrmUtil.checkDataBaseBySiteId((String)siteId);
        VrmUtil.getSiteById((String)siteId);
        Object object = LockFactory.CLOUD_PLATFORM_LOCK;
        synchronized (object) {
            List<DrFm> fms = CloudServiceUtil.findDrFms(null, fmSn);
            if (!VerifyUtil.isEmpty(fms)) {
                this.logger.error((Object)("The fm(" + fmSn + ") has already registed."), 90160758787071L);
                throw new LegoCheckedException(1073947660L);
            }
            this.saveRegistInfos(siteId, fmSn);
        }
        this.logger.info((Object)"registFm exit.", 90160758786816L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRegistInfos(String siteId, String fmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        Session session = template.getSessionFactory().openSession();
        Transaction t = null;
        try {
            t = session.beginTransaction();
            session.saveOrUpdate((Object)this.getRegistableFm(siteId, fmSn));
            VrmUtil.getSiteById((String)siteId);
            t.commit();
        }
        catch (LegoCheckedException e) {
            this.rollbackSession(t);
            throw e;
        }
        catch (Exception e) {
            this.rollbackSession(t);
            ExceptionUtil.rethrowException((Throwable)e, (String)"failed to regist cloud platform.", (long)-1L, null, (Log)this.logger);
        }
        finally {
            this.closeSession(session);
        }
    }

    private DrFm getRegistableFm(String siteId, String fmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        FusionManager fm = this.getFm(fmSn);
        return FmUtils.translateFm((FusionManager)fm, (String)siteId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregistFm(String siteId, String sn) {
        this.logger.info((Object)("unregistFm enter. siteid = " + siteId + ", sn = " + sn + ", type = "), 90160758786816L);
        VrmUtil.checkParameter((String)sn);
        VrmUtil.checkParameter((String)siteId);
        Object object = LockFactory.CLOUD_PLATFORM_LOCK;
        synchronized (object) {
            List<DrFm> fms = CloudServiceUtil.findDrFms(siteId, sn);
            this.checkUnregistFmRules(siteId, sn, fms);
            this.unregistFmAndFcs(fms);
        }
        this.logger.info((Object)("cloud(" + sn + ") has been unRegistered."), 90160758786816L);
    }

    public Page pageQueryVmsByCloudSn(String fmSn, String orderBy, int pageSize, int startPage, boolean isAsc, String filterName, String filterValue) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty((String)fmSn) || VerifyUtil.isEmpty((String)orderBy)) {
            this.logger.error((Object)"parameter fmSn or orderBy is invalid.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        List<VRM> vrms = this.getRegistedFcOfSpecfiedFm(fmSn);
        if (VerifyUtil.isEmpty(vrms)) {
            this.logger.error((Object)("there is no FC under FM, fmSn=" + fmSn), 90160758787071L);
            return new Page();
        }
        ArrayList<String> vrmSns = new ArrayList<String>();
        for (VRM vrm : vrms) {
            vrmSns.add(vrm.getSn());
        }
        ArrayList<Object> criterionList = new ArrayList<Object>();
        criterionList.add(Restrictions.in((String)"topMoUuid", vrmSns));
        criterionList.add(Restrictions.eq((String)"providerID", (Object)GalaxVM.VMProviderType.FM.getValue()));
        if ("name".equalsIgnoreCase(filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            criterionList.add(Restrictions.ilike((String)"name", (Object)("%" + filterValue + "%")));
        } else if ("status".equalsIgnoreCase(filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            int valueInt = CommUtil.convertToInteger((Object)filterValue);
            criterionList.add(Restrictions.eq((String)"status", (Object)valueInt));
        } else if ("ID".equalsIgnoreCase(filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            criterionList.add(Restrictions.ilike((String)"uri", (Object)("%vms/%" + filterValue + "%")));
        }
        return CommonDAOLocator.getBaseDao().pagedQuery(GalaxVM.class, startPage, pageSize, criterionList, orderBy, isAsc);
    }

    private void closeSession(Session session) {
        this.logger.trace((Object)(this.trace + " trace message"));
        DBOperationUtil.closeSession((Session)session);
    }
}

