/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.service;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.galax.constant.LockFactory;
import com.huawei.ism.drm.galax.sdk.model.DrFm;
import com.huawei.ism.drm.galax.sdk.model.DrVRG;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.VRG;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.service.ICloudService;
import com.huawei.ism.drm.galax.sdk.service.IGalaxSiteResService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.ism.drm.site.sdk.service.ISiteResourceService;
import com.huawei.ism.drm.site.util.SiteResourceManagerUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;

@ServiceBoundInfo(methodName="onBind", targetBeanName="siteResourceServiceProxy", properties="resType:ism.drm.deviceType.fusionsphere.mainType")
public class FusionsphereSiteResServiceImpl
implements ISiteResourceService {
    private Log logger = LogFactory.getInstance(FusionsphereSiteResServiceImpl.class);
    private String trace = "trace";
    private Map<String, IGalaxSiteResService> galaxServiceMap = new HashMap<String, IGalaxSiteResService>();
    private ICloudService cloudService;
    private ISiteBaseService siteService;

    public ISiteBaseService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(ISiteBaseService siteService) {
        this.siteService = siteService;
    }

    public ICloudService getCloudService() {
        return this.cloudService;
    }

    public void setCloudService(ICloudService cloudService) {
        this.cloudService = cloudService;
    }

    public void onBind(IGalaxSiteResService mgrSerivce, Map<?, ?> properties) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.galaxServiceMap.put(mgrSerivce.getResourceSubType(), mgrSerivce);
    }

    public void onUnbind(IGalaxSiteResService mgrSerivce, Map<?, ?> properties) {
        this.logger.trace((Object)(this.trace + " trace message"));
        this.galaxServiceMap.remove(mgrSerivce.getResourceSubType());
    }

    private IGalaxSiteResService getGalaxSiteResService(DrResource res) {
        IGalaxSiteResService service = null;
        if (res instanceof DrVrm || res instanceof DrFm) {
            service = this.galaxServiceMap.get("ism.drm.deviceType.cloud.subType");
        } else if (res instanceof DrVRG) {
            service = this.galaxServiceMap.get("ism.drm.deviceType.vrg.subType");
        }
        if (null == service) {
            String subType = res.getSubType();
            service = this.galaxServiceMap.get(subType);
        }
        if (null == service) {
            this.logger.error((Object)("can not find the service. sn=" + res.getDeviceSn()));
            throw new LegoCheckedException(1073947393L);
        }
        return service;
    }

    private IGalaxSiteResService getGalaxSiteResService(NetworkEntity entity) {
        IGalaxSiteResService service = null;
        if (entity instanceof FusionManager || entity instanceof VRM) {
            service = this.galaxServiceMap.get("ism.drm.deviceType.cloud.subType");
        } else if (entity instanceof VRG) {
            service = this.galaxServiceMap.get("ism.drm.deviceType.vrg.subType");
        }
        if (null == service) {
            service = this.galaxServiceMap.get(entity.getSubType());
            IGalaxSiteResService iGalaxSiteResService = service = service != null ? service : this.galaxServiceMap.get("ism.drm.deviceType.cloud.subType");
        }
        if (null == service) {
            this.logger.error((Object)("entity is not in Fusionsphere. sn=" + entity.getSn()), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void isResourceUsed(Long moId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (null == moId) {
            this.logger.error((Object)"parameter moid is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ManagedObject ob = (ManagedObject)CommonDAOLocator.getMoDao().get((Serializable)moId);
        if (null == ob) {
            this.logger.error((Object)"delete Host error because mo is null", 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        String siteHql = "from DrResource as dh where dh.deviceSn = ? ";
        Object[] condition = new String[]{ob.getUuid()};
        try {
            List fms = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(siteHql, condition);
            if (VerifyUtil.isEmpty((Collection)fms)) {
                return;
            }
            Object object = LockFactory.CLOUD_PLATFORM_LOCK;
            synchronized (object) {
                for (DrResource res : fms) {
                    this.checkDrResouceUsed(res);
                }
            }
        }
        catch (DataAccessException ex) {
            this.logger.error((Object)("check resorce used failed" + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758787071L);
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    private void checkDrResouceUsed(DrResource res) {
        Site site = this.siteService.getSiteById(res.getSiteId());
        if (site.getSiteType() != 0) {
            return;
        }
        this.getGalaxSiteResService(res).checkDrResouceUsed(res.getSiteId(), res.getDeviceSn());
    }

    public void registerResource(Site site, String[] resSns) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty((Object[])resSns)) {
            this.logger.error((Object)"parameter resSns is empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        NetworkEntity entity = (NetworkEntity)CommonDAOLocator.getMoDao().getMo(NetworkEntity.class, "sn", (Object)resSns[0]);
        if (null == entity) {
            this.logger.error((Object)("entity is not discovery. sn=" + resSns[0]), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.getGalaxSiteResService(entity).registerResource(site, resSns);
    }

    public void refreshResouce(Site site) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (site == null || 1 != site.getSiteType()) {
            return;
        }
        for (IGalaxSiteResService siteResService : this.galaxServiceMap.values()) {
            siteResService.refreshResouce(site);
        }
    }

    public int sum(String siteId, Long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List sns = this.getDrResourceSnsBySiteId(siteId);
        if (VerifyUtil.isEmpty(sns)) {
            return 0;
        }
        Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(siteId);
        if (!VerifyUtil.isEmpty((Object)site) && site.getSiteType() == 0) {
            sns = SiteResourceManagerUtil.filterDrResourceSN(sns, (Long)userId);
        }
        return VerifyUtil.isEmpty(sns) ? 0 : sns.size();
    }

    public DrResource getDrResourceByMo(ManagedObject mo) {
        if (!(mo instanceof NetworkEntity)) {
            return null;
        }
        return this.getGalaxSiteResService((NetworkEntity)mo).getDrResourceByMo((NetworkEntity)mo);
    }

    public DrResource getDrResourceBySn(String cloudSn) {
        for (IGalaxSiteResService siteResService : this.galaxServiceMap.values()) {
            DrResource dr = siteResService.getDrResourceBySn(cloudSn);
            if (null == dr) continue;
            return dr;
        }
        return null;
    }

    public List<DrResource> getDrResourceBySite(Integer siteType) {
        ArrayList<DrResource> result = new ArrayList<DrResource>();
        for (IGalaxSiteResService siteResService : this.galaxServiceMap.values()) {
            result.addAll(siteResService.getDrResourceBySite(siteType));
        }
        return result;
    }

    public List<DrResource> getDrResourceBySite(String siteId) {
        ArrayList<DrResource> result = new ArrayList<DrResource>();
        for (IGalaxSiteResService siteResService : this.galaxServiceMap.values()) {
            result.addAll(siteResService.getDrResourceBySite(siteId));
        }
        return result;
    }

    private List<String> getDrResourceSnsBySiteId(String siteId) {
        ArrayList<String> sns = new ArrayList<String>();
        List<DrResource> resList = this.getDrResourceBySite(siteId);
        for (DrResource res : resList) {
            sns.add(res.getDeviceSn());
        }
        return sns;
    }
}

