/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.service;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.drm.galax.resource.discovery.manager.VrmManager;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DrsGroup;
import com.huawei.ism.drm.galax.sdk.model.GalaxObject;
import com.huawei.ism.drm.galax.sdk.model.PhysicalStorageDevice;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.service.IVrmResourceService;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@Service(name="com.huawei.ism.drm.galax.sdk.service.IVrmResourceService", desc="", interfaceClass=IVrmResourceService.class)
public class VrmResourceServiceImpl
extends BaseService
implements IVrmResourceService {
    private static final Log logger = LogFactory.getInstance(VrmResourceServiceImpl.class);

    public VRM loginVrm(NeMgrProtocolExtend extend) {
        VrmObject vrmObj = VrmUtil.generateVrmObj((NeMgrProtocolExtend)extend);
        vrmObj = VrmManager.getInstance().getVrmVirtualResService().login(vrmObj);
        if (null == vrmObj || null == vrmObj.getUri()) {
            return null;
        }
        extend.getExtendParams().put("vrmUri", vrmObj.getUri());
        extend.getExtendParams().put("vrmUrn", vrmObj.getUrn());
        extend.getExtendParams().put("vrmVersion", vrmObj.getVersion().getVersion());
        extend.getExtendParams().put("loginUri", vrmObj.getVersion().getLoginUri());
        extend.getExtendParams().put("param_name", vrmObj.getName());
        VRM vrm = new VRM();
        vrm.setUuid(VrmUtil.generateVrmSn((String)((String)extend.getExtendParams().get("vrmUri"))));
        vrm.setLinkIp(extend.getNetworkIpAddress());
        vrm.setIpAddress(vrm.getLinkIp());
        vrm.setSn(vrm.getUuid());
        vrm.setName(vrmObj.getName());
        vrm.setDescription(CommonUtil.getDescription((String)vrmObj.getDescription()));
        vrm.setLocation(extend.getOtherParam());
        if (null != vrmObj.getVersion()) {
            vrm.setVersion(vrmObj.getVersion().getVersion());
        }
        vrm.setLicenseVersion(VrmManager.getInstance().getVrmVirtualResService().queryVrmLicenseVersion(vrmObj));
        return vrm;
    }

    public List<GalaxObject> queryResource(NeMgrProtocolExtend extend) {
        String resType = (String)extend.getExtendParams().get("resourceType");
        if (null == resType) {
            return new ArrayList<GalaxObject>();
        }
        try {
            return this.getResource(extend);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("Failed to get vrm(" + extend.getNetworkIpAddress() + ") resource(" + resType + "!"), (Throwable)e, 90160758787071L);
            throw e;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to get vrm(" + extend.getNetworkIpAddress() + ") resource(" + resType + "!"), (long)1073947399L, null, (Log)logger);
            return new ArrayList<GalaxObject>();
        }
    }

    private List<GalaxObject> getResource(NeMgrProtocolExtend extend) {
        String resType = (String)extend.getExtendParams().get("resourceType");
        if (resType == null) {
            logger.error((Object)"Data resType is null.");
            throw new LegoCheckedException(1073947393L);
        }
        List<GalaxObject> list = new ArrayList<GalaxObject>();
        IVirtualResourceManager vrmVirtualResService = VrmManager.getInstance().getVrmVirtualResService();
        VrmObject vrmInfo = VrmUtil.generateVrmObj((NeMgrProtocolExtend)extend);
        switch (resType) {
            case "clustor": {
                List listTemp = vrmVirtualResService.queryCluster(vrmInfo);
                if (this.checkVrmVersion(extend)) {
                    this.getDrsGroupResource(listTemp, vrmInfo, vrmVirtualResService);
                }
                this.insertList(list, listTemp);
                break;
            }
            case "host": {
                list = this.getHostResource(vrmInfo, vrmVirtualResService);
                break;
            }
            case "dvswitch": {
                List listTemp = vrmVirtualResService.queryAllDVSwitch(vrmInfo);
                this.insertList(list, listTemp);
                break;
            }
            case "portGroup": {
                String switchUri = (String)extend.getExtendParams().get("parrentUri");
                List listTemp = vrmVirtualResService.queryPortGroupBySwitchId(vrmInfo, switchUri);
                this.insertList(list, listTemp);
                break;
            }
            case "datastore": {
                List listTemp = vrmVirtualResService.queryDataStore(vrmInfo);
                this.insertList(list, listTemp);
                break;
            }
            case "vm": {
                List listTemp = vrmVirtualResService.queryVMByDataStore(vrmInfo);
                this.insertList(list, listTemp);
                break;
            }
        }
        return list;
    }

    private boolean checkVrmVersion(NeMgrProtocolExtend extend) {
        double version;
        String vrmVersion = (String)extend.getExtendParams().get("vrmVersion");
        if (VerifyUtil.isEmpty((String)vrmVersion)) {
            logger.error((Object)"Data vrmVersion is null.");
            return false;
        }
        String newVrmVersion = vrmVersion.replace("v", "");
        String[] charts = newVrmVersion.split("\\.");
        try {
            version = Double.parseDouble(charts[0]);
        }
        catch (NumberFormatException ex) {
            logger.error((Object)"VrmVersion is error,vrmVersion is %s,error is %s.", new Object[]{vrmVersion, ExceptionUtil.getErrorMessage((Throwable)ex)});
            return false;
        }
        return version >= 8.0;
    }

    private void getDrsGroupResource(List<ComputeCluster> listTemp, VrmObject vrmInfo, IVirtualResourceManager vrmVirtualResService) {
        for (ComputeCluster cluster : listTemp) {
            List groups = vrmVirtualResService.queryDrsGroup(vrmInfo, cluster);
            if (groups.isEmpty()) continue;
            for (DrsGroup group : groups) {
                cluster.addChildMo((ManagedObject)group);
                group.setParentMo((ManagedObject)cluster);
            }
        }
    }

    private List<GalaxObject> getHostResource(VrmObject vrmInfo, IVirtualResourceManager vrmVirtualResService) {
        ArrayList<GalaxObject> list = new ArrayList<GalaxObject>();
        List listTemp = vrmVirtualResService.queryAllComputeNode(vrmInfo);
        if (VerifyUtil.isEmpty((Collection)listTemp)) {
            return Collections.emptyList();
        }
        for (ComputeNode computeNode : listTemp) {
            List listHbaTemp = vrmVirtualResService.queryStorageAdapter(vrmInfo, computeNode.getUri());
            if (VerifyUtil.isEmpty((Collection)listHbaTemp)) continue;
            for (PhysicalStorageDevice storageDevice : listHbaTemp) {
                computeNode.addChildMo((ManagedObject)storageDevice);
            }
        }
        this.insertList(list, listTemp);
        return list;
    }

    private void insertList(List<GalaxObject> list, List<? extends GalaxObject> listTemp) {
        for (GalaxObject galaxObject : listTemp) {
            if (null == galaxObject.getName() || "null".equals(galaxObject.getName())) {
                galaxObject.setName("null ");
            }
            list.add(galaxObject);
        }
    }
}

