/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.service;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolCommonServiceV2Stub;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.galax.constant.LockFactory;
import com.huawei.ism.drm.galax.constant.cloudenum.FmScanCriteriaEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.StopVmMode;
import com.huawei.ism.drm.galax.constant.cloudenum.VmRecoveryCmdEnum;
import com.huawei.ism.drm.galax.recovery.common.FsRecoveryUtil;
import com.huawei.ism.drm.galax.resource.discovery.service.CloudServiceUtil;
import com.huawei.ism.drm.galax.resource.manager.impl.FMInfosRetrieverInvocationHandler;
import com.huawei.ism.drm.galax.sdk.dao.IDaoAdapter;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.DrComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.Hypervisor;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.sdk.model.VrmCommInfo;
import com.huawei.ism.drm.galax.sdk.service.ICloudService;
import com.huawei.ism.drm.galax.sdk.service.IDsgService;
import com.huawei.ism.drm.galax.sdk.service.IFmService;
import com.huawei.ism.drm.galax.sdk.service.IVrmService;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.SetDataStoreModeRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VMOperateResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigDiskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmTaskType;
import com.huawei.ism.drm.galax.sdk.vrm.service.IFMInfosRetriever;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVRMDrManager;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateTemplate;

@Service(name="com.huawei.ism.drm.galax.sdk.service.IVrmService", desc="", interfaceClass=IVrmService.class)
public class VrmServiceImpl
extends BaseService
implements IVrmService {
    private Log logger = LogFactory.getInstance(VrmServiceImpl.class);
    private String trace = "trace";
    private INeMgrProtocolExtendService neMgr;
    private IVirtualResourceManager vrmVirtualResService;
    private IVRMDrManager vrmDrManager;
    private IFMInfosRetriever fmRetriever;
    private IDsgService dsgService;
    private IFmService fmService;
    private ICloudService cloudService;

    public IVirtualResourceManager getVrmVirtualResService() {
        return this.vrmVirtualResService;
    }

    public void setVrmVirtualResService(IVirtualResourceManager vrmVirtualResService) {
        this.vrmVirtualResService = vrmVirtualResService;
    }

    public IFMInfosRetriever getFmRetriever() {
        return this.fmRetriever;
    }

    public void setFmRetriever(IFMInfosRetriever fmRetriever) {
        FMInfosRetrieverInvocationHandler handler = new FMInfosRetrieverInvocationHandler(fmRetriever);
        this.fmRetriever = (IFMInfosRetriever)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{IFMInfosRetriever.class}, (InvocationHandler)handler);
    }

    public IDsgService getDsgService() {
        return this.dsgService;
    }

    public void setDsgService(IDsgService dsgService) {
        this.dsgService = dsgService;
    }

    public ICloudService getCloudService() {
        return this.cloudService;
    }

    public void setCloudService(ICloudService cloudService) {
        this.cloudService = cloudService;
    }

    public IFmService getFmService() {
        return this.fmService;
    }

    public void setFmService(IFmService fmService) {
        this.fmService = fmService;
    }

    public INeMgrProtocolExtendService getNeMgr() {
        return this.neMgr;
    }

    public void setNeMgr(INeMgrProtocolExtendService neMgr) {
        this.neMgr = neMgr;
    }

    public VRM getVrm(String vrmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        return (VRM)this.cloudService.getCloud("sn", (Object)vrmSn, VRM.class);
    }

    public VRM getVrmByMoId(String moId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        return (VRM)this.cloudService.getCloud("moId", (Object)Long.valueOf(moId), VRM.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registFcs(String siteId, List<String> fcSns) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty(fcSns) || VerifyUtil.isEmpty((String)siteId)) {
            this.logger.error((Object)"fcSns or siteId is Empty.Failed to regist.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        VrmUtil.checkDataBaseBySiteId((String)siteId);
        VrmUtil.getSiteById((String)siteId);
        Object object = LockFactory.CLOUD_PLATFORM_LOCK;
        synchronized (object) {
            this.checkRegistIndependenceFcRules(siteId, fcSns);
            this.saveFcRegistInfos(siteId, fcSns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregistVrm(String siteId, String vrmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        VrmUtil.checkParameter((String)vrmSn);
        VrmUtil.checkParameter((String)siteId);
        Object object = LockFactory.CLOUD_PLATFORM_LOCK;
        synchronized (object) {
            List<DrVrm> vrms = CloudServiceUtil.findDrVrms(siteId, vrmSn);
            if (VerifyUtil.isEmpty(vrms)) {
                this.logger.error((Object)("the DrVrm has been deleted or unregisterd:" + vrmSn), 90160758787071L);
                throw new LegoCheckedException(1073947394L);
            }
            CloudServiceUtil.checkCloudPlatformIsUsed(siteId, vrmSn);
            ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).deleteResouce((Object)vrms.get(0));
        }
        this.logger.info((Object)("vrm(" + vrmSn + ") has been unRegistered."), 90160758786816L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFcRegistInfos(String siteId, List<String> fcSns) {
        this.logger.trace((Object)(this.trace + " trace message"));
        HibernateTemplate template = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        Session session = template.getSessionFactory().openSession();
        Transaction t = null;
        try {
            t = session.beginTransaction();
            for (String fcSn : fcSns) {
                VRM vrm = this.getVrm(fcSn);
                DrVrm drVrm = VrmUtil.translateVrm((VRM)vrm, (String)siteId);
                session.saveOrUpdate((Object)drVrm);
                Set drHosts = drVrm.getChildResources();
                if (VerifyUtil.isEmpty((Collection)drHosts)) continue;
                this.deleteExistHost(session, drHosts);
                for (DrResource drHost : drHosts) {
                    session.saveOrUpdate((Object)drHost);
                }
            }
            VrmUtil.getSiteById((String)siteId);
            t.commit();
        }
        catch (LegoCheckedException e) {
            this.rollbackSession(t);
            throw e;
        }
        catch (Exception e) {
            this.rollbackSession(t);
            ExceptionUtil.rethrowException((Throwable)e, (String)"Failed to regist FC.", (long)-1L, null, (Log)this.logger);
        }
        finally {
            this.closeSession(session);
        }
    }

    private void rollbackSession(Transaction t) {
        if (null != t) {
            t.rollback();
        }
    }

    private void deleteExistHost(Session session, Set<DrResource> drHosts) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List existHosts = session.createCriteria(DrComputeNode.class).list();
        if (VerifyUtil.isEmpty((Collection)existHosts)) {
            return;
        }
        block0: for (DrComputeNode existHost : existHosts) {
            for (DrResource newHost : drHosts) {
                if (!existHost.getDeviceSn().equals(newHost.getDeviceSn())) continue;
                session.delete((Object)existHost);
                continue block0;
            }
        }
    }

    private void checkRegistIndependenceFcRules(String siteId, List<String> fcSns) {
        this.logger.trace((Object)(this.trace + " trace message"));
        CloudServiceUtil.checkFcRegistRule(siteId, fcSns);
    }

    public synchronized void updateVrm(String vrmId, VrmCommInfo commInfo, boolean changedPw, String optName) {
        this.logger.trace((Object)(this.trace + " trace message"));
        VrmUtil.checkParameter((String)vrmId);
        CloudServiceUtil.checkCommInfoParam(commInfo);
        String vrmUri = CloudServiceUtil.updateExtend(vrmId, commInfo, changedPw, DrVrm.class, this.neMgr);
        VRM vrm = this.getVrmByMoId(vrmId);
        CloudServiceUtil.updateNetworkEntity(commInfo, VrmUtil.generateVrmSn((String)vrmUri), (NetworkEntity)vrm);
        CloudServiceUtil.updateRegistedCloud(commInfo, (NetworkEntity)vrm, DrVrm.class);
        try {
            this.cloudService.refreshVrm(vrm.getSn(), optName);
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to refresh vrm." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786816L);
        }
    }

    public List<DrVrm> getUnregisteredVrmList(Long userId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        List<String> sns = new ArrayList();
        List<VRM> vrms = CloudServiceUtil.getAllLocalMos(VRM.class);
        if (!VerifyUtil.isEmpty(vrms)) {
            for (VRM vrmMo : vrms) {
                sns.add(vrmMo.getSn());
            }
        }
        if (null == (sns = ((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).filterDrResourceSN(sns, userId)) || sns.isEmpty()) {
            return new ArrayList<DrVrm>();
        }
        List<DrVrm> registedDrVrms = CloudServiceUtil.findDrVrms(null, null);
        return CloudServiceUtil.getUnregisteredDrResource(vrms, registedDrVrms, sns);
    }

    public VrmCommInfo getVrmCommInfo(String vrmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        VRM vrm = this.getVrm(vrmSn);
        return this.getVrmCommInfoByMoId(vrm.getMoId().toString());
    }

    public VrmCommInfo getVrmCommInfoByMoId(String moId) {
        this.logger.trace((Object)(this.trace + " trace message"));
        VrmUtil.checkParameter((String)moId);
        NeMgrProtocolExtend extend = VrmUtil.getExtend((String)moId);
        VrmCommInfo result = new VrmCommInfo(extend.getNetworkUserName(), extend.getNetworkPassword(), extend.getNetworkIpAddress(), (String)extend.getExtendParams().get("port"));
        return result;
    }

    public void checkLicense(String vrmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (!this.isVrmSn(vrmSn)) {
            return;
        }
        VRM vrm = this.getVrm(vrmSn);
        VrmObject vrmObj = VrmUtil.generateVrmObj((NeMgrProtocolExtend)VrmUtil.getExtend((String)String.valueOf(vrm.getMoId())));
        this.vrmVirtualResService.checkLicense(vrmObj);
    }

    private String excuteCmdToFcVm(String cloudSn, String vmUri, String cmdType) {
        VMOperateResponseType taskInfo;
        this.logger.trace((Object)(this.trace + " trace message"));
        VrmObject vrmInfo = VrmUtil.getRecoveryVrmObject((String)cloudSn);
        if (VmRecoveryCmdEnum.STOP_VM_SAFE.name().equals(cmdType)) {
            taskInfo = this.vrmVirtualResService.stopVM(vrmInfo, vmUri, StopVmMode.safe);
        } else if (VmRecoveryCmdEnum.STOP_VM_FORCE.name().equals(cmdType)) {
            taskInfo = this.vrmVirtualResService.stopVM(vrmInfo, vmUri, StopVmMode.force);
        } else if (VmRecoveryCmdEnum.DELETE_VM.name().equals(cmdType)) {
            taskInfo = this.vrmVirtualResService.terminateVm(vrmInfo, vmUri, null);
        } else if (VmRecoveryCmdEnum.SET_VM_OCCUPIED.name().equals(cmdType)) {
            taskInfo = this.vrmDrManager.setVMOccupied(vrmInfo, vmUri);
        } else if (VmRecoveryCmdEnum.SYN_VM_CACHE_DATA.name().equals(cmdType)) {
            taskInfo = this.vrmDrManager.synVMDrCache(vrmInfo, vmUri);
        } else if (VmRecoveryCmdEnum.DELETE_DS.name().equals(cmdType)) {
            String[] params = vmUri.split(";");
            if (params.length < 2) {
                this.logger.error((Object)("params length is wrong, length: " + params.length), 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            taskInfo = this.vrmVirtualResService.deleteDatastore(vrmInfo, params[0], params[1]);
        } else if (VmRecoveryCmdEnum.SET_STORAGEMODE.name().equals(cmdType)) {
            taskInfo = this.vrmVirtualResService.setDataStoreMode(vrmInfo, vmUri, new SetDataStoreModeRequestType("protecting"));
        } else {
            this.logger.error((Object)"VmRecoveryCmdEnum is not has appropriate cmdType");
            throw new LegoCheckedException(1073947393L);
        }
        String result = CommonUtil.beanToJson((Object)taskInfo);
        this.logger.info((Object)("Transfer result is " + result), 90160758786816L);
        return result;
    }

    public IVRMDrManager getVrmDrManager() {
        return this.vrmDrManager;
    }

    public void setVrmDrManager(IVRMDrManager vrmDrManager) {
        this.vrmDrManager = vrmDrManager;
    }

    private String excuteCmdToFmVm(String cloudSn, String vmId, String cmdType) {
        this.logger.trace((Object)(this.trace + " trace message"));
        HashMap<String, String> excuteResult = new HashMap<String, String>();
        String taskId = null;
        FmObject fmInfo = FmUtils.generateFmObj((String)cloudSn);
        try {
            if (VmRecoveryCmdEnum.STOP_VM_SAFE.name().equals(cmdType)) {
                taskId = this.fmRetriever.stopVMSafe(fmInfo, vmId);
            } else if (VmRecoveryCmdEnum.STOP_VM_FORCE.name().equals(cmdType)) {
                taskId = this.fmRetriever.stopVMForce(fmInfo, vmId);
            } else if (VmRecoveryCmdEnum.DELETE_VM.name().equals(cmdType)) {
                taskId = this.fmRetriever.deleteVM(fmInfo, vmId);
            } else if (VmRecoveryCmdEnum.SET_VM_OCCUPIED.name().equals(cmdType)) {
                taskId = this.fmRetriever.setOccupiedVM(fmInfo, vmId);
            } else {
                this.logger.error((Object)"VmRecoveryCmdEnum is not has appropriate cmdType");
                throw new LegoCheckedException(1073947393L);
            }
            excuteResult.put("taskId", taskId);
        }
        catch (FmBusinessException e) {
            this.logger.error((Object)("Failed to stop or start vm:" + fmInfo), (Throwable)e, 90160758787071L);
            excuteResult.put("errorCode", e.getErrorCode());
        }
        this.logger.info((Object)("Transfer result is " + taskId), 90160758786816L);
        return JSONObject.fromObject(excuteResult).toString();
    }

    public String excuteCmdToVm(String cloudSn, String params, String cmdType) {
        this.logger.info((Object)("Command type:" + cmdType + ";vrmSn:" + cloudSn + ";params:" + params), 90160758786816L);
        if (null == cloudSn) {
            this.logger.error((Object)"cloudSn is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VmRecoveryCmdEnum.SCAN_FM_DS.name().equals(cmdType)) {
            return this.scanFmDs(cloudSn);
        }
        if (null == params) {
            this.logger.error((Object)"params is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (this.isVrmSn(cloudSn)) {
            return this.excuteCmdToFcVm(cloudSn, params, cmdType);
        }
        return this.excuteCmdToFmVm(cloudSn, params, cmdType);
    }

    private String scanFmDs(String vrmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        Hypervisor hyperV = this.fmService.getHypervisorByVrm(vrmSn);
        FusionManager fm = this.fmService.getDependenceFmByVrm(vrmSn);
        if (null == fm || null == hyperV) {
            this.logger.error((Object)("Failed to get fm or hyperV by vrmSn:" + vrmSn), 90160758787071L);
            throw new LegoCheckedException(1073947394L);
        }
        String hypervisorId = FmUtils.getCommonObjectId((String)hyperV.getUuid(), (String)Hypervisor.class.getSimpleName());
        FmObject fmInfo = FmUtils.generateFmObj((String)fm.getSn());
        String taskId = null;
        try {
            taskId = this.fmRetriever.rescanHyperVRes(fmInfo, hypervisorId, FmScanCriteriaEnum.ALL.getScanType());
        }
        catch (FmBusinessException e) {
            this.logger.error((Object)("Failed to rescanHyperVRes:" + fmInfo), (Throwable)e, 90160758787071L);
        }
        return taskId;
    }

    public String queryVmResult(String cloudSn, String taskUri) {
        String result;
        this.logger.info((Object)("VrmSn:" + cloudSn + ";taskUri:" + taskUri), 90160758786816L);
        if (null == cloudSn || null == taskUri) {
            this.logger.error((Object)"cloudSn or taskUri is null.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            if (this.isVrmSn(cloudSn)) {
                VrmObject vrmInfo = VrmUtil.getRecoveryVrmObject((String)cloudSn);
                VrmTaskType taskType = this.vrmVirtualResService.describeTasks(vrmInfo, taskUri);
                result = CommonUtil.beanToJson((Object)taskType);
            } else {
                FmObject fmInfo = FmUtils.generateFmObj((String)cloudSn);
                ResourcepoolCommonServiceV2Stub.QueryTaskResp response = this.fmRetriever.queryTask(fmInfo, taskUri);
                result = CommonUtil.beanToJson((Object)response);
            }
        }
        catch (FmBusinessException e) {
            this.logger.error((Object)"Failed to transfer result.", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        this.logger.info((Object)("Transfer result is " + result), 90160758786816L);
        return result;
    }

    public String getDatastoreInfos(String vrmSn, String dsUrn) {
        this.logger.info((Object)("VrmSn:" + vrmSn + ";dsUrn:" + dsUrn), 90160758786816L);
        if (null == vrmSn || null == dsUrn) {
            this.logger.error((Object)"vrmSn or dsUrn is null.");
            throw new LegoCheckedException(1073947393L);
        }
        String result = this.vrmVirtualResService.getDatastoreInfos(vrmSn, dsUrn);
        this.logger.info((Object)("Transfer result is " + result), 90160758786816L);
        return result;
    }

    public boolean isVrmSn(String sn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        return sn.startsWith("Dr_Vrm");
    }

    public List<DataStore> getDataStoreListByVrmSn(String vrmSn) {
        this.logger.trace((Object)(this.trace + " trace message"));
        VRM vrm = this.getVrm(vrmSn);
        HashMap<String, VRM> props = new HashMap<String, VRM>();
        props.put("parentMo", vrm);
        List dataStoreInVrm = CommonDAOLocator.getMoDao().findMoBy(DataStore.class, "name", true, props);
        return new ArrayList<DataStore>(dataStoreInVrm);
    }

    public Page pageQueryVmsByCloudSn(String vrmSn, String orderBy, int pageSize, int startPage, boolean isAsc, String filterName, String filterValue) {
        this.logger.trace((Object)(this.trace + " trace message"));
        if (VerifyUtil.isEmpty((String)vrmSn) || VerifyUtil.isEmpty((String)orderBy)) {
            this.logger.error((Object)"parameter vrmSn or orderBy is invalid.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<Criterion> criterionList = new ArrayList<Criterion>();
        criterionList.add((Criterion)Restrictions.eq((String)"topMoUuid", (Object)vrmSn));
        if ("name".equalsIgnoreCase(filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            criterionList.add(Restrictions.ilike((String)"name", (Object)("%" + filterValue + "%")));
        } else if ("status".equalsIgnoreCase(filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            int valueInt = CommUtil.convertToInteger((Object)filterValue);
            criterionList.add((Criterion)Restrictions.eq((String)"status", (Object)valueInt));
        } else if ("ID".equalsIgnoreCase(filterName) && !VerifyUtil.isEmpty((String)filterValue)) {
            criterionList.add(Restrictions.ilike((String)"uri", (Object)("%vms/%" + filterValue + "%")));
        }
        this.addQueryVmIdsCriterion(criterionList, filterName, filterValue);
        return CommonDAOLocator.getBaseDao().pagedQuery(GalaxVM.class, startPage, pageSize, criterionList, orderBy, isAsc);
    }

    private void addQueryVmIdsCriterion(List<Criterion> criterionList, String filterName, String filterValue) {
        if (!"filterVmId".equalsIgnoreCase(filterName) || StringUtils.isEmpty((CharSequence)filterValue)) {
            return;
        }
        Disjunction dis = Restrictions.disjunction();
        List<String> vmIds = Arrays.asList(filterValue.split(","));
        for (String vmId : vmIds) {
            dis.add(Restrictions.ilike((String)"uri", (Object)("%vms/%" + vmId + "%")));
        }
        criterionList.add((Criterion)dis);
    }

    private void closeSession(Session session) {
        this.logger.trace((Object)(this.trace + " trace message"));
        DBOperationUtil.closeSession((Session)session);
    }

    public Set<String> getProtectedVmInOtherVRM(VRM vrm) {
        if (null == vrm) {
            return new HashSet<String>();
        }
        List<RecoveryPlan> plans = this.getRecoveryPlanInTesting();
        if (VerifyUtil.isEmpty(plans)) {
            return new HashSet<String>();
        }
        Hypervisor hypervisor = this.fmService.getHypervisorByVrm(vrm);
        String fmSn = null == hypervisor ? "UNKONWN" : hypervisor.getTopMoUuid();
        return this.getAllVmUuids(vrm, plans, fmSn);
    }

    private Set<String> getAllVmUuids(VRM vrm, List<RecoveryPlan> plans, String fmSn) {
        HashSet<String> result = new HashSet<String>();
        for (RecoveryPlan plan : plans) {
            if (VerifyUtil.isEmpty((Collection)plan.getProtectGroups())) continue;
            for (ProtectGroup pg : plan.getProtectGroups()) {
                if (12 != pg.getPoType() || vrm.getSn().equals(pg.getPoProviderSN()) || fmSn.equals(pg.getPoProviderSN()) || VerifyUtil.isEmpty((Collection)pg.getPolist())) continue;
                for (ProtectObject po : pg.getPolist()) {
                    result.add(po.getMoUuid());
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<RecoveryPlan> getRecoveryPlanInTesting() {
        List list;
        Session session = null;
        String sql = "from RecoveryPlan rp where rp.planStatus in (?, ?, ?, ?, ?)";
        try {
            session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
            Query query = session.createQuery(sql);
            query.setInteger(0, DrmEnumDefine.RecoveryPlanStatusE.TEST_RUNNING.getValue());
            query.setInteger(1, DrmEnumDefine.RecoveryPlanStatusE.TEST_COMPLETED.getValue());
            query.setInteger(2, DrmEnumDefine.RecoveryPlanStatusE.TEST_FAILED.getValue());
            query.setInteger(3, DrmEnumDefine.RecoveryPlanStatusE.CLEAN_RUNNING.getValue());
            query.setInteger(4, DrmEnumDefine.RecoveryPlanStatusE.CLEAN_FAILED.getValue());
            list = query.list();
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("get vm mouuid error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            }
            catch (Throwable throwable) {
                DBOperationUtil.closeSession(session);
                throw throwable;
            }
            DBOperationUtil.closeSession((Session)session);
            return new ArrayList<RecoveryPlan>(0);
        }
        DBOperationUtil.closeSession((Session)session);
        return list;
    }

    public List<String> getInvalidSharedDiskVms(String pgId) {
        return FsRecoveryUtil.getInvalidSharedDiskVms(pgId);
    }

    public List<VmConfigDiskType> getVmConfigDiskTypes(String moUuid, String vrmSn) {
        VerifyUtil.checkStrs((String[])new String[]{moUuid, vrmSn});
        VrmObject vrmObject = VrmUtil.getRecoveryVrmObject((String)vrmSn);
        if (VerifyUtil.isEmpty((Object)vrmObject) || VerifyUtil.isEmpty((String)vrmObject.getIp())) {
            this.logger.warn((Object)"VrmObject is null, moUuid is %s, providerSN is %s.", new Object[]{moUuid, vrmSn});
            return Collections.emptyList();
        }
        GalaxVM galaxVm = (GalaxVM)((IDaoAdapter)ServiceLocator.getInstance().getService(IDaoAdapter.class)).getMo(GalaxVM.class, "uuid", (Object)moUuid);
        if (VerifyUtil.isEmpty((Object)galaxVm) || VerifyUtil.isEmpty((String)galaxVm.getUri())) {
            this.logger.warn((Object)"GalaxVm is empty, moUuid is %s.", new Object[]{moUuid});
            return Collections.emptyList();
        }
        GalaxVM currentVm = this.vrmVirtualResService.queryVmDetailInfo(galaxVm.getUri(), vrmObject);
        if (currentVm == null || VerifyUtil.isEmpty((String)currentVm.getVmConfig())) {
            this.logger.warn((Object)"CurrentVm is empty, uri is %s.", new Object[]{galaxVm.getUri()});
            return Collections.emptyList();
        }
        VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)currentVm.getVmConfig(), VmConfigType.class);
        return vmConfig.getDisks();
    }
}

