/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.soap;

import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.lego.comm.security.BcmX509TrustManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.lang.reflect.Constructor;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.MessageContext;

public final class FMSoapClient {
    private static int transactionIDCounter = 0;
    private static final Log logger = LogFactory.getInstance(FMSoapClient.class);

    private FMSoapClient() {
    }

    public static <T extends Stub> T getInstance(FmObject fmInfo, Class<T> stubClass) {
        if (null == fmInfo) {
            logger.error((Object)"fmInfo is null.");
            throw new LegoCheckedException(1073947393L);
        }
        return FMSoapClient.getInstance(fmInfo.getIp(), String.valueOf(fmInfo.getPort()), stubClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Stub> T getInstance(String ip, String port, Class<T> stubClass) {
        String serviceName = stubClass.getSimpleName().replaceAll("Stub", "");
        String soapUrl = String.format("https://%s:%s/irm/services/%s", ip, port, serviceName);
        Class<FMSoapClient> clazz = FMSoapClient.class;
        synchronized (FMSoapClient.class) {
            try {
                Constructor<T> con = stubClass.getConstructor(String.class);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return (T)((Stub)con.newInstance(soapUrl));
            }
            catch (Exception e) {
                logger.error((Object)e);
                ExceptionUtil.rethrowException((Throwable)e, (String)"new instance error.", (long)-1L, null, (Log)logger);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return null;
            }
        }
    }

    public static void addHeaderOMElement(Stub stub, FmObject fmInfo) {
        FMSoapClient.addHeaderOMElement(stub, fmInfo.getUser(), fmInfo.getPwd(), fmInfo.getPort(), fmInfo.getIp());
    }

    public static void addHeaderOMElement(Stub stub, String user, String password, int port, String ipAddress) {
        ServiceClient serviceClient = stub._getServiceClient();
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement ele = omFactory.createOMElement(new QName("http://idc.huawei.com/schemas/2013-04-10", "IDCAccessId"));
        ele.setText(user);
        serviceClient.addHeader(ele);
        ele = omFactory.createOMElement(new QName("http://idc.huawei.com/schemas/2013-04-10", "IDCPwd"));
        ele.setText(password);
        serviceClient.addHeader(ele);
        ele = omFactory.createOMElement(new QName("http://idc.huawei.com/schemas/2013-04-10", "Encrypt"));
        ele.setText(Boolean.FALSE.toString());
        serviceClient.addHeader(ele);
        String timestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
        ele = omFactory.createOMElement(new QName("http://idc.huawei.com/schemas/2013-04-10", "Timestamp"));
        ele.setText(timestamp);
        serviceClient.addHeader(ele);
        ele = omFactory.createOMElement(new QName("http://idc.huawei.com/schemas/2013-04-10", "TransactionID"));
        if (++transactionIDCounter > 99999999) {
            transactionIDCounter = 0;
        }
        ele.setText(user + timestamp + String.format("%08d", transactionIDCounter));
        serviceClient.addHeader(ele);
        serviceClient.getOptions().setTimeOutInMilliSeconds(600000L);
        SSLContext sslCtx = null;
        try {
            sslCtx = SSLContext.getInstance("TLS");
            sslCtx.init(null, new TrustManager[]{new BcmX509TrustManager(ipAddress)}, SecureRandomFactory.getInstanceStrongWithDRBG());
        }
        catch (NoSuchAlgorithmException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"init Axis error.", (long)1073947395L, null, (Log)logger);
        }
        catch (KeyManagementException e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"init Axis error.", (long)1073947395L, null, (Log)logger);
        }
        serviceClient.getOptions().setProperty("__CHUNKED__", (Object)"false");
    }

    public static String getCode(Stub stub) throws AxisFault {
        ServiceClient client = stub._getServiceClient();
        MessageContext message = client.getLastOperationContext().getMessageContext("In");
        SOAPEnvelope envelope = message.getEnvelope();
        if (envelope == null) {
            return null;
        }
        SOAPHeader soapHeader = envelope.getHeader();
        Iterator list = soapHeader.getChildElements();
        String resultCode = null;
        if (list != null) {
            while (list.hasNext()) {
                OMElement element = (OMElement)list.next();
                if (!element.getLocalName().equalsIgnoreCase("ResultCode")) continue;
                resultCode = element.getText();
            }
        }
        return resultCode;
    }
}

