/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.discovery.synchronizer;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.commons.DiscoverContext;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.CommonTemplate;
import com.huawei.ism.cbb.discover.framework.CommonTemplateManager;
import com.huawei.ism.drm.galax.resource.discovery.service.CloudServiceUtil;
import com.huawei.ism.drm.galax.sdk.model.FusionManager;
import com.huawei.ism.drm.galax.sdk.model.VRM;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.galax.util.common.encrypt.SHAEncrypt;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.AbstractSynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.MoListOrMap;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CloudSynchronizer
extends AbstractSynchronizer {
    private static final Log LOGGER = LogFactory.getInstance(CloudSynchronizer.class);

    public MoListOrMap synchronizeDataAndConstructMo(SynchronizeParameter paramSynchronizeParameter, MoListOrMap paramMoListOrMap) {
        LOGGER.info((Object)"##this is Cloud Synchronizer", 90160758786816L);
        NeMgrProtocolExtend extend = new NeMgrProtocolExtend();
        extend.setNetworkIpAddress(paramSynchronizeParameter.getDeviceIp());
        Map paramMap = paramSynchronizeParameter.getDiscoveryPolicy().getParamMap();
        CloudServiceUtil.checkParamIsValid(paramMap);
        extend.setNetworkUserName((String)paramMap.get("username"));
        HashMap extParam = new HashMap();
        extParam.put("port", paramMap.get("port"));
        this.checkCloudDiscovered(extend.getNetworkIpAddress(), paramSynchronizeParameter.getDiscoveryPolicy().getLocation());
        extend.setExtendParams(extParam);
        extend.setOtherParam(paramSynchronizeParameter.getLocation());
        String deviceType = (String)paramMap.get("devicetype");
        if ("FusionManager".equalsIgnoreCase(deviceType)) {
            extend.setNetworkPassword((String)paramMap.get("password"));
            extend.getExtendParams().put("fmUri", extend.getNetworkIpAddress());
            this.discoverFm(paramSynchronizeParameter, paramMoListOrMap, extend);
        } else if ("FusionCompute".equalsIgnoreCase(deviceType)) {
            extend.setNetworkPassword(SHAEncrypt.encryptSHA256((String)((String)paramMap.get("password"))));
            extend.getExtendParams().put("vrmUri", extend.getNetworkIpAddress());
            this.discoverFc(paramSynchronizeParameter, paramMoListOrMap, extend);
        } else {
            LOGGER.error((Object)("Does't support devicetype : " + deviceType), 90160758786880L);
            throw new LegoCheckedException(1073947393L);
        }
        return null;
    }

    private void discoverFm(SynchronizeParameter paramSynchronizeParameter, MoListOrMap paramMoListOrMap, NeMgrProtocolExtend extend) {
        FusionManager fm = new FusionManager();
        fm.setUuid(extend.getNetworkIpAddress());
        fm.setLinkIp(extend.getNetworkIpAddress());
        fm.setIpAddress(fm.getLinkIp());
        fm.setSn(fm.getUuid());
        fm.setLocation(paramSynchronizeParameter.getLocation());
        DiscoverContext context = new DiscoverContext(paramSynchronizeParameter, paramMoListOrMap);
        context.setAttribute("NeMgrProtocolExtend", (Object)extend);
        context.setAttribute("StorageDevice", (Object)fm);
        String siteId = paramSynchronizeParameter.getDiscoveryPolicy().getLocation();
        context.setAttribute("siteId", (Object)siteId);
        String disCoveryType = "register";
        CommonTemplate discoverTemplate = CommonTemplateManager.getInstance().getDiscoverTemplateByDeviceType("Dr_Fm");
        context.setAttribute("DiscoveryType", (Object)disCoveryType);
        context.setAttribute("OperatorId", (Object)paramSynchronizeParameter.getDiscoveryPolicy().getOperatorId());
        discoverTemplate.process((AbstractContext)context);
    }

    private void discoverFc(SynchronizeParameter paramSynchronizeParameter, MoListOrMap paramMoListOrMap, NeMgrProtocolExtend extend) {
        CommonTemplate discoverTemplate;
        String disCoveryType;
        VRM vrm = new VRM();
        vrm.setUuid(VrmUtil.generateVrmSn((String)extend.getNetworkIpAddress()));
        vrm.setLinkIp(extend.getNetworkIpAddress());
        vrm.setIpAddress(vrm.getLinkIp());
        vrm.setSn(vrm.getUuid());
        vrm.setLocation(paramSynchronizeParameter.getLocation());
        DiscoverContext context = new DiscoverContext(paramSynchronizeParameter, paramMoListOrMap);
        context.setAttribute("NeMgrProtocolExtend", (Object)extend);
        context.setAttribute("StorageDevice", (Object)vrm);
        String siteId = paramSynchronizeParameter.getDiscoveryPolicy().getLocation();
        context.setAttribute("siteId", (Object)siteId);
        if (null == vrm.getSn() || null == CommonDAOLocator.getMoDao().getMo(VRM.class, "sn", (Object)vrm.getSn())) {
            disCoveryType = "register";
            discoverTemplate = CommonTemplateManager.getInstance().getDiscoverTemplateByDeviceType("Dr_Vrm");
        } else {
            disCoveryType = "refresh";
            discoverTemplate = CommonTemplateManager.getInstance().getRefreshTemplateByDeviceType("Dr_Vrm");
        }
        context.setAttribute("DiscoveryType", (Object)disCoveryType);
        context.setAttribute("OperatorId", (Object)paramSynchronizeParameter.getDiscoveryPolicy().getOperatorId());
        discoverTemplate.process((AbstractContext)context);
    }

    private void checkCloudDiscovered(String ip, String siteId) {
        List nes = CommonDAOLocator.getBaseDao().find("from DrResource where ipAddress=? and siteId=?", new Object[]{ip, siteId});
        if (!VerifyUtil.isEmpty((Collection)nes)) {
            LOGGER.error((Object)("Cloud is discovered, ip=" + ip), 90160758786880L);
            throw new LegoCheckedException(1073947431L);
        }
    }
}

