/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.manager.common;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigCPUType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigDiskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigMemType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigNicType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigPropertiesType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.sdk.vrm.model.c10.VmConfigPropsTypeExt;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MaintainVmUtil {
    private static Log log = LogFactory.getInstance(MaintainVmUtil.class);
    private static String trace = "trace";

    public static ResourcepoolVMServiceV2Stub.Nic[] getNic(ResourcepoolVMServiceV2Stub.VMInfo0 vmInfo) {
        log.trace((Object)(trace + " trace message"));
        return vmInfo.getVmConfig().getNics();
    }

    public static ResourcepoolVMServiceV2Stub.Disk[] getFmDisk(ResourcepoolVMServiceV2Stub.VMInfo0 fmVmInfo) {
        log.trace((Object)(trace + " trace message"));
        return fmVmInfo.getVmConfig().getDisks();
    }

    public static List<ResourcepoolVMServiceV2Stub.Nic> getDeleteNicList(ResourcepoolVMServiceV2Stub.Nic[] oldNicList, ResourcepoolVMServiceV2Stub.Nic[] newNicList) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<ResourcepoolVMServiceV2Stub.Nic> deleteNicList = new ArrayList<ResourcepoolVMServiceV2Stub.Nic>();
        for (ResourcepoolVMServiceV2Stub.Nic oldNic : oldNicList) {
            if (null == oldNic || null != MaintainVmUtil.getNicBySequenceNum(oldNic.getSequenceNum(), newNicList)) continue;
            deleteNicList.add(oldNic);
        }
        return deleteNicList;
    }

    public static List<ResourcepoolVMServiceV2Stub.Nic> getAddNicList(ResourcepoolVMServiceV2Stub.Nic[] oldNicList, ResourcepoolVMServiceV2Stub.Nic[] newNicList) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<ResourcepoolVMServiceV2Stub.Nic> addNicList = new ArrayList<ResourcepoolVMServiceV2Stub.Nic>();
        for (ResourcepoolVMServiceV2Stub.Nic newNic : newNicList) {
            if (null == newNic || null != MaintainVmUtil.getNicBySequenceNum(newNic.getSequenceNum(), oldNicList)) continue;
            addNicList.add(newNic);
        }
        return addNicList;
    }

    private static ResourcepoolVMServiceV2Stub.Nic getNicBySequenceNum(int sn, ResourcepoolVMServiceV2Stub.Nic[] nicList) {
        log.trace((Object)(trace + " trace message"));
        for (ResourcepoolVMServiceV2Stub.Nic nic : nicList) {
            if (null == nic || nic.getSequenceNum() != sn) continue;
            return nic;
        }
        return null;
    }

    public static List<ResourcepoolVMServiceV2Stub.Disk> getDeleteDisk(ResourcepoolVMServiceV2Stub.Disk[] oldDiskList, ResourcepoolVMServiceV2Stub.Disk[] newDiskList) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<ResourcepoolVMServiceV2Stub.Disk> deleteDiskList = new ArrayList<ResourcepoolVMServiceV2Stub.Disk>();
        for (ResourcepoolVMServiceV2Stub.Disk oldDisk : oldDiskList) {
            if (null != MaintainVmUtil.getDiskByUuid(oldDisk.getVdiskId(), newDiskList)) continue;
            deleteDiskList.add(oldDisk);
        }
        return deleteDiskList;
    }

    public static List<ResourcepoolVMServiceV2Stub.Disk> getAddDisk(ResourcepoolVMServiceV2Stub.Disk[] oldDiskList, ResourcepoolVMServiceV2Stub.Disk[] newDiskList) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<ResourcepoolVMServiceV2Stub.Disk> addDiskList = new ArrayList<ResourcepoolVMServiceV2Stub.Disk>();
        for (ResourcepoolVMServiceV2Stub.Disk newDisk : newDiskList) {
            if (null != MaintainVmUtil.getDiskByUuid(newDisk.getVdiskId(), oldDiskList)) continue;
            addDiskList.add(newDisk);
        }
        return addDiskList;
    }

    private static ResourcepoolVMServiceV2Stub.Disk getDiskByUuid(String uuid, ResourcepoolVMServiceV2Stub.Disk[] diskList) {
        log.trace((Object)(trace + " trace message"));
        for (ResourcepoolVMServiceV2Stub.Disk disk : diskList) {
            if (!disk.getVdiskId().equals(uuid)) continue;
            return disk;
        }
        return null;
    }

    public static List<VmConfigDiskType> getBasePropsChangedDisk(GalaxVM phVm, GalaxVM galaxVm) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<VmConfigDiskType> changedDiskList = new ArrayList<VmConfigDiskType>();
        List<VmConfigDiskType> oldDiskList = MaintainVmUtil.getFcDisk(phVm);
        List<VmConfigDiskType> newDiskList = MaintainVmUtil.getFcDisk(galaxVm);
        for (VmConfigDiskType newDisk : newDiskList) {
            VmConfigDiskType oldDisk = MaintainVmUtil.getFcDiskByUuid(newDisk.getVolumeUuid(), oldDiskList);
            if (oldDisk == null || !MaintainVmUtil.isBaseDiskPropsChanged(newDisk, oldDisk)) continue;
            newDisk.setVolumeUrn(oldDisk.getVolumeUrn());
            changedDiskList.add(newDisk);
        }
        return changedDiskList;
    }

    private static List<VmConfigDiskType> getFcDisk(GalaxVM galaxVm) {
        log.trace((Object)(trace + " trace message"));
        String vmConfigJson = galaxVm.getVmConfig();
        VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)vmConfigJson, VmConfigType.class);
        List diskList = vmConfig.getDisks();
        Iterator iterator = diskList.iterator();
        while (iterator.hasNext()) {
            if (0 != ((VmConfigDiskType)iterator.next()).getSequenceNum()) continue;
            iterator.remove();
        }
        return diskList;
    }

    private static boolean isBaseDiskPropsChanged(VmConfigDiskType newDisk, VmConfigDiskType oldDisk) {
        log.trace((Object)(trace + " trace message"));
        boolean isPropsChanged = !newDisk.getPersistentDisk().equals(oldDisk.getPersistentDisk()) || !newDisk.getDiskName().equals(oldDisk.getDiskName());
        return isPropsChanged;
    }

    private static VmConfigDiskType getFcDiskByUuid(String uuid, List<VmConfigDiskType> diskList) {
        log.trace((Object)(trace + " trace message"));
        for (VmConfigDiskType disk : diskList) {
            if (!disk.getVolumeUuid().equals(uuid)) continue;
            return disk;
        }
        return null;
    }

    public static VmConfigCPUType getCpu(GalaxVM galaxVm) {
        log.trace((Object)(trace + " trace message"));
        String vmConfigJson = galaxVm.getVmConfig();
        VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)vmConfigJson, VmConfigType.class);
        return vmConfig.getCpu();
    }

    public static VmConfigPropsTypeExt getConfigProperties(GalaxVM galaxVm) {
        log.trace((Object)(trace + " trace message"));
        String vmConfigJson = galaxVm.getVmConfig();
        JSONObject resultObj = JSONObject.fromObject((Object)vmConfigJson);
        String cfgProps = resultObj.getString("properties");
        if (!VerifyUtil.isEmpty((String)cfgProps)) {
            VmConfigPropsTypeExt propsTypeExt = (VmConfigPropsTypeExt)CommonUtil.jsonToBean((String)cfgProps, VmConfigPropsTypeExt.class);
            return propsTypeExt;
        }
        return null;
    }

    public static VmConfigPropertiesType getC00ConfigProperties(GalaxVM galaxVm) {
        log.trace((Object)(trace + " trace message"));
        String vmConfigJson = galaxVm.getVmConfig();
        VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)vmConfigJson, VmConfigType.class);
        return vmConfig.getProperties();
    }

    public static VmConfigMemType getMemory(GalaxVM galaxVm) {
        log.trace((Object)(trace + " trace message"));
        String vmConfigJson = galaxVm.getVmConfig();
        VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)vmConfigJson, VmConfigType.class);
        return vmConfig.getMemory();
    }

    public static List<VmConfigNicType> getNic(GalaxVM galaxVm) {
        log.trace((Object)(trace + " trace message"));
        String vmConfigJson = galaxVm.getVmConfig();
        VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)vmConfigJson, VmConfigType.class);
        return vmConfig.getNics();
    }

    public static List<VmConfigNicType> getDeleteNicList(List<VmConfigNicType> oldNicList, List<VmConfigNicType> newNicList) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<VmConfigNicType> deleteNicList = new ArrayList<VmConfigNicType>();
        for (VmConfigNicType oldNic : oldNicList) {
            if (null != MaintainVmUtil.getNicBySequenceNum(oldNic.getSequenceNum(), newNicList)) continue;
            deleteNicList.add(oldNic);
        }
        return deleteNicList;
    }

    public static List<VmConfigNicType> getAddNicList(List<VmConfigNicType> oldNicList, List<VmConfigNicType> newNicList) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<VmConfigNicType> addNicList = new ArrayList<VmConfigNicType>();
        for (VmConfigNicType newNic : newNicList) {
            if (null != MaintainVmUtil.getNicBySequenceNum(newNic.getSequenceNum(), oldNicList)) continue;
            addNicList.add(newNic);
        }
        return addNicList;
    }

    private static VmConfigNicType getNicBySequenceNum(Integer sn, List<VmConfigNicType> nicList) {
        log.trace((Object)(trace + " trace message"));
        for (VmConfigNicType nic : nicList) {
            if (!nic.getSequenceNum().equals(sn)) continue;
            return nic;
        }
        return null;
    }

    public static List<VmConfigDiskType> getDisk(GalaxVM galaxVm) {
        log.trace((Object)(trace + " trace message"));
        String vmConfigJson = galaxVm.getVmConfig();
        VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)vmConfigJson, VmConfigType.class);
        List diskList = vmConfig.getDisks();
        Iterator iterator = diskList.iterator();
        while (iterator.hasNext()) {
            if (0 != ((VmConfigDiskType)iterator.next()).getSequenceNum()) continue;
            iterator.remove();
        }
        return diskList;
    }

    public static List<VmConfigDiskType> getDeleteDisk(List<VmConfigDiskType> oldDiskList, List<VmConfigDiskType> newDiskList) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<VmConfigDiskType> deleteDiskList = new ArrayList<VmConfigDiskType>();
        for (VmConfigDiskType oldDisk : oldDiskList) {
            if (MaintainVmUtil.getDiskByUuid(oldDisk.getVolumeUuid(), oldDisk.getSequenceNum(), newDiskList) != null) continue;
            deleteDiskList.add(oldDisk);
        }
        return deleteDiskList;
    }

    public static List<VmConfigDiskType> getAddDisk(List<VmConfigDiskType> oldDiskList, List<VmConfigDiskType> newDiskList) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<VmConfigDiskType> addDiskList = new ArrayList<VmConfigDiskType>();
        for (VmConfigDiskType newDisk : newDiskList) {
            if (MaintainVmUtil.getDiskByUuid(newDisk.getVolumeUuid(), newDisk.getSequenceNum(), oldDiskList) != null) continue;
            addDiskList.add(newDisk);
        }
        return addDiskList;
    }

    public static List<VmConfigDiskType> getBasePropsChangedDisk(List<VmConfigDiskType> oldDiskList, List<VmConfigDiskType> newDiskList) {
        log.trace((Object)(trace + " trace message"));
        ArrayList<VmConfigDiskType> changedDiskList = new ArrayList<VmConfigDiskType>();
        for (VmConfigDiskType newDisk : newDiskList) {
            VmConfigDiskType oldDisk = MaintainVmUtil.getDiskByUuid(newDisk.getVolumeUuid(), newDisk.getSequenceNum(), oldDiskList);
            if (oldDisk == null || !MaintainVmUtil.isDiskBasePropsChanged(newDisk, oldDisk)) continue;
            newDisk.setVolumeUrn(oldDisk.getVolumeUrn());
            changedDiskList.add(newDisk);
        }
        return changedDiskList;
    }

    private static boolean isDiskBasePropsChanged(VmConfigDiskType newDisk, VmConfigDiskType oldDisk) {
        log.trace((Object)(trace + " trace message"));
        return !newDisk.getPersistentDisk().equals(oldDisk.getPersistentDisk()) || !newDisk.getDiskName().equals(oldDisk.getDiskName());
    }

    private static VmConfigDiskType getDiskByUuid(String uuid, Integer sequenceNum, List<VmConfigDiskType> diskList) {
        log.trace((Object)(trace + " trace message"));
        for (VmConfigDiskType disk : diskList) {
            if (!disk.getVolumeUuid().equals(uuid) || disk.getSequenceNum().compareTo(sequenceNum) != 0) continue;
            return disk;
        }
        return null;
    }
}

