/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.manager.common;

import com.huawei.ism.drm.galax.constant.cloudenum.VmStatusEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.VmTypeEnum;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.vrm.model.OsOptionsType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigNicType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmMsgsData;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class VirtualResourceMgrUtil {
    private static final Log LOG = LogFactory.getInstance(VirtualResourceMgrUtil.class);

    public static GalaxVM getGalaxVm(VmMsgsData vmInfo) {
        GalaxVM vrVmInfo = null;
        if (vmInfo != null) {
            vrVmInfo = VirtualResourceMgrUtil.setGalaxVmInfo(vmInfo, false);
        }
        return vrVmInfo;
    }

    public static GalaxVM setGalaxVmInfo(VmMsgsData vmInfo, boolean needNic) {
        if (null == vmInfo) {
            return null;
        }
        VmConfigType vmConfig = (VmConfigType)CommonUtil.jsonToBean((String)vmInfo.getVmConfig(), VmConfigType.class);
        if (needNic && !VirtualResourceMgrUtil.isVmHasNic(vmConfig)) {
            return null;
        }
        GalaxVM vrVmInfo = VirtualResourceMgrUtil.buildGalaxVM(vmInfo);
        VmStatusEnum statusEnum = VmStatusEnum.findStatusByValue((String)vmInfo.getStatus());
        vrVmInfo.setStatus(Integer.valueOf(null == statusEnum ? VmStatusEnum.UNKNOWN.getKey() : statusEnum.getKey()));
        if (vmInfo.getVmType().intValue() == VmTypeEnum.PLACE_HOLDER_VM.getStatus()) {
            vrVmInfo.setUuid("P" + vmInfo.getUuid());
        }
        vrVmInfo.setDrStatus(vmInfo.getDrStatus());
        vrVmInfo.setIsMultiDiskSpeedup(vmInfo.getIsMultiDiskSpeedup());
        String group = vmInfo.getGroup();
        if (!VerifyUtil.isEmpty((String)group) && group.startsWith("FM_")) {
            vrVmInfo.setProviderID(GalaxVM.VMProviderType.FM.getValue());
        } else {
            vrVmInfo.setProviderID(GalaxVM.VMProviderType.FC.getValue());
        }
        if (!VirtualResourceMgrUtil.setVMToJsonString(vrVmInfo, vmInfo)) {
            return null;
        }
        VirtualResourceMgrUtil.setVMLocation(vrVmInfo, vmInfo);
        vrVmInfo.setVmConfig(vmInfo.getVmConfig());
        return vrVmInfo;
    }

    private static GalaxVM buildGalaxVM(VmMsgsData vmInfo) {
        GalaxVM vrVmInfo = new GalaxVM();
        vrVmInfo.setName(vmInfo.getName());
        vrVmInfo.setUri(vmInfo.getUri());
        vrVmInfo.setUrn(vmInfo.getUrn());
        vrVmInfo.setDescription(CommonUtil.getDescription((String)vmInfo.getDescription()));
        vrVmInfo.setTemplate(vmInfo.getIsTemplate());
        vrVmInfo.setConfidentialityLevel(vmInfo.getConfidentialityLevel());
        vrVmInfo.setKek(vmInfo.getKek());
        vrVmInfo.setLinkClone(vmInfo.getIsLinkClone());
        vrVmInfo.setOsType(vmInfo.getOsOptions().getOsType());
        vrVmInfo.setOsVersion(String.valueOf(vmInfo.getOsOptions().getOsVersion()));
        vrVmInfo.setUuid(vmInfo.getUuid());
        vrVmInfo.setVmType(vmInfo.getVmType());
        vrVmInfo.setVmCategory(vmInfo.getVmCategory());
        vrVmInfo.setRpoStatus(vmInfo.getRpoStatus());
        vrVmInfo.setInitSyncStatus(vmInfo.getInitSyncStatus());
        vrVmInfo.setDrDrillVmUri(vmInfo.getDrDrillVmUri());
        vrVmInfo.setDrDrillVmUrn(vmInfo.getDrDrillVmUrn());
        vrVmInfo.setCustomProperties(vmInfo.getCustomProperties());
        vrVmInfo.setVmStatus(vmInfo.getStatus());
        return vrVmInfo;
    }

    private static boolean isVmHasNic(VmConfigType vmConfig) {
        if (null == vmConfig) {
            return false;
        }
        List nics = vmConfig.getNics();
        if (null == nics || nics.isEmpty()) {
            return false;
        }
        for (VmConfigNicType nic : nics) {
            if (null == nic) continue;
            return true;
        }
        return false;
    }

    private static boolean setVMToJsonString(GalaxVM vrVmInfo, VmMsgsData vmInfo) {
        try {
            vrVmInfo.setVmConfig(vmInfo.getVmConfig());
            OsOptionsType options = vmInfo.getOsOptions();
            if (options != null) {
                String pass = options.getPassword();
                if (!VerifyUtil.isEmpty((String)pass)) {
                    options.setPassword(WccEncryptor.encrypt((String)pass));
                }
                String osOptions = CommonUtil.beanToJson((Object)options);
                vrVmInfo.setOsOptions(osOptions);
            }
            vrVmInfo.setDataStoreUrns(VirtualResourceMgrUtil.getDataStore(CommonUtil.beanToJson((Object)vmInfo.getDataStoreUrns())));
        }
        catch (Exception e) {
            LOG.error((Object)("Change object to json failed,vmInfo:" + vmInfo.toString() + ExceptionUtil.getErrorMessage((Throwable)e)), -1L);
            return false;
        }
        return true;
    }

    private static void setVMLocation(GalaxVM vrVmInfo, VmMsgsData vmInfo) {
        if (!StringUtils.isBlank((CharSequence)vmInfo.getClusterUrn())) {
            vrVmInfo.setClusterUrn(vmInfo.getClusterUrn());
            vrVmInfo.setBindingHost(Boolean.valueOf(false));
        } else {
            vrVmInfo.setBindingHost(Boolean.valueOf(true));
            vrVmInfo.setHostUrn(vmInfo.getHostUrn());
        }
    }

    private static String getDataStore(String data) {
        try {
            int i = data.indexOf("[");
            int j = data.indexOf("]");
            data = data.substring(i + 1, j);
            data = data.replaceAll("\"", "");
            return data;
        }
        catch (Exception e) {
            LOG.warn((Object)("the datastore is invalid, data=" + data + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786816L);
            return "";
        }
    }
}

