/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.manager.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.sdk.service.IManagementProtocolService;
import com.huawei.ism.cbb.util.DiscParamValidator;
import com.huawei.ism.drm.galax.sdk.model.VrmCommInfo;
import com.huawei.ism.drm.galax.sdk.service.IGalaxMgrProtocol;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class CloudMgrProtocolImpl
implements IGalaxMgrProtocol {
    private static final Log LOG = LogFactory.getInstance(CloudMgrProtocolImpl.class);

    public NeMgrProtocolExtend getMgrProtocol(Long moId) {
        LOG.debug((Object)("CloudMgrProtocolImpl:getMgrProtocol enter, moId=" + moId), 90160758786816L);
        IManagementProtocolService service = (IManagementProtocolService)ServiceLocator.getInstance().getService(IManagementProtocolService.class);
        if (VerifyUtil.isEmpty((Object)service)) {
            return null;
        }
        NeMgrProtocolExtend neMgrProtocolExtend = service.findByMoId(moId);
        Map extparamMap = neMgrProtocolExtend.getExtendParams();
        HashMap newExtParam = new HashMap();
        newExtParam.put("port", extparamMap.get("port"));
        neMgrProtocolExtend.setExtendParams(newExtParam);
        return neMgrProtocolExtend;
    }

    public void validate(NeMgrProtocolExtend neMgrProtocol) {
    }

    public void updateMgrProtocol(NeMgrProtocolExtend neMgrProtocol) {
        LOG.debug((Object)"CloudMgrProtocolImpl:updateMgrProtocol enter.", 90160758786816L);
        if (null == neMgrProtocol || null == neMgrProtocol.getMoId()) {
            LOG.error((Object)"parameter is null or moId is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        Long moId = neMgrProtocol.getMoId();
        VrmCommInfo commInfo = this.getCloudBaseInfo(String.valueOf(moId));
        boolean isPwdChanged = false;
        if (neMgrProtocol.isModifyAuthInfo()) {
            String userName = neMgrProtocol.getNetworkUserName();
            this.checkUserName(userName);
            commInfo.setUserName(userName);
            if (!VerifyUtil.isEmpty((String)neMgrProtocol.getNetworkPassword())) {
                isPwdChanged = true;
                this.checkPwd(neMgrProtocol.getNetworkPassword());
                commInfo.setPassword(neMgrProtocol.getNetworkPassword());
            }
            String port = this.getNePort(neMgrProtocol.getExtendParams());
            commInfo.setPort(port);
            String ipAddr = neMgrProtocol.getNetworkIpAddress();
            this.checkIpAddr(ipAddr);
            commInfo.setIp(ipAddr);
        }
        this.updateCloud(String.valueOf(moId), commInfo, isPwdChanged);
        LOG.debug((Object)"CloudResMgrProtocolImpl:updateMgrProtocol leave.", 90160758786816L);
    }

    public String getSubResType() {
        return null;
    }

    protected abstract VrmCommInfo getCloudBaseInfo(String var1);

    protected abstract void updateCloud(String var1, VrmCommInfo var2, boolean var3);

    private void checkPwd(String pwd) {
        if (pwd.length() < 1 || pwd.length() > 32) {
            LOG.error((Object)"Password does not meet the requirements");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkIpAddr(String ipAddr) {
        if (VerifyUtil.isEmpty((String)ipAddr) || !CommonUtil.isIpValid((String)ipAddr)) {
            LOG.error((Object)"ipAddr is empty or is not valid.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkUserName(String userName) {
        if (VerifyUtil.isEmpty((String)userName) || userName.length() < 1 || userName.length() > 32) {
            LOG.error((Object)"user name is invalid.", 90160758787071L);
            throw new LegoCheckedException(1073948931L);
        }
    }

    private String getNePort(Map<String, String> param) {
        if (VerifyUtil.isEmpty(param)) {
            LOG.error((Object)"update action has no externed parameter.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        String port = param.get("port");
        if (VerifyUtil.isEmpty((String)port)) {
            LOG.error((Object)"can not find the port parameter.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        try {
            int intPort = Integer.parseInt(port);
            if (!DiscParamValidator.isPort((int)intPort)) {
                LOG.error((Object)("The parameter of Cloud Port is invalid, intPort=" + intPort), 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)("The parameter of Cloud Port is error, port=" + port), 90160758787071L);
            throw new LegoCheckedException(1073947393L, (Throwable)e);
        }
        return port;
    }
}

