/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.manager.impl;

import com.huawei.idc.wsdl._2014_03_15.ResourcepoolCommonServiceV2Stub;
import com.huawei.idc.wsdl._2014_03_15.ResourcepoolNetServiceV2Stub;
import com.huawei.idc.wsdl._2014_03_15.ResourcepoolVMServiceV2Stub;
import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.drm.galax.resource.discovery.soap.FMSoapClient;
import com.huawei.ism.drm.galax.resource.manager.impl.FMManagerCommon;
import com.huawei.ism.drm.galax.sdk.model.FmNetwork;
import com.huawei.ism.drm.galax.sdk.model.Hypervisor;
import com.huawei.ism.drm.galax.sdk.model.SecurityGroup;
import com.huawei.ism.drm.galax.sdk.model.VDC;
import com.huawei.ism.drm.galax.sdk.model.VPC;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.model.FmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.VersionInfo;
import com.huawei.ism.drm.galax.sdk.vrm.service.IFMInfosRetriever;
import com.huawei.ism.drm.galax.util.cloud.FmUtils;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;

public class FMInfosRetriever
implements IFMInfosRetriever {
    private static Log logger = LogFactory.getInstance(FMInfosRetriever.class);
    private static final String FM_VERSION_R5C00 = "V100R005C00";
    private static final int TIME_INTERVAL = 1;
    private String trace = "trace";
    private FMManagerCommon fmManagerCommon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FmObject login(NeMgrProtocolExtend extend) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(extend);
        logger.debug((Object)("begin login in FusionManager, ip=" + extend.getNetworkIpAddress()), 90160758786816L);
        ResourcepoolCommonServiceV2Stub.QuerySysInfoResponseE response = null;
        String resultCode = null;
        String port = (String)extend.getExtendParams().get("port");
        if (VerifyUtil.isEmpty((String)port)) {
            logger.error((Object)"can not get the port of FM.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        ResourcepoolCommonServiceV2Stub commonStub = FMSoapClient.getInstance(extend.getNetworkIpAddress(), port, ResourcepoolCommonServiceV2Stub.class);
        ResourcepoolCommonServiceV2Stub.QuerySysInfo querySysInfo = new ResourcepoolCommonServiceV2Stub.QuerySysInfo();
        ResourcepoolCommonServiceV2Stub.QuerySysInfoRequest param = new ResourcepoolCommonServiceV2Stub.QuerySysInfoRequest();
        querySysInfo.setQuerySysInfoRequest(param);
        ResourcepoolCommonServiceV2Stub resourcepoolCommonServiceV2Stub = commonStub;
        synchronized (resourcepoolCommonServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)commonStub, extend.getNetworkUserName(), extend.getNetworkPassword(), Integer.parseInt(port), extend.getNetworkIpAddress());
                response = commonStub.querySysInfo(querySysInfo);
                logger.debug((Object)"end querySysInfo, ipAddress : %s ", new Object[]{extend.getNetworkIpAddress()});
                resultCode = FMSoapClient.getCode((Stub)commonStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("IpAddress : " + extend.getNetworkIpAddress() + ", failed to querySysInfo from FusionManager."), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(commonStub._getServiceClient());
            }
        }
        if (null == response) {
            return null;
        }
        ResourcepoolCommonServiceV2Stub.QuerySysInfoResponse res = response.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        FmObject fmInfo = null;
        if (res != null) {
            fmInfo = new FmObject(extend, new VersionInfo(null, this.getVersion(res.getVersion())), res.getSn());
        }
        logger.debug((Object)("end login in FusionManager, sn=" + (null == fmInfo ? null : fmInfo.getUrn())), 90160758786816L);
        return fmInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourcepoolCommonServiceV2Stub.OrgInfo> queryOrgs(FmObject fmInfo) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo);
        logger.debug((Object)("begin query ORG from FusionManager, ip=" + fmInfo.getIp()), 90160758786816L);
        ResourcepoolCommonServiceV2Stub commonStub = FMSoapClient.getInstance(fmInfo, ResourcepoolCommonServiceV2Stub.class);
        ResourcepoolCommonServiceV2Stub.QueryOrg queryOrg = new ResourcepoolCommonServiceV2Stub.QueryOrg();
        ResourcepoolCommonServiceV2Stub.QueryOrgsRequest param = new ResourcepoolCommonServiceV2Stub.QueryOrgsRequest();
        queryOrg.setQueryOrgsRequest(param);
        ResourcepoolCommonServiceV2Stub.QueryOrgResponse response = null;
        String resultCode = null;
        ResourcepoolCommonServiceV2Stub resourcepoolCommonServiceV2Stub = commonStub;
        synchronized (resourcepoolCommonServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)commonStub, fmInfo);
                response = commonStub.queryOrg(queryOrg);
                logger.debug((Object)"end queryOrg, ip : %s", new Object[]{fmInfo.getIp()});
                resultCode = FMSoapClient.getCode((Stub)commonStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Ip : " + fmInfo.getIp() + ", failed to queryOrgs from FusionManager."), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(commonStub._getServiceClient());
            }
        }
        if (null == response) {
            logger.warn((Object)"result of  query ORG from FusionManager is null.", 90160758787071L);
            return new ArrayList<ResourcepoolCommonServiceV2Stub.OrgInfo>();
        }
        ResourcepoolCommonServiceV2Stub.QueryOrgsResponse res = response.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        logger.debug((Object)"end query ORG from FusionManager.", 90160758786816L);
        if (res != null && res.getOrgsInfo() != null) {
            return Arrays.asList(res.getOrgsInfo());
        }
        return new ArrayList<ResourcepoolCommonServiceV2Stub.OrgInfo>();
    }

    public List<VDC> queryVDCs(FmObject fmInfo) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo);
        logger.debug((Object)("begin query VDCS from FusionManager, ip=" + fmInfo.getIp()), 90160758786816L);
        ArrayList<VDC> vdcs = new ArrayList<VDC>();
        List<ResourcepoolCommonServiceV2Stub.OrgInfo> orgs = this.queryOrgs(fmInfo);
        for (ResourcepoolCommonServiceV2Stub.OrgInfo org : orgs) {
            VDC vdc = new VDC(org.getOrgId());
            vdc.setUuid(FmUtils.getFmResourceUrn((String)fmInfo.getUrn(), (String)VDC.class.getSimpleName(), (String)org.getOrgId()));
            vdc.setName(org.getOrgName());
            vdcs.add(vdc);
        }
        logger.debug((Object)("end query ORG from FusionManager, result=" + vdcs), 90160758786816L);
        return vdcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VPC> queryVPCsByOrg(FmObject fmInfo, String orgId) throws FmBusinessException {
        ResourcepoolNetServiceV2Stub.VPCInOrg[] vpcInfos;
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo, orgId);
        logger.debug((Object)("begin query VPCS by ORG from FusionManager, ip=" + fmInfo.getIp()), 90160758786816L);
        ResourcepoolNetServiceV2Stub netStub = FMSoapClient.getInstance(fmInfo, ResourcepoolNetServiceV2Stub.class);
        ResourcepoolNetServiceV2Stub.QueryVPCByOrg queryVPCsByOrg = new ResourcepoolNetServiceV2Stub.QueryVPCByOrg();
        ResourcepoolNetServiceV2Stub.QueryVPCByOrgReq param = new ResourcepoolNetServiceV2Stub.QueryVPCByOrgReq();
        param.setOrgId(orgId);
        queryVPCsByOrg.setQueryVPCByOrgReq(param);
        ArrayList<VPC> vpcs = new ArrayList<VPC>();
        ResourcepoolNetServiceV2Stub.QueryVPCByOrgResponse response = null;
        String resultCode = null;
        ResourcepoolNetServiceV2Stub resourcepoolNetServiceV2Stub = netStub;
        synchronized (resourcepoolNetServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)netStub, fmInfo);
                response = netStub.queryVPCByOrg(queryVPCsByOrg);
                logger.debug((Object)"end queryVPCByOrg, ip : %s", new Object[]{fmInfo.getIp()});
                resultCode = FMSoapClient.getCode((Stub)netStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Ip : " + fmInfo.getIp() + ", failed to queryVPCsByVDC from FusionManager."), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(netStub._getServiceClient());
            }
        }
        if (null == response) {
            logger.warn((Object)"result of query VPC by ORG from FusionManager is null.", 90160758787071L);
            return vpcs;
        }
        ResourcepoolNetServiceV2Stub.QueryVPCByOrgResp res = response.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        if (res == null || res.getVpcsInOrg() == null) {
            return vpcs;
        }
        for (ResourcepoolNetServiceV2Stub.VPCInOrg v : vpcInfos = res.getVpcsInOrg()) {
            if (v == null) continue;
            VPC vpc = new VPC(v.getOrgId());
            vpc.setUuid(FmUtils.getFmResourceUrn((String)fmInfo.getUrn(), (String)VPC.class.getSimpleName(), (String)v.getVpcId()));
            vpc.setName(this.getVpcName(v));
            vpcs.add(vpc);
        }
        logger.debug((Object)("end query VPCS by ORG from FusionManager, result=" + vpcs), 90160758786816L);
        return vpcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VPC> queryAllVPC(FmObject fmInfo) throws FmBusinessException {
        ArrayList<VPC> vpcs;
        block15: {
            String resultCode;
            logger.trace((Object)(this.trace + " trace message"));
            this.fmManagerCommon.checkParametersNotEmpty(fmInfo);
            logger.debug((Object)("begin query all VPCS from FusionManager, ip=" + fmInfo.getIp()), 90160758786816L);
            vpcs = new ArrayList<VPC>();
            ResourcepoolNetServiceV2Stub netStub = FMSoapClient.getInstance(fmInfo, ResourcepoolNetServiceV2Stub.class);
            int limit = 100;
            int offset = 0;
            while (true) {
                ResourcepoolNetServiceV2Stub.QueryAllVPC queryVpc = new ResourcepoolNetServiceV2Stub.QueryAllVPC();
                ResourcepoolNetServiceV2Stub.QueryAllVPCReq queryCRequest = new ResourcepoolNetServiceV2Stub.QueryAllVPCReq();
                queryCRequest.setLimit(limit);
                queryCRequest.setOffset(offset);
                queryVpc.setQueryAllVPCReq(queryCRequest);
                ResourcepoolNetServiceV2Stub.QueryAllVPCResponse response = null;
                resultCode = null;
                ResourcepoolNetServiceV2Stub resourcepoolNetServiceV2Stub = netStub;
                synchronized (resourcepoolNetServiceV2Stub) {
                    try {
                        FMSoapClient.addHeaderOMElement((Stub)netStub, fmInfo);
                        response = netStub.queryAllVPC(queryVpc);
                        logger.debug((Object)"end queryAllVPC, ip : %s ", new Object[]{fmInfo.getIp()});
                        resultCode = FMSoapClient.getCode((Stub)netStub);
                    }
                    catch (Exception e) {
                        ExceptionUtil.rethrowException((Throwable)e, (String)("Ip : " + fmInfo.getIp() + ", failed to queryAllVPC from FusionManager."), (long)1073947399L, null, (Log)logger);
                    }
                    finally {
                        this.fmManagerCommon.cleanupTransport(netStub._getServiceClient());
                    }
                }
                if (null == response) {
                    return vpcs;
                }
                ResourcepoolNetServiceV2Stub.QueryAllVPCResp res = response.get_return();
                if (res == null) break;
                this.fmManagerCommon.handleBusinessException(resultCode, res.getFaultString());
                Object[] vpcInfos = res.getVpcs();
                if (VerifyUtil.isEmpty((Object[])vpcInfos)) {
                    logger.warn((Object)"vpc infors is empty, maybe it is end.", 90160758786816L);
                } else {
                    for (Object v : vpcInfos) {
                        if (v == null) continue;
                        VPC vpc = new VPC();
                        vpc.setUuid(FmUtils.getFmResourceUrn((String)fmInfo.getUrn(), (String)VPC.class.getSimpleName(), (String)v.getVpcId()));
                        vpc.setName(this.getVpcName((ResourcepoolNetServiceV2Stub.VPCBasicInfo)v));
                        vpcs.add(vpc);
                    }
                    if (vpcInfos.length >= limit) {
                        offset += limit;
                        continue;
                    }
                }
                break block15;
                break;
            }
            logger.warn((Object)"result of query vpc is null, maybe it is end.", 90160758786816L);
            this.fmManagerCommon.handleBusinessException(resultCode, null);
        }
        logger.debug((Object)("end query all VPCS from FusionManager, result=" + vpcs), 90160758786816L);
        return vpcs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Hypervisor> queryHyperviors(FmObject fmInfo) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo);
        logger.debug((Object)("begin query hyperviors from FusionManager, ip=" + fmInfo.getIp()), 90160758786816L);
        ResourcepoolCommonServiceV2Stub commonStub = FMSoapClient.getInstance(fmInfo, ResourcepoolCommonServiceV2Stub.class);
        ResourcepoolCommonServiceV2Stub.QueryHypervisorsByDc queryHypervisorsByDc = new ResourcepoolCommonServiceV2Stub.QueryHypervisorsByDc();
        ResourcepoolCommonServiceV2Stub.QueryHypervisorsByDcRequest param = new ResourcepoolCommonServiceV2Stub.QueryHypervisorsByDcRequest();
        queryHypervisorsByDc.setQueryHypervisorsByDcRequest(param);
        ArrayList<Hypervisor> hyperViors = new ArrayList<Hypervisor>();
        ResourcepoolCommonServiceV2Stub.QueryHypervisorsByDcResponseE response = null;
        String resultCode = null;
        ResourcepoolCommonServiceV2Stub resourcepoolCommonServiceV2Stub = commonStub;
        synchronized (resourcepoolCommonServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)commonStub, fmInfo);
                response = commonStub.queryHypervisorsByDc(queryHypervisorsByDc);
                logger.debug((Object)"end queryHypervisorsByDc, ip : %s ", new Object[]{fmInfo.getIp()});
                resultCode = FMSoapClient.getCode((Stub)commonStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Ip : " + fmInfo.getIp() + ", failed to queryHyperviors."), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(commonStub._getServiceClient());
            }
        }
        if (null == response) {
            logger.warn((Object)"result of query hyperviors from FusionManager is null.", 90160758787071L);
            return hyperViors;
        }
        ResourcepoolCommonServiceV2Stub.QueryHypervisorsByDcResponse res = response.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        if (res != null && res.getHypervisorsInfo() != null) {
            ResourcepoolCommonServiceV2Stub.HypervisorsInfo[] hyperInfos;
            for (ResourcepoolCommonServiceV2Stub.HypervisorsInfo h : hyperInfos = res.getHypervisorsInfo()) {
                if (h == null) continue;
                ResourcepoolCommonServiceV2Stub.ConnectorInfo c = h.getConnector();
                Hypervisor hyper = new Hypervisor(h.getVendor(), h.getVersion(), h.getType(), c.getIp(), c.getPort(), c.getProtocol());
                hyper.setUuid(FmUtils.getFmResourceUrn((String)fmInfo.getUrn(), (String)Hypervisor.class.getSimpleName(), (String)h.getHypervisorId()));
                hyper.setName(h.getHypervisorName());
                hyperViors.add(hyper);
            }
        }
        logger.debug((Object)("end query hyperviors from FusionManager, result=" + hyperViors), 90160758786816L);
        return hyperViors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SecurityGroup> querySecurityGroupsByVPC(FmObject fmInfo, String vpcId) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo, vpcId);
        logger.debug((Object)("begin query SecurityGroup from FusionManager, ip=" + fmInfo.getIp() + ", vpcId=" + vpcId), 90160758786816L);
        ArrayList<SecurityGroup> securityGroups = new ArrayList<SecurityGroup>();
        ResourcepoolNetServiceV2Stub netStub = FMSoapClient.getInstance(fmInfo, ResourcepoolNetServiceV2Stub.class);
        ResourcepoolNetServiceV2Stub.QuerySEGsByVPC querySEGsByVPC = new ResourcepoolNetServiceV2Stub.QuerySEGsByVPC();
        ResourcepoolNetServiceV2Stub.QuerySEGsByVPCRequest param = new ResourcepoolNetServiceV2Stub.QuerySEGsByVPCRequest();
        param.setVpcId(vpcId);
        querySEGsByVPC.setQuerySEGsByVPCRequest(param);
        ResourcepoolNetServiceV2Stub.QuerySEGsByVPCResponseE response = null;
        String resultCode = null;
        ResourcepoolNetServiceV2Stub resourcepoolNetServiceV2Stub = netStub;
        synchronized (resourcepoolNetServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)netStub, fmInfo);
                response = netStub.querySEGsByVPC(querySEGsByVPC);
                logger.debug((Object)"end querySEGsByVPC, ip : %s, vpcId : %s", new Object[]{fmInfo.getIp(), vpcId});
                resultCode = FMSoapClient.getCode((Stub)netStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to querySecurityGroupsByVDC. vdcId : " + vpcId + ", ip :" + fmInfo.getIp()), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(netStub._getServiceClient());
            }
        }
        if (null == response) {
            logger.warn((Object)"result of query SecurityGroup from FusionManager is null.", 90160758787071L);
            return securityGroups;
        }
        ResourcepoolNetServiceV2Stub.QuerySEGsByVPCResponse res = response.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        if (res != null && res.getSegsInfo() != null) {
            ResourcepoolNetServiceV2Stub.SegInfo[] segInfos;
            for (ResourcepoolNetServiceV2Stub.SegInfo s : segInfos = res.getSegsInfo()) {
                if (s == null) continue;
                SecurityGroup sg = new SecurityGroup(vpcId);
                sg.setUuid(FmUtils.getFmResourceUrn((String)fmInfo.getUrn(), (String)SecurityGroup.class.getSimpleName(), (String)s.getSegId()));
                sg.setName(s.getSegName());
                securityGroups.add(sg);
            }
        }
        logger.debug((Object)("end query SecurityGroup from FusionManager, result=" + securityGroups), 90160758786816L);
        return securityGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FmNetwork> queryNetworksByVPC(FmObject fmInfo, String vpcId) throws FmBusinessException {
        List<FmNetwork> fmDirectNetworkList;
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo, vpcId);
        logger.debug((Object)("begin query Networks from FusionManager, ip=" + fmInfo.getIp() + ", vpcId=" + vpcId), 90160758786816L);
        ResourcepoolNetServiceV2Stub netStub = FMSoapClient.getInstance(fmInfo, ResourcepoolNetServiceV2Stub.class);
        ResourcepoolNetServiceV2Stub.QueryNetwork queryNetwork = new ResourcepoolNetServiceV2Stub.QueryNetwork();
        ResourcepoolNetServiceV2Stub.QueryNetworkReq param = new ResourcepoolNetServiceV2Stub.QueryNetworkReq();
        param.setVpcID(vpcId);
        queryNetwork.setQueryNetworkReq(param);
        ArrayList<FmNetwork> fmNetworkList = new ArrayList<FmNetwork>();
        ResourcepoolNetServiceV2Stub.QueryNetworkResponse networksResponse = null;
        String resultCode = null;
        ResourcepoolNetServiceV2Stub resourcepoolNetServiceV2Stub = netStub;
        synchronized (resourcepoolNetServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)netStub, fmInfo);
                networksResponse = netStub.queryNetwork(queryNetwork);
                logger.debug((Object)"end queryOrg, ip : %s, vpcId : %s", new Object[]{fmInfo.getIp(), vpcId});
                resultCode = FMSoapClient.getCode((Stub)netStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to queryNetworksByVPC. vpcId : " + vpcId + ", ip : " + fmInfo.getIp()), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(netStub._getServiceClient());
            }
        }
        if (null == networksResponse) {
            logger.warn((Object)"result of query Networks from FusionManager is null.", 90160758787071L);
            return fmNetworkList;
        }
        ResourcepoolNetServiceV2Stub.QueryNetworkResp res = networksResponse.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        if (res != null && res.getNetworks() != null) {
            ResourcepoolNetServiceV2Stub.NetworkSet[] networkSet;
            for (ResourcepoolNetServiceV2Stub.NetworkSet net : networkSet = res.getNetworks()) {
                if (net == null) continue;
                FmNetwork fmNet = new FmNetwork();
                fmNet.setUuid(FmUtils.getFmResourceUrn((String)fmInfo.getUrn(), (String)FmNetwork.class.getSimpleName(), (String)net.getNetworkID()));
                fmNet.setName(net.getName());
                fmNetworkList.add(fmNet);
            }
        }
        if (!VerifyUtil.isEmpty(fmDirectNetworkList = this.queryDirectNetwork(fmInfo, vpcId))) {
            fmNetworkList.addAll(fmDirectNetworkList);
        }
        logger.debug((Object)("end query Networks from FusionManager, result=" + fmNetworkList), 90160758786816L);
        return fmNetworkList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FmNetwork> queryDirectNetwork(FmObject fmInfo, String vpcId) throws FmBusinessException {
        ResourcepoolNetServiceV2Stub.DirectNetworkSet[] networkSet;
        logger.trace((Object)(this.trace + " trace message"));
        ResourcepoolNetServiceV2Stub netStub = FMSoapClient.getInstance(fmInfo, ResourcepoolNetServiceV2Stub.class);
        logger.debug((Object)("begin query direct Network from FusionManager, ip=" + fmInfo.getIp() + ", vpcId=" + vpcId), 90160758786816L);
        ResourcepoolNetServiceV2Stub.QueryDirectNetwork request = new ResourcepoolNetServiceV2Stub.QueryDirectNetwork();
        ResourcepoolNetServiceV2Stub.QueryDirectNetworkReq param = new ResourcepoolNetServiceV2Stub.QueryDirectNetworkReq();
        param.setVpcID(vpcId);
        request.setQueryDirectNetworkReq(param);
        ArrayList<FmNetwork> fmNetworkList = new ArrayList<FmNetwork>();
        ResourcepoolNetServiceV2Stub.QueryDirectNetworkResponse networksResponse = null;
        String resultCode = null;
        ResourcepoolNetServiceV2Stub resourcepoolNetServiceV2Stub = netStub;
        synchronized (resourcepoolNetServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)netStub, fmInfo);
                networksResponse = netStub.queryDirectNetwork(request);
                logger.debug((Object)"end queryDirectNetwork, ip : %s, vpcId : %s ", new Object[]{fmInfo.getIp(), vpcId});
                resultCode = FMSoapClient.getCode((Stub)netStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to queryNetworksByVPC. vpcId : " + vpcId + ", ip : " + fmInfo.getIp()), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(netStub._getServiceClient());
            }
        }
        if (null == networksResponse) {
            return fmNetworkList;
        }
        ResourcepoolNetServiceV2Stub.QueryDirectNetworkResp res = networksResponse.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        if (res == null || res.getDirectNetworks() == null) {
            return fmNetworkList;
        }
        for (ResourcepoolNetServiceV2Stub.DirectNetworkSet net : networkSet = res.getDirectNetworks()) {
            if (net == null) continue;
            FmNetwork fmNet = new FmNetwork();
            fmNet.setUuid(FmUtils.getFmResourceUrn((String)fmInfo.getUrn(), (String)FmNetwork.class.getSimpleName(), (String)net.getNetworkID()));
            fmNet.setName(net.getDirectNetworkName());
            fmNetworkList.add(fmNet);
        }
        return fmNetworkList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rescanHyperVRes(FmObject fmInfo, String hypervisorId, String scanCriteria) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo, hypervisorId);
        logger.info((Object)("begin rescan Hypervisor from FusionManager, ip=" + fmInfo.getIp() + ", hypervisorId=" + hypervisorId), 90160758786816L);
        ResourcepoolCommonServiceV2Stub commonStub = FMSoapClient.getInstance(fmInfo, ResourcepoolCommonServiceV2Stub.class);
        ResourcepoolCommonServiceV2Stub.RescanHyperVRes request = new ResourcepoolCommonServiceV2Stub.RescanHyperVRes();
        ResourcepoolCommonServiceV2Stub.RescanHyperVResRequest param = new ResourcepoolCommonServiceV2Stub.RescanHyperVResRequest();
        param.setHyperVId(hypervisorId);
        param.setScanCriteria(scanCriteria);
        request.setRescanHyperVResRequest(param);
        ResourcepoolCommonServiceV2Stub.RescanHyperVResResponseE response = null;
        String resultCode = null;
        ResourcepoolCommonServiceV2Stub resourcepoolCommonServiceV2Stub = commonStub;
        synchronized (resourcepoolCommonServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)commonStub, fmInfo);
                response = commonStub.rescanHyperVRes(request);
                logger.debug((Object)"end rescanHyperVRes, ip : %s, hypervisorId : %s ", new Object[]{fmInfo.getIp(), hypervisorId});
                resultCode = FMSoapClient.getCode((Stub)commonStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Ip :" + fmInfo.getIp() + ", hypervisorId : " + hypervisorId + ", failed to rescanHyperVRes."), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(commonStub._getServiceClient());
            }
        }
        if (null == response) {
            logger.warn((Object)"result of rescan Hypervisor is null.", 90160758787071L);
            return null;
        }
        ResourcepoolCommonServiceV2Stub.RescanHyperVResResponse res = response.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        String taskId = res == null ? null : res.getTaskId();
        logger.info((Object)("end rescan Hypervisor from FusionManager, taskId=" + taskId), 90160758786816L);
        return taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourcepoolCommonServiceV2Stub.QueryTaskResp queryTask(FmObject fmInfo, String taskId) throws FmBusinessException {
        ResourcepoolCommonServiceV2Stub.QueryTaskResponse response;
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo, taskId);
        logger.debug((Object)("begin query task from FusionManager, ip=" + fmInfo.getIp() + ", taskId=" + taskId), 90160758786816L);
        ResourcepoolCommonServiceV2Stub commonStub = FMSoapClient.getInstance(fmInfo, ResourcepoolCommonServiceV2Stub.class);
        ResourcepoolCommonServiceV2Stub.QueryTask request = new ResourcepoolCommonServiceV2Stub.QueryTask();
        ResourcepoolCommonServiceV2Stub.QueryTaskReq param = new ResourcepoolCommonServiceV2Stub.QueryTaskReq();
        param.setTaskID(taskId);
        request.setQueryTaskReq(param);
        ResourcepoolCommonServiceV2Stub resourcepoolCommonServiceV2Stub = commonStub;
        synchronized (resourcepoolCommonServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)commonStub, fmInfo);
                response = this.queryTask(commonStub, request, 3);
                logger.debug((Object)"end queryTask, ip : %s, taskId : %s", new Object[]{fmInfo.getIp(), taskId});
            }
            catch (Exception e) {
                response = null;
                ExceptionUtil.rethrowException((Throwable)e, (String)("Ip : " + fmInfo.getIp() + "taskId : " + taskId + ", failed to queryTaskState."), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(commonStub._getServiceClient());
            }
        }
        if (null == response) {
            logger.error((Object)"response is null.", 90160758787071L);
            return null;
        }
        ResourcepoolCommonServiceV2Stub.QueryTaskResp queryTaskResp = response.get_return();
        if (null == queryTaskResp) {
            logger.error((Object)"queryTaskResp is null.", 90160758787071L);
            return null;
        }
        String resultCode = queryTaskResp.getResultCode();
        if (VerifyUtil.isEmpty((String)resultCode)) {
            resultCode = "00000000";
        }
        this.fmManagerCommon.handleBusinessException(resultCode, queryTaskResp.getFaultString());
        logger.debug((Object)("end query task from FusionManager, task status=" + queryTaskResp.getStatus()), 90160758786816L);
        return queryTaskResp;
    }

    private ResourcepoolCommonServiceV2Stub.QueryTaskResponse queryTask(ResourcepoolCommonServiceV2Stub commonStub, ResourcepoolCommonServiceV2Stub.QueryTask request, int retryNum) {
        logger.trace((Object)(this.trace + " trace message"));
        ResourcepoolCommonServiceV2Stub.QueryTaskResponse response = null;
        try {
            response = commonStub.queryTask(request);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to queryTask." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            if (retryNum >= 0) {
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e1) {
                    logger.error((Object)"Retry to queryTask sleep error.", 90160758787071L);
                }
                logger.error((Object)("Retry to queryTask, num: " + retryNum), 90160758787071L);
                response = this.queryTask(commonStub, request, --retryNum);
            }
            logger.error((Object)"Retry to queryTask num finish.", 90160758787071L);
            ExceptionUtil.rethrowException((Exception)e, (String)"init Axis error.", (long)1073947399L, null);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResourcepoolCommonServiceV2Stub.DataStoreInfo> queryDatastoreMap(FmObject fmInfo, String hypervisorId, String datasotreUrn) throws FmBusinessException {
        ResourcepoolCommonServiceV2Stub.DataStoreInfo[] dsArray;
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo, hypervisorId, datasotreUrn);
        logger.debug((Object)("begin query datastore map from FusionManager, ip=" + fmInfo.getIp() + ", hypervisorId=" + hypervisorId + ", datasotreUrn" + datasotreUrn), 90160758786816L);
        ResourcepoolCommonServiceV2Stub commonStub = FMSoapClient.getInstance(fmInfo, ResourcepoolCommonServiceV2Stub.class);
        ResourcepoolCommonServiceV2Stub.QueryDatastoreMap request = new ResourcepoolCommonServiceV2Stub.QueryDatastoreMap();
        ResourcepoolCommonServiceV2Stub.QueryDatastoreMapRequest param = new ResourcepoolCommonServiceV2Stub.QueryDatastoreMapRequest();
        param.setHyperVId(hypervisorId);
        param.setVdataStoreURN(datasotreUrn);
        request.setQueryDatastoreMapRequest(param);
        ResourcepoolCommonServiceV2Stub.QueryDatastoreMapResponseE response = null;
        String resultCode = null;
        ResourcepoolCommonServiceV2Stub resourcepoolCommonServiceV2Stub = commonStub;
        synchronized (resourcepoolCommonServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)commonStub, fmInfo);
                response = commonStub.queryDatastoreMap(request);
                logger.debug((Object)"end queryDatastoreMap, ip : %s, hypervisorId : %s, datasotreUrn : %s ", new Object[]{fmInfo.getIp(), hypervisorId, datasotreUrn});
                resultCode = FMSoapClient.getCode((Stub)commonStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Ip :" + fmInfo.getIp() + ", hypervisorId :" + hypervisorId + ", datasotreUrn :" + datasotreUrn + ", failed to queryDatastoreMap."), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(commonStub._getServiceClient());
            }
        }
        if (null == response) {
            logger.warn((Object)"result of query datastore map from FusionManager is null.", 90160758787071L);
            return new ArrayList<ResourcepoolCommonServiceV2Stub.DataStoreInfo>();
        }
        ResourcepoolCommonServiceV2Stub.QueryDatastoreMapResponse res = response.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        if (res != null && (dsArray = res.getDataStoreList()) != null) {
            logger.debug((Object)("end query datastore map from FusionManager, size=" + dsArray.length), 90160758786816L);
            return Arrays.asList(dsArray);
        }
        logger.debug((Object)"end query datastore map from FusionManager, size=0.", 90160758786816L);
        return new ArrayList<ResourcepoolCommonServiceV2Stub.DataStoreInfo>();
    }

    public String startVM(FmObject fmInfo, String vmId) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        return this.actVM(fmInfo, vmId, 1, 0);
    }

    public String resumeVM(FmObject fmInfo, String vmId, int resumeOption) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        return this.actVM(fmInfo, vmId, 7, resumeOption);
    }

    public String stopVMSafe(FmObject fmInfo, String vmId) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        try {
            return this.actVM(fmInfo, vmId, 4, 0);
        }
        catch (FmBusinessException e) {
            if ("00030127".equals(e.getErrorCode())) {
                return this.actVM(fmInfo, vmId, 6, 0);
            }
            throw e;
        }
    }

    public String stopVMForce(FmObject fmInfo, String vmId) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        return this.actVM(fmInfo, vmId, 6, 0);
    }

    public String pauseVM(FmObject fmInfo, String vmId) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        return this.actVM(fmInfo, vmId, 2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String actVM(FmObject fmInfo, String vmId, int actType, int resumeOption) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo, vmId);
        logger.debug((Object)("begin actVM from FusionManager, ip=" + fmInfo.getIp() + ", vmId=" + vmId + ", actType" + actType), 90160758786816L);
        ResourcepoolVMServiceV2Stub vmStub = FMSoapClient.getInstance(fmInfo, ResourcepoolVMServiceV2Stub.class);
        ResourcepoolVMServiceV2Stub.ActVMResponse response = null;
        String resultCode = null;
        ResourcepoolVMServiceV2Stub.ActVM request = new ResourcepoolVMServiceV2Stub.ActVM();
        ResourcepoolVMServiceV2Stub.ActVMReq param = new ResourcepoolVMServiceV2Stub.ActVMReq();
        param.setVmID(vmId);
        param.setActType(actType);
        if (actType == 7) {
            param.setResumeOption(resumeOption);
        }
        request.setActVMReq(param);
        ResourcepoolVMServiceV2Stub resourcepoolVMServiceV2Stub = vmStub;
        synchronized (resourcepoolVMServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)vmStub, fmInfo);
                response = vmStub.actVM(request);
                logger.debug((Object)"end actVM, ip : %s, vmId : %s, actType : %s ", new Object[]{fmInfo.getIp(), vmId, actType});
                resultCode = FMSoapClient.getCode((Stub)vmStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to actVM. act : " + actType + ",vm : " + vmId + "ip : " + fmInfo.getIp()), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(vmStub._getServiceClient());
            }
        }
        if (null == response) {
            logger.error((Object)"the reponse of actVM is null.", 90160758787071L);
            throw new LegoCheckedException(1073947399L);
        }
        ResourcepoolVMServiceV2Stub.ActVMResp res = response.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        String taskId = res == null ? null : res.getTaskID();
        logger.info((Object)("end actVM from FusionManager, taskId =" + taskId), 90160758786816L);
        return taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deleteVM(FmObject fmInfo, String vmId) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo, vmId);
        logger.debug((Object)("begin deleteVM from FusionManager, ip=" + fmInfo.getIp() + ", vmId=" + vmId), 90160758786816L);
        ResourcepoolVMServiceV2Stub vmStub = FMSoapClient.getInstance(fmInfo, ResourcepoolVMServiceV2Stub.class);
        ResourcepoolVMServiceV2Stub.DeleteVM request = new ResourcepoolVMServiceV2Stub.DeleteVM();
        ResourcepoolVMServiceV2Stub.DeleteVMReq param = new ResourcepoolVMServiceV2Stub.DeleteVMReq();
        param.setVmID(vmId);
        param.setForcedClearRes(true);
        request.setDeleteVMReq(param);
        logger.debug((Object)("DeleteVm from Fm. fmIp is" + fmInfo.toString() + ", vmId = " + vmId), 90160758786816L);
        ResourcepoolVMServiceV2Stub.DeleteVMResponse response = null;
        String resultCode = null;
        ResourcepoolVMServiceV2Stub resourcepoolVMServiceV2Stub = vmStub;
        synchronized (resourcepoolVMServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)vmStub, fmInfo);
                response = vmStub.deleteVM(request);
                logger.debug((Object)"end deleteVM, ip : %s, vmId : %s ", new Object[]{fmInfo.getIp(), vmId});
                resultCode = FMSoapClient.getCode((Stub)vmStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to deleteVM. vm : " + vmId + "ip : " + fmInfo.getIp()), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(vmStub._getServiceClient());
            }
        }
        if (null == response) {
            logger.warn((Object)"result of deleteVM from FusionManager is null.", 90160758787071L);
            return null;
        }
        ResourcepoolVMServiceV2Stub.DeleteVMResp res = response.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        String taskId = res == null ? null : res.getTaskID();
        logger.debug((Object)("end deleteVM from FusionManager, taskId=" + taskId), 90160758786816L);
        return taskId;
    }

    public List<ResourcepoolVMServiceV2Stub.VMInfo0> queryVMs(FmObject fmInfo, String hypervisorId, List<String> vmIds) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo, vmIds);
        ArrayList<ResourcepoolVMServiceV2Stub.VMInfo0> vmInfos = new ArrayList<ResourcepoolVMServiceV2Stub.VMInfo0>();
        for (int i = 0; i < vmIds.size(); i += 50) {
            List<ResourcepoolVMServiceV2Stub.VMInfo0> fifty = this.queryVMsForFifty(fmInfo, hypervisorId, vmIds.subList(i, i + 50 > vmIds.size() ? vmIds.size() : i + 50), true);
            if (VerifyUtil.isEmpty(fifty)) continue;
            vmInfos.addAll(fifty);
        }
        return vmInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResourcepoolVMServiceV2Stub.VMInfo0> queryVMsForFifty(FmObject fmInfo, String hypervisorId, List<String> vmIds, boolean checkExcpetion) throws FmBusinessException {
        ResourcepoolVMServiceV2Stub.VMInfo0[] vmsArray;
        logger.trace((Object)(this.trace + " trace message"));
        ResourcepoolVMServiceV2Stub vmStub = FMSoapClient.getInstance(fmInfo, ResourcepoolVMServiceV2Stub.class);
        logger.debug((Object)("begin queryVMsForFifty from FusionManager, ip=" + fmInfo.getIp() + ", hypervisorId" + hypervisorId + ", vmIds=" + vmIds), 90160758786816L);
        ResourcepoolVMServiceV2Stub.QueryVM2 request = new ResourcepoolVMServiceV2Stub.QueryVM2();
        ResourcepoolVMServiceV2Stub.QueryVM2Req param = new ResourcepoolVMServiceV2Stub.QueryVM2Req();
        if (VerifyUtil.isEmpty((String)hypervisorId)) {
            param.setVmIDs(vmIds.toArray(new String[vmIds.size()]));
        } else {
            ResourcepoolVMServiceV2Stub.VVMId fcVm = new ResourcepoolVMServiceV2Stub.VVMId();
            fcVm.setHyperVID(hypervisorId);
            fcVm.setVVMURNs(vmIds.toArray(new String[vmIds.size()]));
            param.setVVMId(fcVm);
        }
        request.setQueryVM2Req(param);
        String resultCode = null;
        ResourcepoolVMServiceV2Stub.QueryVM2Response response = null;
        ResourcepoolVMServiceV2Stub resourcepoolVMServiceV2Stub = vmStub;
        synchronized (resourcepoolVMServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)vmStub, fmInfo);
                response = vmStub.queryVM2(request);
                logger.debug((Object)"end queryVM2, ip : %s, hypervisorId : %s, vmIds : %s", new Object[]{fmInfo.getIp(), hypervisorId, vmIds});
                resultCode = FMSoapClient.getCode((Stub)vmStub);
            }
            catch (AxisFault e) {
                logger.error((Object)("Ip :" + fmInfo.getIp() + ", hypervisorId : " + hypervisorId + ", vmIds : " + vmIds + ", failed to queryVMs2."), (Throwable)e, 90160758787071L);
                ExceptionUtil.rethrowException((Throwable)e, (String)"init Axis error.", (long)1073947399L, null, (Log)logger);
            }
            catch (RemoteException e) {
                logger.error((Object)("Ip : " + fmInfo.getIp() + ", hypervisorId : " + hypervisorId + ", vmIds : " + vmIds + ", failed to queryVMs2."), (Throwable)e, 90160758787071L);
                ExceptionUtil.rethrowException((Throwable)e, (String)"init Axis error.", (long)1073947399L, null, (Log)logger);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Ip : " + fmInfo.getIp() + ", hypervisorId : " + hypervisorId + ", vmIds : " + vmIds + ", failed to queryVMs2."), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(vmStub._getServiceClient());
            }
        }
        if (null == response) {
            logger.warn((Object)"result of queryVMsForFifty from FusionManager is null.", 90160758787071L);
            return new ArrayList<ResourcepoolVMServiceV2Stub.VMInfo0>();
        }
        ResourcepoolVMServiceV2Stub.QueryVM2Resp res = response.get_return();
        if (checkExcpetion) {
            this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        }
        if (res != null && (vmsArray = res.getVms()) != null) {
            logger.debug((Object)("end queryVMsForFifty from FusionManager, size=" + vmsArray.length), 90160758786816L);
            List<ResourcepoolVMServiceV2Stub.VMInfo0> vmInfo0s = Arrays.asList(vmsArray);
            return this.filterNullValue(vmInfo0s);
        }
        logger.debug((Object)"end queryVMsForFifty from FusionManager, size=0.", 90160758786816L);
        return new ArrayList<ResourcepoolVMServiceV2Stub.VMInfo0>();
    }

    private List<ResourcepoolVMServiceV2Stub.VMInfo0> filterNullValue(List<ResourcepoolVMServiceV2Stub.VMInfo0> objs) {
        logger.trace((Object)(this.trace + " trace message"));
        ArrayList<ResourcepoolVMServiceV2Stub.VMInfo0> vmInfo0s = new ArrayList<ResourcepoolVMServiceV2Stub.VMInfo0>();
        if (VerifyUtil.isEmpty(objs)) {
            return vmInfo0s;
        }
        for (ResourcepoolVMServiceV2Stub.VMInfo0 vm : objs) {
            if (null == vm) continue;
            vmInfo0s.add(vm);
        }
        return vmInfo0s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourcepoolVMServiceV2Stub.RestoreVMResponse restoreVM(FmObject fmInfo, String postVPCId, ResourcepoolVMServiceV2Stub.VMInfo vmInfo) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo);
        logger.debug((Object)("begin restoreVM from FusionManager, ip=" + fmInfo.getIp() + ", postVPCId" + postVPCId + ", vmUuid=" + vmInfo.getVmUUId()), 90160758786816L);
        ResourcepoolVMServiceV2Stub vmStub = FMSoapClient.getInstance(fmInfo, ResourcepoolVMServiceV2Stub.class);
        ResourcepoolVMServiceV2Stub.RestoreVM request = new ResourcepoolVMServiceV2Stub.RestoreVM();
        ResourcepoolVMServiceV2Stub.RestoreVMRequest param = new ResourcepoolVMServiceV2Stub.RestoreVMRequest();
        param.setPostVPCId(postVPCId);
        param.setVmInfo(vmInfo);
        request.setRestoreVMRequest(param);
        String resultCode = null;
        ResourcepoolVMServiceV2Stub.RestoreVMResponseE response = null;
        ResourcepoolVMServiceV2Stub resourcepoolVMServiceV2Stub = vmStub;
        synchronized (resourcepoolVMServiceV2Stub) {
            try {
                String requestStr = CommonUtil.beanToJson((Object)request);
                logger.debug((Object)("[restoreVM]request is:" + requestStr), 90160758786816L);
                FMSoapClient.addHeaderOMElement((Stub)vmStub, fmInfo);
                response = vmStub.restoreVM(request);
                logger.debug((Object)"end restoreVM, ip : %s, postVPCId : %s, vmUuid : %s ", new Object[]{fmInfo.getIp(), postVPCId, vmInfo.getVmUUId()});
                resultCode = FMSoapClient.getCode((Stub)vmStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to restoreVM. vm : " + vmInfo.getName() + "ip : " + fmInfo.getIp() + "postVPCId : " + postVPCId + "vmUuid : " + vmInfo.getVmUUId()), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(vmStub._getServiceClient());
            }
        }
        logger.debug((Object)"[restoreVM]response is: %s", new Object[]{null == response ? response : CommonUtil.beanToJson((Object)response)});
        if (null == response) {
            logger.warn((Object)"result of restoreVM from FusionManager is null.", 90160758787071L);
            return null;
        }
        ResourcepoolVMServiceV2Stub.RestoreVMResponse res = response.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        logger.info((Object)"end restoreVM from FusionManager.", 90160758786816L);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setOccupiedVM(FmObject fmInfo, String vmID) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo, vmID);
        logger.debug((Object)("begin setOccupiedVM from FusionManager, ip=" + fmInfo.getIp() + ", vmID=" + vmID), 90160758786816L);
        ResourcepoolVMServiceV2Stub vmStub = FMSoapClient.getInstance(fmInfo, ResourcepoolVMServiceV2Stub.class);
        ResourcepoolVMServiceV2Stub.SetOccupiedVMResponse response = null;
        String resultCode = null;
        ResourcepoolVMServiceV2Stub resourcepoolVMServiceV2Stub = vmStub;
        synchronized (resourcepoolVMServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)vmStub, fmInfo);
                ResourcepoolVMServiceV2Stub.SetOccupiedVM setOccupiedVm = new ResourcepoolVMServiceV2Stub.SetOccupiedVM();
                ResourcepoolVMServiceV2Stub.SetOccupiedVMReq request = new ResourcepoolVMServiceV2Stub.SetOccupiedVMReq();
                request.setVmId(vmID);
                setOccupiedVm.setReq(request);
                response = vmStub.setOccupiedVM(setOccupiedVm);
                logger.debug((Object)"end setOccupiedVM, ip : %s, vmID : %s", new Object[]{fmInfo.getIp(), vmID});
                resultCode = FMSoapClient.getCode((Stub)vmStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to createVM. ip : " + fmInfo.getIp() + "vmID : " + vmID), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(vmStub._getServiceClient());
            }
        }
        if (null == response) {
            logger.warn((Object)"result of setOccupiedVM from FusionManager is null.", 90160758787071L);
            return null;
        }
        ResourcepoolVMServiceV2Stub.SetOccupiedVMResp res = response.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        String taskId = res == null ? null : res.getTaskID();
        logger.info((Object)("end setOccupiedVM from FusionManager, taskId=" + taskId), 90160758786816L);
        return taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourcepoolNetServiceV2Stub.ElasticIP queryElasticIpInfo(FmObject fmInfo, String vpcId, String ip) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo, ip, vpcId);
        logger.debug((Object)("begin queryElasticIpInfo from FusionManager, ip=" + fmInfo.getIp() + ", vpcId=" + vpcId + ", ip=" + ip), 90160758786816L);
        ResourcepoolNetServiceV2Stub netStub = FMSoapClient.getInstance(fmInfo, ResourcepoolNetServiceV2Stub.class);
        ResourcepoolNetServiceV2Stub.QueryElasticIP queryPublicIp = new ResourcepoolNetServiceV2Stub.QueryElasticIP();
        ResourcepoolNetServiceV2Stub.QueryElasticIPReq param = new ResourcepoolNetServiceV2Stub.QueryElasticIPReq();
        param.setVpcID(vpcId);
        param.setIp(ip);
        queryPublicIp.setQueryElasticIPReq(param);
        ResourcepoolNetServiceV2Stub.QueryElasticIPResponse response = null;
        String resultCode = null;
        ResourcepoolNetServiceV2Stub resourcepoolNetServiceV2Stub = netStub;
        synchronized (resourcepoolNetServiceV2Stub) {
            try {
                FMSoapClient.addHeaderOMElement((Stub)netStub, fmInfo);
                response = netStub.queryElasticIP(queryPublicIp);
                logger.debug((Object)"end queryElasticIP, ip : %s, vpcId : %s", new Object[]{ip, vpcId});
                resultCode = FMSoapClient.getCode((Stub)netStub);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to queryElasticIp from FusionManager's VPC. ip : " + ip + "vpcId :" + vpcId), (long)1073947399L, null, (Log)logger);
            }
            finally {
                this.fmManagerCommon.cleanupTransport(netStub._getServiceClient());
            }
        }
        if (null == response) {
            logger.warn((Object)"result of queryElasticIpInfo from FusionManager is null.", 90160758787071L);
            return null;
        }
        ResourcepoolNetServiceV2Stub.QueryElasticIPResp res = response.get_return();
        this.fmManagerCommon.handleBusinessException(resultCode, res != null ? res.getFaultString() : null);
        if (res != null && res.getElasticIPs() != null) {
            Object[] elasticIPs = res.getElasticIPs();
            if (VerifyUtil.isEmpty((Object[])elasticIPs)) {
                logger.debug((Object)"end queryElasticIpInfo from FusionManager, there is no ElasticIP.", 90160758786816L);
                return null;
            }
            logger.debug((Object)"end queryElasticIpInfo from FusionManager.", 90160758786816L);
            return elasticIPs[0];
        }
        logger.debug((Object)"end queryElasticIpInfo from FusionManager, there is no ElasticIP.", 90160758786816L);
        return null;
    }

    public void setFmManagerCommon(FMManagerCommon fmManagerCommon) {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon = fmManagerCommon;
    }

    public FMManagerCommon getFmManagerCommon() {
        logger.trace((Object)(this.trace + " trace message"));
        return this.fmManagerCommon;
    }

    private String getVpcName(ResourcepoolNetServiceV2Stub.VPCBasicInfo vpc) {
        logger.trace((Object)(this.trace + " trace message"));
        StringBuilder builder = new StringBuilder();
        builder.append(vpc.getVpcName());
        builder.append('_');
        builder.append(vpc.getVpcId());
        return builder.toString();
    }

    private String getVpcName(ResourcepoolNetServiceV2Stub.VPCInOrg vpc) {
        logger.trace((Object)(this.trace + " trace message"));
        StringBuilder builder = new StringBuilder();
        builder.append(vpc.getVpcName());
        builder.append('_');
        builder.append(vpc.getVpcId());
        return builder.toString();
    }

    private String getVersion(String version) {
        logger.trace((Object)(this.trace + " trace message"));
        return version.contains(FM_VERSION_R5C00) ? "v5.0" : "v5.1";
    }

    public List<ResourcepoolVMServiceV2Stub.VMInfo0> queryVMInfos(FmObject fmInfo, String hypervisorId, List<String> vmIds) throws FmBusinessException {
        logger.trace((Object)(this.trace + " trace message"));
        this.fmManagerCommon.checkParametersNotEmpty(fmInfo, vmIds);
        ArrayList<ResourcepoolVMServiceV2Stub.VMInfo0> vmInfos = new ArrayList<ResourcepoolVMServiceV2Stub.VMInfo0>();
        for (int i = 0; i < vmIds.size(); i += 50) {
            List<ResourcepoolVMServiceV2Stub.VMInfo0> fifty = this.queryVMsForFifty(fmInfo, hypervisorId, vmIds.subList(i, i + 50 > vmIds.size() ? vmIds.size() : i + 50), false);
            if (VerifyUtil.isEmpty(fifty)) continue;
            vmInfos.addAll(fifty);
        }
        return vmInfos;
    }
}

