/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.manager.impl;

import com.huawei.ism.drm.galax.sdk.vrm.model.FmBusinessException;
import com.huawei.ism.drm.galax.sdk.vrm.service.IFMInfosRetriever;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FMInfosRetrieverInvocationHandler
implements InvocationHandler {
    private static final long DEFAULT_TIMEOUT = 600L;
    private static final Log LOGGER = LogFactory.getInstance(FMInfosRetrieverInvocationHandler.class);
    private static ExecutorService newCachedExcutor = Executors.newCachedThreadPool();
    private IFMInfosRetriever fmRetriever;
    private long timeout;

    public FMInfosRetrieverInvocationHandler(IFMInfosRetriever fmRetriever, long timeout) {
        this.fmRetriever = fmRetriever;
        this.timeout = timeout;
    }

    public FMInfosRetrieverInvocationHandler(IFMInfosRetriever fmRetriever) {
        this(fmRetriever, 600L);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        StubMethodInvoker invoker = new StubMethodInvoker(this.fmRetriever, method, args);
        FutureTask<Object> futureTask = new FutureTask<Object>(invoker);
        Throwable exception = null;
        try {
            newCachedExcutor.execute(futureTask);
            return futureTask.get(this.timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("FMInfosRetrieverInvocationHandler invoke error:" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            exception = new LegoCheckedException(1073947399L);
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)("FMInfosRetrieverInvocationHandler invoke error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            Throwable cause = e.getCause();
            if (cause instanceof InvocationTargetException) {
                exception = (InvocationTargetException)cause;
            }
        }
        catch (TimeoutException e) {
            LOGGER.error((Object)("FMInfosRetrieverInvocationHandler invoke error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            exception = new LegoCheckedException(1073947399L);
        }
        if (null == exception) {
            return null;
        }
        if (!futureTask.isCancelled()) {
            futureTask.cancel(true);
        }
        if (exception instanceof InvocationTargetException) {
            exception = this.convertException((Exception)exception);
        }
        throw exception;
    }

    private Exception convertException(Exception exception) {
        if (exception instanceof InvocationTargetException) {
            Throwable throwable = ((InvocationTargetException)exception).getTargetException();
            if (throwable instanceof InvocationTargetException) {
                Throwable throwablesec = ((InvocationTargetException)throwable).getTargetException();
                if (throwablesec instanceof LegoCheckedException) {
                    exception = (LegoCheckedException)throwablesec;
                } else if (throwable instanceof FmBusinessException) {
                    exception = (FmBusinessException)throwable;
                }
            } else if (throwable instanceof LegoCheckedException) {
                exception = (LegoCheckedException)throwable;
            } else if (throwable instanceof FmBusinessException) {
                exception = (FmBusinessException)throwable;
            }
        }
        return exception;
    }

    static class StubMethodInvoker
    implements Callable<Object> {
        private Method method;
        private Object[] args;
        private IFMInfosRetriever object;

        private StubMethodInvoker(IFMInfosRetriever object, Method method, Object[] args) {
            this.object = object;
            this.method = method;
            this.args = args;
        }

        @Override
        public Object call() throws IllegalAccessException, InvocationTargetException {
            if (null == this.method) {
                return null;
            }
            int retryNum = 3;
            while (true) {
                try {
                    return this.method.invoke((Object)this.object, this.args);
                }
                catch (InvocationTargetException e) {
                    Throwable throwable = e.getTargetException();
                    if (throwable instanceof LegoCheckedException) {
                        retryNum = this.dealLegoException(retryNum, e, throwable);
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }

        private int dealLegoException(int retryNum, InvocationTargetException e, Throwable throwable) throws InvocationTargetException {
            LegoCheckedException legoException = (LegoCheckedException)throwable;
            if (retryNum <= 0 || legoException.getErrorCode() != 1073947399L) {
                throw e;
            }
            this.sleepForRetry();
            LOGGER.error((Object)("IFMInfosRetriever retry: " + retryNum), (Throwable)legoException, 90160758787071L);
            return --retryNum;
        }

        private void sleepForRetry() {
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e1) {
                LOGGER.error((Object)"Retry to queryTask sleep error.", 90160758787071L);
            }
        }
    }
}

