/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.manager.impl;

import com.huawei.ism.drm.galax.resource.manager.impl.VirtualResourceManagerCommon;
import com.huawei.ism.drm.galax.resource.manager.impl.VrmResource;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.vrm.model.AddNicRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.AttachVolRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ChangeDsStorageUnitRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ChangeDsStorageUnitResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ChangeVMDrAgentRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ChangeVMDrAgentResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.CreateDrDrillVMRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.CreateVMRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.CreateVMResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.CreateVolRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.CreateVolResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.DetachVolRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.HostMsgsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListSystemIntfResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ResumeDrVmRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.SetVmDrRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.StartVMDrRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.SystemIntfMsgsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.UpdateNicRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.UpdateVolRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VMDrProgressResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VMOperateResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVRMDrManager;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class VRMDrManagerProxy
implements IVRMDrManager {
    private static final Log LOG = LogFactory.getInstance(VRMDrManagerProxy.class);
    private static final int BUSSINESS_MANAGER_INTF = 2;
    private static final long SLEEP_TIME = 5000L;
    private static final String TASK_CONFICTS = "10300162";
    private VirtualResourceManagerCommon vrmCommon;
    private VrmResource vrmResource;
    private IVirtualResourceManager virtualResourceManager;

    public VMOperateResponseType setVMDr(VrmObject vrmInfo, String vmUri, SetVmDrRequestType request) {
        LOG.info((Object)("Enter into setVMDr " + vrmInfo + ",vmUri=" + vmUri + ", request=" + request), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.checkSetVmDrRequest(request);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/setdr";
        VMOperateResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, request, VMOperateResponseType.class);
        LOG.info((Object)("Leave setVMDr. ret=" + reply), 90160758786816L);
        return reply;
    }

    public VMOperateResponseType startVMDr(VrmObject vrmInfo, String vmUri, StartVMDrRequestType request) {
        LOG.info((Object)("Enter into startVMDr " + vrmInfo + ", vmUri=" + vmUri + ",request=" + request), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/startdr";
        VMOperateResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, request, VMOperateResponseType.class);
        LOG.info((Object)("Leave startVMDr. ret=" + reply), 90160758786816L);
        return reply;
    }

    public VMOperateResponseType pauseVMDr(VrmObject vrmInfo, String vmUri) {
        LOG.info((Object)("Enter into pauseVMDr " + vrmInfo + ", vmUri=" + vmUri), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/pausedr";
        VMOperateResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, null, VMOperateResponseType.class);
        LOG.info((Object)("Leave pauseVMDr. ret=" + reply), 90160758786816L);
        return reply;
    }

    public VMOperateResponseType resumeVMDr(VrmObject vrmInfo, String vmUri) {
        LOG.info((Object)("Enter into resumeVMDr " + vrmInfo + ", vmUri=" + vmUri), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/resumedr";
        VMOperateResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, null, VMOperateResponseType.class);
        LOG.info((Object)("Leave resumeVMDr. ret=" + reply), 90160758786816L);
        return reply;
    }

    public VMOperateResponseType removeVMDr(VrmObject vrmInfo, String vmUri) {
        LOG.info((Object)("Enter into removeVMDr " + vrmInfo + ", vmUri=" + vmUri), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/removedr";
        VMOperateResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, null, VMOperateResponseType.class);
        LOG.info((Object)("Leave removeVMDr. ret=" + reply), 90160758786816L);
        return reply;
    }

    public int queryVMDrProgress(VrmObject vrmInfo, String vmUri) {
        LOG.debug((Object)("Enter into queryVMDrProgress " + vrmInfo + ", vmUri=" + vmUri), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/drprogress";
        VMDrProgressResponseType reply = this.getVrmResource().getVrmResource(vrmInfo, url, VMDrProgressResponseType.class);
        LOG.debug((Object)"Leave queryVMDrProgress.", 90160758786816L);
        if (reply == null || reply.getErrorCode() != null) {
            String errorCode = null;
            if (reply != null) {
                errorCode = reply.getErrorCode();
            }
            LOG.error((Object)("queryVMDrProgress failed, errorcode is " + errorCode), 90160758787071L);
            return -1;
        }
        return reply.getProgress();
    }

    public VMOperateResponseType synVMDrCache(VrmObject vrmInfo, String vmUri) {
        LOG.info((Object)("Enter into synVMDrCache " + vrmInfo + ", vmUri=" + vmUri), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/syncache";
        VMOperateResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, null, VMOperateResponseType.class);
        LOG.info((Object)("Leave synVMDrCache. ret=" + reply), 90160758786816L);
        return reply;
    }

    public VMOperateResponseType createVMDrSnap(VrmObject vrmInfo, String vmUri) {
        LOG.info((Object)("Enter into createVMDrSnap " + vrmInfo + ", vmUri=" + vmUri), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/createdrsnap";
        VMOperateResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, null, VMOperateResponseType.class);
        LOG.info((Object)("Leave createVMDrSnap. ret=" + reply), 90160758786816L);
        return reply;
    }

    public VMOperateResponseType setVMOccupied(VrmObject vrmInfo, String vmUri) {
        LOG.info((Object)("Enter into setVMOccupied " + vrmInfo + ", vmUri=" + vmUri), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/setoccupied";
        VMOperateResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, null, VMOperateResponseType.class);
        LOG.info((Object)("Leave setVMOccupied. ret=" + reply), 90160758786816L);
        return reply;
    }

    public VMOperateResponseType resumeDrVM(VrmObject vrmInfo, String vmUri, ResumeDrVmRequestType request) {
        LOG.info((Object)("Enter into resumeDrVM " + vrmInfo + ", vmUri=" + vmUri + ", request=" + request), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/resumedrvm";
        VMOperateResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, request, VMOperateResponseType.class);
        LOG.info((Object)("Leave resumeDrVM. ret=" + reply), 90160758786816L);
        return reply;
    }

    public CreateVMResponseType createDrDrillVM(VrmObject vrmInfo, String vmUri, CreateDrDrillVMRequestType request) {
        LOG.info((Object)("Enter into createDrDrillVM " + vrmInfo + ", vmUri=" + vmUri), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        this.checkCreateDrDrillVMRequest(request);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/clone";
        CreateVMResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, request, CreateVMResponseType.class);
        LOG.info((Object)("Leave createDrDrillVM. ret=" + reply), 90160758786816L);
        return reply;
    }

    public String queryHostDrIp(VrmObject vrmInfo, String hostUri) {
        LOG.info((Object)("Enter into queryHostDrIps, vrm=" + vrmInfo + ", hostUri=" + hostUri), 90160758786816L);
        List<SystemIntfMsgsData> reply = this.queryHostSystemIntfs(vrmInfo, hostUri);
        if (reply != null) {
            for (SystemIntfMsgsData data : reply) {
                if (!this.isDrOptionOn(data) || data.getType() != 2) continue;
                LOG.info((Object)("Leave queryHostDrIps, ip=" + data.getNetAddr()), 90160758786816L);
                return data.getNetAddr();
            }
            for (SystemIntfMsgsData data : reply) {
                if (data.getType() != 0) continue;
                LOG.info((Object)("Leave queryHostDrIps, ip=" + data.getNetAddr()), 90160758786816L);
                return data.getNetAddr();
            }
        }
        LOG.warn((Object)"Leave queryHostDrIps, result is null", 90160758786816L);
        return null;
    }

    private boolean isDrOptionOn(SystemIntfMsgsData data) {
        return null != data.getOption() && data.getOption().contains("dr");
    }

    public List<SystemIntfMsgsData> queryHostSystemIntfs(VrmObject vrmInfo, String hostUri) {
        LOG.info((Object)"Enter into queryHostSystemIntfs", 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(hostUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = hostUri + "/systemintfs";
        ListSystemIntfResponseType reply = this.getVrmResource().getVrmResource(vrmInfo, url, ListSystemIntfResponseType.class);
        List ret = null;
        if (reply != null) {
            LOG.info((Object)("queryHostSystemIntfs, return code:" + reply.getErrorCode()), 90160758786816L);
            ret = reply.getSystemIntfs();
        }
        LOG.info((Object)"Leave queryHostSystemIntfs.", 90160758786816L);
        return ret;
    }

    public CreateVMResponseType createVM(VrmObject vrmInfo, CreateVMRequestType request) {
        LOG.info((Object)("Enter into createVM " + vrmInfo), 90160758786816L);
        LOG.info((Object)("test request=" + request), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        this.checkCreateVMRequest(request);
        String url = vrmInfo.getUri() + "/vms";
        CreateVMResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, request, CreateVMResponseType.class);
        LOG.info((Object)("Leave createVM. ret=" + reply), 90160758786816L);
        return reply;
    }

    public ChangeVMDrAgentResponseType changeDrAgent(VrmObject vrmInfo, String vmUri, ChangeVMDrAgentRequestType request) {
        LOG.info((Object)("Enter into changeDrAgent " + vrmInfo + ", vmUri=" + vmUri + ", request=" + request), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/changeAgent";
        ChangeVMDrAgentResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, request, ChangeVMDrAgentResponseType.class);
        LOG.info((Object)("Leave changeDrAgent, new Urn=" + (null == reply ? null : reply.getNewHostUrn())), 90160758786816L);
        return reply;
    }

    public int queryVMDrStatusByUri(VrmObject vrmInfo, String vmUri) {
        LOG.debug((Object)("Enter into queryVMDrStatusByUri " + vrmInfo + ", vmUri=" + vmUri), 90160758786816L);
        GalaxVM vm = this.virtualResourceManager.queryVMByUri(vrmInfo, vmUri);
        int ret = -1;
        if (null == vm) {
            LOG.warn((Object)"queryVMDrStatusByUri, vm is null", 90160758786816L);
            return ret;
        }
        LOG.debug((Object)"Leave queryVMDrStatusByUri.", 90160758786816L);
        ret = vm.getDrStatus();
        return ret;
    }

    public String queryHostUrnByVMUri(VrmObject vrmInfo, String vmUri) {
        LOG.debug((Object)("Enter into queryHostUrnByVMUri " + vrmInfo + ", vmUri=" + vmUri), 90160758786816L);
        GalaxVM vm = this.virtualResourceManager.queryVMByUri(vrmInfo, vmUri);
        if (null == vm) {
            LOG.info((Object)"queryHostUrnByVMUri, vm is null", 90160758786816L);
            return null;
        }
        LOG.debug((Object)"Leave queryHostUrnByVMUri.", 90160758786816L);
        return vm.getHostUrn();
    }

    public ChangeDsStorageUnitResponseType changeDsStorageUnit(VrmObject vrmInfo, String dsUri, ChangeDsStorageUnitRequestType request) {
        LOG.info((Object)("Enter into changeDsStorageUnit " + vrmInfo + ", dsUri=" + dsUri + ",request=" + request), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(dsUri);
        this.checkChangeDsStorageUnitsRequest(request);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vrmInfo.getUri() + dsUri + "/action/replaceStorageUnits";
        ChangeDsStorageUnitResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, request, ChangeDsStorageUnitResponseType.class);
        LOG.info((Object)("Leave changeDsStorageUnit. ret=" + reply), 90160758786816L);
        return reply;
    }

    public VMOperateResponseType attachVol(VrmObject vrmInfo, String vmUri, AttachVolRequestType request) {
        LOG.info((Object)("Enter into attachVol " + vrmInfo + ", vmUri=" + vmUri + ", request=" + request), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        this.checkAttachVolumeRequest(request);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/attachvol";
        VMOperateResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, request, VMOperateResponseType.class);
        LOG.info((Object)("Leave attachVol. ret=" + reply), 90160758786816L);
        return reply;
    }

    public VMOperateResponseType detachVol(VrmObject vrmInfo, String vmUri, DetachVolRequestType request) {
        LOG.info((Object)("Enter into detachVol " + vrmInfo + ", vmUri=" + vmUri + ", request=" + request), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        this.checkDeatachVolumeRequest(request);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/detachvol";
        VMOperateResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, request, VMOperateResponseType.class);
        LOG.info((Object)("Leave detachVol. ret=" + reply), 90160758786816L);
        return reply;
    }

    public CreateVolResponseType createVol(VrmObject vrmInfo, CreateVolRequestType request) {
        LOG.info((Object)("Enter into createVol " + vrmInfo + ",request" + request), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.checkCreateVolumeRequest(request);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vrmInfo.getUri() + "/volumes";
        CreateVolResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, request, CreateVolResponseType.class);
        LOG.info((Object)("Leave createVol. ret=" + reply), 90160758786816L);
        return reply;
    }

    public VMOperateResponseType deleteVol(VrmObject vrmInfo, String volUri) {
        LOG.info((Object)("Enter into deleteVol " + vrmInfo + ", volUri=" + volUri), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(volUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        VMOperateResponseType reply = this.getVrmResource().deleteVrm(vrmInfo, volUri, VMOperateResponseType.class);
        LOG.info((Object)("Leave deleteVol. ret=" + reply), 90160758786816L);
        return reply;
    }

    private void checkCreateVMRequest(CreateVMRequestType request) {
        if (StringUtils.isBlank((CharSequence)request.getUuid()) || StringUtils.isBlank((CharSequence)request.getLocation()) || null == request.getVmConfig() || null == request.getOsOptions()) {
            LOG.error((Object)"the param is invaild", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkCreateDrDrillVMRequest(CreateDrDrillVMRequestType request) {
        if (StringUtils.isBlank((CharSequence)request.getUuid()) || null == request.getDrDrillOption() || StringUtils.isBlank((CharSequence)request.getName())) {
            LOG.error((Object)"the param is invaild", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkSetVmDrRequest(SetVmDrRequestType request) {
        if (StringUtils.isBlank((CharSequence)request.getVrgIp()) || VerifyUtil.isEmpty((Object)request.getVrgPort()) || VerifyUtil.isEmpty((Object)request.getMaxSpeed())) {
            LOG.error((Object)"the param is invaild", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkChangeDsStorageUnitsRequest(ChangeDsStorageUnitRequestType request) {
        if (null == request || request.getStorageUnits() == null || request.getStorageUnits().isEmpty()) {
            LOG.error((Object)"the param is invaild", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        for (ChangeDsStorageUnitRequestType.StorageUnitRequest sur : request.getStorageUnits()) {
            if (!StringUtils.isBlank((CharSequence)sur.getSrcSuWwn()) && !StringUtils.isBlank((CharSequence)sur.getDstSuWwn())) continue;
            LOG.error((Object)"the param is invaild", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkAttachVolumeRequest(AttachVolRequestType request) {
        if (null == request || StringUtils.isBlank((CharSequence)request.getVolUrn())) {
            LOG.error((Object)"the param is invaild", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkDeatachVolumeRequest(DetachVolRequestType request) {
        if (null == request || StringUtils.isBlank((CharSequence)request.getVolUrn())) {
            LOG.error((Object)"the param is invaild", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkCreateVolumeRequest(CreateVolRequestType request) {
        if (null == request || request.getQuantityGB() == null || StringUtils.isBlank((CharSequence)request.getDatastoreUrn()) || StringUtils.isBlank((CharSequence)request.getType())) {
            LOG.error((Object)"the param is invaild", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void setVrmCommon(VirtualResourceManagerCommon vrmCommon) {
        this.vrmCommon = vrmCommon;
    }

    public VirtualResourceManagerCommon getVrmCommon() {
        return this.vrmCommon;
    }

    public void setVrmResource(VrmResource vrmResource) {
        this.vrmResource = vrmResource;
    }

    public VrmResource getVrmResource() {
        return this.vrmResource;
    }

    public void setVirtualResourceManager(IVirtualResourceManager virtualResourceManager) {
        this.virtualResourceManager = virtualResourceManager;
    }

    public IVirtualResourceManager getVirtualResourceManager() {
        return this.virtualResourceManager;
    }

    public VMOperateResponseType updateVol(VrmObject vrmInfo, String volUri, UpdateVolRequestType request) {
        LOG.info((Object)("Enter into updateVol " + vrmInfo + ", volUri=" + volUri + ", request=" + request), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(volUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        VMOperateResponseType reply = this.getVrmResource().putVrm(vrmInfo, volUri, request, VMOperateResponseType.class);
        LOG.info((Object)("Leave updateVol. ret=" + reply), 90160758786816L);
        return reply;
    }

    public VMOperateResponseType addNic(VrmObject vrmInfo, String vmUri, AddNicRequestType request) {
        LOG.info((Object)("Enter into addNic " + vrmInfo + ", vmUri" + vmUri + ", request=" + request), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/virtualNics";
        VMOperateResponseType reply = this.getVrmResource().postVrm(vrmInfo, url, request, VMOperateResponseType.class);
        LOG.info((Object)("Leave addNic. ret=" + reply), 90160758786816L);
        return reply;
    }

    public VMOperateResponseType removeNic(VrmObject vrmInfo, String nicUri) {
        LOG.info((Object)("Enter into removeNic " + vrmInfo + ", nicUri=" + nicUri), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(nicUri);
        if (!nicUri.contains("nics")) {
            LOG.error((Object)"the param is invaild", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        nicUri = nicUri.replace("nics", "virtualNics");
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        VMOperateResponseType reply = this.getVrmResource().deleteVrm(vrmInfo, nicUri, VMOperateResponseType.class);
        LOG.info((Object)("Leave removeNic. ret=" + reply), 90160758786816L);
        return reply;
    }

    public VMOperateResponseType updateNic(VrmObject vrmInfo, String nicUri, UpdateNicRequestType request) {
        LOG.info((Object)("Enter into updateNic " + vrmInfo + ", nicUri=" + nicUri + ", request=" + request), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(nicUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        VMOperateResponseType reply = this.getVrmResource().putVrm(vrmInfo, nicUri, request, VMOperateResponseType.class);
        LOG.info((Object)("Leave updateNic. ret=" + reply), 90160758786816L);
        return reply;
    }

    public HostMsgsData queryHost(VrmObject vrmInfo, String hostUri) {
        LOG.debug((Object)("@@Enter into queryHost " + vrmInfo + ", hostUri=" + hostUri), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(hostUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        HostMsgsData response = this.getVrmResource().getVrmResource(vrmInfo, hostUri, HostMsgsData.class);
        LOG.debug((Object)"Leave queryHost.", 90160758786816L);
        return response;
    }

    public VMOperateResponseType updateVmAttchType(VrmObject vrmInfo, String uri, boolean attchType) {
        LOG.info((Object)("@@Enter into updateVmAttchType " + vrmInfo + ", uri=" + uri + ", attchType=" + attchType), 90160758786816L);
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(uri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        HashMap<String, Boolean> attchParam = new HashMap<String, Boolean>();
        attchParam.put("attachType", attchType);
        HashMap<String, HashMap<String, Boolean>> param = new HashMap<String, HashMap<String, Boolean>>();
        param.put("properties", attchParam);
        VMOperateResponseType response = null;
        for (int idx = 0; idx < 10 && (response = this.getVrmResource().putVrm(vrmInfo, uri, param, VMOperateResponseType.class)) != null && TASK_CONFICTS.equals(response.getErrorCode()); ++idx) {
            LOG.error((Object)("task is conflict: " + uri), 90160758787071L);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"tryRepeat updateVmAttchType sleep error:", (Throwable)e, 90160758787071L);
            }
            LOG.info((Object)("Leave updateVmAttchType. ret=" + response), 90160758786816L);
        }
        return response;
    }
}

