/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.manager.impl;

import com.huawei.ism.drm.galax.sdk.model.VmSnapshot;
import com.huawei.ism.drm.galax.sdk.vrm.model.SetVolIOPropResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.StorageUnitsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigNicType;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

public class VirtualResourceManagerBase {
    private static Log log = LogFactory.getInstance(VirtualResourceManagerBase.class);
    private static final String HA_CONFIGURED = "10410478";

    protected void checkResponse(SetVolIOPropResponseType reply) {
        if (reply == null) {
            throw new LegoCheckedException(-1L, "Response error.");
        }
        if (HA_CONFIGURED.equals(reply.getErrorCode())) {
            log.info((Object)"All disks have been configured with HA.Need not to configure them again.");
            return;
        }
        if (VerifyUtil.isEmpty((String)reply.getErrorCode()) && VerifyUtil.isEmpty((String)reply.getTaskUri())) {
            throw new LegoCheckedException(-1L, "Response error.");
        }
        if (!VerifyUtil.isEmpty((String)reply.getErrorCode()) && !reply.getErrorCode().equals("0")) {
            throw new LegoCheckedException(Long.parseLong(reply.getErrorCode()));
        }
    }

    protected String getStorageDeviceWwn(String deviceType, String wwn) {
        if (!"FC".equals(deviceType)) {
            return wwn;
        }
        if (null == wwn || wwn.trim().length() < 2) {
            return wwn;
        }
        if (wwn.startsWith("0x")) {
            return wwn.substring(2);
        }
        return wwn;
    }

    protected void getSnapshotList(List<VmSnapshot> vmSnapshotList, List<VmSnapshot> snapshotListResult) {
        if (null == vmSnapshotList) {
            return;
        }
        for (VmSnapshot rootVmSnapshot : vmSnapshotList) {
            snapshotListResult.add(rootVmSnapshot);
            this.getSnapshotList(rootVmSnapshot.getChildSnapshots(), snapshotListResult);
        }
    }

    protected void checkLicVersion(int licVersion) {
        if (licVersion == -1) {
            log.error((Object)"the vrm license is invaild", 1073947396L);
            throw new LegoCheckedException(1073947396L);
        }
        if (licVersion == 0 || licVersion == 1) {
            log.error((Object)"the vrm license has no authorization ", 1073947397L);
            throw new LegoCheckedException(1073947397L);
        }
    }

    protected void convertNasStorageSuName(List<StorageUnitsData> storageUnits, String storageType) {
        if ("NAS".equals(storageType)) {
            for (StorageUnitsData storageUnit : storageUnits) {
                String suName = storageUnit.getSuName();
                log.debug((Object)"StorageUnitsData suName: %s", new Object[]{suName});
                if (!suName.contains(":/")) continue;
                storageUnit.setSuName(suName.substring(suName.indexOf("/")));
            }
        }
    }

    public static class NicComparator
    implements Comparator<VmConfigNicType>,
    Serializable {
        private static final long serialVersionUID = -389413815742572295L;

        @Override
        public int compare(VmConfigNicType arg0, VmConfigNicType arg1) {
            if (arg0.getSequenceNum() == null && arg1.getSequenceNum() == null) {
                return 0;
            }
            if (arg0.getSequenceNum() == null) {
                return -1;
            }
            if (arg1.getSequenceNum() == null) {
                return 1;
            }
            return arg0.getSequenceNum().compareTo(arg1.getSequenceNum());
        }
    }
}

