/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.manager.impl;

import com.huawei.ism.array.sdk.model.FusionStorageUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.arbitration.util.JSONArray;
import com.huawei.ism.drm.base.util.concurrent.ThreadPoolConfig;
import com.huawei.ism.drm.base.util.concurrent.ThreadPoolHelper;
import com.huawei.ism.drm.constant.DiskProtectStatusEnum;
import com.huawei.ism.drm.constant.DrsEnumDefine;
import com.huawei.ism.drm.galax.constant.cloudenum.Arch;
import com.huawei.ism.drm.galax.constant.cloudenum.CpuVendor;
import com.huawei.ism.drm.galax.constant.cloudenum.HostStatusEnum;
import com.huawei.ism.drm.galax.constant.cloudenum.StopVmMode;
import com.huawei.ism.drm.galax.resource.manager.common.VirtualResourceMgrUtil;
import com.huawei.ism.drm.galax.resource.manager.impl.VirtualResourceManagerBase;
import com.huawei.ism.drm.galax.resource.manager.impl.VirtualResourceManagerCommon;
import com.huawei.ism.drm.galax.resource.manager.impl.VrmResource;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.ComputeNode;
import com.huawei.ism.drm.galax.sdk.model.DVSwitch;
import com.huawei.ism.drm.galax.sdk.model.DataStore;
import com.huawei.ism.drm.galax.sdk.model.DrsGroup;
import com.huawei.ism.drm.galax.sdk.model.GalaxVM;
import com.huawei.ism.drm.galax.sdk.model.PhysicalStorageDevice;
import com.huawei.ism.drm.galax.sdk.model.PortGroup;
import com.huawei.ism.drm.galax.sdk.model.VmConfigDiskResponse;
import com.huawei.ism.drm.galax.sdk.model.VmSnapshot;
import com.huawei.ism.drm.galax.sdk.model.VmSnapshotMO;
import com.huawei.ism.drm.galax.sdk.vrm.model.ClusterMsgsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.CreateDatastoreRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.CreateDatastoreResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.DVSwitchInfo;
import com.huawei.ism.drm.galax.sdk.vrm.model.DataChannel;
import com.huawei.ism.drm.galax.sdk.vrm.model.DataStoreMsgsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.HostMsgsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.LicenseVersionResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListAllVmsResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListClustersResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListDataStoresResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListDvsResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListHostResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListPortgroupResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListStorageAdapterResponeType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListStorageResourceResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListStorageUnitResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListVmMsgsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListVmSnapshotsResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListVmsResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.NicSpecification;
import com.huawei.ism.drm.galax.sdk.vrm.model.PageQueryVMCondition;
import com.huawei.ism.drm.galax.sdk.vrm.model.PageQueryVolumeRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.PageQueryVolumeResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.PortgroupMsgsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.QueryVmBalanceRespone;
import com.huawei.ism.drm.galax.sdk.vrm.model.RefreshStorageResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.RefreshStorageUnitRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.RegisterVMRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.RegisterVMResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.SetDataStoreModeRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.SetOccupiedVmRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.SetVolIOPropResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.StopVmRequestType;
import com.huawei.ism.drm.galax.sdk.vrm.model.StorageAdapterMsgData;
import com.huawei.ism.drm.galax.sdk.vrm.model.StorageResourceMsgsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.StorageUnitsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.VMOperateResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmBalanceData;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigDiskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigNicType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmConfigsTaskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmCustomization;
import com.huawei.ism.drm.galax.sdk.vrm.model.VmMsgsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.VolumeData;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmTaskType;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.DrsResourceGroupMsgData;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.DrsRuleGroupMsgData;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.ListDrsBalanceGroupResponse;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.ListDrsResourceGroupResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.ListDrsRuleGroupResponse;
import com.huawei.ism.drm.galax.sdk.vrm.service.IVirtualResourceManager;
import com.huawei.ism.drm.galax.util.cloud.DsgUtil;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.galax.util.common.task.constants.TaskExecuteStatus;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.storage.hypermetro.builder.HypermetroPairConfiguration;
import com.huawei.ism.drm.storage.hypermetro.builder.util.HypermetroUtil;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.EVolHypermetroVolumeInfo;
import com.huawei.ism.drm.storage.manager.sdk.model.FusionStorageHypermetroVolumeInfo;
import com.huawei.ism.drm.storage.manager.sdk.model.HypermetroVolumeInfo;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.sdk.service.IStorageBaseService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoBaseConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class VirtualResourceManagerProxy
extends VirtualResourceManagerBase
implements IVirtualResourceManager {
    private static final Log LOGGER = LogFactory.getInstance(VirtualResourceManagerProxy.class);
    private static final long SLEEP_TIME_SECOND = 5000L;
    private static final String QUERY_SNAPSHOT_KEY = "threadCount.snapshot.query";
    private static final int QUERY_SNAPSHOT_DEFAULT = 50;
    private static final String CONFIGURE_CHANGEMAC_WHEN_MODIFY_IP = "changemac_when_modify_ip";
    private static final Integer DRS_GROUP_PAGE_SIZE = 20;
    private VrmResource vrmResource;
    private VirtualResourceManagerCommon vrmCommon;

    public VrmResource getVrmResource() {
        return this.vrmResource;
    }

    public void setVrmResource(VrmResource vrmResource) {
        this.vrmResource = vrmResource;
    }

    public VrmObject login(VrmObject vrmInfo) {
        LOGGER.debug((Object)"Enter into login vrm, the vrm object is %s.", new Object[]{JSONObject.fromObject((Object)vrmInfo)});
        this.vrmCommon.checkVrmObject(vrmInfo);
        return this.vrmResource.login(vrmInfo);
    }

    public List<DrsGroup> queryDrsGroup(VrmObject vrmInfo, ComputeCluster cluster) {
        LOGGER.info((Object)"Enter into query drs group list, the vrm object is %s.", new Object[]{JSONObject.fromObject((Object)vrmInfo)});
        this.vrmCommon.checkVrmObject(vrmInfo);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        List<DrsResourceGroupMsgData> drsHostResourceGroups = this.getDrsResourceGroups(vrmInfo, cluster, 0, DrsEnumDefine.GroupTypeEnum.HOST_GROUP, true);
        ArrayList<DrsGroup> groups = new ArrayList<DrsGroup>(this.dealDrsResourceGroupMsg(drsHostResourceGroups, DrsEnumDefine.GroupTypeEnum.HOST_GROUP));
        List<DrsResourceGroupMsgData> drsVmResourceGroups = this.getDrsResourceGroups(vrmInfo, cluster, 0, DrsEnumDefine.GroupTypeEnum.VM_GROUP, true);
        groups.addAll(this.dealDrsResourceGroupMsg(drsVmResourceGroups, DrsEnumDefine.GroupTypeEnum.VM_GROUP));
        List<DrsResourceGroupMsgData> drsBalancedGroups = this.getDrsBalancedGroup(vrmInfo, cluster);
        groups.addAll(this.dealDrsResourceGroupMsg(drsBalancedGroups, DrsEnumDefine.GroupTypeEnum.BALANCED_GROUP));
        List<DrsRuleGroupMsgData> drsRuleGroups = this.getDrsRuleGroup(vrmInfo, cluster, 0, true);
        groups.addAll(this.dealDrsRuleGroupMsg(drsRuleGroups, cluster));
        return groups;
    }

    private Collection<? extends DrsGroup> dealDrsRuleGroupMsg(List<DrsRuleGroupMsgData> groups, ComputeCluster cluster) {
        if (groups == null || groups.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<DrsGroup> list = new ArrayList<DrsGroup>();
        for (DrsRuleGroupMsgData msgData : groups) {
            DrsGroup drsGroup = new DrsGroup();
            drsGroup.setName(msgData.getRuleName());
            drsGroup.setGroupType(Integer.valueOf(DrsEnumDefine.GroupTypeEnum.RULE_GROUP.getValue()));
            drsGroup.setUri(cluster.getUri() + "/rulegroups");
            drsGroup.setUrn(cluster.getUrn() + ":" + "DRS_GROUP_RULE" + ":" + msgData.getRuleIndex());
            drsGroup.setUuid(drsGroup.getUrn());
            drsGroup.setVm2HostRuleType(msgData.getVm2HostRuleType());
            drsGroup.setRuleType(msgData.getRuleType());
            drsGroup.setVmGroupUrn(msgData.getVmGroupUrn());
            drsGroup.setHostGroupUrn(msgData.getHostGroupUrn());
            drsGroup.setVmParentGroupUrn(msgData.getVmParentGroupUrn());
            list.add(drsGroup);
        }
        return list;
    }

    private List<DrsGroup> dealDrsResourceGroupMsg(List<DrsResourceGroupMsgData> groups, DrsEnumDefine.GroupTypeEnum groupTypeEnum) {
        if (groups == null || groups.isEmpty()) {
            return new ArrayList<DrsGroup>();
        }
        ArrayList<DrsGroup> list = new ArrayList<DrsGroup>();
        for (DrsResourceGroupMsgData msgData : groups) {
            DrsGroup drsGroup = new DrsGroup();
            drsGroup.setName(msgData.getName());
            drsGroup.setGroupType(Integer.valueOf(groupTypeEnum.getValue()));
            drsGroup.setUri(msgData.getUri());
            drsGroup.setUrn(msgData.getUrn());
            drsGroup.setUuid(msgData.getUrn());
            list.add(drsGroup);
        }
        return list;
    }

    public List<DrsRuleGroupMsgData> getDrsRuleGroup(VrmObject vrmInfo, ComputeCluster cluster, int offset, boolean isContinue) {
        if (VerifyUtil.isEmpty((Object)vrmInfo) || VerifyUtil.isEmpty((Object)cluster)) {
            LOGGER.error((Object)"Object vrmInfo is invalidation or Object cluster is invalidation.");
            throw new LegoCheckedException(1073947393L);
        }
        String siteId = cluster.getUri().split("/")[3];
        String clusterId = cluster.getUri().split("/")[5];
        String url = cluster.getUri() + String.format(Locale.ROOT, "/rulegroups?siteID=%s&clusterID=%s&limit=%d&offset=%d", siteId, clusterId, DRS_GROUP_PAGE_SIZE, offset);
        LOGGER.debug((Object)"Parameters siteId is [%s],clusterId is [%s],url is [%s].", new Object[]{siteId, clusterId, url});
        ListDrsRuleGroupResponse ruleGroupResponse = this.vrmResource.getVrmResource(vrmInfo, url, ListDrsRuleGroupResponse.class);
        if (ruleGroupResponse == null || ruleGroupResponse.getGroups() == null) {
            LOGGER.info((Object)"Data ruleGroupResponse or groups is null.");
            return Collections.emptyList();
        }
        ArrayList<DrsRuleGroupMsgData> list = new ArrayList<DrsRuleGroupMsgData>(ruleGroupResponse.getGroups());
        if (!isContinue) {
            return list;
        }
        if (ruleGroupResponse.getTotal() > DRS_GROUP_PAGE_SIZE) {
            double pi = (double)ruleGroupResponse.getTotal() / (double)DRS_GROUP_PAGE_SIZE.intValue();
            int times = (int)Math.ceil(pi);
            for (int index = 1; index < times; ++index) {
                int newOffset = index * DRS_GROUP_PAGE_SIZE + offset;
                list.addAll(this.getDrsRuleGroup(vrmInfo, cluster, newOffset, false));
            }
        }
        return list;
    }

    private List<DrsResourceGroupMsgData> getDrsBalancedGroup(VrmObject vrmInfo, ComputeCluster cluster) {
        String siteId = cluster.getUri().split("/")[3];
        String clusterId = cluster.getUri().split("/")[5];
        String url = cluster.getUri() + String.format(Locale.ROOT, "/lbgroups?siteID=%s&clusterID=%s", siteId, clusterId);
        LOGGER.debug((Object)"Parameters siteId is %s,clusterId is %s,url is %s.", new Object[]{siteId, clusterId, url});
        ListDrsBalanceGroupResponse groupResponse = this.vrmResource.getVrmResource(vrmInfo, url, ListDrsBalanceGroupResponse.class);
        if (groupResponse == null || groupResponse.getLbGroups() == null) {
            return Collections.emptyList();
        }
        return groupResponse.getLbGroups();
    }

    private List<DrsResourceGroupMsgData> getDrsResourceGroups(VrmObject vrmInfo, ComputeCluster cluster, int offset, DrsEnumDefine.GroupTypeEnum groupType, boolean isContinue) {
        String siteId = cluster.getUri().split("/")[3];
        String clusterId = cluster.getUri().split("/")[5];
        String url = groupType.getValue() == DrsEnumDefine.GroupTypeEnum.HOST_GROUP.getValue() ? cluster.getUri() + String.format(Locale.ROOT, "/resourcegroups?type=1&siteID=%s&clusterID=%s&limit=%d&offset=%d", siteId, clusterId, DRS_GROUP_PAGE_SIZE, offset) : cluster.getUri() + String.format(Locale.ROOT, "/resourcegroups?type=0&siteID=%s&clusterID=%s&limit=%d&offset=%d", siteId, clusterId, DRS_GROUP_PAGE_SIZE, offset);
        LOGGER.debug((Object)"Parameters siteId is %s,clusterId is %s,url is %s.", new Object[]{siteId, clusterId, url});
        ListDrsResourceGroupResponseType groupResponseType = this.vrmResource.getVrmResource(vrmInfo, url, ListDrsResourceGroupResponseType.class);
        if (groupResponseType == null || groupResponseType.getTotal() == 0) {
            return Collections.emptyList();
        }
        ArrayList<DrsResourceGroupMsgData> list = new ArrayList<DrsResourceGroupMsgData>(groupResponseType.getGroups());
        if (!isContinue) {
            return list;
        }
        if (groupResponseType.getTotal() > DRS_GROUP_PAGE_SIZE) {
            double pi = (double)groupResponseType.getTotal() / (double)DRS_GROUP_PAGE_SIZE.intValue();
            int times = (int)Math.ceil(pi);
            for (int index = 1; index < times; ++index) {
                int newOffset = index * DRS_GROUP_PAGE_SIZE + offset;
                list.addAll(this.getDrsResourceGroups(vrmInfo, cluster, newOffset, groupType, false));
            }
        }
        return list;
    }

    public List<ComputeCluster> queryCluster(VrmObject vrmInfo) {
        LOGGER.debug((Object)"Enter into query vrm cluster list, the vrm object is %s.", new Object[]{vrmInfo});
        this.vrmCommon.checkVrmObject(vrmInfo);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vrmInfo.getUri() + "/clusters";
        ListClustersResponseType clusterList = this.vrmResource.getVrmResource(vrmInfo, url, ListClustersResponseType.class);
        if (clusterList == null || VerifyUtil.isEmpty((Collection)clusterList.getClusters())) {
            LOGGER.warn((Object)"Result of query vrm cluster is null, vrm object is %s.", new Object[]{vrmInfo});
            return Collections.emptyList();
        }
        ArrayList<ComputeCluster> clusters = new ArrayList<ComputeCluster>();
        for (ClusterMsgsData cluster : clusterList.getClusters()) {
            ComputeCluster vrCluster = new ComputeCluster();
            vrCluster.setName(cluster.getName());
            vrCluster.setUrn(cluster.getUrn());
            vrCluster.setUri(cluster.getUri());
            vrCluster.setDescription(com.huawei.ism.drm.galax.util.rest.CommonUtil.getDescription((String)cluster.getDescription()));
            vrCluster.setUuid(cluster.getUrn());
            vrCluster.setArch(cluster.getArch());
            if (cluster.getCpuVendor() == null) {
                vrCluster.setCpuVendor(Arch.ARM.getArch().equalsIgnoreCase(cluster.getArch()) ? CpuVendor.HISILICON.getCpuVendor() : CpuVendor.INTEL.getCpuVendor());
            } else {
                vrCluster.setCpuVendor(cluster.getCpuVendor());
            }
            clusters.add(vrCluster);
        }
        LOGGER.debug((Object)"Leave query vrm cluster list, clusters is %s.", new Object[]{clusters});
        return clusters;
    }

    public List<ComputeNode> queryAllComputeNode(VrmObject vrmInfo) {
        LOGGER.debug((Object)"Enter into query vrm host list, the vrm object is %s.", new Object[]{vrmInfo});
        this.vrmCommon.checkVrmObject(vrmInfo);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vrmInfo.getUri() + "/hosts";
        ListHostResponseType hostList = this.vrmResource.getVrmResource(vrmInfo, url, ListHostResponseType.class);
        if (hostList == null || VerifyUtil.isEmpty((Collection)hostList.getHosts())) {
            LOGGER.warn((Object)"Result of query all ComputeNode is null, vrm object is %s.", new Object[]{vrmInfo});
            return Collections.emptyList();
        }
        ArrayList<ComputeNode> nodes = new ArrayList<ComputeNode>();
        for (HostMsgsData host : hostList.getHosts()) {
            ComputeNode node = new ComputeNode();
            node.setName(host.getName());
            node.setUrn(host.getUrn());
            node.setUri(host.getUri());
            node.setDescription(com.huawei.ism.drm.galax.util.rest.CommonUtil.getDescription((String)host.getDescription()));
            node.setUuid(host.getUrn());
            node.setComputeClusterUrn(host.getClusterUrn());
            node.setIp(host.getIp());
            node.setHostStatus(host.getStatus());
            HostStatusEnum statusEnum = HostStatusEnum.findStatusByValue((String)host.getStatus());
            node.setStatus(Integer.valueOf(statusEnum == null ? HostStatusEnum.UNKNOWN.getKey() : statusEnum.getKey()));
            node.setArch(host.getArch());
            if (host.getCpuVendor() == null) {
                node.setCpuVendor(Arch.ARM.getArch().equalsIgnoreCase(host.getArch()) ? CpuVendor.HISILICON.getCpuVendor() : CpuVendor.INTEL.getCpuVendor());
            } else {
                node.setCpuVendor(host.getCpuVendor());
            }
            nodes.add(node);
        }
        LOGGER.debug((Object)"Leave query vrm host list, nodes is %s.", new Object[]{nodes});
        return nodes;
    }

    public List<DataStore> queryDataStore(VrmObject vrmInfo) {
        LOGGER.debug((Object)"Enter into query vrm datastore, the vrm object is: %s", new Object[]{vrmInfo});
        this.vrmCommon.checkVrmObject(vrmInfo);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vrmInfo.getUri() + "/datastores" + "/queryDatastores";
        ListDataStoresResponseType dataStoresResponse = this.vrmResource.getVrmResource(vrmInfo, url, ListDataStoresResponseType.class);
        if (dataStoresResponse != null && !VerifyUtil.isEmpty((String)dataStoresResponse.getErrorCode())) {
            LOGGER.error((Object)"Get datastore resource info from FC failed, error code: %s.", new Object[]{dataStoresResponse.getErrorCode()});
            throw new LegoCheckedException(1073947405L, new String[]{dataStoresResponse.getErrorDes()});
        }
        if (dataStoresResponse == null || VerifyUtil.isEmpty((Collection)dataStoresResponse.getDatastores())) {
            return Collections.emptyList();
        }
        ListStorageResourceResponseType resourceList = this.queryStorageResource(vrmInfo);
        Map<String, String> nameDevSnMap = this.buildNameDevSnMap(resourceList);
        ArrayList<DataStore> dataStoreList = new ArrayList<DataStore>();
        for (DataStoreMsgsData dataStoreMsgData : dataStoresResponse.getDatastores()) {
            if (!VrmUtil.isDataStoreTypeSupport((String)dataStoreMsgData.getStorageType())) continue;
            dataStoreList.add(this.convertToDataStore(dataStoreMsgData, resourceList, nameDevSnMap));
        }
        LOGGER.debug((Object)"Leave query vrm datastore: %s", new Object[]{dataStoreList});
        return dataStoreList;
    }

    private DataStore convertToDataStore(DataStoreMsgsData dataStoreMsgData, ListStorageResourceResponseType resourceList, Map<String, String> nameDevSnMap) {
        DataStore ds = new DataStore();
        this.getDevSnFromStorageUnits(dataStoreMsgData.getStorageUnits(), nameDevSnMap).ifPresent(arg_0 -> ((DataStore)ds).setDevSn(arg_0));
        this.dealNasDataStore(dataStoreMsgData, resourceList);
        ds.setName(dataStoreMsgData.getName());
        ds.setUrn(dataStoreMsgData.getUrn());
        ds.setUri(dataStoreMsgData.getUri());
        ds.setDescription(com.huawei.ism.drm.galax.util.rest.CommonUtil.getDescription((String)dataStoreMsgData.getDescription()));
        ds.setCapacityGB(dataStoreMsgData.getCapacityGB().intValue());
        ds.setFreeSizeGB(dataStoreMsgData.getFreeSizeGB().intValue());
        ds.setUsedSizeGB(dataStoreMsgData.getUsedSizeGB().intValue());
        ds.setWwn(dataStoreMsgData.getWwn());
        ds.setUuid(dataStoreMsgData.getUrn());
        ds.setStorageType(dataStoreMsgData.getStorageType());
        String hosts = this.getDsHosts(dataStoreMsgData.getHosts());
        ds.setHosts(hosts);
        ds.setValid(Boolean.valueOf("NORMAL".equals(dataStoreMsgData.getStatus())));
        ds.setVersion(dataStoreMsgData.getVersion());
        List storageUnits = dataStoreMsgData.getStorageUnits();
        this.convertNasStorageSuName(storageUnits, ds.getStorageType());
        ds.setStorageUnits(JSONArray.fromObject((Object)storageUnits).toString());
        ds.setConfidentialityLevel(dataStoreMsgData.getConfidentialityLevel());
        return ds;
    }

    private Map<String, String> buildNameDevSnMap(ListStorageResourceResponseType responseType) {
        if (responseType == null || VerifyUtil.isEmpty((Collection)responseType.getStorageResources())) {
            LOGGER.info((Object)"Query vrm storage resources response is empty.");
            return Collections.emptyMap();
        }
        HashMap<String, String> ipDevSnMap = new HashMap<String, String>();
        for (StorageNE storageNe : CommonDAOLocator.getMoDao().getAllMo(StorageNE.class)) {
            String sn = storageNe.getSn();
            ipDevSnMap.put(storageNe.getLinkIp(), sn);
            String managedIps = storageNe.getManagedIps();
            if (VerifyUtil.isEmpty((String)managedIps)) continue;
            Arrays.stream(managedIps.split(",")).forEach(managedIp -> ipDevSnMap.put((String)managedIp, sn));
        }
        HashMap<String, String> nameDevSnMap = new HashMap<String, String>();
        List storageResources = responseType.getStorageResources();
        for (StorageResourceMsgsData storageResource : storageResources) {
            this.getDevSnByManageIp(ipDevSnMap, storageResource.getManagementIp()).ifPresent(devSn -> nameDevSnMap.put(storageResource.getName(), (String)devSn));
        }
        return nameDevSnMap;
    }

    private Optional<String> getDevSnByManageIp(Map<String, String> ipDevSnMap, String managementIp) {
        if (VerifyUtil.isEmpty((String)managementIp)) {
            return Optional.empty();
        }
        return Arrays.stream(managementIp.split(";")).map(ipDevSnMap::get).filter(Objects::nonNull).findAny();
    }

    private Optional<String> getDevSnFromStorageUnits(List<StorageUnitsData> storageUnits, Map<String, String> nameDevSnMap) {
        if (VerifyUtil.isEmpty(storageUnits)) {
            return Optional.empty();
        }
        return storageUnits.stream().map(StorageUnitsData::getSdName).filter(Objects::nonNull).findAny().map(nameDevSnMap::get);
    }

    public ListStorageResourceResponseType queryStorageResource(VrmObject vrmInfo) {
        String url = vrmInfo.getUri() + "/storageresources";
        int limit = 100;
        int offset = 0;
        ArrayList list = new ArrayList();
        ListStorageResourceResponseType result = new ListStorageResourceResponseType();
        while (true) {
            String pageQueryUrl = url + "?" + "limit=" + limit + "&" + "offset=" + offset;
            LOGGER.info((Object)"The pageQueryUrl: %s.", new Object[]{pageQueryUrl});
            ListStorageResourceResponseType dsList = this.vrmResource.getVrmResource(vrmInfo, pageQueryUrl, ListStorageResourceResponseType.class);
            if (VerifyUtil.isEmpty((Object)dsList) || VerifyUtil.isEmpty((Collection)dsList.getStorageResources())) break;
            list.addAll(dsList.getStorageResources());
            if (dsList.getStorageResources().size() < limit) break;
            offset += limit;
        }
        result.setStorageResources(list);
        return result;
    }

    private void dealNasDataStore(DataStoreMsgsData dataStore, ListStorageResourceResponseType rsList) {
        if (!"NAS".equals(dataStore.getStorageType())) {
            return;
        }
        if (rsList == null || VerifyUtil.isEmpty((Collection)rsList.getStorageResources())) {
            LOGGER.error((Object)"Query vrm storeageResources list is empty.");
            return;
        }
        for (StorageResourceMsgsData storageResource : rsList.getStorageResources()) {
            for (StorageUnitsData storageUnit : dataStore.getStorageUnits()) {
                if (!storageUnit.getSdName().equals(storageResource.getName())) continue;
                String ip = ((DataChannel)storageResource.getDataChannel().get(0)).getIp();
                storageUnit.setSdName(ip);
            }
        }
    }

    private String getDsHosts(List<String> dsHosts) {
        if (dsHosts == null) {
            return null;
        }
        StringBuffer hosts = new StringBuffer();
        for (String host : dsHosts) {
            hosts.append(host + ";");
        }
        return hosts.toString();
    }

    public List<DVSwitch> queryAllDVSwitch(VrmObject vrmInfo) {
        LOGGER.debug((Object)"Enter into query vrm dvswitch list, the vrm object is %s.", new Object[]{vrmInfo});
        this.vrmCommon.checkVrmObject(vrmInfo);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vrmInfo.getUri() + "/dvswitchs";
        ListDvsResponseType dvswitchs = this.vrmResource.getVrmResource(vrmInfo, url, ListDvsResponseType.class);
        ArrayList<DVSwitch> dvsList = new ArrayList<DVSwitch>();
        if (dvswitchs != null && dvswitchs.getDvSwitchs() != null && !dvswitchs.getDvSwitchs().isEmpty()) {
            for (DVSwitchInfo dvswitch : dvswitchs.getDvSwitchs()) {
                DVSwitch dvs = new DVSwitch();
                dvs.setName(dvswitch.getName());
                dvs.setUrn(dvswitch.getUrn());
                dvs.setUri(dvswitch.getUri());
                dvs.setDescription(com.huawei.ism.drm.galax.util.rest.CommonUtil.getDescription((String)dvswitch.getDescription()));
                dvs.setUuid(dvswitch.getUrn());
                dvsList.add(dvs);
            }
        } else {
            LOGGER.warn((Object)"Result of query  all DVSwitch is null, vrm object is %s.", new Object[]{vrmInfo});
        }
        LOGGER.debug((Object)"Leave query vrm dvswitch list,dvsList is %s.", new Object[]{dvsList});
        return dvsList;
    }

    public List<PortGroup> queryPortGroupBySwitchId(VrmObject vrmInfo, String dvsUri) {
        LOGGER.debug((Object)"Enter into query portgroup list by dvswitch, vrm object is %s, dvsUri = %s.", new Object[]{vrmInfo, dvsUri});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(dvsUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = dvsUri + "/portgroups";
        ListPortgroupResponseType portGroups = this.vrmResource.getVrmResource(vrmInfo, url, ListPortgroupResponseType.class);
        ArrayList<PortGroup> pgList = new ArrayList<PortGroup>();
        if (portGroups != null && portGroups.getPortGroups() != null && !portGroups.getPortGroups().isEmpty()) {
            for (PortgroupMsgsData portGroup : portGroups.getPortGroups()) {
                PortGroup ps = new PortGroup();
                ps.setName(portGroup.getName());
                ps.setUrn(portGroup.getUrn());
                ps.setUri(portGroup.getUri());
                ps.setDescription(com.huawei.ism.drm.galax.util.rest.CommonUtil.getDescription((String)portGroup.getDescription()));
                ps.setSubnetUrn(portGroup.getSubnetUrn());
                ps.setVlanId(portGroup.getVlanId());
                ps.setTxLimit(portGroup.getTxLimit());
                ps.setPriority(portGroup.getPriority());
                ps.setDhcpIsolation(portGroup.getIsDhcpIsolation().booleanValue());
                ps.setUuid(portGroup.getUrn());
                pgList.add(ps);
            }
        } else {
            LOGGER.warn((Object)"Result of query PortGroup is null, vrm object is %s, dvsUri = %s.", new Object[]{vrmInfo, dvsUri});
        }
        LOGGER.debug((Object)"Leave query portgroup list by dvswitch, pgList is %s.", new Object[]{pgList});
        return pgList;
    }

    public List<GalaxVM> queryVMByDataStore(VrmObject vrmInfo) {
        LOGGER.debug((Object)"Enter into query vm list by datastore, the vrm object is %s.", new Object[]{vrmInfo});
        this.vrmCommon.checkVrmObject(vrmInfo);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        PageQueryVMCondition condition = new PageQueryVMCondition();
        condition.setDetail(Integer.valueOf(2));
        String vmUrl = vrmInfo.getUri() + "/vms";
        List<VmMsgsData> vmDataList = this.getAllVMSOfDataSote(vmUrl, condition, vrmInfo);
        ThreadPoolConfig config = ThreadPoolHelper.defaultConfig((String)QUERY_SNAPSHOT_KEY, (int)50);
        VrmObject finalVrmInfo = vrmInfo;
        ArrayList<GalaxVM> vmList = new ArrayList<GalaxVM>();
        ThreadPoolHelper.synBatchExecute((ThreadPoolConfig)config, vmDataList, vmData -> {
            this.calVMDataStoreUrns((VmMsgsData)vmData);
            GalaxVM vm = VirtualResourceMgrUtil.getGalaxVm(vmData);
            if (vm != null) {
                List<VmSnapshot> snapshotList = this.queryVmSnapshot(finalVrmInfo, vm);
                if (!VerifyUtil.isEmpty(snapshotList)) {
                    this.buildSnapshotMO(snapshotList, vm);
                }
                vmList.add(vm);
            }
        });
        LOGGER.debug((Object)"Leave query vm list by datastore. size=%s.", (long)vmList.size());
        return vmList;
    }

    private void buildSnapshotMO(List<VmSnapshot> snapshotList, GalaxVM vm) {
        snapshotList.stream().map(item -> {
            VmSnapshotMO snapshotMO = new VmSnapshotMO();
            snapshotMO.setName(item.getName());
            snapshotMO.setUri(item.getUri());
            snapshotMO.setUrn(item.getUrn());
            snapshotMO.setUuid(item.getUrn());
            snapshotMO.setVmUuid(vm.getUuid());
            return snapshotMO;
        }).collect(Collectors.toList()).forEach(arg_0 -> ((GalaxVM)vm).addChildMo(arg_0));
    }

    private void calVMDataStoreUrns(VmMsgsData vmData) {
        if (VerifyUtil.isEmpty((Collection)vmData.getDataStoreUrns())) {
            vmData.setDataStoreUrns(new ArrayList());
        }
        try {
            VmConfigType vmConfig = (VmConfigType)com.huawei.ism.drm.galax.util.rest.CommonUtil.jsonToBean((String)vmData.getVmConfig(), VmConfigType.class);
            List disks = vmConfig.getDisks();
            for (VmConfigDiskType disk : disks) {
                if (VerifyUtil.isEmpty((String)disk.getDatastoreUrn()) || vmData.getDataStoreUrns().contains(disk.getDatastoreUrn())) continue;
                vmData.getDataStoreUrns().add(disk.getDatastoreUrn());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"calc datastore urn catch exception, error: %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    private List<VmMsgsData> getAllVMSOfDataSote(String vmUrl, PageQueryVMCondition condition, VrmObject vrmInfo) {
        int limit = condition.getLimit();
        int offset = 0;
        ArrayList<VmMsgsData> vms = new ArrayList<VmMsgsData>();
        while (true) {
            condition.setOffset(Integer.valueOf(offset));
            String queryListVmsUrl = vmUrl + condition.toUrl();
            LOGGER.info((Object)"QueryListVmsUrl : %s.", new Object[]{queryListVmsUrl});
            ListAllVmsResponseType vmslist = this.vrmResource.getVrmResource(vrmInfo, queryListVmsUrl, ListAllVmsResponseType.class);
            if (VerifyUtil.isEmpty((Object)vmslist) || vmslist.getVms() == null) break;
            if (!vmslist.getVms().isEmpty()) {
                vms.addAll(vmslist.getVms());
            }
            if (vmslist.getVms().size() < limit) break;
            offset += limit;
        }
        return vms;
    }

    public RefreshStorageResponseType refreshStorageUnitByHost(VrmObject vrmInfo, RefreshStorageUnitRequestType request) {
        LOGGER.info((Object)"Enter into refresh storageUnit by host.The vrm object is %s.", new Object[]{vrmInfo});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.checkRefreshStorageRequest(request);
        LOGGER.info((Object)"The request hosturn is %s.", new Object[]{request.getHostUrn()});
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vrmInfo.getUri() + "/storageunits" + "/action/refresh";
        RefreshStorageResponseType reply = this.vrmResource.postVrm(vrmInfo, url, request, RefreshStorageResponseType.class);
        LOGGER.info((Object)"Leave refresh storageUnit by host, result=%s.", new Object[]{reply});
        return reply;
    }

    public ListStorageUnitResponseType queryStorageUnitByHost(VrmObject vrmInfo, String hostUrn) {
        LOGGER.debug((Object)"Enter into query storageUnit by host.The vrm object is %s, the hosturn is %s.", new Object[]{vrmInfo, hostUrn});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(hostUrn);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        StringBuffer sb = new StringBuffer();
        String url = sb.append(vrmInfo.getUri()).append("/storageunits").append("/querysu").append("?hostUrn=").append(hostUrn).append("&useState=all&deviceType=0").toString();
        ListStorageUnitResponseType reply = this.vrmResource.getVrmResource(vrmInfo, url, ListStorageUnitResponseType.class);
        LOGGER.debug((Object)"Leave query storageUnit by host.");
        return reply;
    }

    public CreateDatastoreResponseType createDatastore(VrmObject vrmInfo, CreateDatastoreRequestType requests) {
        LOGGER.info((Object)"Enter into create datastore by host.The vrm object is %s, the request is %s.", new Object[]{vrmInfo, requests});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.checkDatastoreRequest(requests);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vrmInfo.getUri() + "/datastores";
        CreateDatastoreResponseType reply = this.vrmResource.postVrm(vrmInfo, url, requests, CreateDatastoreResponseType.class);
        LOGGER.info((Object)"Leave create datastore by host. ret=%s.", new Object[]{reply});
        return reply;
    }

    public VMOperateResponseType setDataStoreMode(VrmObject vrmInfo, String datastoreUri, SetDataStoreModeRequestType requests) {
        LOGGER.info((Object)"Enter into set datastore mode by datastoreUri.The vrm object is %s, the datastoreUri is %s, the request is %s.", new Object[]{vrmInfo, datastoreUri, requests});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(datastoreUri);
        this.checkSetDataStoreModeRequest(requests);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String cmd = "/setMode";
        String url = datastoreUri + cmd;
        VMOperateResponseType reply = this.vrmResource.putVrm(vrmInfo, url, requests, VMOperateResponseType.class);
        LOGGER.info((Object)"Leave  set datastore mode, ret=%s.", new Object[]{reply});
        return reply;
    }

    public VMOperateResponseType deleteDatastore(VrmObject vrmInfo, String hostUrn, String datastoreUri) {
        LOGGER.info((Object)"Enter into delete datastore by host.The vrm object is %s, the hostUrn is %s, the datastoreUri is %s.", new Object[]{vrmInfo, hostUrn, datastoreUri});
        this.vrmCommon.checkVrmObject(vrmInfo);
        if (StringUtils.isBlank((CharSequence)hostUrn) || StringUtils.isBlank((CharSequence)datastoreUri)) {
            LOGGER.error((Object)"Param hostUrn or datastoreUri is invalid.", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = datastoreUri + "?hostUrn=" + hostUrn;
        VMOperateResponseType reply = this.vrmResource.deleteVrm(vrmInfo, url, VMOperateResponseType.class);
        LOGGER.info((Object)"Leave delete datastore by host. ret=%s.", new Object[]{reply});
        return reply;
    }

    public RegisterVMResponseType registerVM(VrmObject vrmInfo, RegisterVMRequestType request) {
        LOGGER.info((Object)"Enter into register VM.The vrm object is %s, the request is %s.", new Object[]{vrmInfo, request});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.checkRegisterVMRequest(request);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vrmInfo.getUri() + "/vms" + "/action/register";
        this.changeMac(request);
        RegisterVMResponseType reply = this.vrmResource.postVrm(vrmInfo, url, request, RegisterVMResponseType.class);
        LOGGER.info((Object)"Leave register VM. ret=%s.", new Object[]{reply});
        return reply;
    }

    private void changeMac(RegisterVMRequestType request) {
        if (!Boolean.valueOf(LegoBaseConfig.getInstance().getKeyValue(CONFIGURE_CHANGEMAC_WHEN_MODIFY_IP)).booleanValue()) {
            return;
        }
        VmCustomization vmCustomization = request.getVmCustomization();
        if (VerifyUtil.isEmpty((Object)vmCustomization) || VerifyUtil.isEmpty((Object)request.getVmConfig()) || VerifyUtil.isEmpty((Collection)request.getVmConfig().getNics())) {
            return;
        }
        List nicSpecificationList = vmCustomization.getNicSpecification();
        if (VerifyUtil.isEmpty((Collection)nicSpecificationList)) {
            return;
        }
        HashSet<Integer> nicSequenceNameSet = new HashSet<Integer>();
        for (NicSpecification nicSpecification : nicSpecificationList) {
            if (VerifyUtil.isEmpty((String)nicSpecification.getIp())) continue;
            nicSequenceNameSet.add(nicSpecification.getSequenceNum() - 1);
        }
        VmConfigType vmConfig = request.getVmConfig();
        List nics = vmConfig.getNics();
        this.logNics(nics);
        Collections.sort(nics, new VirtualResourceManagerBase.NicComparator());
        LOGGER.debug((Object)"Change mac sequence: %s.", new Object[]{nicSequenceNameSet});
        this.setMac(nicSequenceNameSet, nics);
    }

    private void setMac(Set<Integer> nicSequenceNameSet, List<VmConfigNicType> nics) {
        for (int index : nicSequenceNameSet) {
            if (index >= 0 && index < nics.size()) {
                nics.get(index).setMac(null);
                LOGGER.debug((Object)"Change mac for: %s.", new Object[]{nics.get(index)});
                continue;
            }
            LOGGER.error((Object)"Can't find nic for: %s.", new Object[]{String.valueOf(index)});
        }
    }

    private void logNics(List<VmConfigNicType> nics) {
        if (LOGGER.isDebugEnabled()) {
            for (VmConfigNicType nic : nics) {
                LOGGER.debug((Object)"The vm nics: %s.", new Object[]{nic});
            }
        }
    }

    public VMOperateResponseType startVM(VrmObject vrmInfo, String vmUri) {
        LOGGER.info((Object)"Enter into start vm. vrm is= %s, vmUri= %s.", new Object[]{vrmInfo, vmUri});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/start";
        VMOperateResponseType reply = this.vrmResource.postVrm(vrmInfo, url, null, VMOperateResponseType.class);
        LOGGER.info((Object)"Leave start vm. ret= %s.", new Object[]{reply});
        return reply;
    }

    public VMOperateResponseType stopVM(VrmObject vrmInfo, String vmUri, StopVmMode mode) {
        LOGGER.info((Object)"Enter into stop vm. vrm is= %s, vmUri= %s.", new Object[]{vrmInfo, vmUri});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/stop";
        StopVmRequestType request = new StopVmRequestType();
        request.setMode(mode.name());
        VMOperateResponseType reply = this.vrmResource.postVrm(vrmInfo, url, request, VMOperateResponseType.class);
        if (StopVmMode.safe.equals((Object)mode) && "10300026".equals(reply.getErrorCode())) {
            request.setMode(StopVmMode.force.name());
            reply = this.vrmResource.postVrm(vrmInfo, url, request, VMOperateResponseType.class);
        }
        LOGGER.info((Object)"Leave stop vm. ret= %s.", new Object[]{reply});
        return reply;
    }

    public VMOperateResponseType hangUpVM(VrmObject vrmInfo, String vmUri) {
        LOGGER.info((Object)"Enter into hibernate vm. vrm is=%s, vmUri= %s.", new Object[]{vrmInfo, vmUri});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = vmUri + "/action/hibernate";
        VMOperateResponseType reply = this.vrmResource.postVrm(vrmInfo, url, null, VMOperateResponseType.class);
        LOGGER.info((Object)"Leave hibernate vm. ret= %s.", new Object[]{reply});
        return reply;
    }

    public VMOperateResponseType terminateVm(VrmObject vrmInfo, String vmUri, String urlExt) {
        String url;
        LOGGER.info((Object)"Enter into terminate vm.The vrm object is %s, the vmUri is %s.", new Object[]{vrmInfo, vmUri});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        if (urlExt == null) {
            urlExt = "";
        }
        if (vmUri.contains("@")) {
            vmUri = vmUri.replace("@", "");
            url = vmUri + "?" + "isReserveDisks=0" + "&" + "isOnlyDeleteDisksInDB=1" + "&" + "isDeleteShareDisks=1";
        } else {
            url = vmUri + "?" + "isReserveDisks=0" + urlExt;
            if (!url.contains("isDeleteShareDisks=1")) {
                url = url + "&" + "isDeleteShareDisks=1";
            }
        }
        VMOperateResponseType reply = this.vrmResource.deleteVrm(vrmInfo, url, VMOperateResponseType.class);
        LOGGER.info((Object)"Leave terminate vm. ret= %s.", new Object[]{reply});
        return reply;
    }

    public VMOperateResponseType powerOnHost(VrmObject vrmInfo, String hostUri) {
        LOGGER.info((Object)"@@Enter into power on Host, the hostUri is %s.", new Object[]{hostUri});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(hostUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = hostUri + "/action/poweron";
        VMOperateResponseType reply = this.vrmResource.postVrm(vrmInfo, url, null, VMOperateResponseType.class);
        LOGGER.info((Object)"@@Leave power on Host. ret=%s.", new Object[]{reply});
        return reply;
    }

    public VrmTaskType describeTasks(VrmObject vrmInfo, String taskUri) {
        LOGGER.debug((Object)"Enter into query task. vrm object is %s, taskUri is %s.", new Object[]{vrmInfo, taskUri});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(taskUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = taskUri;
        VrmTaskType task = this.vrmResource.getVrmResource(vrmInfo, url, VrmTaskType.class);
        LOGGER.debug((Object)"Leave query task. task is %s.", new Object[]{task});
        return task;
    }

    public DataStore queryDataStoreByWWN(VrmObject vrmInfo, String wwn) {
        LOGGER.debug((Object)"Enter into query dataStore by wwn.The vrm object is %s, the wwn is %s.", new Object[]{vrmInfo, wwn});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(wwn);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        List<DataStore> dsList = this.queryDataStore(vrmInfo);
        for (DataStore ds : dsList) {
            if (("LUNPOME".equals(ds.getStorageType()) || "NAS".equals(ds.getStorageType()) || "LUN".equals(ds.getStorageType())) && DsgUtil.getDataStoreStorageWwns((DataStore)ds).contains(wwn)) {
                LOGGER.info((Object)"Query dataStore by wwn. The datastore urn is %s.", new Object[]{ds.getUrn()});
                return ds;
            }
            if (!wwn.startsWith("SNAPSHOTID_") || !ds.getName().endsWith(wwn)) continue;
            LOGGER.info((Object)"Query dataStore by wwn. dataSotre= %s.", new Object[]{ds});
            return ds;
        }
        LOGGER.error((Object)"Result of query datastore is null, wwn=%s.", new Object[]{wwn});
        return null;
    }

    public void checkLicense(VrmObject vrmInfo) {
        LOGGER.info((Object)"Enter into check vrm license.The vrm object is %s.", new Object[]{vrmInfo});
        this.vrmCommon.checkVrmObject(vrmInfo);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String checkVersionStr = (String)this.vrmResource.getConfig().get("vrm_checkVersion");
        if (VerifyUtil.isEmpty((String)checkVersionStr)) {
            return;
        }
        String[] checkVersions = checkVersionStr.split(";");
        if (!Arrays.asList(checkVersions).contains(vrmInfo.getVersion().getVersion())) {
            LOGGER.info((Object)"Version(%s) don't need checking vrm license.", new Object[]{vrmInfo.getVersion().getVersion()});
            return;
        }
        String url = vrmInfo.getUri() + "/licservice/getLicenseVersion";
        LicenseVersionResponseType reply = this.vrmResource.getVrmResource(vrmInfo, url, LicenseVersionResponseType.class);
        if (reply != null && reply.getVersion() != null) {
            LOGGER.info((Object)"The vrm license is %s.", (long)reply.getVersion().intValue());
            this.checkLicVersion(reply.getVersion());
        }
    }

    public GalaxVM queryVMByUri(VrmObject vrmInfo, String vmUri) {
        LOGGER.debug((Object)"Enter into queryVMByUri, vrmInfo is %s.", new Object[]{vrmInfo});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(vmUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        VmMsgsData vmInfo = this.getVrmResource().getVrmResource(vrmInfo, vmUri, VmMsgsData.class);
        GalaxVM ret = null;
        if (vmInfo != null) {
            if (!StringUtils.isBlank((CharSequence)vmInfo.getErrorCode())) {
                LOGGER.error((Object)"QueryVMByUri failed, errorCode is %s.", new Object[]{vmInfo.getErrorCode()});
                return null;
            }
            this.calVMDataStoreUrns(vmInfo);
            ret = VirtualResourceMgrUtil.setGalaxVmInfo(vmInfo, false);
            if (ret == null) {
                LOGGER.error((Object)"The ret is null.");
                return null;
            }
            ret.setHostUrn(vmInfo.getHostUrn());
            LOGGER.debug((Object)"Leave queryVMByUri, ret is %s.", new Object[]{ret});
        } else {
            LOGGER.info((Object)"The queryVMByUri return null.");
        }
        return ret;
    }

    public List<VmBalanceData> queryVMBalanceDr(VrmObject vrmInfo, String clusterUri) {
        LOGGER.debug((Object)"Enter queryVMBalanceDr, vrm: %s, cluster: %s.", new Object[]{vrmInfo, clusterUri});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(clusterUri);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = clusterUri + "/action/loadbalancedr";
        QueryVmBalanceRespone respone = this.vrmResource.postVrm(vrmInfo, url, null, QueryVmBalanceRespone.class);
        if (respone == null || respone.getRecommendations() == null) {
            LOGGER.info((Object)"Result of queryVMBalanceDr is null. clusterUri= %s.", new Object[]{clusterUri});
            return null;
        }
        LOGGER.debug((Object)"Leave queryVMBalanceDr, size of data is %s.", (long)respone.getRecommendations().size());
        return respone.getRecommendations();
    }

    public List<GalaxVM> queryVMByIp(VrmObject vrmInfo, String ip) {
        LOGGER.debug((Object)"Enter into queryVMByIp, vrmInfo is %s, ip is %s.", new Object[]{vrmInfo, ip});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(ip);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        PageQueryVMCondition condition = new PageQueryVMCondition();
        condition.setIp(ip);
        String vmUrl = vrmInfo.getUri() + "/vms";
        String queryListVmsUrl = vmUrl + condition.toUrl();
        ListVmsResponseType vmInfo = this.vrmResource.getVrmResource(vrmInfo, queryListVmsUrl, ListVmsResponseType.class);
        List<ListVmMsgsData> vms = this.getAllVMList(vmInfo, vmUrl, condition, vrmInfo);
        ArrayList<GalaxVM> ret = new ArrayList<GalaxVM>(vms.size());
        for (ListVmMsgsData vmData : vms) {
            GalaxVM vm = new GalaxVM();
            vm.setName(vmData.getName());
            vm.setUri(vmData.getUri());
            vm.setUrn(vmData.getUrn());
            vm.setUuid(vmData.getUuid());
            ret.add(vm);
        }
        LOGGER.info((Object)"Leave queryVMByIp, ret is %s.", new Object[]{ret});
        return ret;
    }

    public GalaxVM queryVMByUuid(VrmObject vrmInfo, String uuid) {
        LOGGER.debug((Object)"Enter into queryVMByUuid,  vrmInfo is %s, uuid is %s.", new Object[]{vrmInfo, uuid});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(uuid);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        PageQueryVMCondition condition = new PageQueryVMCondition();
        condition.setUuid(uuid);
        condition.setDetail(Integer.valueOf(1));
        String vmUrl = vrmInfo.getUri() + "/vms";
        String queryListVmsUrl = vmUrl + condition.toUrl();
        ListVmsResponseType vmInfo = this.vrmResource.getVrmResource(vrmInfo, queryListVmsUrl, ListVmsResponseType.class);
        List<ListVmMsgsData> vms = this.getAllVMList(vmInfo, vmUrl, condition, vrmInfo);
        ArrayList<GalaxVM> ret = new ArrayList<GalaxVM>(vms.size());
        for (ListVmMsgsData vmData : vms) {
            GalaxVM vm = new GalaxVM();
            vm.setVmStatus(vmData.getStatus());
            vm.setName(vmData.getName());
            vm.setUri(vmData.getUri());
            vm.setUrn(vmData.getUrn());
            vm.setUuid(vmData.getUuid());
            vm.setVmType(vmData.getVmType());
            ret.add(vm);
        }
        LOGGER.debug((Object)"Leave queryVMByUuid, ret is %s.", new Object[]{ret});
        return ret.isEmpty() ? null : (GalaxVM)ret.get(0);
    }

    public VolumeData queryVolumeByUrn(VrmObject vrmInfo, String urn) {
        LOGGER.debug((Object)"Enter into queryVolumeByUrn, vrmInfo is %s, urn is %s.", new Object[]{vrmInfo, urn});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(urn);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        PageQueryVolumeRequestType condition = new PageQueryVolumeRequestType();
        condition.setVolUrn(urn);
        String volumeUrl = vrmInfo.getUri() + "/volumes";
        String queryListVmsUrl = volumeUrl + condition.toUrl();
        PageQueryVolumeResponseType volInfo = this.vrmResource.getVrmResource(vrmInfo, queryListVmsUrl, PageQueryVolumeResponseType.class);
        LOGGER.debug((Object)"Leave queryVolumeByUrn.");
        if (volInfo == null) {
            return null;
        }
        return volInfo.getTotal() == 0 ? null : (VolumeData)volInfo.getVolumes().get(0);
    }

    public List<VolumeData> queryVolumeByDataStoreUrn(VrmObject vrmInfo, String dataStoreUrn, boolean drFlag) {
        LOGGER.debug((Object)"Enter into queryVolumeByDataStoreUrn, vrmInfo is %s , dataStoreUrn is %s.", new Object[]{vrmInfo, dataStoreUrn});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(dataStoreUrn);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        ArrayList<VolumeData> volumeInfos = new ArrayList<VolumeData>();
        String volumeUrl = vrmInfo.getUri() + "/volumes";
        int idx = 0;
        while (true) {
            PageQueryVolumeRequestType condition = new PageQueryVolumeRequestType();
            condition.setScope(dataStoreUrn);
            condition.setDrFlag(Boolean.valueOf(drFlag));
            condition.setOffset(Integer.valueOf(idx * 100));
            String queryListVmsUrl = volumeUrl + condition.toUrl();
            PageQueryVolumeResponseType volInfo = this.vrmResource.getVrmResource(vrmInfo, queryListVmsUrl, PageQueryVolumeResponseType.class);
            if (volInfo == null || VerifyUtil.isEmpty((Collection)volInfo.getVolumes())) {
                LOGGER.info((Object)"There is no more volume from FC, dataStoreUrn= %s.", new Object[]{dataStoreUrn});
                break;
            }
            List volumeDatas = volInfo.getVolumes();
            volumeInfos.addAll(volumeDatas);
            if (volumeDatas.size() < 100) {
                LOGGER.info((Object)"End query volume by datastore, dataStoreUrn= %s.", new Object[]{dataStoreUrn});
                break;
            }
            ++idx;
        }
        LOGGER.debug((Object)"Leave queryVolumeByDataStoreUrn.");
        return volumeInfos;
    }

    public String getDatastoreInfos(String vrmSn, String dsUrn) {
        LOGGER.debug((Object)"Enter into getDatastoreInfos,vrmSn: %s, dataStoreUrn= %s.", new Object[]{vrmSn, dsUrn});
        VrmObject vrmInfo = VrmUtil.getRecoveryVrmObject((String)vrmSn);
        List<VolumeData> volumeDatas = this.queryVolumeByDataStoreUrn(vrmInfo, dsUrn, false);
        boolean hasIsolateVolume = false;
        JSONObject result = new JSONObject();
        for (VolumeData volumeData : volumeDatas) {
            if (volumeData.getBindToVm() == 3) continue;
            hasIsolateVolume = true;
            break;
        }
        result.put((Object)"hasIsolateVolume", (Object)hasIsolateVolume);
        return result.toString();
    }

    private List<ListVmMsgsData> getAllVMList(ListVmsResponseType vmsByDs, String vmUrl, PageQueryVMCondition condition, VrmObject vrmInfo) {
        List<Object> vms = new ArrayList<ListVmMsgsData>();
        if (vmsByDs != null && vmsByDs.getVms() != null && !vmsByDs.getVms().isEmpty()) {
            vms = vmsByDs.getVms();
            int limit = condition.getLimit();
            LOGGER.info((Object)"The vm's total is :%s.", (long)vmsByDs.getTotal().intValue());
            if (vmsByDs.getTotal() > limit) {
                int index = vmsByDs.getTotal() / limit;
                vms = this.getOtherVMS(index, vmUrl, condition, vrmInfo, vms);
            }
        }
        return vms;
    }

    public GalaxVM queryVmDetailInfo(String vmUri, VrmObject vrmInfo) {
        LOGGER.debug((Object)"Enter into query VM detail, vrmInfo= %s, vmUri= %s.", new Object[]{vrmInfo, vmUri});
        String queryVmUrl = vmUri + "?listAllDisks=1";
        VmMsgsData vmInfo = this.vrmResource.getVrmResource(vrmInfo, queryVmUrl, VmMsgsData.class);
        GalaxVM galaxVm = VirtualResourceMgrUtil.setGalaxVmInfo(vmInfo, true);
        LOGGER.debug((Object)"Leave query VM detail, ret= %s.", new Object[]{galaxVm});
        return galaxVm;
    }

    public Integer queryVrmLicenseVersion(VrmObject vrmInfo) {
        LOGGER.debug((Object)"Enter into query VRM license, vrmInfo=%s.", new Object[]{vrmInfo});
        String url = vrmInfo.getUri() + "/licservice/getLicenseVersion";
        LicenseVersionResponseType reply = this.vrmResource.getVrmResource(vrmInfo, url, LicenseVersionResponseType.class);
        if (reply == null || reply.getVersion() == null) {
            LOGGER.error((Object)"Get FC Version failed, ip=%s.", new Object[]{vrmInfo.getIp()});
            return null;
        }
        LOGGER.debug((Object)"Leave query VRM license.");
        return reply.getVersion();
    }

    private void checkDatastoreRequest(CreateDatastoreRequestType requests) {
        if (StringUtils.isBlank((CharSequence)requests.getHostUrn()) || StringUtils.isBlank((CharSequence)requests.getStorageUnitUrn()) || StringUtils.isBlank((CharSequence)requests.getName())) {
            LOGGER.error((Object)"The param is invalid.", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkSetDataStoreModeRequest(SetDataStoreModeRequestType requests) {
        if (StringUtils.isBlank((CharSequence)requests.getMode())) {
            LOGGER.error((Object)"The param is invalid.", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkRefreshStorageRequest(RefreshStorageUnitRequestType request) {
        if (StringUtils.isBlank((CharSequence)request.getHostUrn())) {
            LOGGER.error((Object)"The param is invalid.", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private void checkRegisterVMRequest(RegisterVMRequestType request) {
        if (StringUtils.isBlank((CharSequence)request.getUuid()) || StringUtils.isBlank((CharSequence)request.getLocation()) || request.getVmConfig() == null || request.getOsOptions() == null) {
            LOGGER.error((Object)"The param is invalid.", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private List<ListVmMsgsData> getOtherVMS(int index, String vmUrl, PageQueryVMCondition condition, VrmObject vrmInfo, List<ListVmMsgsData> vms) {
        int limit = condition.getLimit();
        for (int i = 1; i <= index; ++i) {
            condition.setOffset(Integer.valueOf(i * limit));
            String queryListVmsUrl = vmUrl + condition.toUrl();
            LOGGER.info((Object)"QueryListVmsUrl :%s.", new Object[]{queryListVmsUrl});
            ListVmsResponseType vmslist = this.vrmResource.getVrmResource(vrmInfo, queryListVmsUrl, ListVmsResponseType.class);
            if (vmslist == null || vmslist.getVms() == null || vmslist.getVms().isEmpty()) continue;
            vms.addAll(vmslist.getVms());
        }
        return vms;
    }

    public void setVrmCommon(VirtualResourceManagerCommon vrmCommon) {
        this.vrmCommon = vrmCommon;
    }

    public VirtualResourceManagerCommon getVrmCommon() {
        return this.vrmCommon;
    }

    public VMOperateResponseType setOccupiedvmProperty(VrmObject vrmInfo, GalaxVM occupiedVm, Integer recoverPointNum) {
        LOGGER.info((Object)"Enter into set occupied vm property, vrmInfo=%s.", new Object[]{vrmInfo});
        this.vrmCommon.checkVrmObject(vrmInfo);
        if (occupiedVm == null) {
            LOGGER.error((Object)"The occupiedVM object is null.");
            throw new LegoCheckedException(1073947393L);
        }
        this.vrmCommon.checkStringParam(occupiedVm.getUri());
        LOGGER.info((Object)"Parameter of vmUri is %s.", new Object[]{occupiedVm.getUri()});
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = occupiedVm.getUri() + "/action/setoccupiedvmproperty";
        SetOccupiedVmRequestType request = new SetOccupiedVmRequestType();
        request.setRecoverPointNum(recoverPointNum);
        VMOperateResponseType reply = this.vrmResource.postVrm(vrmInfo, url, request, VMOperateResponseType.class);
        LOGGER.info((Object)"Leave set occupied vm property. ret=%s.", new Object[]{reply});
        return reply;
    }

    public List<VmSnapshot> queryVmSnapshot(VrmObject vrmInfo, GalaxVM occupiedVm) {
        LOGGER.debug((Object)"Enter into query vrm vmsnapshot list, the vrm object is %s.", new Object[]{vrmInfo.toString()});
        this.vrmCommon.checkVrmObject(vrmInfo);
        if (occupiedVm == null) {
            LOGGER.error((Object)"The occupiedVm object is null.");
            throw new LegoCheckedException(1073947393L);
        }
        LOGGER.debug((Object)"Parameter vmUri=%s.", new Object[]{occupiedVm.getUri()});
        this.vrmCommon.checkStringParam(occupiedVm.getUri());
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        String url = occupiedVm.getUri() + "/snapshots";
        ListVmSnapshotsResponseType vmSnapshotList = this.vrmResource.getVrmResource(vrmInfo, url, ListVmSnapshotsResponseType.class);
        if (vmSnapshotList != null && vmSnapshotList.getCurrentSnapshot() != null && vmSnapshotList.getRootSnapshots() != null) {
            ArrayList<VmSnapshot> snapshotListResult = new ArrayList<VmSnapshot>();
            snapshotListResult.add(vmSnapshotList.getCurrentSnapshot());
            this.getSnapshotList(vmSnapshotList.getRootSnapshots(), snapshotListResult);
            LOGGER.debug((Object)"Leave query vrm vmsnapshot list, result is =%s.", new Object[]{snapshotListResult});
            return snapshotListResult;
        }
        LOGGER.warn((Object)"Leave query vrm vmsnapshot list, result is null.");
        return null;
    }

    public <T> VMOperateResponseType modifyDrsGroup(String modifyUrl, VrmObject vrmInfo, T msg) {
        this.vrmCommon.checkVrmObject(vrmInfo);
        vrmInfo = this.vrmCommon.checkSiteUri(vrmInfo, this.vrmResource);
        return this.vrmResource.putVrm(vrmInfo, vrmInfo.getUri() + modifyUrl, msg, VMOperateResponseType.class);
    }

    public List<PhysicalStorageDevice> queryStorageAdapter(VrmObject vrmInfo, String hostUri) {
        LOGGER.debug((Object)"Enter into query storage adapter, vrmInfo=%s, hostUri=%s.", new Object[]{vrmInfo, hostUri});
        this.vrmCommon.checkVrmObject(vrmInfo);
        this.vrmCommon.checkStringParam(hostUri);
        String url = hostUri + "/storageadapters";
        ListStorageAdapterResponeType response = this.vrmResource.getVrmResource(vrmInfo, url, ListStorageAdapterResponeType.class);
        if (response == null || VerifyUtil.isEmpty((Collection)response.getStorageAdapters())) {
            LOGGER.error((Object)"There is no HBA info, hostUri=%s.", new Object[]{hostUri});
            return null;
        }
        ArrayList<PhysicalStorageDevice> devices = new ArrayList<PhysicalStorageDevice>();
        List storageAdapters = response.getStorageAdapters();
        for (StorageAdapterMsgData msgData : storageAdapters) {
            PhysicalStorageDevice storageDevice = new PhysicalStorageDevice();
            storageDevice.setUri(msgData.getUri());
            storageDevice.setUrn(msgData.getUrn());
            storageDevice.setUuid(msgData.getUrn());
            storageDevice.setName(msgData.getName());
            storageDevice.setDeviceName(msgData.getName());
            storageDevice.setDeviceUuid(msgData.getUrn());
            storageDevice.setDeviceType(msgData.getType());
            storageDevice.setStorageWwn(this.getStorageDeviceWwn(msgData.getType(), msgData.getWwn()));
            devices.add(storageDevice);
        }
        LOGGER.debug((Object)"Leave queryStorageAdapter,devices=%s.", new Object[]{devices});
        return devices;
    }

    public List<GalaxVM> queryVmsByUuuids(Set<String> vmUuids, VrmObject vrmInfo) {
        LOGGER.debug((Object)"Enter into query vm by uuids, vrmInfo=%s, vmUUids=%s.", new Object[]{vrmInfo, vmUuids});
        this.vrmCommon.checkVrmObject(vrmInfo);
        ArrayList<GalaxVM> retVms = new ArrayList<GalaxVM>();
        if (VerifyUtil.isEmpty(vmUuids)) {
            LOGGER.warn((Object)"parameter vmUUids is empty, sn=%s.", new Object[]{vrmInfo});
            return retVms;
        }
        List<GalaxVM> galaxVms = this.queryVMByDataStore(vrmInfo);
        if (VerifyUtil.isEmpty(galaxVms)) {
            LOGGER.warn((Object)"there is no vm from fc, sn=%s.", new Object[]{vrmInfo});
            return retVms;
        }
        for (GalaxVM vm : galaxVms) {
            if (!vmUuids.contains(vm.getUuid()) && !vmUuids.contains(vm.getUuid().substring("P".length()))) continue;
            retVms.add(vm);
        }
        return retVms;
    }

    public void multiSetVmBlockIoHangTimeout(VrmObject vrmInfo, JSONObject message) {
        LOGGER.info((Object)"Start sending request for multiSetVmBlockIoHangTimeout.");
        String url = vrmInfo.getUri() + "/vms/action/multiSetVmBlockIoHangTimeout";
        VmConfigsTaskType response = this.vrmResource.postVrm(vrmInfo, url, message, VmConfigsTaskType.class);
        if (VerifyUtil.isEmpty((Object)response)) {
            LOGGER.error((Object)"Failed to send the request of multiSetVmBlockIoHangTimeout, url is %s, request is %s.", new Object[]{url, message});
            throw new LegoCheckedException(1073948374L);
        }
        if (VerifyUtil.isEmpty((String)response.getTaskUri()) || VerifyUtil.isEmpty((String)response.getTaskUrn())) {
            LOGGER.error((Object)"Failed to send the request of multiSetVmBlockIoHangTimeout, url is %s, request is %s, response is %s.", new Object[]{url, message, JSONObject.fromObject((Object)response)});
            throw new LegoCheckedException(1073948374L);
        }
        long waitTime = 2000L;
        int retryCount = 1800;
        try {
            while (retryCount-- > 0) {
                Thread.sleep(2000L);
                VrmTaskType taskType = this.describeTasks(vrmInfo, response.getTaskUri());
                if (!"failed".equals(taskType.getStatus()) && !"success".equals(taskType.getStatus())) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Error of sleep thread, error is %s.", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        LOGGER.error((Object)"Unknown result of multiSetVmBlockIoHangTimeout.");
    }

    public SetVolIOPropResponseType enableVmsHypermetro(VrmObject vrmInfo, List<? extends HypermetroVolumeInfo> hypermetroVolumeInfos) {
        LOGGER.debug((Object)"Start sending request for enableVmsHypermetro.");
        String url = this.getVmsHypermetroUri(vrmInfo, hypermetroVolumeInfos);
        SetVolIOPropResponseType reply = this.vrmResource.postVrm(vrmInfo, url, hypermetroVolumeInfos, SetVolIOPropResponseType.class);
        this.checkResponse(reply);
        if (!VerifyUtil.isEmpty((String)reply.getTaskUri())) {
            this.retryCheckTaskResult(vrmInfo, reply.getTaskUri());
        }
        return reply;
    }

    private void retryCheckTaskResult(VrmObject vrmInfo, String taskUri) {
        VrmTaskType vrmTaskType;
        while ((vrmTaskType = this.describeTasks(vrmInfo, taskUri)) == null || !vrmTaskType.getStatus().equals(TaskExecuteStatus.success.name())) {
            if (vrmTaskType != null && vrmTaskType.getStatus().equals(TaskExecuteStatus.failed.name())) {
                LOGGER.error((Object)"Failed to send the request of enableVmsHypermetro or stopVmsHypermetro.");
                throw new LegoCheckedException(1073948374L);
            }
            CommonUtil.sleep((long)5000L);
        }
        return;
    }

    public SetVolIOPropResponseType stopVmsHypermetro(VrmObject vrmInfo, List<? extends HypermetroVolumeInfo> hypermetroVolumeInfos) {
        LOGGER.debug((Object)"Start sending request for stopVmsHypermetro.");
        String url = this.getVmsHypermetroUri(vrmInfo, hypermetroVolumeInfos);
        SetVolIOPropResponseType reply = this.vrmResource.deleteVrmByBody(vrmInfo, url, hypermetroVolumeInfos, SetVolIOPropResponseType.class);
        this.checkResponse(reply);
        if (!VerifyUtil.isEmpty((String)reply.getTaskUri())) {
            this.retryCheckTaskResult(vrmInfo, reply.getTaskUri());
        }
        return reply;
    }

    private String getVmsHypermetroUri(VrmObject vrmInfo, List<? extends HypermetroVolumeInfo> hypermetroVolumeInfos) {
        VerifyUtil.checkObjs((Object[])new Object[]{vrmInfo, vrmInfo.getUri(), hypermetroVolumeInfos});
        if (hypermetroVolumeInfos.get(0) instanceof EVolHypermetroVolumeInfo) {
            return vrmInfo.getUri() + "/evol/hyperMetro";
        }
        if (hypermetroVolumeInfos.get(0) instanceof FusionStorageHypermetroVolumeInfo) {
            return vrmInfo.getUri() + "/hyperMetro";
        }
        LOGGER.error((Object)"Object hypermetroVolumeInfos is invalidation.");
        throw new LegoCheckedException(1073947393L);
    }

    public void checkVmsHypermetro(VrmObject vrmInfo, ProtectGroup protectGroup, GalaxVM vm, List<DiskInfo> diskInfoList) {
        boolean isEvsHyperMetro;
        LOGGER.debug((Object)"Start sending request for checkVmsHypermetro.");
        VmConfigType vmConfigType = (VmConfigType)JSONObject.toBean((String)vm.getVmConfig(), VmConfigType.class);
        if (VerifyUtil.isEmpty((Object)vmConfigType) || VerifyUtil.isEmpty((Collection)vmConfigType.getDisks()) || VerifyUtil.isEmpty(diskInfoList)) {
            return;
        }
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(vrmInfo.getUri());
        urlBuilder.append("/volumes");
        urlBuilder.append("?");
        for (VmConfigDiskType diskType : vmConfigType.getDisks()) {
            urlBuilder.append("volUrns=");
            urlBuilder.append(diskType.getVolumeUrn());
            urlBuilder.append("&");
        }
        urlBuilder.append("limit=1000&offset=0&refreshflag=true");
        VmConfigDiskResponse response = this.vrmResource.getVrmResource(vrmInfo, urlBuilder.toString(), VmConfigDiskResponse.class);
        HashMap<String, VmConfigDiskType> diskTypeMap = new HashMap<String, VmConfigDiskType>();
        for (VmConfigDiskType diskType : response.getVolumes()) {
            diskTypeMap.put(diskType.getVolNameOnDev(), diskType);
        }
        List<FusionStorageHypermetroVolumeInfo> hypermetroVolumeInfos = this.buildHypermetroVolumeInfos(protectGroup, diskInfoList, diskTypeMap);
        boolean bl = isEvsHyperMetro = protectGroup.getTemplate().getType() == 53;
        if (!VerifyUtil.isEmpty(hypermetroVolumeInfos) && !isEvsHyperMetro) {
            this.enableVmsHypermetro(vrmInfo, hypermetroVolumeInfos);
        }
    }

    private List<FusionStorageHypermetroVolumeInfo> buildHypermetroVolumeInfos(ProtectGroup protectGroup, List<DiskInfo> diskInfoList, Map<String, VmConfigDiskType> diskTypeMap) {
        StorageLunManagerProxy lunManagerProxy = StorageLunManagerProxy.getInstance();
        String hypermetroCfg = (String)protectGroup.getProps().get("storagePoolMapping");
        HypermetroPairConfiguration config = new HypermetroPairConfiguration(hypermetroCfg);
        StoragePair storagePair = config.findStoragePair();
        ArrayList<FusionStorageHypermetroVolumeInfo> hypermetroVolumeInfos = new ArrayList<FusionStorageHypermetroVolumeInfo>();
        List fusionStorageUnitList = ((IStorageBaseService)ServiceLocator.getInstance().getService(IStorageBaseService.class)).getFusionStorageStorageList();
        Map poolIdAndNameMap = HypermetroUtil.getPoolMap();
        for (DiskInfo diskInfo : diskInfoList) {
            String deviceName = diskInfo.getDeviceName();
            String status = diskInfo.getStatus();
            if (!DiskProtectStatusEnum.PROTECTED.getStatus().equals(status) && !DiskProtectStatusEnum.EXPANDED.getStatus().equals(status)) {
                LOGGER.info((Object)"Disk(resource id: %s) is not protected or expanded.", new Object[]{diskInfo.getResourceId()});
                continue;
            }
            if (!diskTypeMap.containsKey(deviceName) || diskTypeMap.get(deviceName).getIsHypermetro() != 0) continue;
            Lun srcLun = lunManagerProxy.getLunById(diskInfo.getDevSn(), diskInfo.getResourceId());
            String srcPoolId = srcLun.getStoragePoolId();
            String tgtDevSn = diskInfo.getDevSn().equals(storagePair.getSrcDevSN()) ? storagePair.getTgtDevSN() : storagePair.getSrcDevSN();
            FusionStorageHypermetroVolumeInfo hypermetroVolumeInfo = new FusionStorageHypermetroVolumeInfo();
            hypermetroVolumeInfo.setUuid(srcLun.getName());
            String poolId = storagePair.getTgtStoragePool(diskInfo.getDevSn(), srcPoolId);
            hypermetroVolumeInfo.setStandbyDs((String)poolIdAndNameMap.get(CommUtil.combineString((String[])new String[]{tgtDevSn, poolId})));
            hypermetroVolumeInfo.setStandbyPoolId(poolId);
            List fusionStorageUnits = fusionStorageUnitList.stream().filter(fusionStorageUnit -> fusionStorageUnit.getDevSn().equals(tgtDevSn)).collect(Collectors.toList());
            hypermetroVolumeInfo.setStandbyFloatIp(((FusionStorageUnit)fusionStorageUnits.get(0)).getIpAddress());
            hypermetroVolumeInfos.add(hypermetroVolumeInfo);
        }
        return hypermetroVolumeInfos;
    }
}

