/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.manager.impl;

import com.huawei.ism.drm.galax.sdk.vrm.model.ListSitesResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.ListVersionResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.RegisterVMResponseType;
import com.huawei.ism.drm.galax.sdk.vrm.model.SiteMsgsData;
import com.huawei.ism.drm.galax.sdk.vrm.model.VersionInfo;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.util.rest.RestServiceClient;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class VrmResource {
    private static final Log LOG = LogFactory.getInstance(VrmResource.class);
    private Properties config;
    private ConcurrentMap<String, RestServiceClient> clientTable = new ConcurrentHashMap<String, RestServiceClient>();

    public Properties getConfig() {
        return this.config;
    }

    public void setConfig(Properties config) {
        this.config = config;
    }

    public VrmObject login(VrmObject vrmInfo) {
        LOG.info((Object)"Enter into login vrm, get site and version info", 90160758786816L);
        ListVersionResponseType versions = this.getVersion(vrmInfo);
        vrmInfo = this.checkVersion(vrmInfo, versions);
        vrmInfo = this.getSiteInfo(vrmInfo);
        LOG.info((Object)"Leave login vrm", 90160758786816L);
        return vrmInfo;
    }

    public <T> T getVrmResource(VrmObject vrmInfo, String url, Class<T> claz) {
        RestServiceClient restClient;
        try {
            restClient = this.getClient(vrmInfo);
        }
        catch (Exception e) {
            LOG.error((Object)("getVrmResource failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            return null;
        }
        return (T)restClient.get(url, claz);
    }

    public <T> T postVrm(VrmObject vrmInfo, String url, Object msg, Class<T> claz) {
        RestServiceClient restClient;
        try {
            restClient = this.getClient(vrmInfo);
        }
        catch (Exception e) {
            LOG.error((Object)("postVrm failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            return null;
        }
        boolean flagType = this.isVersion1(vrmInfo) && RegisterVMResponseType.class == claz;
        LOG.info((Object)("claz:" + claz), 90160758786816L);
        LOG.info((Object)("flagType:" + flagType), 90160758786816L);
        return (T)restClient.post(url, msg, claz, flagType);
    }

    private boolean isVersion1(VrmObject vrmInfo) {
        if (null == vrmInfo || null == vrmInfo.getVersion()) {
            LOG.error((Object)"vrm object is invaild", 90160758787071L);
            return false;
        }
        String checkVersionStr = (String)this.getConfig().get("vrm_checkVersion");
        if (VerifyUtil.isEmpty((String)checkVersionStr)) {
            LOG.error((Object)"Vrm version str is invaild", 90160758787071L);
            return false;
        }
        String[] checkVersions = checkVersionStr.split(";");
        LOG.error((Object)("VRM'S version:" + vrmInfo.getVersion().getVersion()), 90160758786816L);
        if (!Arrays.asList(checkVersions).contains(vrmInfo.getVersion().getVersion())) {
            LOG.error((Object)"Vrm's version is beyound c00.", 90160758787071L);
            return false;
        }
        return true;
    }

    public <T> T putVrm(VrmObject vrmInfo, String url, Object msg, Class<T> claz) {
        RestServiceClient restClient;
        try {
            restClient = this.getClient(vrmInfo);
        }
        catch (Exception e) {
            LOG.error((Object)("putVrm failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            return null;
        }
        return (T)restClient.put(url, msg, claz);
    }

    public <T> T deleteVrm(VrmObject vrmInfo, String url, Class<T> claz) {
        RestServiceClient restClient;
        try {
            restClient = this.getClient(vrmInfo);
        }
        catch (Exception e) {
            LOG.error((Object)("deleteVrm failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            return null;
        }
        return (T)restClient.delete(url, claz);
    }

    public <T> T deleteVrmByBody(VrmObject vrmInfo, String url, Object msg, Class<T> claz) {
        RestServiceClient restClient;
        try {
            restClient = this.getClient(vrmInfo);
        }
        catch (Exception e) {
            LOG.error((Object)("deleteVrm failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            return null;
        }
        return (T)restClient.delete(url, msg, claz);
    }

    private RestServiceClient init(VrmObject vrmInfo) {
        RestServiceClient restClient = null == vrmInfo.getVersion() || StringUtils.isBlank((CharSequence)vrmInfo.getVersion().getLoginUri()) || StringUtils.isBlank((CharSequence)vrmInfo.getVersion().getVersion()) ? new RestServiceClient(vrmInfo.getIp(), vrmInfo.getPort().intValue(), vrmInfo.getUser(), vrmInfo.getPwd()) : new RestServiceClient(vrmInfo.getIp(), vrmInfo.getPort().intValue(), vrmInfo.getUser(), vrmInfo.getPwd(), vrmInfo.getVersion().getVersion(), vrmInfo.getVersion().getLoginUri());
        return restClient;
    }

    private RestServiceClient getClient(VrmObject vrmInfo) {
        RestServiceClient client = (RestServiceClient)this.clientTable.get(vrmInfo.getIp());
        if (client == null) {
            RestServiceClient newClient = this.init(vrmInfo);
            client = this.clientTable.putIfAbsent(vrmInfo.getIp(), newClient);
            if (client == null) {
                client = newClient;
            }
        }
        if (!client.getPwd().equals(vrmInfo.getPwd()) || !client.getUserName().equals(vrmInfo.getUser()) || client.getPort() != vrmInfo.getPort().intValue()) {
            client = this.init(vrmInfo);
            this.clientTable.put(vrmInfo.getIp(), client);
        }
        if (null != vrmInfo.getVersion() && !StringUtils.isBlank((CharSequence)vrmInfo.getVersion().getLoginUri()) && !StringUtils.isBlank((CharSequence)vrmInfo.getVersion().getVersion())) {
            client.setVersion(vrmInfo.getVersion().getVersion());
            client.setLogUri(vrmInfo.getVersion().getLoginUri());
        }
        return client;
    }

    private VrmObject getSiteInfo(VrmObject vrmInfo) {
        LOG.info((Object)"Enter into get vrm site info.");
        String url = "/service/sites";
        ListSitesResponseType listSites = this.getVrmResource(vrmInfo, url, ListSitesResponseType.class);
        if (VerifyUtil.isEmpty((Object)listSites) || VerifyUtil.isEmpty((Collection)listSites.getSites())) {
            if (!VerifyUtil.isEmpty((String)listSites.getErrorCode())) {
                LOG.error((Object)"Get vrm site info error,errorCode:%s. errorDes:%s.", new Object[]{listSites.getErrorCode(), listSites.getErrorDes()});
                throw new LegoCheckedException(Long.parseLong(listSites.getErrorCode()));
            }
            LOG.warn((Object)"Get vrm site info is empty!");
            return vrmInfo;
        }
        for (SiteMsgsData site : listSites.getSites()) {
            if (!site.getIsSelf().booleanValue()) continue;
            vrmInfo.setName(VrmResource.generateSiteName(site));
            vrmInfo.setDescription(site.getDescription());
            vrmInfo.setUri(site.getUri());
            vrmInfo.setUrn(site.getUrn());
        }
        LOG.info((Object)"Leave get vrm site info.");
        return vrmInfo;
    }

    private static String generateSiteName(SiteMsgsData site) {
        if (VerifyUtil.isEmpty((String)site.getUrn()) || site.getUrn().split(":").length != 3) {
            return site.getName();
        }
        return "FC_SN_" + site.getUrn().split(":")[2];
    }

    private ListVersionResponseType getVersion(VrmObject vrmInfo) {
        RestServiceClient restClient;
        LOG.info((Object)"Enter into get vrm version info", 90160758786816L);
        String url = "/service/versions";
        try {
            restClient = this.getClient(vrmInfo);
        }
        catch (Exception e) {
            LOG.error((Object)("getVersion failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            return null;
        }
        restClient.setLogUri("");
        restClient.setVersion("");
        ListVersionResponseType listVersions = (ListVersionResponseType)restClient.get(url, ListVersionResponseType.class);
        if (listVersions != null && listVersions.getVersions() != null && !listVersions.getVersions().isEmpty()) {
            List versionInfos = listVersions.getVersions();
            String version = ((VersionInfo)versionInfos.get(0)).getVersion();
            String uri = ((VersionInfo)versionInfos.get(0)).getLoginUri();
            restClient.setVersion(version);
            restClient.setLogUri(uri);
            LOG.info((Object)("Enter into get vrm version is: " + version), 90160758786816L);
        }
        LOG.info((Object)"Leave get vrm version info", 90160758786816L);
        return listVersions;
    }

    private VrmObject checkVersion(VrmObject vrmInfo, ListVersionResponseType versions) {
        if (null != versions && null != versions.getVersions() && !versions.getVersions().isEmpty()) {
            vrmInfo.setVersion(this.getVersionByConfig(versions));
        }
        return vrmInfo;
    }

    private VersionInfo getVersionByConfig(ListVersionResponseType versions) {
        String confVersions = (String)this.config.get("vrm_version");
        if (VerifyUtil.isEmpty((String)confVersions)) {
            return null;
        }
        Object[] versionArray = confVersions.split(";");
        Arrays.sort(versionArray);
        int len = versionArray.length;
        for (int i = len - 1; i >= 0; --i) {
            Object versionStr = versionArray[i];
            for (VersionInfo version : versions.getVersions()) {
                if (!version.getVersion().equals(versionStr)) continue;
                version.setVersion((String)versionStr);
                return version;
            }
        }
        return null;
    }
}

