/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.mapping;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.PageQuery;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.DrsGroup;
import com.huawei.ism.drm.galax.sdk.model.DrsMapping;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;

public class DrsMappingDao {
    private static final Log LOG = LogFactory.getInstance(DrsMappingDao.class);
    private IBaseDao<Object, Serializable> dao;
    private IMoDao moDao;

    public void saveDrsMappings(List<DrsMapping> drsMappings) {
        if (VerifyUtil.isEmpty(drsMappings)) {
            return;
        }
        try {
            SessionFactory sessionFactory = this.dao.getHibernateTemplate().getSessionFactory();
            Session session = sessionFactory.getCurrentSession();
            Transaction transaction = session.getTransaction();
            transaction.begin();
            for (DrsMapping mapping : drsMappings) {
                session.save((Object)mapping);
            }
            transaction.commit();
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)"Add drsMapping error.", (long)-1L, null, (Log)LOG);
        }
    }

    public List<DrsGroup> getDrsGroupByCluster(String productResourceId) {
        ComputeCluster cluster = (ComputeCluster)this.moDao.getMo(ComputeCluster.class, "urn", (Object)productResourceId);
        if (VerifyUtil.isEmpty((Object)cluster)) {
            return Collections.emptyList();
        }
        HashMap<String, ComputeCluster> params = new HashMap<String, ComputeCluster>();
        params.put("parentMo", cluster);
        List list = this.moDao.findMoBy(DrsGroup.class, params);
        if (VerifyUtil.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        return list;
    }

    public DrsGroup getDrsGroupByUrn(String urn) {
        this.checkParam(urn);
        return (DrsGroup)this.moDao.getMo(DrsGroup.class, "urn", (Object)urn);
    }

    public List<DrsMapping> getDrsMappingByResMappingId(String resourceMappingId, Boolean isValid) {
        this.checkParam(resourceMappingId);
        try {
            DetachedCriteria criteria = DetachedCriteria.forClass(DrsMapping.class);
            criteria.add((Criterion)Restrictions.eq((String)"resourceMapping.mappingId", (Object)resourceMappingId));
            if (isValid != null) {
                criteria.add((Criterion)Restrictions.eq((String)"isValid", (Object)isValid));
            }
            return this.dao.getHibernateTemplate().findByCriteria(criteria);
        }
        catch (DataAccessException ex) {
            LOG.error((Object)"Get getDrsMappingByResMappingId failed, resourceMappingId is %s, isValid is %s, msg is %s.", new Object[]{resourceMappingId, isValid, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    public DrsMapping getResourceMappingById(String mappingId) {
        this.checkParam(mappingId);
        try {
            DrsMapping drsMapping = (DrsMapping)this.dao.getHibernateTemplate().get(DrsMapping.class, (Serializable)((Object)mappingId));
            return drsMapping;
        }
        catch (DataAccessException ex) {
            LOG.error((Object)"Get drsMapping by id failed, mappingId is %s.", new Object[]{ex, mappingId});
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    public void updateDrsMapping(DrsMapping drsMapping) {
        try {
            this.dao.getHibernateTemplate().update((Object)drsMapping);
        }
        catch (DataAccessException ex) {
            LOG.error((Object)"Update drsMapping by id failed, drsMapping is %s.", new Object[]{ex, JSONObject.fromObject((Object)drsMapping)});
            throw new LegoCheckedException(-1L, ExceptionUtil.getErrorMessage((Throwable)ex));
        }
    }

    public void deleteDrsMapping(DrsMapping drsMapping) {
        try {
            this.dao.getHibernateTemplate().delete((Object)drsMapping);
        }
        catch (DataAccessException ex) {
            LOG.error((Object)"Delete drsMapping by id failed, mappingId is %s,error is %s.", new Object[]{drsMapping.getMappingId(), ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    public List<DrsMapping> getRuleTypeMappingByCite(String mappingId) {
        if (VerifyUtil.isEmpty((String)mappingId)) {
            return Collections.emptyList();
        }
        try {
            String hql = "select td from DrsMapping as td ,DrsMapping td1 where (td.fromDrsMapping.mappingId=td1.mappingId or td.toDrsMapping.mappingId=td1.mappingId) and td1.mappingId=?";
            return this.dao.getHibernateTemplate().find(hql, new Object[]{mappingId});
        }
        catch (DataAccessException ex) {
            LOG.error((Object)"Method getRuleTypeMappingByCite error, mappingId is %s,error is %s.", new Object[]{mappingId, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    public List<DrsMapping> checkGroupUrnByUsed(String groupUrn) {
        if (VerifyUtil.isEmpty((String)groupUrn)) {
            return Collections.emptyList();
        }
        try {
            String hql = "from DrsMapping td where td.productGroupUrn=? or td.recoveryGroupUrn=?";
            return this.dao.getHibernateTemplate().find(hql, new Object[]{groupUrn, groupUrn});
        }
        catch (DataAccessException ex) {
            LOG.error((Object)"Method checkGroupUrnByUsed error, groupUrn is %s,error is %s.", new Object[]{groupUrn, ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    public Page getDrsMappingByPage(PageQuery pageQuery) {
        this.checkParam(pageQuery);
        int startPage = pageQuery.getStartPage();
        LOG.info((Object)"getDrsMappingByPage,pageNo is %s,pageSize is %s,orderBy is %s,isAsc is %s.", new Object[]{startPage, pageQuery.getPageSize(), pageQuery.getOrderBy(), pageQuery.isAsc()});
        List list = this.dao.translatePropsToCriterions(pageQuery.getQueryConditionList());
        try {
            return this.dao.pagedQuery(DrsMapping.class, startPage, pageQuery.getPageSize(), list, pageQuery.getOrderBy(), pageQuery.isAsc());
        }
        catch (DataAccessException ex) {
            LOG.error((Object)"Method getDrsMappingByPage error, pageQuery is %s,error is %s.", new Object[]{JSONObject.fromObject((Object)pageQuery), ExceptionUtil.getErrorMessage((Throwable)ex)});
            throw new LegoCheckedException(-1L, (Throwable)ex);
        }
    }

    private void checkParam(Object param) {
        if (param == null) {
            LOG.error((Object)"Error params.");
            throw new LegoCheckedException(1073947393L);
        }
    }

    public IBaseDao<Object, Serializable> getDao() {
        return this.dao;
    }

    public void setDao(IBaseDao<Object, Serializable> dao) {
        this.dao = dao;
    }

    public IMoDao getMoDao() {
        return this.moDao;
    }

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }
}

