/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.mapping;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.PageQuery;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.DrsEnumDefine;
import com.huawei.ism.drm.galax.resource.mapping.DrsMappingDao;
import com.huawei.ism.drm.galax.resource.mapping.DrsMappingRemoteOperator;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingVerify;
import com.huawei.ism.drm.galax.resource.mapping.RmFcResourceService;
import com.huawei.ism.drm.galax.sdk.model.DrsGroup;
import com.huawei.ism.drm.galax.sdk.model.DrsGroupInfo;
import com.huawei.ism.drm.galax.sdk.model.DrsMapping;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.service.IResourceMappingService;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class DrsMappingOperator {
    private static final Log LOG = LogFactory.getInstance(DrsMappingOperator.class);
    private static final List<String> PROCESSING_DRS_MAPPING = new ArrayList<String>();
    private IResourceMappingService rmService;
    private ISiteBaseService siteService;
    private DrsMappingDao drsDao;
    private DrsMappingRemoteOperator drsRemoteOp;
    private RmFcResourceService rmFcService;
    private ResourceMappingVerify rmVerify;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchOperationResult createDrsMappings(List<DrsMapping> drsMappings, Integer groupType, String resourceMappingId) {
        BatchOperationResult ret = new BatchOperationResult();
        if (VerifyUtil.isEmpty(drsMappings) || VerifyUtil.isEmpty((Object)groupType)) {
            return ret;
        }
        ResourceMapping rm = this.getResourceMapping(resourceMappingId);
        Optional<Site> recoverySite = this.checkDoubleRdModel(rm.getRecoverySiteId());
        Optional<Site> productSite = this.checkDoubleRdModel(rm.getProductSiteId());
        if (recoverySite.isPresent() && productSite.isPresent()) {
            LOG.error((Object)"Neither recoverySite or productSite is localSite.");
            throw new LegoCheckedException(1073947393L);
        }
        List<Map<String, DrsGroup>> drsGroupMapList = this.getDrsGroupByResourceMappingId(rm, productSite.orElse(null), recoverySite.orElse(null));
        List<DrsMapping> persistList = this.drsDao.getDrsMappingByResMappingId(resourceMappingId, null);
        HashMap<String, DrsMapping> persistUrns = new HashMap<String, DrsMapping>();
        for (DrsMapping mapping : persistList) {
            persistUrns.put(mapping.getProductGroupUrn(), mapping);
            persistUrns.put(mapping.getRecoveryGroupUrn(), mapping);
        }
        this.tryLock(drsMappings);
        try {
            this.checkDrsMappings(drsMappings, drsGroupMapList, persistUrns);
            this.checkPersistDrsMapping(drsMappings, persistUrns, drsGroupMapList);
            ArrayList<BatchOperation> result = new ArrayList<BatchOperation>();
            for (DrsMapping mapping : drsMappings) {
                this.resetDrsMapping(mapping, drsGroupMapList, rm);
                BatchOperation batchOperation = new BatchOperation();
                batchOperation.setDetailParam(new String[]{mapping.getProductGroupName(), mapping.getRecoveryGroupName(), rm.getProductResourceName(), rm.getProductSiteName(), rm.getProductResourceProviderName(), rm.getRecoveryResourceName(), rm.getRecoverySiteName(), rm.getRecoveryResourceProviderName()});
                result.add(batchOperation);
            }
            recoverySite.ifPresent(site -> this.drsRemoteOp.postRemoteRes(drsMappings, (Site)site));
            productSite.ifPresent(site -> this.drsRemoteOp.postRemoteRes(drsMappings, (Site)site));
            this.drsDao.saveDrsMappings(drsMappings);
            ret.setSucceedCount(drsMappings.size());
            ret.setTotalCount(drsMappings.size());
            ret.setResult(result);
        }
        finally {
            this.releaseLock(drsMappings);
        }
        return ret;
    }

    public void synAddDrsMapping(List<DrsMapping> drsMappings) {
        this.rmVerify.checkParam(drsMappings);
        this.tryLock(drsMappings);
        try {
            this.drsDao.saveDrsMappings(drsMappings);
        }
        finally {
            this.releaseLock(drsMappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DrsMapping updateDrsMapping(DrsMapping oldDrsMapping) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format(Locale.ROOT, "Method updateDrsMapping[%s] starting.", JSONObject.fromObject((Object)oldDrsMapping)));
        }
        this.checkDrsMappingEntity(oldDrsMapping);
        if (oldDrsMapping.getGroupType().equals(DrsEnumDefine.GroupTypeEnum.RULE_GROUP.getValue()) && (oldDrsMapping.getRuleType().equals(DrsEnumDefine.RuleTypeEnum.VM_TO_HOST.getValue()) || oldDrsMapping.getRuleType().equals(DrsEnumDefine.RuleTypeEnum.VM_TO_VM.getValue()))) {
            LOG.error((Object)"Data DrsMapping is invalidation,groupType is %s,ruleType is %s.", new Object[]{oldDrsMapping.getGroupType(), oldDrsMapping.getRuleType()});
            throw new LegoCheckedException(1073947393L);
        }
        this.checkCited(oldDrsMapping);
        DrsGroup drsGroup = this.drsDao.getDrsGroupByUrn(oldDrsMapping.getProductGroupUrn());
        this.checkDrsMapping(oldDrsMapping, drsGroup);
        Optional<Site> recoverySite = this.checkDoubleRdModel(oldDrsMapping.getResourceMapping().getRecoverySiteId());
        DrsGroup recoveryDrsGroup = recoverySite.map(site -> this.getDrsGroupByUrn(oldDrsMapping, (Site)site)).orElseGet(() -> this.drsDao.getDrsGroupByUrn(oldDrsMapping.getRecoveryGroupUrn()));
        this.checkDrsMapping(oldDrsMapping, recoveryDrsGroup);
        oldDrsMapping.setProductGroupName(drsGroup.getName());
        oldDrsMapping.setRecoveryGroupName(recoveryDrsGroup.getName());
        this.checkUpdateMapping(oldDrsMapping.getRecoveryGroupUrn());
        this.tryLock(oldDrsMapping);
        try {
            oldDrsMapping.setIsValid(Boolean.valueOf(true));
            recoverySite.ifPresent(site -> this.drsRemoteOp.updateRemoteDrsMapping(oldDrsMapping, (Site)site));
            this.drsDao.updateDrsMapping(oldDrsMapping);
        }
        finally {
            this.releaseLock(oldDrsMapping);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format(Locale.ROOT, "Method updateDrsMapping[%s] end.", JSONObject.fromObject((Object)oldDrsMapping)));
        }
        return oldDrsMapping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDrsMapping(String mappingId, ResourceMapping resourceMapping) {
        DrsMapping drsMapping = this.drsDao.getResourceMappingById(mappingId);
        if (VerifyUtil.isEmpty((Object)resourceMapping) || VerifyUtil.isEmpty((Object)drsMapping)) {
            LOG.error((Object)"Obj not exist.");
            throw new LegoCheckedException(1073947394L);
        }
        this.checkDrsMappingEntity(drsMapping);
        this.checkCited(drsMapping);
        this.tryLock(drsMapping);
        try {
            Optional<Site> recoverySite = this.checkDoubleRdModel(resourceMapping.getRecoverySiteId());
            recoverySite.ifPresent(site -> this.drsRemoteOp.deleteRemoteDrsMapping(drsMapping, (Site)site));
            this.drsDao.deleteDrsMapping(drsMapping);
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)String.format(Locale.ROOT, "Delete drsMapping error, mappingId is %s.", mappingId), (long)-1L, null, (Log)LOG);
        }
        finally {
            this.releaseLock(drsMapping);
        }
    }

    public void synUpdateDrsMapping(DrsMapping drsMapping) {
        this.tryLock(drsMapping);
        try {
            ResourceMapping resourceMapping = drsMapping.getResourceMapping();
            resourceMapping.setRole(resourceMapping.getRole() ^ 1);
            this.drsDao.updateDrsMapping(drsMapping);
        }
        finally {
            this.releaseLock(drsMapping);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synDeleteDrsMapping(String drsMappingId, ResourceMapping resourceMapping) {
        DrsMapping drsMapping = this.drsDao.getResourceMappingById(drsMappingId);
        if (VerifyUtil.isEmpty((Object)resourceMapping) || VerifyUtil.isEmpty((Object)drsMapping)) {
            LOG.error((Object)"Obj not exist.");
            throw new LegoCheckedException(1073947394L);
        }
        this.checkCited(drsMapping);
        this.tryLock(drsMapping);
        try {
            this.drsDao.deleteDrsMapping(drsMapping);
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)String.format(Locale.ROOT, "Delete drsMapping error, mappingId is %s.", drsMappingId), (long)-1L, null, (Log)LOG);
        }
        finally {
            this.releaseLock(drsMapping);
        }
    }

    public Page getDrsMappingByPage(PageQuery pageQuery, ResourceMapping resourceMapping) {
        Optional<Site> recoverySite = this.checkDoubleRdModel(resourceMapping.getRecoverySiteId());
        if (recoverySite.isPresent()) {
            LOG.debug((Object)"RecoverySite is remote site,site is %s.", new Object[]{resourceMapping.getRecoverySiteId()});
            return this.drsRemoteOp.getRemoteDrsMappingByPage(pageQuery, resourceMapping.getMappingId(), recoverySite.get());
        }
        return this.drsDao.getDrsMappingByPage(pageQuery);
    }

    public String getDrsGroupInfoByUrn(Site site, String urn) {
        DrsGroup drsGroup;
        if (VerifyUtil.isEmpty((Object)site) || VerifyUtil.isEmpty((String)urn)) {
            LOG.error((Object)"Data site or urn is null.");
            throw new LegoCheckedException(1073947393L);
        }
        Optional<Site> siteOptional = this.checkDoubleRdModel(site.getSiteId());
        if (siteOptional.isPresent()) {
            drsGroup = this.drsRemoteOp.getRemoteDrsGroupByUrn(siteOptional.get(), urn);
        } else {
            DrsGroup drsGroupDb = this.drsDao.getDrsGroupByUrn(urn);
            drsGroup = new DrsGroup();
            drsGroup.setUrn(drsGroupDb.getUrn());
            drsGroup.setName(drsGroupDb.getName());
            drsGroup.setUri(drsGroupDb.getUri());
            drsGroup.setGroupType(drsGroupDb.getGroupType());
            drsGroup.setTopMoUuid(drsGroupDb.getTopMoUuid());
            drsGroup.setVmGroupUrn(drsGroupDb.getVmGroupUrn());
            drsGroup.setHostGroupUrn(drsGroupDb.getHostGroupUrn());
            drsGroup.setMoId(drsGroupDb.getMoId());
            drsGroup.setVm2HostRuleType(drsGroupDb.getVm2HostRuleType());
            drsGroup.setVmParentGroupUrn(drsGroupDb.getVmParentGroupUrn());
            drsGroup.setRuleType(drsGroupDb.getRuleType());
        }
        if (VerifyUtil.isEmpty((Object)drsGroup) || VerifyUtil.isEmpty((Object)drsGroup.getMoId())) {
            return new JSONObject().toString();
        }
        return JSONObject.fromObject((Object)drsGroup).toString();
    }

    public List<DrsMapping> getTotalDrsMapping(String resourceMappingId) {
        this.rmVerify.checkParam(resourceMappingId);
        ResourceMapping resourceMapping = this.getResourceMapping(resourceMappingId);
        Optional<Site> recoverySite = this.checkDoubleRdModel(resourceMapping.getRecoverySiteId());
        if (recoverySite.isPresent()) {
            long totalNum;
            int currentNum;
            int currentPage;
            PageQuery pageQuery = new PageQuery();
            ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>();
            QueryCondition queryCondition = new QueryCondition("resourceMapping.mappingId", (Object)resourceMapping.getMappingId(), true, true);
            conditions.add(queryCondition);
            pageQuery.setQueryConditionList(conditions);
            ArrayList<DrsMapping> list = new ArrayList<DrsMapping>();
            int pageSize = pageQuery.getPageSize();
            do {
                Page page = this.drsRemoteOp.getRemoteDrsMappingByPage(pageQuery, resourceMapping.getMappingId(), recoverySite.get());
                totalNum = page.getTotalCount();
                currentPage = pageQuery.getStartPage();
                int nextPage = currentPage + 1;
                pageQuery.setStartPage(nextPage);
                List current = page.getResult();
                currentNum = current.size();
                list.addAll(current);
            } while ((long)currentPage * (long)pageSize + (long)currentNum < totalNum);
            return list;
        }
        return this.drsDao.getDrsMappingByResMappingId(resourceMappingId, null);
    }

    private void checkUpdateMapping(String groupUrn) {
        List<DrsMapping> list = this.drsDao.checkGroupUrnByUsed(groupUrn);
        if (!VerifyUtil.isEmpty(list)) {
            LOG.error((Object)String.format(Locale.ROOT, "Data drsMapping is already exists,groupUrn is %s.", groupUrn));
            String groupName = "";
            for (DrsMapping drsMapping : list) {
                if (groupUrn.equals(drsMapping.getProductGroupUrn())) {
                    groupName = drsMapping.getProductGroupName();
                    break;
                }
                if (!groupUrn.equals(drsMapping.getRecoveryGroupUrn())) continue;
                groupName = drsMapping.getRecoveryGroupName();
                break;
            }
            throw new LegoCheckedException(1073949742L, new String[]{groupName});
        }
    }

    private void checkCited(DrsMapping drsMapping) {
        LOG.debug((Object)"Data ruleType is %s,mappingId is %s.", new Object[]{String.valueOf(drsMapping.getGroupType()), drsMapping.getMappingId()});
        if (!drsMapping.getGroupType().equals(DrsEnumDefine.GroupTypeEnum.HOST_GROUP.getValue()) && !drsMapping.getGroupType().equals(DrsEnumDefine.GroupTypeEnum.VM_GROUP.getValue())) {
            return;
        }
        List<DrsMapping> list = this.drsDao.getRuleTypeMappingByCite(drsMapping.getMappingId());
        if (!VerifyUtil.isEmpty(list)) {
            LOG.error((Object)"Data DrsMapping is invalidation,DrsMapping[%s] is used by other DrsMapping.", new Object[]{drsMapping.getMappingId()});
            DrsMapping mapping = list.get(0);
            throw new LegoCheckedException(1073949749L, new String[]{mapping.getProductGroupName(), mapping.getRecoveryGroupName(), mapping.getProductGroupName(), mapping.getRecoveryGroupName()});
        }
    }

    private List<DrsGroup> getTotalRemoteAvailableGroup(ResourceMapping rm, Integer groupType, Site remoteSite) {
        DrsGroupInfo drsGroupInfo = new DrsGroupInfo();
        drsGroupInfo.setResourceProviderId(rm.getRecoveryResourceProviderId());
        drsGroupInfo.setClusterId(rm.getRecoveryResourceId());
        drsGroupInfo.setSiteId(rm.getRecoverySiteId());
        drsGroupInfo.setGroupType(groupType);
        return this.rmFcService.getTotalRemoteAvailableGroup(drsGroupInfo, remoteSite);
    }

    private DrsGroup getDrsGroupByUrn(DrsMapping oldDrsMapping, Site site) {
        DrsGroup recoveryDrsGroup = null;
        List<DrsGroup> groups = this.getTotalRemoteAvailableGroup(oldDrsMapping.getResourceMapping(), oldDrsMapping.getGroupType(), site);
        if (VerifyUtil.isEmpty(groups)) {
            LOG.error((Object)"Data recovery DrsGroup is invalidation.");
            throw new LegoCheckedException(1073947393L);
        }
        for (DrsGroup group : groups) {
            if (!oldDrsMapping.getRecoveryGroupUrn().equals(group.getUrn())) continue;
            recoveryDrsGroup = group;
        }
        if (recoveryDrsGroup == null) {
            LOG.error((Object)"Data recovery DrsGroup is invalidation.");
            throw new LegoCheckedException(1073947393L);
        }
        return recoveryDrsGroup;
    }

    private void checkPersistDrsMapping(List<DrsMapping> drsMappings, Map<String, DrsMapping> persistUrns, List<Map<String, DrsGroup>> drsGroupMapList) {
        for (DrsMapping mapping : drsMappings) {
            if (persistUrns.containsKey(mapping.getProductGroupUrn())) {
                LOG.error((Object)"Data drsMapping is already exists,drsMapping productGroupUrn is %s.", new Object[]{mapping.getProductGroupUrn()});
                DrsGroup productDrsGroup = drsGroupMapList.get(0).get(mapping.getProductGroupUrn());
                throw new LegoCheckedException(1073949742L, new String[]{productDrsGroup.getName()});
            }
            if (!persistUrns.containsKey(mapping.getRecoveryGroupUrn())) continue;
            LOG.error((Object)"Data drsMapping is already exists,drsMapping productGroupUrn is %s,recoveryGroupUrn is %s.", new Object[]{mapping.getProductGroupUrn(), mapping.getRecoveryGroupUrn()});
            DrsGroup recoveryDrsGroup = drsGroupMapList.get(1).get(mapping.getRecoveryGroupUrn());
            throw new LegoCheckedException(1073949742L, new String[]{recoveryDrsGroup.getName()});
        }
    }

    private void checkDrsMappings(List<DrsMapping> drsMappings, List<Map<String, DrsGroup>> drsGroupMapList, Map<String, DrsMapping> persistUrns) {
        for (DrsMapping mapping : drsMappings) {
            Set<String> productKeySet = drsGroupMapList.get(0).keySet();
            Set<String> recoveryKeySet = drsGroupMapList.get(1).keySet();
            if (!productKeySet.contains(mapping.getProductGroupUrn()) || !recoveryKeySet.contains(mapping.getRecoveryGroupUrn())) {
                LOG.error((Object)String.format(Locale.ROOT, "Data drsMapping is invalidation,drsMapping msg is %s.", JSONObject.fromObject((Object)mapping)));
                throw new LegoCheckedException(1073949746L);
            }
            DrsGroup proDrsGroup = drsGroupMapList.get(0).get(mapping.getProductGroupUrn());
            if (proDrsGroup == null) {
                LOG.error((Object)"Data proDrsGroup is null,groupUrn is %s.", new Object[]{mapping.getProductGroupUrn()});
                throw new LegoCheckedException(1073949746L);
            }
            DrsGroup recoveryDrsGroup = drsGroupMapList.get(1).get(mapping.getRecoveryGroupUrn());
            mapping.setRuleType(proDrsGroup.getRuleType());
            mapping.setHostRuleType(proDrsGroup.getVm2HostRuleType());
            this.checkCiteGroupForAdd(mapping, persistUrns, proDrsGroup, recoveryDrsGroup, drsGroupMapList);
            this.checkDrsMappingEntity(mapping);
            this.checkDrsMapping(mapping, proDrsGroup);
            DrsGroup recoveryGroup = drsGroupMapList.get(1).get(mapping.getRecoveryGroupUrn());
            this.checkDrsMapping(mapping, recoveryGroup);
        }
    }

    private void checkCiteGroupForAdd(DrsMapping mapping, Map<String, DrsMapping> persistUrns, DrsGroup proDrsGroup, DrsGroup recoveryDrsGroup, List<Map<String, DrsGroup>> drsGroupMapList) {
        if (recoveryDrsGroup == null || proDrsGroup == null) {
            LOG.error((Object)"RecoveryDrsGroup or proDrsGroup is null.");
            throw new LegoCheckedException(1073949746L);
        }
        if (mapping.getGroupType().intValue() != DrsEnumDefine.GroupTypeEnum.RULE_GROUP.getValue()) {
            LOG.debug((Object)"Data DrsMapping groupType is %s.", new Object[]{String.valueOf(mapping.getGroupType())});
            return;
        }
        if (mapping.getGroupType().intValue() == DrsEnumDefine.GroupTypeEnum.RULE_GROUP.getValue() && mapping.getRuleType().intValue() != DrsEnumDefine.RuleTypeEnum.VM_TO_VM.getValue() && mapping.getRuleType().intValue() != DrsEnumDefine.RuleTypeEnum.VM_TO_HOST.getValue()) {
            LOG.debug((Object)"Data DrsMapping ruleType is %s,groupType is %s", new Object[]{String.valueOf(mapping.getRuleType()), String.valueOf(mapping.getGroupType())});
            return;
        }
        this.checkRuleGroupWhenVmToVmOrVmToHost(mapping, persistUrns, proDrsGroup, recoveryDrsGroup, drsGroupMapList);
    }

    private void checkRuleGroupWhenVmToVmOrVmToHost(DrsMapping mapping, Map<String, DrsMapping> persistUrns, DrsGroup proDrsGroup, DrsGroup recoveryDrsGroup, List<Map<String, DrsGroup>> drsGroupMapList) {
        Map<String, DrsGroup> proDrsGroupMap = drsGroupMapList.get(0);
        Map<String, DrsGroup> recDrsGroupMap = drsGroupMapList.get(1);
        String proVmGroupUrn = proDrsGroup.getVmGroupUrn();
        String recoveryVmGroupUrn = recoveryDrsGroup.getVmGroupUrn();
        if (!proDrsGroupMap.containsKey(proVmGroupUrn)) {
            LOG.error((Object)"ProDrsGroup vmParentGroup is null,vmGroupUrn is %s.", new Object[]{proVmGroupUrn});
            throw new LegoCheckedException(1073949746L);
        }
        if (!persistUrns.containsKey(proVmGroupUrn) || !persistUrns.containsKey(recoveryVmGroupUrn)) {
            LOG.error((Object)"No mapping exists for drsGroup,drsGroupUrn is %s.", new Object[]{proDrsGroup.getUrn()});
            this.throwErrorMsg(proVmGroupUrn, recoveryVmGroupUrn, proDrsGroupMap, recDrsGroupMap);
            return;
        }
        DrsMapping proDrsGroupVmMapping = persistUrns.get(proDrsGroup.getVmGroupUrn());
        DrsMapping recoveryDrsGroupVmMapping = persistUrns.get(recoveryDrsGroup.getVmGroupUrn());
        if (!proDrsGroupVmMapping.getMappingId().equals(recoveryDrsGroupVmMapping.getMappingId())) {
            LOG.error((Object)"No mapping between proDrsGroupMapping and recoveryDrsGroupMapping,proDrsGroupMapping id is %s,recoveryDrsGroupMapping id is %s.", new Object[]{proDrsGroupVmMapping.getMappingId(), recoveryDrsGroupVmMapping.getMappingId()});
            this.throwErrorMsg(proVmGroupUrn, recoveryVmGroupUrn, proDrsGroupMap, recDrsGroupMap);
        }
        mapping.setFromDrsMapping(persistUrns.get(proDrsGroup.getVmGroupUrn()));
        if (mapping.getRuleType().intValue() == DrsEnumDefine.RuleTypeEnum.VM_TO_HOST.getValue()) {
            LOG.debug((Object)"Data DrsMapping ruleType is %s.", new Object[]{String.valueOf(mapping.getRuleType())});
            return;
        }
        if (!proDrsGroupMap.containsKey(proDrsGroup.getVmParentGroupUrn())) {
            LOG.error((Object)"ProDrsGroup vmParentGroup is null,vmParentGroupUrn is %s.", new Object[]{proDrsGroup.getVmParentGroupUrn()});
            throw new LegoCheckedException(1073949746L);
        }
        String proParentVmGroupUrn = proDrsGroup.getVmParentGroupUrn();
        String recoveryParentVmGroupUrn = recoveryDrsGroup.getVmParentGroupUrn();
        if (!persistUrns.containsKey(proParentVmGroupUrn) || !persistUrns.containsKey(recoveryParentVmGroupUrn)) {
            LOG.error((Object)"No mapping exists for drsGroup,drsGroupUrn is %s.", new Object[]{proDrsGroup.getUrn()});
            this.throwErrorMsg(proParentVmGroupUrn, recoveryParentVmGroupUrn, proDrsGroupMap, recDrsGroupMap);
        }
        DrsMapping proDrsGroupVmParentMapping = persistUrns.get(proDrsGroup.getVmParentGroupUrn());
        DrsMapping recoveryDrsGroupVmParentMapping = persistUrns.get(recoveryDrsGroup.getVmParentGroupUrn());
        if (!proDrsGroupVmParentMapping.getMappingId().equals(recoveryDrsGroupVmParentMapping.getMappingId())) {
            LOG.error((Object)"No mapping between proDrsGroupVmParentMapping and recoveryDrsGroupVmParentMapping, proDrsGroupVmParentMapping id is %s,recoveryDrsGroupVmParentMapping id is %s.", new Object[]{proDrsGroupVmParentMapping.getMappingId(), recoveryDrsGroupVmParentMapping.getMappingId()});
            this.throwErrorMsg(proParentVmGroupUrn, recoveryParentVmGroupUrn, proDrsGroupMap, recDrsGroupMap);
        }
        mapping.setToDrsMapping(persistUrns.get(recoveryDrsGroup.getVmParentGroupUrn()));
    }

    private void throwErrorMsg(String proGroupUrn, String recoveryGroupUrn, Map<String, DrsGroup> proDrsGroupMap, Map<String, DrsGroup> recDrsGroupMap) {
        DrsGroup proGroup = proDrsGroupMap.get(proGroupUrn);
        DrsGroup recGroup = recDrsGroupMap.get(recoveryGroupUrn);
        String param = proGroup.getName() + "-->" + recGroup.getName();
        throw new LegoCheckedException(1073949750L, new String[]{param, param});
    }

    private void checkDrsMapping(DrsMapping mapping, DrsGroup drsGroup) {
        if (!this.checkParamCommon(mapping.getGroupType(), drsGroup.getGroupType(), DrsEnumDefine.GroupTypeEnum.class)) {
            LOG.error((Object)String.format(Locale.ROOT, "Data drsMapping groupType is invalidation,drsMapping groupType is %s,drsGroup groupType is %s.", mapping.getGroupType(), drsGroup.getGroupType()));
            throw new LegoCheckedException(1073949747L);
        }
        if (mapping.getGroupType().intValue() != DrsEnumDefine.GroupTypeEnum.RULE_GROUP.getValue()) {
            return;
        }
        if (!this.checkParamCommon(mapping.getRuleType(), drsGroup.getRuleType(), DrsEnumDefine.RuleTypeEnum.class)) {
            LOG.error((Object)String.format(Locale.ROOT, "Data drsMapping ruleType is invalidation,drsMapping ruleType is %s,drsGroup ruleType is %s. ", mapping.getRuleType(), drsGroup.getRuleType()));
            throw new LegoCheckedException(1073949747L);
        }
        if (mapping.getRuleType().intValue() != DrsEnumDefine.RuleTypeEnum.VM_TO_HOST.getValue()) {
            return;
        }
        if (!this.checkParamCommon(mapping.getHostRuleType(), drsGroup.getVm2HostRuleType(), DrsEnumDefine.HostRuleTypeEnum.class)) {
            LOG.error((Object)String.format(Locale.ROOT, "DrsMapping hostRuleType is invalidation,drsMapping hostRuleType is %s,drsGroup vm2HostRuleType is %s.", mapping.getHostRuleType(), drsGroup.getVm2HostRuleType()));
            throw new LegoCheckedException(1073949747L);
        }
    }

    private boolean checkParamCommon(Integer mappingValue, Integer compValue, Class<?> enumClass) {
        if (VerifyUtil.isEmpty((Object)mappingValue)) {
            return false;
        }
        boolean isCorrect = true;
        switch (enumClass.getSimpleName()) {
            case "GroupTypeEnum": {
                isCorrect = DrsEnumDefine.GroupTypeEnum.isContains((Integer)mappingValue);
                break;
            }
            case "RuleTypeEnum": {
                isCorrect = DrsEnumDefine.RuleTypeEnum.isContains((Integer)mappingValue);
                break;
            }
            case "HostRuleTypeEnum": {
                isCorrect = DrsEnumDefine.HostRuleTypeEnum.isContains((Integer)mappingValue);
                break;
            }
        }
        return isCorrect && mappingValue.equals(compValue);
    }

    public void updateDrsMappingAfterRefreshResourceMapping(ResourceMapping rm, Set<ManagedObject> drsGroups, String vrmId) {
        List<DrsMapping> drsMappingList = this.drsDao.getDrsMappingByResMappingId(rm.getMappingId(), null);
        if (VerifyUtil.isEmpty(drsMappingList)) {
            LOG.info((Object)"DrsMappingList emptyList, ResourceMappingId:%s", new Object[]{rm.getMappingId()});
            return;
        }
        Optional<Site> recoverySite = this.checkDoubleRdModel(this.isMasterRole(rm) ? rm.getRecoverySiteId() : rm.getProductSiteId());
        if (vrmId.equals(rm.getProductResourceProviderId())) {
            drsMappingList.forEach(drsMapping -> {
                if (this.updateDrsProductResource((DrsMapping)drsMapping, drsGroups)) {
                    recoverySite.ifPresent(site -> this.drsRemoteOp.updateRemoteDrsMapping((DrsMapping)drsMapping, (Site)site));
                    this.drsDao.updateDrsMapping((DrsMapping)drsMapping);
                }
            });
        } else if (vrmId.equals(rm.getRecoveryResourceProviderId())) {
            drsMappingList.forEach(drsMapping -> {
                if (this.updateDrsRecoveryResource((DrsMapping)drsMapping, drsGroups)) {
                    recoverySite.ifPresent(site -> this.drsRemoteOp.updateRemoteDrsMapping((DrsMapping)drsMapping, (Site)site));
                    this.drsDao.updateDrsMapping((DrsMapping)drsMapping);
                }
            });
        } else {
            LOG.warn((Object)"UpdateDrsMappingAfterRefreshResourceMapping failed,ResourceMapping id:%s,vrm id:%s", new Object[]{rm.getMappingId(), vrmId});
        }
    }

    private boolean updateDrsProductResource(DrsMapping drsMapping, Set<ManagedObject> drsGroups) {
        for (ManagedObject drsGroup : drsGroups) {
            if (!drsGroup.getUuid().equals(drsMapping.getProductGroupUrn()) || drsGroup.getName().equals(drsMapping.getProductGroupName())) continue;
            drsMapping.setProductGroupName(drsGroup.getName());
            return true;
        }
        return false;
    }

    private boolean updateDrsRecoveryResource(DrsMapping drsMapping, Set<ManagedObject> drsGroups) {
        for (ManagedObject drsGroup : drsGroups) {
            if (!drsGroup.getUuid().equals(drsMapping.getRecoveryGroupUrn()) || drsGroup.getName().equals(drsMapping.getRecoveryGroupName())) continue;
            drsMapping.setRecoveryGroupName(drsGroup.getName());
            return true;
        }
        return false;
    }

    public boolean checkDrsMappingAndSendAlarm(DrsMapping drsMapping, boolean needSendAlarm) {
        DrsGroup remoteDrsGroup;
        DrsGroup localDrsGroup;
        ResourceMapping parentMapping = drsMapping.getResourceMapping();
        boolean masterFlag = this.isMasterRole(parentMapping);
        String remoteSiteId = masterFlag ? parentMapping.getRecoverySiteId() : parentMapping.getProductSiteId();
        Optional<Site> site = this.checkDoubleRdModel(remoteSiteId);
        if (masterFlag) {
            localDrsGroup = this.drsDao.getDrsGroupByUrn(drsMapping.getProductGroupUrn());
            remoteDrsGroup = site.isPresent() ? this.drsRemoteOp.getRemoteDrsGroupByUrn(site.get(), drsMapping.getRecoveryGroupUrn()) : this.drsDao.getDrsGroupByUrn(drsMapping.getRecoveryGroupUrn());
        } else {
            localDrsGroup = this.drsDao.getDrsGroupByUrn(drsMapping.getRecoveryGroupUrn());
            remoteDrsGroup = site.isPresent() ? this.drsRemoteOp.getRemoteDrsGroupByUrn(site.get(), drsMapping.getProductGroupUrn()) : this.drsDao.getDrsGroupByUrn(drsMapping.getProductGroupUrn());
        }
        boolean sendAlarmFlag = false;
        if (VerifyUtil.isEmpty((Object)localDrsGroup)) {
            LOG.error((Object)"DrsMapping(%s) of localDrsGroup not exist, remoteSite isPresent: %s, urn:%s, ", new Object[]{drsMapping.getMappingId(), site.isPresent(), masterFlag ? drsMapping.getProductGroupUrn() : drsMapping.getRecoveryGroupUrn()});
            sendAlarmFlag = true;
        }
        if (VerifyUtil.isEmpty((Object)remoteDrsGroup)) {
            LOG.error((Object)"DrsMapping(%s) of remoteDrsGroup not exist, remoteSite isPresent: %s,urn:%s", new Object[]{drsMapping.getMappingId(), site.isPresent(), masterFlag ? drsMapping.getRecoveryGroupUrn() : drsMapping.getProductGroupUrn()});
            sendAlarmFlag = true;
        }
        try {
            if (!sendAlarmFlag) {
                this.checkDrsMapping(drsMapping, localDrsGroup);
                this.checkDrsMapping(drsMapping, remoteDrsGroup);
                if (masterFlag) {
                    this.checkDrsMappingForRuleGroup(drsMapping, parentMapping, localDrsGroup, remoteDrsGroup);
                } else {
                    this.checkDrsMappingForRuleGroup(drsMapping, parentMapping, remoteDrsGroup, localDrsGroup);
                }
            }
        }
        catch (LegoCheckedException ex) {
            sendAlarmFlag = true;
        }
        this.updateAndSendAlarm(drsMapping, needSendAlarm, site, sendAlarmFlag);
        return drsMapping.getIsValid();
    }

    private void checkDrsMappingForRuleGroup(DrsMapping drsMapping, ResourceMapping parentMapping, DrsGroup proDrsGroup, DrsGroup recoveryDrsGroup) {
        if (drsMapping.getGroupType().intValue() != DrsEnumDefine.GroupTypeEnum.RULE_GROUP.getValue()) {
            LOG.debug((Object)"Data DrsMapping groupType is %s.", new Object[]{String.valueOf(drsMapping.getGroupType())});
            return;
        }
        if (drsMapping.getRuleType().intValue() != DrsEnumDefine.RuleTypeEnum.VM_TO_VM.getValue() && drsMapping.getRuleType().intValue() != DrsEnumDefine.RuleTypeEnum.VM_TO_HOST.getValue()) {
            LOG.debug((Object)"Data DrsMapping ruleType is %s,groupType is %s", new Object[]{String.valueOf(drsMapping.getRuleType()), String.valueOf(drsMapping.getGroupType())});
            return;
        }
        Optional<Site> recoverySite = this.checkDoubleRdModel(parentMapping.getRecoverySiteId());
        Optional<Site> productSite = this.checkDoubleRdModel(parentMapping.getProductSiteId());
        if (recoverySite.isPresent() && productSite.isPresent()) {
            LOG.error((Object)"Neither recoverySite or productSite is localSite.");
            throw new LegoCheckedException(1073947393L);
        }
        List<Map<String, DrsGroup>> drsGroupMapList = this.getDrsGroupByResourceMappingId(parentMapping, productSite.orElse(null), recoverySite.orElse(null));
        List<DrsMapping> persistList = this.drsDao.getDrsMappingByResMappingId(parentMapping.getMappingId(), null);
        HashMap<String, DrsMapping> persistUrns = new HashMap<String, DrsMapping>();
        for (DrsMapping mapping : persistList) {
            persistUrns.put(mapping.getProductGroupUrn(), mapping);
            persistUrns.put(mapping.getRecoveryGroupUrn(), mapping);
        }
        this.checkRuleGroupWhenVmToVmOrVmToHost(drsMapping, persistUrns, proDrsGroup, recoveryDrsGroup, drsGroupMapList);
    }

    private void updateAndSendAlarm(DrsMapping drsMapping, boolean needSendAlarm, Optional<Site> site, boolean sendAlarmFlag) {
        if (sendAlarmFlag) {
            LOG.error((Object)"Update DrsMapping %s valid to false", new Object[]{drsMapping.getMappingId()});
            drsMapping.setIsValid(Boolean.valueOf(false));
            site.ifPresent(value -> this.drsRemoteOp.updateRemoteDrsMapping(drsMapping, (Site)value));
            this.drsDao.updateDrsMapping(drsMapping);
            if (needSendAlarm) {
                ResourceMapping parentMapping = drsMapping.getResourceMapping();
                boolean masterFlag = this.isMasterRole(parentMapping);
                AlarmReporter.sendNoRepeatAlarm((long)52625536L, (String)drsMapping.getMappingId(), (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{drsMapping.getMappingId(), masterFlag ? parentMapping.getProductSiteName() : parentMapping.getRecoverySiteName(), masterFlag ? parentMapping.getProductResourceName() : parentMapping.getRecoveryResourceName(), masterFlag ? drsMapping.getProductGroupName() : drsMapping.getRecoveryGroupName(), masterFlag ? parentMapping.getRecoveryResourceName() : parentMapping.getProductSiteName(), masterFlag ? drsMapping.getRecoveryGroupName() : drsMapping.getProductGroupName()});
            }
        } else if (!drsMapping.getIsValid().booleanValue()) {
            LOG.info((Object)"Update DrsMapping %s valid to true", new Object[]{drsMapping.getMappingId()});
            drsMapping.setIsValid(Boolean.valueOf(true));
            site.ifPresent(value -> this.drsRemoteOp.updateRemoteDrsMapping(drsMapping, (Site)value));
            this.drsDao.updateDrsMapping(drsMapping);
        }
    }

    private boolean isMasterRole(ResourceMapping resourceMapping) {
        return resourceMapping.getRole() == 1;
    }

    public void restoreAllDrsMappingAlarm() {
        List alarmList = AlarmReporter.getAlarmListWithAlarmId((long)52625536L);
        if (VerifyUtil.isEmpty((Collection)alarmList)) {
            LOG.info((Object)"AlarmList of DrsMapping is Clear.");
            return;
        }
        for (LegoAlarm alarm : alarmList) {
            DrsMapping drsMapping = this.drsDao.getResourceMappingById(alarm.getSourceId());
            if ((!VerifyUtil.isEmpty((Object)drsMapping) || FaultEnum.ClearState.CLEARED.equals((Object)alarm.getClearStatus())) && (VerifyUtil.isEmpty((Object)drsMapping) || !drsMapping.getIsValid().booleanValue())) continue;
            LOG.info((Object)"Alarm of drsMapping (%s) need clear.", new Object[]{alarm.getSourceId()});
            AlarmReporter.restoreAlarm((long)52625536L, (String[])new String[]{alarm.getSourceId()});
        }
    }

    private void checkDrsMappingEntity(DrsMapping drsMapping) {
        if (drsMapping.getGroupType() == null || !DrsEnumDefine.GroupTypeEnum.isContains((Integer)drsMapping.getGroupType())) {
            LOG.error((Object)"DrsMapping groupType is invalidation,groupType is %s.", new Object[]{String.valueOf(drsMapping.getGroupType())});
            throw new LegoCheckedException(1073947393L);
        }
        LOG.debug((Object)"DrsMapping groupType is %s,ruleType is %s.", new Object[]{String.valueOf(drsMapping.getGroupType()), String.valueOf(drsMapping.getRuleType())});
        if (!drsMapping.getGroupType().equals(DrsEnumDefine.GroupTypeEnum.RULE_GROUP.getValue())) {
            return;
        }
        if (drsMapping.getRuleType() == null || !DrsEnumDefine.RuleTypeEnum.isContains((Integer)drsMapping.getRuleType())) {
            LOG.error((Object)"DrsMapping ruleType is invalidation,ruleType is %s.", new Object[]{String.valueOf(drsMapping.getRuleType())});
            throw new LegoCheckedException(1073947393L);
        }
        if (!drsMapping.getRuleType().equals(DrsEnumDefine.RuleTypeEnum.VM_TO_HOST.getValue()) && !drsMapping.getRuleType().equals(DrsEnumDefine.RuleTypeEnum.VM_TO_VM.getValue())) {
            return;
        }
        if (drsMapping.getRuleType().equals(DrsEnumDefine.RuleTypeEnum.VM_TO_HOST.getValue()) && drsMapping.getFromDrsMapping() == null) {
            LOG.error((Object)"DrsMapping fromDrsMapping is invalidation,drsMapping id is %s.", new Object[]{drsMapping.getMappingId()});
            throw new LegoCheckedException(1073947393L);
        }
        if (drsMapping.getRuleType().equals(DrsEnumDefine.RuleTypeEnum.VM_TO_VM.getValue()) && (drsMapping.getFromDrsMapping() == null || drsMapping.getToDrsMapping() == null)) {
            LOG.error((Object)"DrsMapping fromDrsMapping or toDrsMapping is invalidation,drsMapping id is %s.", new Object[]{drsMapping.getMappingId()});
            throw new LegoCheckedException(1073947393L);
        }
    }

    private List<Map<String, DrsGroup>> getDrsGroupByResourceMappingId(ResourceMapping rm, Site productSite, Site recoverySite) {
        if (VerifyUtil.isEmpty((String)rm.getProductResourceId())) {
            LOG.error((Object)"Data resourceMapping productResourceId is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)rm.getRecoveryResourceId())) {
            LOG.error((Object)"Data resourceMapping recoveryResourceId is null.");
            throw new LegoCheckedException(1073947393L);
        }
        List<DrsGroup> productList = this.getDrsGroupList(rm, productSite, true);
        if (VerifyUtil.isEmpty(productList)) {
            LOG.error((Object)String.format(Locale.ROOT, "Data DrsGroup list is null in cluster[%s].", rm.getProductResourceName()));
            throw new LegoCheckedException(1073949745L);
        }
        ArrayList<Map<String, DrsGroup>> list = new ArrayList<Map<String, DrsGroup>>();
        HashMap<String, DrsGroup> drsGroupMap = new HashMap<String, DrsGroup>();
        for (DrsGroup drsGroup : productList) {
            drsGroupMap.put(drsGroup.getUrn(), drsGroup);
        }
        list.add(drsGroupMap);
        List<DrsGroup> recoveryList = this.getDrsGroupList(rm, recoverySite, false);
        if (VerifyUtil.isEmpty(recoveryList)) {
            LOG.error((Object)String.format(Locale.ROOT, "Data DrsGroup list is null in cluster[%s].", rm.getRecoveryResourceName()));
            throw new LegoCheckedException(1073949745L);
        }
        HashMap<String, DrsGroup> recoveryDrsGroupMap = new HashMap<String, DrsGroup>();
        for (DrsGroup drsGroup : recoveryList) {
            recoveryDrsGroupMap.put(drsGroup.getUrn(), drsGroup);
        }
        list.add(recoveryDrsGroupMap);
        return list;
    }

    private List<DrsGroup> getDrsGroupList(ResourceMapping rm, Site site, boolean isProduct) {
        List<DrsGroup> productList;
        if (!VerifyUtil.isEmpty((Object)site)) {
            DrsGroupInfo drsGroupInfo = new DrsGroupInfo();
            drsGroupInfo.setResourceProviderId(isProduct ? rm.getProductResourceProviderId() : rm.getRecoveryResourceProviderId());
            drsGroupInfo.setClusterId(isProduct ? rm.getProductResourceId() : rm.getRecoveryResourceId());
            drsGroupInfo.setSiteId(isProduct ? rm.getProductSiteId() : rm.getRecoverySiteId());
            productList = this.rmFcService.getTotalRemoteAvailableGroup(drsGroupInfo, site);
        } else {
            productList = this.drsDao.getDrsGroupByCluster(isProduct ? rm.getProductResourceId() : rm.getRecoveryResourceId());
        }
        return productList;
    }

    private void resetDrsMapping(DrsMapping mapping, List<Map<String, DrsGroup>> drsGroupMapList, ResourceMapping rm) {
        DrsGroup productDrsGroup = drsGroupMapList.get(0).get(mapping.getProductGroupUrn());
        DrsGroup recoveryDrsGroup = drsGroupMapList.get(1).get(mapping.getRecoveryGroupUrn());
        mapping.setIsValid(Boolean.valueOf(true));
        mapping.setProductGroupName(productDrsGroup.getName());
        mapping.setRecoveryGroupName(recoveryDrsGroup.getName());
        mapping.setResourceMapping(rm);
        mapping.setMappingId(UUIDGenerator.getUUID());
    }

    private Optional<Site> checkDoubleRdModel(String siteId) {
        Site site = this.siteService.getSiteById(siteId);
        if (site == null) {
            LOG.error((Object)"Data site not exist,siteId is %s.", new Object[]{siteId});
            throw new LegoCheckedException(1073947681L);
        }
        if (site.getSiteType() != 0) {
            return Optional.of(site);
        }
        return site.getSiteType() != 0 ? Optional.of(site) : Optional.empty();
    }

    private ResourceMapping getResourceMapping(String resourceMappingId) {
        ResourceMapping rm = this.rmService.getResourceMappingById(resourceMappingId);
        if (VerifyUtil.isEmpty((Object)rm) || rm.getResourceType() != 0) {
            LOG.error((Object)"Data resourceMapping not exist,resourceMappingId is %s.", new Object[]{resourceMappingId});
            throw new LegoCheckedException(1073949745L);
        }
        return rm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryLock(List<DrsMapping> drsMappings) {
        List<String> list = PROCESSING_DRS_MAPPING;
        synchronized (list) {
            for (DrsMapping mapping : drsMappings) {
                this.isMappingOperating(mapping);
                PROCESSING_DRS_MAPPING.add(mapping.getProductGroupUrn());
                PROCESSING_DRS_MAPPING.add(mapping.getRecoveryGroupUrn());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryLock(DrsMapping mapping) {
        List<String> list = PROCESSING_DRS_MAPPING;
        synchronized (list) {
            this.isMappingOperating(mapping);
            PROCESSING_DRS_MAPPING.add(mapping.getProductGroupUrn());
            PROCESSING_DRS_MAPPING.add(mapping.getRecoveryGroupUrn());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(List<DrsMapping> drsMappings) {
        List<String> list = PROCESSING_DRS_MAPPING;
        synchronized (list) {
            for (DrsMapping mapping : drsMappings) {
                PROCESSING_DRS_MAPPING.remove(mapping.getRecoveryGroupUrn());
                PROCESSING_DRS_MAPPING.remove(mapping.getProductGroupUrn());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(DrsMapping drsMapping) {
        List<String> list = PROCESSING_DRS_MAPPING;
        synchronized (list) {
            PROCESSING_DRS_MAPPING.remove(drsMapping.getRecoveryGroupUrn());
            PROCESSING_DRS_MAPPING.remove(drsMapping.getProductGroupUrn());
        }
    }

    private void isMappingOperating(DrsMapping mapping) {
        if (PROCESSING_DRS_MAPPING.contains(mapping.getProductGroupUrn())) {
            LOG.error((Object)"DrsProductGroup[%s] is running.", new Object[]{mapping.getProductGroupName()});
            throw new LegoCheckedException(1073949742L, new String[]{mapping.getProductGroupName()});
        }
        if (PROCESSING_DRS_MAPPING.contains(mapping.getRecoveryGroupUrn())) {
            LOG.error((Object)"DrsRecoveryGroup[%s] is running.", new Object[]{mapping.getRecoveryGroupName()});
            throw new LegoCheckedException(1073949742L, new String[]{mapping.getRecoveryGroupName()});
        }
    }

    public IResourceMappingService getRmService() {
        return this.rmService;
    }

    public void setRmService(IResourceMappingService rmService) {
        this.rmService = rmService;
    }

    public ISiteBaseService getSiteService() {
        return this.siteService;
    }

    public void setSiteService(ISiteBaseService siteService) {
        this.siteService = siteService;
    }

    public DrsMappingDao getDrsDao() {
        return this.drsDao;
    }

    public void setDrsDao(DrsMappingDao drsDao) {
        this.drsDao = drsDao;
    }

    public DrsMappingRemoteOperator getDrsRemoteOp() {
        return this.drsRemoteOp;
    }

    public void setDrsRemoteOp(DrsMappingRemoteOperator drsRemoteOp) {
        this.drsRemoteOp = drsRemoteOp;
    }

    public RmFcResourceService getRmFcService() {
        return this.rmFcService;
    }

    public void setRmFcService(RmFcResourceService rmFcService) {
        this.rmFcService = rmFcService;
    }

    public ResourceMappingVerify getRmVerify() {
        return this.rmVerify;
    }

    public void setRmVerify(ResourceMappingVerify rmVerify) {
        this.rmVerify = rmVerify;
    }
}

