/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.mapping;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.PageQuery;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.galax.sdk.model.DrsGroup;
import com.huawei.ism.drm.galax.sdk.model.DrsMapping;
import com.huawei.ism.drm.galax.util.rest.JSONUtils;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DrsMappingRemoteOperator {
    private static final Log LOGGER = LogFactory.getInstance(DrsMappingRemoteOperator.class);
    private Map<String, String> remoteRestUrl = new HashMap<String, String>();

    public void deleteRemoteDrsMapping(DrsMapping drsMapping, Site site) {
        RestClient client = SiteUtil.initClient((Site)site);
        if (VerifyUtil.isEmpty((String)drsMapping.getMappingId())) {
            LOGGER.error((Object)"DrsMappingId is not validated.");
            throw new LegoCheckedException(1073947393L);
        }
        try {
            String url = "/ws/synDrsMapping/synDelete";
            client.get(url + "?drsMappingId=" + drsMapping.getMappingId());
        }
        catch (LegoCheckedException ex) {
            LOGGER.error((Object)"Delete remote drsMapping rest request error, drsMappingId is %s.", new Object[]{ex, drsMapping.getMappingId()});
            throw ex;
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)"Delete remote drsMapping rest request catch exception", (long)1073947440L, null, (Log)LOGGER);
        }
    }

    public void postRemoteRes(List<DrsMapping> drsMappings, Site site) {
        if (VerifyUtil.isEmpty(drsMappings)) {
            LOGGER.error((Object)"Data drsMappings is null.");
            throw new LegoCheckedException(1073947393L);
        }
        RestClient client = SiteUtil.initClient((Site)site);
        try {
            client.postSerializableObj(drsMappings, "/ws/synDrsMapping/synAdd");
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)"Syn update drsMapping to remote site exception.", (long)1073947440L, null, (Log)LOGGER);
        }
    }

    public void updateRemoteDrsMapping(DrsMapping drsMapping, Site site) {
        if (VerifyUtil.isEmpty((Object)drsMapping)) {
            LOGGER.error((Object)"Data drsMapping is null.");
            throw new LegoCheckedException(1073947393L);
        }
        RestClient client = SiteUtil.initClient((Site)site);
        try {
            client.postSerializableObj((Object)drsMapping, "/ws/synDrsMapping/synUpdate");
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)"Syn update drsMapping to remote site exception.", (long)1073947440L, null, (Log)LOGGER);
        }
    }

    public Page getRemoteDrsMappingByPage(PageQuery pageQuery, String resourceMapping, Site site) {
        if (VerifyUtil.isEmpty((Object)pageQuery) || VerifyUtil.isEmpty((String)resourceMapping)) {
            LOGGER.error((Object)"Parameter pageQuery is %s,Parameter resourceMapping is %s.", new Object[]{JSONObject.fromObject((Object)pageQuery), resourceMapping});
            throw new LegoCheckedException(1073947393L);
        }
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("resourceMappingId", resourceMapping);
            JSONObject msg = new JSONObject();
            msg.put((Object)"startPage", (Object)pageQuery.getStartPage());
            msg.put((Object)"pageSize", (Object)pageQuery.getPageSize());
            msg.put((Object)"orderBy", (Object)pageQuery.getOrderBy());
            msg.put((Object)"orderType", (Object)(pageQuery.isAsc() ? "asc" : "desc"));
            RestClient client = SiteUtil.initClient((Site)site);
            String json = client.post("/ws/drsmapping/{resourceMappingId}", msg.toString(), map);
            JSONObject jb = JSONUtils.fromString((String)json);
            int start = pageQuery.getPageSize() * pageQuery.getStartPage();
            int totalCount = jb.getInt("totalCount", 0);
            List list = JSONUtils.toCollection((JSONArray)jb.getJSONArray("records"), DrsMapping.class);
            return new Page((long)start, (long)totalCount, pageQuery.getPageSize(), list);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Method getRemoteDrsMappingByPage error, resourceMapping is %s,error is %s.", new Object[]{resourceMapping, ExceptionUtil.getErrorMessage((Throwable)ex)});
            return new Page();
        }
    }

    public DrsGroup getRemoteDrsGroupByUrn(Site site, String urn) {
        try {
            String urnNew = URLEncoder.encode(urn, "UTF-8");
            RestClient client = SiteUtil.initClient((Site)site);
            String url = "/ws/drsmapping/action/getResourceByUrn?siteId=" + site.getSiteId() + "&urn=" + urnNew;
            String json = client.get(url, new HashMap());
            return (DrsGroup)JSONObject.toBean((String)json, DrsGroup.class);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Method getRemoteDrsGroupByUrn error, siteId is %s,urn is %s,error is %s.", new Object[]{site.getSiteId(), urn, ExceptionUtil.getErrorMessage((Throwable)ex)});
            return new DrsGroup();
        }
    }

    public Map<String, List<String>> getRemoteVmsOfGroup(List<DrsMapping> drsMappings, Site site) {
        if (VerifyUtil.isEmpty(drsMappings)) {
            LOGGER.error((Object)"Data drsMappings is null.");
            throw new LegoCheckedException(1073947393L);
        }
        RestClient client = SiteUtil.initClient((Site)site);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        try {
            JSONArray jsonArray = new JSONArray();
            for (DrsMapping drsMapping : drsMappings) {
                jsonArray.add((Object)JSONObject.fromObject((Object)drsMapping));
            }
            String json = client.post("/ws/synDrsMapping/synGetVmsOfGroup?siteId={siteId}", jsonArray.toString(), Collections.singletonMap("siteId", site.getSiteId()));
            JSONObject response = JSONObject.fromObject((Object)json);
            Iterator it = response.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                JSONArray value = response.getJSONArray(key);
                map.put(key, JSONArray.toCollection((JSONArray)value, String.class));
            }
            return map;
        }
        catch (Exception ex) {
            ExceptionUtil.rethrowException((Throwable)ex, (String)"Method getRemoteVmsOfGroup exception.", (long)1073947440L, null, (Log)LOGGER);
            return map;
        }
    }

    public Map<String, String> getRemoteRestUrl() {
        return this.remoteRestUrl;
    }

    public void setRemoteRestUrl(Map<String, String> remoteRestUrl) {
        this.remoteRestUrl = remoteRestUrl;
    }
}

