/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.resource.mapping;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.PageQuery;
import com.huawei.ism.cbb.discover.sdk.service.INeMgrProtocolExtendService;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.DrsEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanBaseService;
import com.huawei.ism.drm.galax.constant.cloudenum.ResTypeEnum;
import com.huawei.ism.drm.galax.recovery.process.ConfigureVmRecoveryProcessor;
import com.huawei.ism.drm.galax.resource.manager.impl.VirtualResourceManagerProxy;
import com.huawei.ism.drm.galax.resource.manager.impl.VrmResource;
import com.huawei.ism.drm.galax.resource.mapping.DrsMappingDao;
import com.huawei.ism.drm.galax.resource.mapping.DrsMappingOperator;
import com.huawei.ism.drm.galax.resource.mapping.DrsMappingRemoteOperator;
import com.huawei.ism.drm.galax.resource.mapping.ResourceMappingDao;
import com.huawei.ism.drm.galax.resource.mapping.RmFcResourceService;
import com.huawei.ism.drm.galax.sdk.model.ComputeCluster;
import com.huawei.ism.drm.galax.sdk.model.DrsGroup;
import com.huawei.ism.drm.galax.sdk.model.DrsGroupInfo;
import com.huawei.ism.drm.galax.sdk.model.DrsMapping;
import com.huawei.ism.drm.galax.sdk.model.ResourceMapping;
import com.huawei.ism.drm.galax.sdk.service.IDrsMappingService;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.DrsBalanceVmResponse;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.DrsResourceGroupResponse;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.DrsResourceVm;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.DrsRuleGroupMsgData;
import com.huawei.ism.drm.galax.sdk.vrm.model.drs.DrsVmInfo;
import com.huawei.ism.drm.galax.util.cloud.VrmUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteBaseService;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service(name="com.huawei.ism.drm.galax.sdk.service.IDrsMappingService", desc="", interfaceClass=IDrsMappingService.class)
public class DrsMappingServiceImpl
extends BaseService
implements IDrsMappingService {
    private static final Log LOGGER = LogFactory.getInstance(DrsMappingServiceImpl.class);
    private DrsMappingOperator drsOperator;
    private DrsMappingDao drsDao;
    private RmFcResourceService rmFcService;
    private DrsMappingRemoteOperator drsRemoteOp;
    private VrmResource vrmResource;
    private VirtualResourceManagerProxy vrmVirtualResSev;
    private ResourceMappingDao rmDao;

    public ResourceMappingDao getRmDao() {
        return this.rmDao;
    }

    public void setRmDao(ResourceMappingDao rmDao) {
        this.rmDao = rmDao;
    }

    public DrsMappingOperator getDrsOperator() {
        return this.drsOperator;
    }

    public void setDrsOperator(DrsMappingOperator drsOperator) {
        this.drsOperator = drsOperator;
    }

    public DrsMappingDao getDrsDao() {
        return this.drsDao;
    }

    public void setDrsDao(DrsMappingDao drsDao) {
        this.drsDao = drsDao;
    }

    public RmFcResourceService getRmFcService() {
        return this.rmFcService;
    }

    public void setRmFcService(RmFcResourceService rmFcService) {
        this.rmFcService = rmFcService;
    }

    public BatchOperationResult createDrsMappings(List<DrsMapping> drsMappings, Integer groupType, String resourceMappingId) {
        return this.drsOperator.createDrsMappings(drsMappings, groupType, resourceMappingId);
    }

    public DrsMapping getResourceMappingById(String mappingId) {
        return this.drsDao.getResourceMappingById(mappingId);
    }

    public DrsMapping updateDrsMapping(DrsMapping oldDrsMapping) {
        return this.drsOperator.updateDrsMapping(oldDrsMapping);
    }

    public void deleteDrsMapping(String mappingId, ResourceMapping resourceMapping) {
        this.drsOperator.deleteDrsMapping(mappingId, resourceMapping);
    }

    public Page getAvailableGroup(DrsGroupInfo drsGroupInfo) {
        return this.rmFcService.getAvailableGroup(drsGroupInfo);
    }

    public Page getDrsMappingByPage(PageQuery pageQuery, ResourceMapping resourceMapping) {
        return this.drsOperator.getDrsMappingByPage(pageQuery, resourceMapping);
    }

    public int countMappingByCluster(String resourceMappingId) {
        List<DrsMapping> list = this.getTotalDrsMapping(resourceMappingId);
        return list.size();
    }

    public List<DrsMapping> getTotalDrsMapping(String resourceMappingId) {
        return this.drsOperator.getTotalDrsMapping(resourceMappingId);
    }

    public void synAddDrsMapping(List<DrsMapping> drsMappings) {
        this.drsOperator.synAddDrsMapping(drsMappings);
    }

    public void synUpdateDrsMapping(DrsMapping drsMapping) {
        this.drsOperator.synUpdateDrsMapping(drsMapping);
    }

    public void synDeleteDrsMapping(String drsMappingId, ResourceMapping oldResMap) {
        this.drsOperator.synDeleteDrsMapping(drsMappingId, oldResMap);
    }

    public String getDrsGroupByUrn(Site site, String urn) {
        return this.drsOperator.getDrsGroupInfoByUrn(site, urn);
    }

    public Map<String, List<String>> getVmsOfGroup(List<DrsMapping> drsMappings, Site site) {
        if (VerifyUtil.isEmpty(drsMappings) || VerifyUtil.isEmpty((Object)site)) {
            LOGGER.error((Object)"Parameter drsMappings is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (site.getSiteType() != 0) {
            return this.drsRemoteOp.getRemoteVmsOfGroup(drsMappings, site);
        }
        return this.getVmsOfGroupDetail(drsMappings, site);
    }

    private List<String> getVmUrn(DrsGroup drsGroup, Map<String, VrmObject> snVrmObjectMap) {
        DrsResourceGroupResponse response;
        if (!snVrmObjectMap.containsKey(drsGroup.getUrn())) {
            INeMgrProtocolExtendService neMgrProtocolExtendService = (INeMgrProtocolExtendService)ServiceLocator.getInstance().getService(INeMgrProtocolExtendService.class);
            NeMgrProtocolExtend extend = neMgrProtocolExtendService.findBySn(drsGroup.getTopMoUuid());
            VrmObject vrmInfo = VrmUtil.generateVrmObj((NeMgrProtocolExtend)extend);
            snVrmObjectMap.put(drsGroup.getUrn(), vrmInfo);
        }
        if (drsGroup.getGroupType().intValue() == DrsEnumDefine.GroupTypeEnum.VM_GROUP.getValue()) {
            response = this.vrmResource.getVrmResource(snVrmObjectMap.get(drsGroup.getUrn()), drsGroup.getUri(), DrsResourceGroupResponse.class);
            return this.handleVmGroup(response.getResourcegroup(), drsGroup);
        }
        if (drsGroup.getGroupType().intValue() == DrsEnumDefine.GroupTypeEnum.BALANCED_GROUP.getValue()) {
            response = this.vrmResource.getVrmResource(snVrmObjectMap.get(drsGroup.getUrn()), drsGroup.getUri(), DrsBalanceVmResponse.class);
            return this.handleBalancedGroup((DrsBalanceVmResponse)response, drsGroup);
        }
        if (drsGroup.getGroupType().intValue() == DrsEnumDefine.GroupTypeEnum.RULE_GROUP.getValue()) {
            return this.getDrsRuleGroup(snVrmObjectMap, drsGroup);
        }
        return Collections.emptyList();
    }

    private List<String> handleBalancedGroup(DrsBalanceVmResponse response, DrsGroup drsGroup) {
        if (VerifyUtil.isEmpty((Object)response) || VerifyUtil.isEmpty((Collection)response.getMembers())) {
            LOGGER.warn((Object)"Data vm Of drsGroup is null,drsGroup urn is %s.", new Object[]{drsGroup.getUrn()});
            return Collections.emptyList();
        }
        ArrayList<String> urnList = new ArrayList<String>();
        for (DrsVmInfo drsVmInfo : response.getMembers()) {
            urnList.add(drsVmInfo.getUrn());
        }
        return urnList;
    }

    private List<String> handleVmGroup(DrsResourceVm response, DrsGroup drsGroup) {
        if (VerifyUtil.isEmpty((Object)response) || VerifyUtil.isEmpty((Collection)response.getGroupMembers())) {
            LOGGER.warn((Object)"Data vm Of drsGroup is null,drsGroup urn is %s.", new Object[]{drsGroup.getUrn()});
            return Collections.emptyList();
        }
        ArrayList<String> urnList = new ArrayList<String>();
        for (DrsVmInfo drsVmInfo : response.getGroupMembers()) {
            urnList.add(drsVmInfo.getUrn());
        }
        return urnList;
    }

    private List<String> getDrsRuleGroup(Map<String, VrmObject> snVrmObjectMap, DrsGroup drsGroup) {
        ComputeCluster cluster = (ComputeCluster)drsGroup.getParentMo();
        List<DrsRuleGroupMsgData> drsRuleGroups = this.vrmVirtualResSev.getDrsRuleGroup(snVrmObjectMap.get(drsGroup.getUrn()), cluster, 0, true);
        if (VerifyUtil.isEmpty(drsRuleGroups)) {
            return Collections.emptyList();
        }
        String[] urns = drsGroup.getUrn().split(":");
        if (urns.length < 7) {
            return Collections.emptyList();
        }
        String ruleIndex = urns[6];
        ArrayList<String> urnList = new ArrayList<String>();
        for (DrsRuleGroupMsgData data : drsRuleGroups) {
            if (data.getRuleIndex() != Integer.parseInt(ruleIndex) || VerifyUtil.isEmpty((Collection)data.getVms())) continue;
            for (DrsVmInfo drsVmInfo : data.getVms()) {
                urnList.add(drsVmInfo.getUrn());
            }
        }
        return urnList;
    }

    public Map<String, List<String>> synGetVmsOfGroup(List<DrsMapping> drsMappings, String siteId) {
        if (VerifyUtil.isEmpty(drsMappings)) {
            LOGGER.error((Object)"Error params.");
            throw new LegoCheckedException(1073947393L);
        }
        Site site = ((ISiteBaseService)ServiceLocator.getInstance().getService(ISiteBaseService.class)).getSiteById(siteId);
        return this.getVmsOfGroupDetail(drsMappings, site);
    }

    public boolean checkDrsMappingState(String planId, DrmEnumDefine.RecoveryPlanExecuteTypeE executeType) {
        IRecoveryPlanBaseService recoveryPlanService = (IRecoveryPlanBaseService)ServiceLocator.getInstance().getService(IRecoveryPlanBaseService.class);
        RecoveryPlan recoveryPlan = recoveryPlanService.getRecoveryPlan(planId);
        ProtectGroup protectGroup = recoveryPlan.getProtectGroup();
        String productSiteId = protectGroup.getProductSiteId();
        List<ResourceMapping> resourceMappings = this.rmDao.getResourceMappingBySite(productSiteId, ResTypeEnum.CLUSTER_RESOURCE, protectGroup.getPoProviderSN());
        if (VerifyUtil.isEmpty(resourceMappings)) {
            LOGGER.info((Object)"Data resourceMappings is empty,site is %s.", new Object[]{productSiteId});
            return false;
        }
        boolean isDrsMappingExistInvalid = resourceMappings.stream().map(ResourceMapping::getMappingId).map(this::getTotalDrsMapping).flatMap(Collection::stream).anyMatch(DrsMapping2 -> DrsMapping2.getIsValid() == false);
        boolean isContainStep = false;
        List recoverSteps = recoveryPlanService.getRecoveryProcessors(planId, executeType);
        if (VerifyUtil.isEmpty((Collection)recoverSteps)) {
            LOGGER.error((Object)"Data recoverSteps is empty,planId is %s,executeType is %s.", new Object[]{planId, executeType.getValue()});
            throw new LegoCheckedException(1073947393L);
        }
        for (RecoveryProcessor processor : recoverSteps) {
            if (!ConfigureVmRecoveryProcessor.class.getTypeName().equals(processor.getProcName()) || !processor.getIsEnabled().booleanValue()) continue;
            isContainStep = true;
            break;
        }
        LOGGER.info((Object)"isContainStep is %s,isDrsMappingExistInvalid is %s,", new Object[]{isContainStep, isDrsMappingExistInvalid});
        return isContainStep && isDrsMappingExistInvalid;
    }

    private Map<String, List<String>> getVmsOfGroupDetail(List<DrsMapping> drsMappings, Site site) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        HashMap<String, VrmObject> snVrmObjectMap = new HashMap<String, VrmObject>();
        for (DrsMapping drsMapping : drsMappings) {
            if (drsMapping == null || drsMapping.getGroupType().intValue() == DrsEnumDefine.GroupTypeEnum.HOST_GROUP.getValue()) continue;
            String productGroupUrn = site.getSiteId().equals(drsMapping.getResourceMapping().getRecoverySiteId()) ? drsMapping.getRecoveryGroupUrn() : drsMapping.getProductGroupUrn();
            DrsGroup drsGroup = this.drsDao.getDrsGroupByUrn(productGroupUrn);
            map.put(productGroupUrn, this.getVmUrn(drsGroup, snVrmObjectMap));
        }
        return map;
    }

    public DrsMappingRemoteOperator getDrsRemoteOp() {
        return this.drsRemoteOp;
    }

    public void setDrsRemoteOp(DrsMappingRemoteOperator drsRemoteOp) {
        this.drsRemoteOp = drsRemoteOp;
    }

    public VrmResource getVrmResource() {
        return this.vrmResource;
    }

    public void setVrmResource(VrmResource vrmResource) {
        this.vrmResource = vrmResource;
    }

    public VirtualResourceManagerProxy getVrmVirtualResSev() {
        return this.vrmVirtualResSev;
    }

    public void setVrmVirtualResSev(VirtualResourceManagerProxy vrmVirtualResSev) {
        this.vrmVirtualResSev = vrmVirtualResSev;
    }
}

